/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.quickFixes;

import com.android.resources.Density;
import com.android.tools.idea.lint.AndroidLintBundle;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiBasedModCommandAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u000f\u0010B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u001f\u0010\b\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0002H\u0014J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0002H\u0014\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/lint/quickFixes/ConvertToDpQuickFix;", "Lcom/intellij/modcommand/PsiBasedModCommandAction;", "Lcom/intellij/psi/PsiElement;", "element", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "getFamilyName", "", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "Lorg/jetbrains/annotations/NotNull;", "context", "Lcom/intellij/modcommand/ActionContext;", "perform", "Lcom/intellij/modcommand/ModCommand;", "ConvertToDpAction", "Companion", "intellij.android.lint"})
@SourceDebugExtension(value={"SMAP\nConvertToDpQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertToDpQuickFix.kt\ncom/android/tools/idea/lint/quickFixes/ConvertToDpQuickFix\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n3829#2:130\n4344#2,2:131\n295#3,2:133\n295#3,2:135\n774#3:137\n865#3,2:138\n1863#3,2:140\n*S KotlinDebug\n*F\n+ 1 ConvertToDpQuickFix.kt\ncom/android/tools/idea/lint/quickFixes/ConvertToDpQuickFix\n*L\n45#1:130\n45#1:131,2\n47#1:133,2\n50#1:135,2\n55#1:137\n55#1:138,2\n56#1:140,2\n*E\n"})
public final class ConvertToDpQuickFix
extends PsiBasedModCommandAction<PsiElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Pattern PX_ATTR_VALUE_PATTERN;
    private static int ourPrevDpi;

    public ConvertToDpQuickFix(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(element);
    }

    @NotNull
    public String getFamilyName() {
        return "ConvertToDpQuickFix";
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class) != null ? Presentation.of((String)AndroidLintBundle.Companion.message("android.lint.fix.convert.to.dp", new Object[0])) : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected ModCommand perform(@NotNull ActionContext context, @NotNull PsiElement element) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Density density;
        Object v3;
        List densities;
        XmlTag parentTag;
        block10: {
            void $this$filterTo$iv$iv2;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
            if (xmlTag == null) {
                ModCommand modCommand = ModCommand.nop();
                Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"nop(...)");
                return modCommand;
            }
            parentTag = xmlTag;
            Density[] densityArray = Density.values();
            Intrinsics.checkNotNullExpressionValue((Object)densityArray, (String)"values(...)");
            Object[] $this$filter$iv2 = densityArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv2) {
                Density it = (Density)element$iv$iv;
                boolean bl = false;
                if (!it.isValidValueForDevice()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            densities = (List)destination$iv$iv;
            Iterable $this$firstOrNull$iv = densities;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Density it = (Density)element$iv;
                boolean bl = false;
                if (!(it.getDpiValue() == Density.DEFAULT_DENSITY)) continue;
                v3 = element$iv;
                break block10;
            }
            v3 = null;
        }
        Density density2 = v3;
        if (density2 == null) {
            ModCommand modCommand = ModCommand.nop();
            Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"nop(...)");
            return modCommand;
        }
        Density defaultValue = density2;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            density = defaultValue;
        } else {
            Object v7;
            block11: {
                Iterable $this$firstOrNull$iv = densities;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Density it = (Density)element$iv;
                    boolean bl = false;
                    if (!(it.getDpiValue() == ourPrevDpi)) continue;
                    v7 = element$iv;
                    break block11;
                }
                v7 = null;
            }
            if ((density = (Density)v7) == null) {
                density = defaultValue;
            }
        }
        Density initialValue = density;
        Object $this$firstOrNull$iv = new ConvertToDpAction[]{new ConvertToDpAction(initialValue, parentTag)};
        List actions2 = CollectionsKt.mutableListOf((Object[])$this$firstOrNull$iv);
        $this$firstOrNull$iv = densities;
        boolean $i$f$filter = false;
        void element$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Density it = (Density)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)initialValue))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            Density it = (Density)element$iv2;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            actions2.add(new ConvertToDpAction(it, parentTag));
        }
        ModCommand modCommand = ModCommand.chooseAction((String)"Choose Screen Density", (List)actions2);
        Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"chooseAction(...)");
        return modCommand;
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.android.tools.idea.lint.quickFixes.ConvertToDpQuickFix");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Pattern pattern = Pattern.compile("(\\d+)px");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        PX_ATTR_VALUE_PATTERN = pattern;
        ourPrevDpi = Density.DEFAULT_DENSITY;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/lint/quickFixes/ConvertToDpQuickFix$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PX_ATTR_VALUE_PATTERN", "Ljava/util/regex/Pattern;", "ourPrevDpi", "", "convertToDp", "", "value", "dpi", "getLabelForDensity", "density", "Lcom/android/resources/Density;", "intellij.android.lint"})
    public static final class Companion {
        private Companion() {
        }

        private final String convertToDp(String value2, int dpi) {
            String newValue = null;
            Matcher matcher = PX_ATTR_VALUE_PATTERN.matcher(value2);
            if (matcher.matches()) {
                String numberString = matcher.group(1);
                try {
                    Intrinsics.checkNotNull((Object)numberString);
                    int px = Integer.parseInt(numberString);
                    int dp = px * 160 / dpi;
                    newValue = dp + "dp";
                }
                catch (NumberFormatException nufe) {
                    LOG.error((Throwable)nufe);
                }
            }
            return newValue;
        }

        private final String getLabelForDensity(Density density) {
            return density.getShortDisplayValue() + " (" + density.getDpiValue() + ")";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0015\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0015\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/lint/quickFixes/ConvertToDpQuickFix$ConvertToDpAction;", "Lcom/intellij/modcommand/ModCommandAction;", "density", "Lcom/android/resources/Density;", "parentTag", "Lcom/intellij/psi/xml/XmlTag;", "<init>", "(Lcom/android/resources/Density;Lcom/intellij/psi/xml/XmlTag;)V", "getFamilyName", "", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "Lorg/jetbrains/annotations/NotNull;", "context", "Lcom/intellij/modcommand/ActionContext;", "perform", "Lcom/intellij/modcommand/ModCommand;", "intellij.android.lint"})
    private static final class ConvertToDpAction
    implements ModCommandAction {
        @NotNull
        private final Density density;
        @NotNull
        private final XmlTag parentTag;

        public ConvertToDpAction(@NotNull Density density, @NotNull XmlTag parentTag) {
            Intrinsics.checkNotNullParameter((Object)density, (String)"density");
            Intrinsics.checkNotNullParameter((Object)parentTag, (String)"parentTag");
            this.density = density;
            this.parentTag = parentTag;
        }

        @NotNull
        public String getFamilyName() {
            return "ConvertToDpQuickFix";
        }

        @NotNull
        public Presentation getPresentation(@NotNull ActionContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Presentation presentation = Presentation.of((String)Companion.getLabelForDensity(this.density));
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"of(...)");
            return presentation;
        }

        @NotNull
        public ModCommand perform(@NotNull ActionContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            ModCommand modCommand = ModCommand.psiUpdate((PsiElement)((PsiElement)this.parentTag), (arg_0, arg_1) -> ConvertToDpAction.perform$lambda$0(this, arg_0, arg_1));
            Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"psiUpdate(...)");
            return modCommand;
        }

        private static final void perform$lambda$0(ConvertToDpAction this$0, XmlTag tag, ModPsiUpdater modPsiUpdater) {
            String newValue;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)modPsiUpdater, (String)"<unused var>");
            int dpi = this$0.density.getDpiValue();
            for (XmlAttribute attribute2 : tag.getAttributes()) {
                String newValue2;
                String value2 = attribute2.getValue();
                if (value2 == null || !StringsKt.endsWith$default((String)value2, (String)"px", (boolean)false, (int)2, null) || (newValue2 = Companion.convertToDp(value2, dpi)) == null) continue;
                attribute2.setValue(newValue2);
            }
            XmlTagValue xmlTagValue = tag.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)xmlTagValue, (String)"getValue(...)");
            XmlTagValue tagValueElement = xmlTagValue;
            String string = tagValueElement.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String tagValue = string;
            if (StringsKt.endsWith$default((String)tagValue, (String)"px", (boolean)false, (int)2, null) && (newValue = Companion.convertToDp(tagValue, dpi)) != null) {
                tagValueElement.setText(newValue);
            }
            if (!ApplicationManager.getApplication().isUnitTestMode() && !IntentionPreviewUtils.isIntentionPreviewActive()) {
                ourPrevDpi = dpi;
            }
        }
    }
}

