/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.ui.toolbar.actions;

import com.android.tools.idea.appinspection.api.process.ProcessesModel;
import com.android.tools.idea.appinspection.ide.ui.SelectProcessAction;
import com.android.tools.idea.appinspection.ide.ui.SelectProcessActionKt;
import com.android.tools.idea.appinspection.inspector.api.process.DeviceDescriptor;
import com.android.tools.idea.appinspection.inspector.api.process.ProcessDescriptor;
import com.android.tools.idea.deviceprovisioner.DeviceProvisionerService;
import com.android.tools.idea.layoutinspector.LayoutInspector;
import com.android.tools.idea.layoutinspector.pipeline.foregroundprocessdetection.DeviceModel;
import com.android.tools.idea.layoutinspector.pipeline.foregroundprocessdetection.ForegroundProcessDetection;
import com.android.tools.idea.layoutinspector.settings.LayoutInspectorSettings;
import com.android.tools.idea.layoutinspector.ui.toolbar.actions.DropDownActionWithButton;
import com.android.tools.idea.layoutinspector.ui.toolbar.actions.SelectDeviceAction;
import com.android.tools.idea.layoutinspector.ui.toolbar.actions.SingleDeviceSelectProcessAction;
import com.android.tools.idea.layoutinspector.ui.toolbar.actions.TargetSelectionActionFactoryKt;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/toolbar/actions/TargetSelectionActionFactory;", "", "<init>", "()V", "getAction", "Lcom/android/tools/idea/layoutinspector/ui/toolbar/actions/DropDownActionWithButton;", "layoutInspector", "Lcom/android/tools/idea/layoutinspector/LayoutInspector;", "getSingleDeviceProcessPicker", "Lcom/android/tools/idea/layoutinspector/ui/toolbar/actions/SingleDeviceSelectProcessAction;", "targetDeviceSerialNumber", "", "getProcessSelectorAction", "Lcom/android/tools/idea/appinspection/ide/ui/SelectProcessAction;", "getDeviceSelectorAction", "Lcom/android/tools/idea/layoutinspector/ui/toolbar/actions/SelectDeviceAction;", "deviceAttribution", "", "device", "Lcom/android/tools/idea/appinspection/inspector/api/process/DeviceDescriptor;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nTargetSelectionActionFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TargetSelectionActionFactory.kt\ncom/android/tools/idea/layoutinspector/ui/toolbar/actions/TargetSelectionActionFactory\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,132:1\n31#2,2:133\n*S KotlinDebug\n*F\n+ 1 TargetSelectionActionFactory.kt\ncom/android/tools/idea/layoutinspector/ui/toolbar/actions/TargetSelectionActionFactory\n*L\n100#1:133,2\n*E\n"})
public final class TargetSelectionActionFactory {
    @NotNull
    public static final TargetSelectionActionFactory INSTANCE = new TargetSelectionActionFactory();

    private TargetSelectionActionFactory() {
    }

    @Nullable
    public final DropDownActionWithButton getAction(@NotNull LayoutInspector layoutInspector) {
        DropDownActionWithButton dropDownActionWithButton;
        Intrinsics.checkNotNullParameter((Object)layoutInspector, (String)"layoutInspector");
        if (LayoutInspectorSettings.Companion.getInstance().getAutoConnectEnabled()) {
            SelectDeviceAction selectDeviceAction = this.getDeviceSelectorAction(layoutInspector);
            if (selectDeviceAction == null) {
                return null;
            }
            SelectDeviceAction action2 = selectDeviceAction;
            dropDownActionWithButton = new DropDownActionWithButton(action2, (Function0<? extends JComponent>)((Function0)() -> TargetSelectionActionFactory.getAction$lambda$0(action2)));
        } else {
            SelectProcessAction selectProcessAction = this.getProcessSelectorAction(layoutInspector);
            if (selectProcessAction == null) {
                return null;
            }
            SelectProcessAction action3 = selectProcessAction;
            dropDownActionWithButton = new DropDownActionWithButton(action3, (Function0<? extends JComponent>)((Function0)() -> TargetSelectionActionFactory.getAction$lambda$1(action3)));
        }
        return dropDownActionWithButton;
    }

    @Nullable
    public final SingleDeviceSelectProcessAction getSingleDeviceProcessPicker(@NotNull LayoutInspector layoutInspector, @NotNull String targetDeviceSerialNumber) {
        Intrinsics.checkNotNullParameter((Object)layoutInspector, (String)"layoutInspector");
        Intrinsics.checkNotNullParameter((Object)targetDeviceSerialNumber, (String)"targetDeviceSerialNumber");
        DeviceModel deviceModel = layoutInspector.getDeviceModel();
        if (deviceModel == null) {
            return null;
        }
        DeviceModel model = deviceModel;
        return new SingleDeviceSelectProcessAction(model, targetDeviceSerialNumber, (Function1<? super ProcessDescriptor, Unit>)((Function1)arg_0 -> TargetSelectionActionFactory.getSingleDeviceProcessPicker$lambda$2(layoutInspector, arg_0)));
    }

    private final SelectProcessAction getProcessSelectorAction(LayoutInspector layoutInspector) {
        ProcessesModel processesModel = layoutInspector.getProcessModel();
        if (processesModel == null) {
            return null;
        }
        ProcessesModel model = processesModel;
        return new SelectProcessAction(model, false, (Function1)new Function1<ProcessDescriptor, String>((Object)SelectProcessAction.Companion){

            public final String invoke(ProcessDescriptor p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((SelectProcessAction.Companion)this.receiver).createCompactProcessLabel(p0);
            }
        }, new SelectProcessAction.StopPresentation("Stop Inspector", "Stop running the layout inspector against the current process"), arg_0 -> TargetSelectionActionFactory.getProcessSelectorAction$lambda$3(layoutInspector, arg_0), (Function2)new Function2<DeviceDescriptor, AnActionEvent, Unit>((Object)INSTANCE){

            public final void invoke(DeviceDescriptor p0, AnActionEvent p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                TargetSelectionActionFactory.access$deviceAttribution((TargetSelectionActionFactory)this.receiver, p0, p1);
            }
        }, null, 64, null);
    }

    private final SelectDeviceAction getDeviceSelectorAction(LayoutInspector layoutInspector) {
        DeviceModel deviceModel = layoutInspector.getDeviceModel();
        if (deviceModel == null) {
            return null;
        }
        DeviceModel model = deviceModel;
        ComponentManager $this$service$iv = (ComponentManager)layoutInspector.getInspectorModel().getProject();
        boolean $i$f$service = false;
        Class<DeviceProvisionerService> serviceClass$iv = DeviceProvisionerService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return new SelectDeviceAction(((DeviceProvisionerService)object).getDeviceProvisioner(), layoutInspector.getInspectorModel().getScope(), model, arg_0 -> TargetSelectionActionFactory.getDeviceSelectorAction$lambda$4(layoutInspector, arg_0), arg_0 -> TargetSelectionActionFactory.getDeviceSelectorAction$lambda$5(layoutInspector, arg_0), null, () -> TargetSelectionActionFactory.getDeviceSelectorAction$lambda$6(layoutInspector), (Function2)new Function2<DeviceDescriptor, AnActionEvent, Unit>((Object)INSTANCE){

            public final void invoke(DeviceDescriptor p0, AnActionEvent p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                TargetSelectionActionFactory.access$deviceAttribution((TargetSelectionActionFactory)this.receiver, p0, p1);
            }
        }, 32, null);
    }

    private final void deviceAttribution(DeviceDescriptor device2, AnActionEvent event) {
        if (device2.getApiLevel().getMajorVersion() < 23) {
            event.getPresentation().setEnabled(false);
            event.getPresentation().setText(SelectProcessActionKt.buildDeviceName(device2) + " (Unsupported for API < 23)");
        } else if (device2.getApiLevel().getMajorVersion() < 29) {
            event.getPresentation().setIcon(TargetSelectionActionFactoryKt.access$toLegacyIcon(device2));
            event.getPresentation().setText(SelectProcessActionKt.buildDeviceName(device2) + " (Live inspection disabled for API < 29)");
        }
    }

    private static final JComponent getAction$lambda$0(SelectDeviceAction $action) {
        return $action.getButton();
    }

    private static final JComponent getAction$lambda$1(SelectProcessAction $action) {
        return $action.getButton();
    }

    private static final Unit getSingleDeviceProcessPicker$lambda$2(LayoutInspector $layoutInspector, ProcessDescriptor newProcess) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)newProcess, (String)"newProcess");
            ProcessesModel processesModel = $layoutInspector.getProcessModel();
            if (processesModel == null) break block0;
            processesModel.setSelectedProcess(newProcess);
        }
        return Unit.INSTANCE;
    }

    private static final Unit getProcessSelectorAction$lambda$3(LayoutInspector $layoutInspector, ProcessDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $layoutInspector.stopInspector();
        return Unit.INSTANCE;
    }

    private static final Unit getDeviceSelectorAction$lambda$4(LayoutInspector $layoutInspector, DeviceDescriptor newDevice) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)newDevice, (String)"newDevice");
            ForegroundProcessDetection foregroundProcessDetection = $layoutInspector.getForegroundProcessDetection();
            if (foregroundProcessDetection == null) break block0;
            ForegroundProcessDetection.startPollingDevice$default(foregroundProcessDetection, newDevice, false, 2, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit getDeviceSelectorAction$lambda$5(LayoutInspector $layoutInspector, ProcessDescriptor newProcess) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)newProcess, (String)"newProcess");
            ProcessesModel processesModel = $layoutInspector.getProcessModel();
            if (processesModel == null) break block0;
            processesModel.setSelectedProcess(newProcess);
        }
        return Unit.INSTANCE;
    }

    private static final Unit getDeviceSelectorAction$lambda$6(LayoutInspector $layoutInspector) {
        $layoutInspector.stopInspector();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$deviceAttribution(TargetSelectionActionFactory $this, DeviceDescriptor device2, AnActionEvent event) {
        $this.deviceAttribution(device2, event);
    }
}

