/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.tree;

import com.android.tools.idea.layoutinspector.LayoutInspector;
import com.android.tools.idea.layoutinspector.model.InspectorModel;
import com.android.tools.idea.layoutinspector.model.SelectionOrigin;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.pipeline.InspectorClient;
import com.android.tools.idea.layoutinspector.tree.LayoutInspectorTreePanel;
import com.android.tools.idea.layoutinspector.tree.LayoutInspectorTreePanelKt;
import com.android.tools.idea.layoutinspector.tree.TreeSettings;
import com.android.tools.idea.layoutinspector.tree.TreeSettingsActionsKt;
import com.android.tools.idea.layoutinspector.ui.RenderModel;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0016\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/layoutinspector/tree/SystemNodeFilterAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "renderModelProvider", "Lkotlin/Function0;", "Lcom/android/tools/idea/layoutinspector/ui/RenderModel;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "isSelected", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.android.layout-inspector"})
public final class SystemNodeFilterAction
extends ToggleAction {
    @NotNull
    private final Function0<RenderModel> renderModelProvider;

    public SystemNodeFilterAction(@NotNull Function0<RenderModel> renderModelProvider) {
        Intrinsics.checkNotNullParameter(renderModelProvider, (String)"renderModelProvider");
        super("Filter System-Defined Layers");
        this.renderModelProvider = renderModelProvider;
    }

    public boolean isSelected(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = LayoutInspector.Companion.get(event);
        return object != null && (object = ((LayoutInspector)object).getTreeSettings()) != null ? object.getHideSystemNodes() : true;
    }

    public void setSelected(@NotNull AnActionEvent event, boolean state2) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            LayoutInspector layoutInspector = LayoutInspector.Companion.get(event);
            if (layoutInspector == null) {
                return;
            }
            LayoutInspector inspector = layoutInspector;
            TreeSettings treeSettings = inspector.getTreeSettings();
            treeSettings.setHideSystemNodes(state2);
            inspector.getCurrentClient().getStats().setHideSystemNodes(state2);
            if (state2) {
                ViewNode hoveredNode2;
                InspectorModel model = inspector.getInspectorModel();
                ViewNode selectedNode = model.getSelection();
                if (selectedNode != null && !selectedNode.isInComponentTree(treeSettings)) {
                    model.setSelection(selectedNode.findClosestUnfilteredNode(treeSettings), SelectionOrigin.COMPONENT_TREE);
                }
                if ((hoveredNode2 = model.getHoveredNode()) != null && !hoveredNode2.isInComponentTree(treeSettings)) {
                    model.setHoveredNode(null);
                }
            }
            LayoutInspectorTreePanel layoutInspectorTreePanel = LayoutInspectorTreePanelKt.treePanel(event);
            if (layoutInspectorTreePanel != null) {
                layoutInspectorTreePanel.refresh();
            }
            RenderModel renderModel = (RenderModel)this.renderModelProvider.invoke();
            if (renderModel == null) break block5;
            renderModel.refresh();
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.update(event);
        InspectorClient.Capability[] capabilityArray = new InspectorClient.Capability[]{InspectorClient.Capability.SUPPORTS_SYSTEM_NODES};
        event.getPresentation().setVisible(TreeSettingsActionsKt.isActionActive(event, capabilityArray));
    }
}

