/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.properties;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.tools.adtui.model.stdui.EditingSupport;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.properties.DimensionUnits;
import com.android.tools.idea.layoutinspector.properties.PropertiesSettings;
import com.android.tools.idea.layoutinspector.properties.PropertySection;
import com.android.tools.idea.layoutinspector.properties.PropertyType;
import com.android.tools.idea.layoutinspector.properties.ViewNodeAndResourceLookup;
import com.android.tools.idea.layoutinspector.resource.ResourceLookup;
import com.android.tools.idea.layoutinspector.resource.SourceLocation;
import com.android.tools.property.panel.api.ActionIconButton;
import com.android.tools.property.panel.api.HelpSupport;
import com.android.tools.property.panel.api.PropertyItem;
import com.android.utils.HashCodes;
import com.intellij.openapi.actionSystem.AnAction;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012BM\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0013\u001a\u00020\u0007\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0015\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0016J\u0010\u00107\u001a\u0002032\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\b\u0010;\u001a\u000203H\u0016J\u0013\u0010<\u001a\u0002002\b\u0010=\u001a\u0004\u0018\u00010>H\u0096\u0002J\u0012\u0010I\u001a\u0004\u0018\u00010\u00032\u0006\u0010J\u001a\u000203H\u0002J\u0012\u0010K\u001a\u0004\u0018\u00010\u00032\u0006\u0010J\u001a\u00020LH\u0002J\u0012\u0010M\u001a\u0004\u0018\u00010\u00032\u0006\u0010N\u001a\u00020LH\u0002J\u0012\u0010O\u001a\u0004\u0018\u00010\u00032\u0006\u0010P\u001a\u00020LH\u0002J\u0012\u0010Q\u001a\u0004\u0018\u00010\u00032\u0006\u0010R\u001a\u00020LH\u0002J\u0010\u0010V\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020LH\u0002J\u0010\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020ZH\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0018\"\u0004\b\u001c\u0010\u001dR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R$\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0017\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u0002008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u001e\u00104\u001a\u0002032\u0006\u0010\u0014\u001a\u000203@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R(\u0010\u0014\u001a\u0004\u0018\u00010\u00032\b\u00108\u001a\u0004\u0018\u00010\u00038V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b9\u0010\u0018\"\u0004\b:\u0010\u001dR\u0014\u0010?\u001a\u00020@X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010BR\u001c\u0010C\u001a\u0004\u0018\u00010DX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010F\"\u0004\bG\u0010HR\u0016\u0010S\u001a\u0004\u0018\u00010L8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bT\u0010U\u00a8\u0006["}, d2={"Lcom/android/tools/idea/layoutinspector/properties/InspectorPropertyItem;", "Lcom/android/tools/property/panel/api/PropertyItem;", "namespace", "", "attrName", "name", "initialType", "Lcom/android/tools/idea/layoutinspector/properties/PropertyType;", "snapshotValue", "section", "Lcom/android/tools/idea/layoutinspector/properties/PropertySection;", "source", "Lcom/android/ide/common/rendering/api/ResourceReference;", "viewId", "", "lookup", "Lcom/android/tools/idea/layoutinspector/properties/ViewNodeAndResourceLookup;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/android/tools/idea/layoutinspector/properties/PropertyType;Ljava/lang/String;Lcom/android/tools/idea/layoutinspector/properties/PropertySection;Lcom/android/ide/common/rendering/api/ResourceReference;JLcom/android/tools/idea/layoutinspector/properties/ViewNodeAndResourceLookup;)V", "type", "value", "group", "(Ljava/lang/String;Ljava/lang/String;Lcom/android/tools/idea/layoutinspector/properties/PropertyType;Ljava/lang/String;Lcom/android/tools/idea/layoutinspector/properties/PropertySection;Lcom/android/ide/common/rendering/api/ResourceReference;JLcom/android/tools/idea/layoutinspector/properties/ViewNodeAndResourceLookup;)V", "getNamespace", "()Ljava/lang/String;", "getAttrName", "getName", "getSnapshotValue", "setSnapshotValue", "(Ljava/lang/String;)V", "getSection", "()Lcom/android/tools/idea/layoutinspector/properties/PropertySection;", "getSource", "()Lcom/android/ide/common/rendering/api/ResourceReference;", "getViewId", "()J", "getLookup", "()Lcom/android/tools/idea/layoutinspector/properties/ViewNodeAndResourceLookup;", "getType", "()Lcom/android/tools/idea/layoutinspector/properties/PropertyType;", "setType", "(Lcom/android/tools/idea/layoutinspector/properties/PropertyType;)V", "sourceLocations", "", "Lcom/android/tools/idea/layoutinspector/resource/SourceLocation;", "getSourceLocations", "()Ljava/util/List;", "needsResolutionEditor", "", "getNeedsResolutionEditor", "()Z", "", "dimensionValue", "getDimensionValue", "()I", "computeDimensionValue", "newValue", "getValue", "setValue", "hashCode", "equals", "other", "", "helpSupport", "Lcom/android/tools/property/panel/api/HelpSupport;", "getHelpSupport", "()Lcom/android/tools/property/panel/api/HelpSupport;", "colorButton", "Lcom/android/tools/property/panel/api/ActionIconButton;", "getColorButton", "()Lcom/android/tools/property/panel/api/ActionIconButton;", "setColorButton", "(Lcom/android/tools/property/panel/api/ActionIconButton;)V", "formatDimension", "pixels", "formatDimensionFloat", "", "formatDimensionFloatDp", "dp", "formatDimensionFloatAsSp", "sp", "formatDimensionFloatAsEm", "em", "pixelsToSpFactor", "getPixelsToSpFactor", "()Ljava/lang/Float;", "formatFloat", "resolveDimensionType", "", "view", "Lcom/android/tools/idea/layoutinspector/model/ViewNode;", "intellij.android.layout-inspector"})
public class InspectorPropertyItem
implements PropertyItem {
    @NotNull
    private final String namespace;
    @NotNull
    private final String attrName;
    @NotNull
    private final String name;
    @Nullable
    private String snapshotValue;
    @NotNull
    private final PropertySection section;
    @Nullable
    private final ResourceReference source;
    private final long viewId;
    @NotNull
    private final ViewNodeAndResourceLookup lookup;
    @NotNull
    private PropertyType type;
    @NotNull
    private final List<SourceLocation> sourceLocations;
    private int dimensionValue;
    @NotNull
    private final HelpSupport helpSupport;
    @Nullable
    private ActionIconButton colorButton;

    public InspectorPropertyItem(@NotNull String namespace, @NotNull String attrName, @NotNull String name2, @NotNull PropertyType initialType, @Nullable String snapshotValue, @NotNull PropertySection section, @Nullable ResourceReference source2, long viewId, @NotNull ViewNodeAndResourceLookup lookup) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)attrName, (String)"attrName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)initialType), (String)"initialType");
        Intrinsics.checkNotNullParameter((Object)((Object)section), (String)"section");
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        this.namespace = namespace;
        this.attrName = attrName;
        this.name = name2;
        this.snapshotValue = snapshotValue;
        this.section = section;
        this.source = source2;
        this.viewId = viewId;
        this.lookup = lookup;
        this.type = initialType;
        this.sourceLocations = new ArrayList();
        this.dimensionValue = this.computeDimensionValue(initialType);
        this.helpSupport = new HelpSupport(this){
            final /* synthetic */ InspectorPropertyItem this$0;
            {
                this.this$0 = $receiver;
            }

            public void browse() {
                block0: {
                    SourceLocation location = (SourceLocation)CollectionsKt.firstOrNull(this.this$0.getSourceLocations());
                    SourceLocation sourceLocation = location;
                    if (sourceLocation == null || (sourceLocation = sourceLocation.getNavigatable()) == null) break block0;
                    sourceLocation.navigate(true);
                }
            }

            public AnAction getHelp() {
                return HelpSupport.super.getHelp();
            }

            public AnAction getSecondaryHelp() {
                return HelpSupport.super.getSecondaryHelp();
            }
        };
    }

    @Override
    @NotNull
    public String getNamespace() {
        return this.namespace;
    }

    @NotNull
    public final String getAttrName() {
        return this.attrName;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public final String getSnapshotValue() {
        return this.snapshotValue;
    }

    public final void setSnapshotValue(@Nullable String string) {
        this.snapshotValue = string;
    }

    @NotNull
    public final PropertySection getSection() {
        return this.section;
    }

    @Nullable
    public final ResourceReference getSource() {
        return this.source;
    }

    public final long getViewId() {
        return this.viewId;
    }

    @NotNull
    public final ViewNodeAndResourceLookup getLookup() {
        return this.lookup;
    }

    public InspectorPropertyItem(@NotNull String namespace, @NotNull String attrName, @NotNull PropertyType type, @Nullable String value2, @NotNull PropertySection group2, @Nullable ResourceReference source2, long viewId, @NotNull ViewNodeAndResourceLookup lookup) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)attrName, (String)"attrName");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)group2), (String)"group");
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        this(namespace, attrName, attrName, type, value2, group2, source2, viewId, lookup);
    }

    @NotNull
    public final PropertyType getType() {
        return this.type;
    }

    private final void setType(PropertyType value2) {
        this.type = value2;
        this.dimensionValue = this.computeDimensionValue(value2);
    }

    @NotNull
    public final List<SourceLocation> getSourceLocations() {
        return this.sourceLocations;
    }

    public boolean getNeedsResolutionEditor() {
        return false;
    }

    public final int getDimensionValue() {
        return this.dimensionValue;
    }

    private final int computeDimensionValue(PropertyType type) {
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> {
                Object v0 = this.snapshotValue;
                if (v0 != null && (v0 = StringsKt.toIntOrNull((String)v0)) != null) {
                    yield ((Integer)v0).intValue();
                }
                yield -1;
            }
            case 2, 3, 4, 5 -> {
                Object v2 = this.snapshotValue;
                yield Float.floatToRawIntBits(v2 != null && (v2 = StringsKt.toFloatOrNull((String)v2)) != null ? ((Float)v2).floatValue() : Float.NaN);
            }
            default -> -1;
        };
    }

    @Override
    @Nullable
    public String getValue() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1 -> this.formatDimension(this.dimensionValue);
            case 3 -> this.formatDimensionFloatDp(Float.intBitsToFloat(this.dimensionValue));
            case 2 -> this.formatDimensionFloatAsEm(Float.intBitsToFloat(this.dimensionValue));
            case 4 -> this.formatDimensionFloat(Float.intBitsToFloat(this.dimensionValue));
            case 5 -> this.formatDimensionFloatAsSp(Float.intBitsToFloat(this.dimensionValue));
            default -> this.snapshotValue;
        };
    }

    @Override
    public void setValue(@Nullable String newValue) {
        this.snapshotValue = newValue;
        this.dimensionValue = this.computeDimensionValue(this.type);
    }

    public int hashCode() {
        ResourceReference resourceReference = this.source;
        return HashCodes.mix((int)this.getNamespace().hashCode(), (int)this.attrName.hashCode(), (int)(resourceReference != null ? resourceReference.hashCode() : 0));
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof InspectorPropertyItem && Intrinsics.areEqual((Object)this.getNamespace(), (Object)((InspectorPropertyItem)other).getNamespace()) && Intrinsics.areEqual((Object)this.attrName, (Object)((InspectorPropertyItem)other).attrName) && Intrinsics.areEqual((Object)this.source, (Object)((InspectorPropertyItem)other).source) && Intrinsics.areEqual(this.getClass(), other.getClass());
    }

    @Override
    @NotNull
    public HelpSupport getHelpSupport() {
        return this.helpSupport;
    }

    @Override
    @Nullable
    public ActionIconButton getColorButton() {
        return this.colorButton;
    }

    public void setColorButton(@Nullable ActionIconButton actionIconButton) {
        this.colorButton = actionIconButton;
    }

    private final String formatDimension(int pixels) {
        switch (pixels) {
            case -2147483648: 
            case -1: 
            case 0x7FFFFFFF: {
                return this.snapshotValue;
            }
        }
        ResourceLookup resourceLookup = this.lookup.getResourceLookup();
        Integer n = resourceLookup.getDpi();
        if (n == null) {
            return pixels + "px";
        }
        int dpi = n;
        return switch (WhenMappings.$EnumSwitchMapping$1[PropertiesSettings.INSTANCE.getDimensionUnits().ordinal()]) {
            case 1 -> pixels + "px";
            case 2 -> pixels * 160 / dpi + "dp";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final String formatDimensionFloat(float pixels) {
        Float spFactor;
        if (Float.isNaN(pixels)) {
            return this.snapshotValue;
        }
        ResourceLookup resourceLookup = this.lookup.getResourceLookup();
        Integer n = resourceLookup.getDpi();
        if (n == null) {
            return this.formatFloat(pixels) + "px";
        }
        int dpi = n;
        if (Intrinsics.areEqual((Object)this.getName(), (Object)"textSize") && !Intrinsics.areEqual((Float)resourceLookup.getFontScale(), (float)0.0f) && PropertiesSettings.INSTANCE.getDimensionUnits() == DimensionUnits.DP && (spFactor = this.getPixelsToSpFactor()) != null) {
            return new DecimalFormat("0.0", DecimalFormatSymbols.getInstance(Locale.ENGLISH)).format(Float.valueOf(pixels * spFactor.floatValue())) + "sp";
        }
        return switch (WhenMappings.$EnumSwitchMapping$1[PropertiesSettings.INSTANCE.getDimensionUnits().ordinal()]) {
            case 1 -> this.formatFloat(pixels) + "px";
            case 2 -> this.formatFloat(pixels * 160.0f / (float)dpi) + "dp";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final String formatDimensionFloatDp(float dp) {
        if (Float.isNaN(dp)) {
            return this.snapshotValue;
        }
        ResourceLookup resourceLookup = this.lookup.getResourceLookup();
        Integer n = resourceLookup.getDpi();
        if (n == null) {
            return this.formatFloat(dp) + "dp";
        }
        int dpi = n;
        return switch (WhenMappings.$EnumSwitchMapping$1[PropertiesSettings.INSTANCE.getDimensionUnits().ordinal()]) {
            case 2 -> this.formatFloat(dp) + "dp";
            case 1 -> this.formatFloat(dp / 160.0f * (float)dpi) + "px";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final String formatDimensionFloatAsSp(float sp) {
        if (Float.isNaN(sp)) {
            return this.snapshotValue;
        }
        Float f = this.getPixelsToSpFactor();
        if (f == null) {
            return this.formatFloat(sp) + "sp";
        }
        float spFactor = f.floatValue();
        return switch (WhenMappings.$EnumSwitchMapping$1[PropertiesSettings.INSTANCE.getDimensionUnits().ordinal()]) {
            case 1 -> this.formatFloat(sp / spFactor) + "px";
            case 2 -> this.formatFloat(sp) + "sp";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final String formatDimensionFloatAsEm(float em) {
        if (Float.isNaN(em)) {
            return this.snapshotValue;
        }
        return this.formatFloat(em) + "em";
    }

    private final Float getPixelsToSpFactor() {
        Integer n = this.lookup.getResourceLookup().getDpi();
        if (n == null) {
            return null;
        }
        int dpi = n;
        Float f = this.lookup.getResourceLookup().getFontScale();
        if (f == null) {
            return null;
        }
        float fontScale = f.floatValue();
        return Float.valueOf(160.0f / fontScale / (float)dpi);
    }

    private final String formatFloat(float value2) {
        String string;
        if (value2 == 0.0f) {
            string = "0";
        } else {
            String string2 = new DecimalFormat("0.0##", DecimalFormatSymbols.getInstance(Locale.ENGLISH)).format(Float.valueOf(value2));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        }
        return string;
    }

    @Slow
    public final void resolveDimensionType(@NotNull ViewNode view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if ((this.type == PropertyType.INT32 || this.type == PropertyType.FLOAT) && this.lookup.getResourceLookup().isDimension(view, this.getName())) {
            this.setType(this.type == PropertyType.INT32 ? PropertyType.DIMENSION : PropertyType.DIMENSION_FLOAT);
        }
    }

    @Override
    @Nullable
    public ActionIconButton getBrowseButton() {
        return PropertyItem.super.getBrowseButton();
    }

    @Override
    @Nullable
    public String getDefaultValue() {
        return PropertyItem.super.getDefaultValue();
    }

    @Override
    @NotNull
    public EditingSupport getEditingSupport() {
        return PropertyItem.super.getEditingSupport();
    }

    @Override
    public boolean isReference() {
        return PropertyItem.super.isReference();
    }

    @Override
    @Nullable
    public Icon getNamespaceIcon() {
        return PropertyItem.super.getNamespaceIcon();
    }

    @Override
    @Nullable
    public String getResolvedValue() {
        return PropertyItem.super.getResolvedValue();
    }

    @Override
    @NotNull
    public String getTooltipForName() {
        return PropertyItem.super.getTooltipForName();
    }

    @Override
    @NotNull
    public String getTooltipForValue() {
        return PropertyItem.super.getTooltipForValue();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PropertyType.values().length];
            try {
                nArray[PropertyType.DIMENSION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyType.DIMENSION_EM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyType.DIMENSION_DP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyType.DIMENSION_FLOAT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyType.DIMENSION_SP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[DimensionUnits.values().length];
            try {
                nArray[DimensionUnits.PIXELS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DimensionUnits.DP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

