/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.metrics.statistics;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.util.StudioPathManager;
import com.google.wireless.android.sdk.stats.DynamicLayoutInspectorAttachToProcess;
import com.google.wireless.android.sdk.stats.DynamicLayoutInspectorErrorInfo;
import com.intellij.openapi.diagnostic.Logger;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 ,2\u00020\u0001:\u0001,BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u0014\u0010\u001b\u001a\u00020\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0005J\u0006\u0010$\u001a\u00020\u001aJ\u000e\u0010%\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010&\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u0006J\u000e\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u0006J\u000e\u0010\u0015\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0006J\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006-"}, d2={"Lcom/android/tools/idea/layoutinspector/metrics/statistics/AttachStatistics;", "", "clientType", "Lcom/google/wireless/android/sdk/stats/DynamicLayoutInspectorAttachToProcess$ClientType;", "multipleProjectsOpen", "Lkotlin/Function0;", "", "isAutoConnectEnabled", "isEmbeddedLayoutInspector", "clock", "Ljava/time/Clock;", "<init>", "(Lcom/google/wireless/android/sdk/stats/DynamicLayoutInspectorAttachToProcess$ClientType;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Ljava/time/Clock;)V", "success", "error", "debugging", "pausedDuringAttach", "errorCode", "Lcom/google/wireless/android/sdk/stats/DynamicLayoutInspectorErrorInfo$AttachErrorCode;", "composeErrorCode", "isOnDeviceRenderingEnabled", "isXr", "attachStartTimeMs", "Ljava/time/Instant;", "attachEndTimeMs", "start", "", "save", "dataSupplier", "Lcom/google/wireless/android/sdk/stats/DynamicLayoutInspectorAttachToProcess$Builder;", "currentProgress", "Lcom/google/wireless/android/sdk/stats/DynamicLayoutInspectorErrorInfo$AttachErrorState;", "getCurrentProgress", "()Lcom/google/wireless/android/sdk/stats/DynamicLayoutInspectorErrorInfo$AttachErrorState;", "setCurrentProgress", "(Lcom/google/wireless/android/sdk/stats/DynamicLayoutInspectorErrorInfo$AttachErrorState;)V", "attachSuccess", "attachError", "composeAttachError", "debuggerInUse", "isPaused", "setOnDeviceRendering", "enabled", "assertErrorNotGeneric", "Companion", "intellij.android.layout-inspector"})
public final class AttachStatistics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DynamicLayoutInspectorAttachToProcess.ClientType clientType;
    @NotNull
    private final Function0<Boolean> multipleProjectsOpen;
    @NotNull
    private final Function0<Boolean> isAutoConnectEnabled;
    @NotNull
    private final Function0<Boolean> isEmbeddedLayoutInspector;
    @NotNull
    private final Clock clock;
    private boolean success;
    private boolean error;
    private boolean debugging;
    private boolean pausedDuringAttach;
    @NotNull
    private DynamicLayoutInspectorErrorInfo.AttachErrorCode errorCode;
    @NotNull
    private DynamicLayoutInspectorErrorInfo.AttachErrorCode composeErrorCode;
    private boolean isOnDeviceRenderingEnabled;
    private boolean isXr;
    @Nullable
    private Instant attachStartTimeMs;
    @Nullable
    private Instant attachEndTimeMs;
    @NotNull
    private DynamicLayoutInspectorErrorInfo.AttachErrorState currentProgress;
    @NotNull
    private static final Logger logger;

    public AttachStatistics(@NotNull DynamicLayoutInspectorAttachToProcess.ClientType clientType, @NotNull Function0<Boolean> multipleProjectsOpen, @NotNull Function0<Boolean> isAutoConnectEnabled, @NotNull Function0<Boolean> isEmbeddedLayoutInspector, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)clientType, (String)"clientType");
        Intrinsics.checkNotNullParameter(multipleProjectsOpen, (String)"multipleProjectsOpen");
        Intrinsics.checkNotNullParameter(isAutoConnectEnabled, (String)"isAutoConnectEnabled");
        Intrinsics.checkNotNullParameter(isEmbeddedLayoutInspector, (String)"isEmbeddedLayoutInspector");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.clientType = clientType;
        this.multipleProjectsOpen = multipleProjectsOpen;
        this.isAutoConnectEnabled = isAutoConnectEnabled;
        this.isEmbeddedLayoutInspector = isEmbeddedLayoutInspector;
        this.clock = clock;
        this.errorCode = DynamicLayoutInspectorErrorInfo.AttachErrorCode.UNKNOWN_ERROR_CODE;
        this.composeErrorCode = DynamicLayoutInspectorErrorInfo.AttachErrorCode.UNKNOWN_ERROR_CODE;
        this.currentProgress = DynamicLayoutInspectorErrorInfo.AttachErrorState.UNKNOWN_ATTACH_ERROR_STATE;
    }

    public /* synthetic */ AttachStatistics(DynamicLayoutInspectorAttachToProcess.ClientType clientType, Function0 function0, Function0 function02, Function0 function03, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC(...)");
            clock = clock2;
        }
        this(clientType, (Function0<Boolean>)function0, (Function0<Boolean>)function02, (Function0<Boolean>)function03, clock);
    }

    public final void start() {
        this.attachStartTimeMs = this.clock.instant();
        this.success = false;
        this.error = false;
        this.errorCode = DynamicLayoutInspectorErrorInfo.AttachErrorCode.UNKNOWN_ERROR_CODE;
        this.composeErrorCode = DynamicLayoutInspectorErrorInfo.AttachErrorCode.UNKNOWN_ERROR_CODE;
        this.currentProgress = DynamicLayoutInspectorErrorInfo.AttachErrorState.UNKNOWN_ATTACH_ERROR_STATE;
    }

    public final void save(@NotNull Function0<DynamicLayoutInspectorAttachToProcess.Builder> dataSupplier) {
        Intrinsics.checkNotNullParameter(dataSupplier, (String)"dataSupplier");
        if (this.attachEndTimeMs == null) {
            this.attachEndTimeMs = this.clock.instant();
        }
        DynamicLayoutInspectorAttachToProcess.Builder it = (DynamicLayoutInspectorAttachToProcess.Builder)dataSupplier.invoke();
        boolean bl = false;
        it.setClientType(this.clientType);
        it.setSuccess(this.success && !this.error);
        DynamicLayoutInspectorErrorInfo.Builder error = it.getErrorInfoBuilder();
        boolean bl2 = false;
        error.setAttachErrorCode(this.errorCode);
        error.setAttachErrorState(this.currentProgress);
        it.setComposeErrorCode(this.composeErrorCode);
        it.setMultipleProjectsOpen(((Boolean)this.multipleProjectsOpen.invoke()).booleanValue());
        it.setDebuggerAttached(this.debugging);
        it.setDebuggerPausedDuringAttach(this.pausedDuringAttach);
        it.setAutoConnectEnabled(((Boolean)this.isAutoConnectEnabled.invoke()).booleanValue());
        it.setIsEmbeddedLayoutInspector(((Boolean)this.isEmbeddedLayoutInspector.invoke()).booleanValue());
        long durationMs = this.attachStartTimeMs != null ? Duration.between(this.attachStartTimeMs, this.attachEndTimeMs).toMillis() : 0L;
        it.setAttachDurationMs(durationMs);
        it.setIsOnDeviceRenderEnabled(this.isOnDeviceRenderingEnabled);
        it.setIsXr(this.isXr);
    }

    @NotNull
    public final DynamicLayoutInspectorErrorInfo.AttachErrorState getCurrentProgress() {
        return this.currentProgress;
    }

    public final void setCurrentProgress(@NotNull DynamicLayoutInspectorErrorInfo.AttachErrorState attachErrorState) {
        Intrinsics.checkNotNullParameter((Object)attachErrorState, (String)"<set-?>");
        this.currentProgress = attachErrorState;
    }

    public final void attachSuccess() {
        this.success = true;
        this.attachEndTimeMs = this.clock.instant();
    }

    public final void attachError(@NotNull DynamicLayoutInspectorErrorInfo.AttachErrorCode errorCode) {
        Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
        this.assertErrorNotGeneric(errorCode);
        this.error = true;
        this.errorCode = errorCode;
        this.attachEndTimeMs = this.clock.instant();
    }

    public final void composeAttachError(@NotNull DynamicLayoutInspectorErrorInfo.AttachErrorCode errorCode) {
        Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
        this.assertErrorNotGeneric(errorCode);
        this.composeErrorCode = errorCode;
        this.attachEndTimeMs = this.clock.instant();
    }

    public final void debuggerInUse(boolean isPaused) {
        this.debugging = true;
        this.pausedDuringAttach = this.pausedDuringAttach || isPaused;
    }

    public final void setOnDeviceRendering(boolean enabled) {
        this.isOnDeviceRenderingEnabled = enabled;
    }

    public final void isXr(boolean isXr) {
        this.isXr = isXr;
    }

    private final void assertErrorNotGeneric(DynamicLayoutInspectorErrorInfo.AttachErrorCode errorCode) {
        if (!((Boolean)StudioFlags.DYNAMIC_LAYOUT_INSPECTOR_THROW_UNEXPECTED_ERROR.get()).booleanValue() && !StudioPathManager.isRunningFromSources()) {
            return;
        }
        if (errorCode == DynamicLayoutInspectorErrorInfo.AttachErrorCode.UNKNOWN_ERROR_CODE) {
            logger.error("Logging UNKNOWN_ERROR_CODE. This error should never be logged.");
        } else if (errorCode == DynamicLayoutInspectorErrorInfo.AttachErrorCode.UNEXPECTED_ERROR) {
            logger.error("Logging UNEXPECTED_ERROR. This error should be classified.");
        }
    }

    static {
        Logger logger = Logger.getInstance(AttachStatistics.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        AttachStatistics.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/layoutinspector/metrics/statistics/AttachStatistics$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.android.layout-inspector"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

