/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.androidSql.psi;

import com.android.tools.idea.lang.androidSql.psi.AndroidSqlBindParameter;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlColumnAliasName;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlColumnDefinitionName;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlColumnName;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlColumnRefExpression;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlDefinedTableName;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlFromTable;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlPsiTypes;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlResultColumns;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlSelectStatement;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlSelectSubquery;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlSelectedTableName;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlSingleTableStatementTable;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlTableAliasName;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlTableDefinitionName;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlWithClauseTable;
import com.android.tools.idea.lang.androidSql.refactoring.AndroidSqlNameElementManipulator;
import com.android.tools.idea.lang.androidSql.resolution.AliasColumnsTable;
import com.android.tools.idea.lang.androidSql.resolution.AliasedTable;
import com.android.tools.idea.lang.androidSql.resolution.AndroidSqlColumnPsiReference;
import com.android.tools.idea.lang.androidSql.resolution.AndroidSqlDefinedTablePsiReference;
import com.android.tools.idea.lang.androidSql.resolution.AndroidSqlParameterReference;
import com.android.tools.idea.lang.androidSql.resolution.AndroidSqlSelectedTablePsiReference;
import com.android.tools.idea.lang.androidSql.resolution.AndroidSqlTable;
import com.android.tools.idea.lang.androidSql.resolution.QualifiedColumnPsiReference;
import com.android.tools.idea.lang.androidSql.resolution.SubqueryTable;
import com.android.tools.idea.lang.androidSql.resolution.UnqualifiedColumnPsiReference;
import com.android.tools.idea.lang.androidSql.resolution.WithClauseTable;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000x\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u0005\u001a\u000e\u0010\u0000\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0019\u001a\u00020\u001a\u001a\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u000e\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u0016\u0010 \u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\r\u001a\u000e\u0010\u001d\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#\u001a\u0016\u0010 \u001a\u00020#2\u0006\u0010\"\u001a\u00020#2\u0006\u0010!\u001a\u00020\r\u001a\u000e\u0010\u001d\u001a\u00020\r2\u0006\u0010$\u001a\u00020%\u001a\u0016\u0010 \u001a\u00020%2\u0006\u0010$\u001a\u00020%2\u0006\u0010!\u001a\u00020\r\u001a\u000e\u0010\u001d\u001a\u00020\r2\u0006\u0010&\u001a\u00020'\u001a\u0016\u0010 \u001a\u00020'2\u0006\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\r\u00a8\u0006("}, d2={"getReference", "Lcom/android/tools/idea/lang/androidSql/resolution/AndroidSqlSelectedTablePsiReference;", "tableName", "Lcom/android/tools/idea/lang/androidSql/psi/AndroidSqlSelectedTableName;", "Lcom/android/tools/idea/lang/androidSql/resolution/AndroidSqlDefinedTablePsiReference;", "Lcom/android/tools/idea/lang/androidSql/psi/AndroidSqlDefinedTableName;", "Lcom/android/tools/idea/lang/androidSql/resolution/AndroidSqlColumnPsiReference;", "columnName", "Lcom/android/tools/idea/lang/androidSql/psi/AndroidSqlColumnName;", "Lcom/intellij/psi/PsiReference;", "bindParameter", "Lcom/android/tools/idea/lang/androidSql/psi/AndroidSqlBindParameter;", "getParameterNameAsString", "", "isColonNamedParameter", "", "getSqlTable", "Lcom/android/tools/idea/lang/androidSql/resolution/AndroidSqlTable;", "fromTable", "Lcom/android/tools/idea/lang/androidSql/psi/AndroidSqlFromTable;", "subquery", "Lcom/android/tools/idea/lang/androidSql/psi/AndroidSqlSelectSubquery;", "resultColumns", "Lcom/android/tools/idea/lang/androidSql/psi/AndroidSqlResultColumns;", "getTableDefinition", "withClauseTable", "Lcom/android/tools/idea/lang/androidSql/psi/AndroidSqlWithClauseTable;", "table", "Lcom/android/tools/idea/lang/androidSql/psi/AndroidSqlSingleTableStatementTable;", "getName", "tableAliasName", "Lcom/android/tools/idea/lang/androidSql/psi/AndroidSqlTableAliasName;", "setName", "newName", "tableDefinitionName", "Lcom/android/tools/idea/lang/androidSql/psi/AndroidSqlTableDefinitionName;", "columnAliasName", "Lcom/android/tools/idea/lang/androidSql/psi/AndroidSqlColumnAliasName;", "columnDefinitionName", "Lcom/android/tools/idea/lang/androidSql/psi/AndroidSqlColumnDefinitionName;", "intellij.android.lang"})
@JvmName(name="PsiImplUtil")
public final class PsiImplUtil {
    @NotNull
    public static final AndroidSqlSelectedTablePsiReference getReference(@NotNull AndroidSqlSelectedTableName tableName) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        return new AndroidSqlSelectedTablePsiReference(tableName);
    }

    @NotNull
    public static final AndroidSqlDefinedTablePsiReference getReference(@NotNull AndroidSqlDefinedTableName tableName) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        return new AndroidSqlDefinedTablePsiReference(tableName, !(tableName.getParent() instanceof AndroidSqlSingleTableStatementTable));
    }

    @NotNull
    public static final AndroidSqlColumnPsiReference getReference(@NotNull AndroidSqlColumnName columnName) {
        AndroidSqlSelectedTableName tableName;
        Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
        PsiElement parent = columnName.getParent();
        if (parent instanceof AndroidSqlColumnRefExpression && (tableName = ((AndroidSqlColumnRefExpression)parent).getSelectedTableName()) != null) {
            return new QualifiedColumnPsiReference(columnName, tableName);
        }
        return new UnqualifiedColumnPsiReference(columnName);
    }

    @Nullable
    public static final PsiReference getReference(@NotNull AndroidSqlBindParameter bindParameter) {
        Intrinsics.checkNotNullParameter((Object)bindParameter, (String)"bindParameter");
        return bindParameter.isColonNamedParameter() ? (PsiReference)new AndroidSqlParameterReference(bindParameter) : null;
    }

    @Nullable
    public static final String getParameterNameAsString(@NotNull AndroidSqlBindParameter bindParameter) {
        String string;
        Intrinsics.checkNotNullParameter((Object)bindParameter, (String)"bindParameter");
        if (PsiImplUtil.isColonNamedParameter(bindParameter)) {
            String string2 = bindParameter.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            String string3 = string2;
            int n = 1;
            String string4 = string3.substring(n);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        } else {
            string = null;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isColonNamedParameter(@NotNull AndroidSqlBindParameter bindParameter) {
        Intrinsics.checkNotNullParameter((Object)bindParameter, (String)"bindParameter");
        ASTNode aSTNode = bindParameter.getNode().getFirstChildNode();
        if (aSTNode == null) {
            return false;
        }
        ASTNode node = aSTNode;
        if (!Intrinsics.areEqual((Object)node.getElementType(), (Object)AndroidSqlPsiTypes.NAMED_PARAMETER)) return false;
        CharSequence charSequence = node.getChars();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getChars(...)");
        if (!StringsKt.startsWith$default((CharSequence)charSequence, (char)':', (boolean)false, (int)2, null)) return false;
        return true;
    }

    @Nullable
    public static final AndroidSqlTable getSqlTable(@NotNull AndroidSqlFromTable fromTable) {
        Intrinsics.checkNotNullParameter((Object)fromTable, (String)"fromTable");
        AndroidSqlTable androidSqlTable = fromTable.getDefinedTableName().getReference().resolveSqlTable();
        if (androidSqlTable == null) {
            return null;
        }
        AndroidSqlTable realTable = androidSqlTable;
        AndroidSqlTableAliasName alias = fromTable.getTableAliasName();
        return alias != null ? (AndroidSqlTable)new AliasedTable(realTable, alias.getNameAsString(), alias) : realTable;
    }

    @Nullable
    public static final AndroidSqlTable getSqlTable(@NotNull AndroidSqlSelectSubquery subquery) {
        Intrinsics.checkNotNullParameter((Object)subquery, (String)"subquery");
        AndroidSqlSelectStatement androidSqlSelectStatement = subquery.getSelectStatement();
        if (androidSqlSelectStatement == null) {
            return null;
        }
        SubqueryTable subqueryTable = new SubqueryTable(androidSqlSelectStatement);
        AndroidSqlTableAliasName alias = subquery.getTableAliasName();
        return alias == null ? (AndroidSqlTable)subqueryTable : (AndroidSqlTable)new AliasedTable(subqueryTable, alias.getNameAsString(), alias);
    }

    @Nullable
    public static final AndroidSqlTable getSqlTable(@NotNull AndroidSqlResultColumns resultColumns) {
        Intrinsics.checkNotNullParameter((Object)resultColumns, (String)"resultColumns");
        return new AliasColumnsTable(resultColumns);
    }

    @Nullable
    public static final AndroidSqlTable getTableDefinition(@NotNull AndroidSqlWithClauseTable withClauseTable) {
        AndroidSqlTable androidSqlTable;
        Intrinsics.checkNotNullParameter((Object)withClauseTable, (String)"withClauseTable");
        List<AndroidSqlColumnDefinitionName> list = withClauseTable.getWithClauseTableDef().getColumnDefinitionNameList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getColumnDefinitionNameList(...)");
        if (!((Collection)list).isEmpty()) {
            androidSqlTable = new WithClauseTable(withClauseTable);
        } else {
            AndroidSqlTableDefinitionName androidSqlTableDefinitionName = withClauseTable.getWithClauseTableDef().getTableDefinitionName();
            Intrinsics.checkNotNullExpressionValue((Object)androidSqlTableDefinitionName, (String)"getTableDefinitionName(...)");
            AndroidSqlTableDefinitionName tableName = androidSqlTableDefinitionName;
            String string = tableName.getNameAsString();
            AndroidSqlSelectStatement androidSqlSelectStatement = withClauseTable.getSelectStatement();
            if (androidSqlSelectStatement == null) {
                return null;
            }
            SubqueryTable subqueryTable = new SubqueryTable(androidSqlSelectStatement);
            androidSqlTable = new AliasedTable(subqueryTable, string, tableName);
        }
        return androidSqlTable;
    }

    @Nullable
    public static final AndroidSqlTable getSqlTable(@NotNull AndroidSqlSingleTableStatementTable table2) {
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        return table2.getDefinedTableName().getReference().resolveSqlTable();
    }

    @NotNull
    public static final String getName(@NotNull AndroidSqlTableAliasName tableAliasName) {
        Intrinsics.checkNotNullParameter((Object)tableAliasName, (String)"tableAliasName");
        return tableAliasName.getNameAsString();
    }

    @NotNull
    public static final AndroidSqlTableAliasName setName(@NotNull AndroidSqlTableAliasName tableAliasName, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)tableAliasName, (String)"tableAliasName");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        new AndroidSqlNameElementManipulator().handleContentChange(tableAliasName, newName);
        return tableAliasName;
    }

    @NotNull
    public static final String getName(@NotNull AndroidSqlTableDefinitionName tableDefinitionName) {
        Intrinsics.checkNotNullParameter((Object)tableDefinitionName, (String)"tableDefinitionName");
        return tableDefinitionName.getNameAsString();
    }

    @NotNull
    public static final AndroidSqlTableDefinitionName setName(@NotNull AndroidSqlTableDefinitionName tableDefinitionName, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)tableDefinitionName, (String)"tableDefinitionName");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        new AndroidSqlNameElementManipulator().handleContentChange(tableDefinitionName, newName);
        return tableDefinitionName;
    }

    @NotNull
    public static final String getName(@NotNull AndroidSqlColumnAliasName columnAliasName) {
        Intrinsics.checkNotNullParameter((Object)columnAliasName, (String)"columnAliasName");
        return columnAliasName.getNameAsString();
    }

    @NotNull
    public static final AndroidSqlColumnAliasName setName(@NotNull AndroidSqlColumnAliasName columnAliasName, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)columnAliasName, (String)"columnAliasName");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        new AndroidSqlNameElementManipulator().handleContentChange(columnAliasName, newName);
        return columnAliasName;
    }

    @NotNull
    public static final String getName(@NotNull AndroidSqlColumnDefinitionName columnDefinitionName) {
        Intrinsics.checkNotNullParameter((Object)columnDefinitionName, (String)"columnDefinitionName");
        return columnDefinitionName.getNameAsString();
    }

    @NotNull
    public static final AndroidSqlColumnDefinitionName setName(@NotNull AndroidSqlColumnDefinitionName columnDefinitionName, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)columnDefinitionName, (String)"columnDefinitionName");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        new AndroidSqlNameElementManipulator().handleContentChange(columnDefinitionName, newName);
        return columnDefinitionName;
    }
}

