/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.insights.ui.actions;

import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.adtui.ui.DynamicRendererList;
import com.android.tools.idea.insights.AppInsight;
import com.android.tools.idea.insights.ui.ResizedSimpleColoredComponent;
import com.android.tools.idea.insights.ui.UiUtilKt;
import com.android.tools.idea.insights.ui.actions.AppInsightsGutterListCellRenderer;
import com.android.tools.idea.insights.ui.actions.HeaderInstruction;
import com.android.tools.idea.insights.ui.actions.InsightInstruction;
import com.android.tools.idea.insights.ui.actions.RenderInstruction;
import com.android.tools.idea.insights.ui.actions.SeparatorInstruction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0003H\u0002J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u00032\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/insights/ui/actions/AppInsightsGutterIconAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "insights", "", "Lcom/android/tools/idea/insights/AppInsight;", "itemChosenCallback", "Lkotlin/Function1;", "", "<init>", "(Ljava/util/List;Lkotlin/jvm/functions/Function1;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "actionPerformed", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createGroupedJList", "Ljavax/swing/JList;", "Lcom/android/tools/idea/insights/ui/actions/RenderInstruction;", "renderInstructions", "generateRenderInstructions", "intellij.android.app-quality-insights.ui"})
@SourceDebugExtension(value={"SMAP\nAppInsightsGutterIconAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppInsightsGutterIconAction.kt\ncom/android/tools/idea/insights/ui/actions/AppInsightsGutterIconAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,273:1\n1#2:274\n1485#3:275\n1510#3,3:276\n1513#3,3:286\n1485#3:289\n1510#3,3:290\n1513#3,3:300\n1246#3,2:305\n1557#3:307\n1628#3,3:308\n1249#3:311\n1797#3,3:312\n381#4,7:279\n381#4,7:293\n462#4:303\n412#4:304\n*S KotlinDebug\n*F\n+ 1 AppInsightsGutterIconAction.kt\ncom/android/tools/idea/insights/ui/actions/AppInsightsGutterIconAction\n*L\n88#1:275\n88#1:276,3\n88#1:286,3\n165#1:289\n165#1:290,3\n165#1:300,3\n167#1:305,2\n170#1:307\n170#1:308,3\n167#1:311\n173#1:312,3\n88#1:279,7\n165#1:293,7\n167#1:303\n167#1:304\n*E\n"})
public final class AppInsightsGutterIconAction
extends AnAction {
    @NotNull
    private final List<AppInsight> insights;
    @NotNull
    private final Function1<AppInsight, Unit> itemChosenCallback;

    public AppInsightsGutterIconAction(@NotNull List<AppInsight> insights, @NotNull Function1<? super AppInsight, Unit> itemChosenCallback) {
        Intrinsics.checkNotNullParameter(insights, (String)"insights");
        Intrinsics.checkNotNullParameter(itemChosenCallback, (String)"itemChosenCallback");
        this.insights = insights;
        this.itemChosenCallback = itemChosenCallback;
    }

    private final Logger getLogger() {
        Logger logger = Logger.getInstance(((Object)((Object)this)).getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        Object list$iv$iv;
        Object key$iv$iv;
        AppInsight it;
        void $this$groupByTo$iv$iv;
        JPanel jPanel;
        void $this$actionPerformed_u24lambda_u2410;
        Object object;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.insights.isEmpty()) {
            return;
        }
        List<RenderInstruction> renderItems = this.generateRenderInstructions(this.insights);
        JList<RenderInstruction> list = this.createGroupedJList(renderItems);
        Ref.ObjectRef popup = new Ref.ObjectRef();
        PopupChooserBuilder popupChooserBuilder = object = new PopupChooserBuilder(list);
        Ref.ObjectRef objectRef = popup;
        boolean bl = false;
        $this$actionPerformed_u24lambda_u2410.setTitle("App Quality Insights");
        $this$actionPerformed_u24lambda_u2410.setSelectionMode(0);
        $this$actionPerformed_u24lambda_u2410.setMovable(true);
        $this$actionPerformed_u24lambda_u2410.setRenderer((ListCellRenderer)new AppInsightsGutterListCellRenderer());
        $this$actionPerformed_u24lambda_u2410.setItemChosenCallback(arg_0 -> AppInsightsGutterIconAction.actionPerformed$lambda$10$lambda$1(arg_0 -> AppInsightsGutterIconAction.actionPerformed$lambda$10$lambda$0(this, popup, arg_0), arg_0));
        $this$actionPerformed_u24lambda_u2410.setCloseOnEnter(false);
        Object $this$actionPerformed_u24lambda_u2410_u24lambda_u242 = jPanel = new JPanel(new BorderLayout());
        boolean bl2 = false;
        $this$actionPerformed_u24lambda_u2410_u24lambda_u242.setName("bottom panel");
        JPanel panel2 = jPanel;
        panel2.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        Object $this$actionPerformed_u24lambda_u2410_u24lambda_u243 = $this$actionPerformed_u24lambda_u2410_u24lambda_u242 = new ResizedSimpleColoredComponent();
        boolean $i$a$-apply-AppInsightsGutterIconAction$actionPerformed$1$hintText$22 = false;
        $this$actionPerformed_u24lambda_u2410_u24lambda_u243.append("Select an issue to see details", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        $this$actionPerformed_u24lambda_u2410_u24lambda_u243.setForeground(UIUtil.getLabelDisabledForeground());
        Object hintText = $this$actionPerformed_u24lambda_u2410_u24lambda_u242;
        panel2.add((Component)hintText, "West");
        Iterable $this$groupBy$iv = this.insights;
        boolean $i$f$groupBy = false;
        Iterable $i$a$-apply-AppInsightsGutterIconAction$actionPerformed$1$hintText$22 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo2 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            it = (AppInsight)element$iv$iv;
            boolean bl3 = false;
            key$iv$iv = it.getProviderName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl4 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        if (destination$iv$iv.size() == 1 && this.insights.size() > 1) {
            JPanel jPanel2;
            long l;
            long l2;
            Iterable iterable = this.insights;
            long l3 = 0L;
            Object object3 = iterable.iterator();
            while (object3.hasNext()) {
                Object element$iv$iv;
                element$iv$iv = object3.next();
                list$iv$iv = (AppInsight)element$iv$iv;
                l2 = l3;
                boolean bl5 = false;
                l = it.getIssue().getIssueDetails().getEventsCount();
                l3 = l2 + l;
            }
            long eventsTotal = l3;
            Iterable $i$f$groupByTo2 = this.insights;
            long l4 = 0L;
            for (Object bl5 : $i$f$groupByTo2) {
                void it2;
                key$iv$iv = (AppInsight)bl5;
                l2 = l4;
                boolean bl6 = false;
                l = it2.getIssue().getIssueDetails().getImpactedDevicesCount();
                l4 = l2 + l;
            }
            long usersTotal = l4;
            Object $this$actionPerformed_u24lambda_u2410_u24lambda_u247 = object3 = new ResizedSimpleColoredComponent();
            boolean bl7 = false;
            Icon icon = StudioIcons.GutterIcons.ISSUE;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ISSUE");
            Color color = UIUtil.getLabelDisabledForeground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getLabelDisabledForeground(...)");
            $this$actionPerformed_u24lambda_u2410_u24lambda_u247.setIcon(ColoredIconGenerator.INSTANCE.generateColoredIcon(icon, color));
            $this$actionPerformed_u24lambda_u2410_u24lambda_u247.append(UiUtilKt.formatNumberToPrettyString(eventsTotal), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            Object eventsComponent = object3;
            Object $this$actionPerformed_u24lambda_u2410_u24lambda_u248 = $this$actionPerformed_u24lambda_u2410_u24lambda_u247 = new ResizedSimpleColoredComponent();
            boolean bl8 = false;
            Icon icon2 = StudioIcons.LayoutEditor.Palette.QUICK_CONTACT_BADGE;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"QUICK_CONTACT_BADGE");
            Color color2 = UIUtil.getLabelDisabledForeground();
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getLabelDisabledForeground(...)");
            $this$actionPerformed_u24lambda_u2410_u24lambda_u248.setIcon(ColoredIconGenerator.INSTANCE.generateColoredIcon(icon2, color2));
            $this$actionPerformed_u24lambda_u2410_u24lambda_u248.append(UiUtilKt.formatNumberToPrettyString(usersTotal), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            Object usersComponent = $this$actionPerformed_u24lambda_u2410_u24lambda_u247;
            JPanel $this$actionPerformed_u24lambda_u2410_u24lambda_u249 = jPanel2 = new JPanel();
            boolean bl9 = false;
            $this$actionPerformed_u24lambda_u2410_u24lambda_u249.setOpaque(false);
            $this$actionPerformed_u24lambda_u2410_u24lambda_u249.add((Component)eventsComponent);
            $this$actionPerformed_u24lambda_u2410_u24lambda_u249.add((Component)usersComponent);
            JPanel countsPanel = jPanel2;
            panel2.add((Component)countsPanel, "East");
        }
        $this$actionPerformed_u24lambda_u2410.setSouthComponent((JComponent)panel2);
        JBPopup jBPopup = object.createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        objectRef.element = jBPopup;
        object = e.getInputEvent();
        MouseEvent mouseEvent = object instanceof MouseEvent ? (MouseEvent)object : null;
        if (mouseEvent != null) {
            JBPopup jBPopup2;
            MouseEvent mouseEvent2 = mouseEvent;
            boolean bl10 = false;
            if (popup.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popup");
                jBPopup2 = null;
            } else {
                jBPopup2 = (JBPopup)popup.element;
            }
            jBPopup2.show(new RelativePoint(mouseEvent2));
        } else {
            JBPopup jBPopup3;
            AppInsightsGutterIconAction $this$actionPerformed_u24lambda_u2412 = this;
            boolean bl11 = false;
            if (popup.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popup");
                jBPopup3 = null;
            } else {
                jBPopup3 = (JBPopup)popup.element;
            }
            jBPopup3.showInBestPositionFor(e.getDataContext());
        }
    }

    private final JList<RenderInstruction> createGroupedJList(List<? extends RenderInstruction> renderInstructions) {
        JBList variableHeightJList = DynamicRendererList.Companion.createDynamicRendererList((ListModel)new CollectionListModel(renderInstructions));
        variableHeightJList.setSelectionModel((ListSelectionModel)new DefaultListSelectionModel(renderInstructions, (JBList<RenderInstruction>)variableHeightJList){
            final /* synthetic */ List<RenderInstruction> $renderInstructions;
            final /* synthetic */ JBList<RenderInstruction> $variableHeightJList;
            {
                this.$renderInstructions = $renderInstructions;
                this.$variableHeightJList = $variableHeightJList;
            }

            public void setSelectionInterval(int index0, int index1) {
                if (index1 == -1) {
                    return;
                }
                RenderInstruction item = this.$renderInstructions.get(index1);
                if (item instanceof InsightInstruction) {
                    this.$variableHeightJList.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    this.$variableHeightJList.setCursor(Cursor.getDefaultCursor());
                }
                super.setSelectionInterval(index0, index1);
            }
        });
        return (JList)variableHeightJList;
    }

    /*
     * WARNING - void declaration
     */
    private final List<RenderInstruction> generateRenderInstructions(List<AppInsight> insights) {
        void $this$fold$iv;
        void $this$mapValuesTo$iv$iv;
        Object key$iv$iv;
        Map $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = insights;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object element$iv$iv = iterator2.next();
            AppInsight it = (AppInsight)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it.getProviderName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object $this$mapValues$iv = MapsKt.toSortedMap((Map)destination$iv$iv);
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl3 = false;
            String displayName = (String)entry.getKey();
            List insights2 = (List)entry.getValue();
            Intrinsics.checkNotNull((Object)displayName);
            Collection collection2 = CollectionsKt.listOf((Object)new HeaderInstruction(displayName));
            Intrinsics.checkNotNull((Object)insights2);
            Iterable iterable2 = insights2;
            Collection collection3 = collection2;
            boolean $i$f$map = false;
            void var21_30 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void insight;
                AppInsight appInsight = (AppInsight)item$iv$iv;
                Collection collection4 = destination$iv$iv2;
                boolean bl4 = false;
                collection4.add(new InsightInstruction((AppInsight)insight));
            }
            List list = CollectionsKt.plus((Collection)collection3, (Iterable)((List)destination$iv$iv2));
            map3.put(k, list);
        }
        $this$mapValues$iv = MapsKt.toList((Map)destination$iv$iv);
        List initial$iv = CollectionsKt.emptyList();
        boolean $i$f$fold = false;
        List accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            Pair pair = (Pair)element$iv;
            List acc = accumulator$iv;
            boolean bl = false;
            List insightsByProvider = (List)pair.component2();
            accumulator$iv = acc.isEmpty() ? insightsByProvider : CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)acc, (Iterable)CollectionsKt.listOf((Object)SeparatorInstruction.INSTANCE)), (Iterable)insightsByProvider);
        }
        return accumulator$iv;
    }

    private static final Unit actionPerformed$lambda$10$lambda$0(AppInsightsGutterIconAction this$0, Ref.ObjectRef $popup, RenderInstruction chosenInsight) {
        if (chosenInsight instanceof InsightInstruction) {
            JBPopup jBPopup;
            this$0.getLogger().debug("Gutter icon click for issue " + chosenInsight);
            if ($popup.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popup");
                jBPopup = null;
            } else {
                jBPopup = (JBPopup)$popup.element;
            }
            jBPopup.closeOk(null);
            this$0.itemChosenCallback.invoke((Object)((InsightInstruction)chosenInsight).getInsight());
        }
        return Unit.INSTANCE;
    }

    private static final void actionPerformed$lambda$10$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

