/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.insights;

import com.android.tools.idea.insights.Event;
import com.android.tools.idea.insights.EventPage;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015J\u0006\u0010\u0017\u001a\u00020\u0015J\u0006\u0010\u0018\u001a\u00020\u0015J\u0006\u0010\u0019\u001a\u00020\u0000J\u0006\u0010\u001a\u001a\u00020\u0000J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001dJ\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0006H\u00c6\u0003J\t\u0010 \u001a\u00020\bH\u00c6\u0003J-\u0010!\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\"\u001a\u00020\u00152\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020\u0006H\u00d6\u0001J\t\u0010%\u001a\u00020\bH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006&"}, d2={"Lcom/android/tools/idea/insights/DynamicEventGallery;", "", "events", "", "Lcom/android/tools/idea/insights/Event;", "selectedIndex", "", "token", "", "<init>", "(Ljava/util/List;ILjava/lang/String;)V", "getEvents", "()Ljava/util/List;", "getSelectedIndex", "()I", "getToken", "()Ljava/lang/String;", "selected", "getSelected", "()Lcom/android/tools/idea/insights/Event;", "hasPrevious", "", "hasNext", "canRequestMoreEvents", "isLastIndexSelected", "next", "previous", "appendEventPage", "page", "Lcom/android/tools/idea/insights/EventPage;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "intellij.android.app-quality-insights.api"})
public final class DynamicEventGallery {
    @NotNull
    private final List<Event> events;
    private final int selectedIndex;
    @NotNull
    private final String token;

    public DynamicEventGallery(@NotNull List<Event> events, int selectedIndex, @NotNull String token) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.events = events;
        this.selectedIndex = selectedIndex;
        this.token = token;
    }

    @NotNull
    public final List<Event> getEvents() {
        return this.events;
    }

    public final int getSelectedIndex() {
        return this.selectedIndex;
    }

    @NotNull
    public final String getToken() {
        return this.token;
    }

    @Nullable
    public final Event getSelected() {
        return this.events.isEmpty() ? null : this.events.get(this.selectedIndex);
    }

    public final boolean hasPrevious() {
        return this.selectedIndex > 0;
    }

    public final boolean hasNext() {
        return this.selectedIndex < this.events.size() - 1;
    }

    public final boolean canRequestMoreEvents() {
        return ((CharSequence)this.token).length() > 0;
    }

    public final boolean isLastIndexSelected() {
        return this.selectedIndex == this.events.size() - 1;
    }

    @NotNull
    public final DynamicEventGallery next() {
        if (this.hasNext()) {
            return new DynamicEventGallery(this.events, this.selectedIndex + 1, this.token);
        }
        return this;
    }

    @NotNull
    public final DynamicEventGallery previous() {
        if (this.hasPrevious()) {
            return new DynamicEventGallery(this.events, this.selectedIndex - 1, this.token);
        }
        return this;
    }

    @NotNull
    public final DynamicEventGallery appendEventPage(@NotNull EventPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        return new DynamicEventGallery(CollectionsKt.plus((Collection)this.events, (Iterable)page.getEvents()), this.selectedIndex, page.getToken());
    }

    @NotNull
    public final List<Event> component1() {
        return this.events;
    }

    public final int component2() {
        return this.selectedIndex;
    }

    @NotNull
    public final String component3() {
        return this.token;
    }

    @NotNull
    public final DynamicEventGallery copy(@NotNull List<Event> events, int selectedIndex, @NotNull String token) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        return new DynamicEventGallery(events, selectedIndex, token);
    }

    public static /* synthetic */ DynamicEventGallery copy$default(DynamicEventGallery dynamicEventGallery, List list, int n, String string, int n2, Object object) {
        if ((n2 & 1) != 0) {
            list = dynamicEventGallery.events;
        }
        if ((n2 & 2) != 0) {
            n = dynamicEventGallery.selectedIndex;
        }
        if ((n2 & 4) != 0) {
            string = dynamicEventGallery.token;
        }
        return dynamicEventGallery.copy(list, n, string);
    }

    @NotNull
    public String toString() {
        return "DynamicEventGallery(events=" + this.events + ", selectedIndex=" + this.selectedIndex + ", token=" + this.token + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.events).hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.selectedIndex);
        result2 = result2 * 31 + this.token.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DynamicEventGallery)) {
            return false;
        }
        DynamicEventGallery dynamicEventGallery = (DynamicEventGallery)other;
        if (!Intrinsics.areEqual(this.events, dynamicEventGallery.events)) {
            return false;
        }
        if (this.selectedIndex != dynamicEventGallery.selectedIndex) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.token, (Object)dynamicEventGallery.token);
    }
}

