/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.ide.common.repository.VersionCatalogNamingUtilKt;
import com.android.tools.idea.gradle.dsl.api.GradleModelProvider;
import com.android.tools.idea.gradle.dsl.api.GradleVersionCatalogView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.toml.lang.psi.TomlFile;
import org.toml.lang.psi.TomlHeaderOwner;
import org.toml.lang.psi.TomlInlineTable;
import org.toml.lang.psi.TomlKey;
import org.toml.lang.psi.TomlKeyValue;
import org.toml.lang.psi.TomlKeyValueOwner;
import org.toml.lang.psi.TomlValue;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"findCatalogKey", "Lcom/intellij/psi/PsiElement;", "tomlFile", "Lorg/toml/lang/psi/TomlFile;", "declarationPath", "", "findAlias", "valueOwner", "Lorg/toml/lang/psi/TomlKeyValueOwner;", "target", "findVersionCatalog", "gradleDeclarationReference", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nVersionCatalogUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionCatalogUtil.kt\ncom/android/tools/idea/gradle/util/VersionCatalogUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,97:1\n2632#2,3:98\n13402#3,2:101\n*S KotlinDebug\n*F\n+ 1 VersionCatalogUtil.kt\ncom/android/tools/idea/gradle/util/VersionCatalogUtilKt\n*L\n39#1:98,3\n49#1:101,2\n*E\n"})
public final class VersionCatalogUtilKt {
    @Nullable
    public static final PsiElement findCatalogKey(@NotNull TomlFile tomlFile, @NotNull String declarationPath) {
        boolean bl;
        String target2;
        String section;
        block9: {
            Intrinsics.checkNotNullParameter((Object)tomlFile, (String)"tomlFile");
            Intrinsics.checkNotNullParameter((Object)declarationPath, (String)"declarationPath");
            Object[] objectArray = new String[]{"versions.", "bundles.", "plugins."};
            List prefix = CollectionsKt.listOf((Object[])objectArray);
            section = null;
            target2 = null;
            Iterable $this$none$iv = prefix;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)declarationPath, (String)it, (boolean)false, (int)2, null)) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        if (bl) {
            section = "libraries";
            target2 = declarationPath;
        } else {
            section = StringsKt.substringBefore$default((String)declarationPath, (char)'.', null, (int)2, null);
            target2 = StringsKt.substringAfter$default((String)declarationPath, (char)'.', null, (int)2, null);
        }
        PsiElement[] psiElementArray = tomlFile.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        Object[] $this$forEach$iv = psiElementArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String keyText;
            PsiElement element = (PsiElement)element$iv;
            boolean bl3 = false;
            if (element instanceof TomlHeaderOwner) {
                TomlKey tomlKey = ((TomlHeaderOwner)element).getHeader().getKey();
                String string = keyText = tomlKey != null ? tomlKey.getText() : null;
                if (VersionCatalogNamingUtilKt.keysMatch((String)keyText, (String)section) && element instanceof TomlKeyValueOwner) {
                    return VersionCatalogUtilKt.findAlias((TomlKeyValueOwner)element, target2);
                }
            }
            if (!(element instanceof TomlKeyValue)) continue;
            keyText = ((TomlKeyValue)element).getKey().getText();
            if (VersionCatalogNamingUtilKt.keysMatch((String)keyText, (String)(section + "." + target2))) {
                return element;
            }
            if (!(((TomlKeyValue)element).getValue() instanceof TomlInlineTable) || !VersionCatalogNamingUtilKt.keysMatch((String)keyText, (String)section)) continue;
            TomlValue tomlValue = ((TomlKeyValue)element).getValue();
            Intrinsics.checkNotNull((Object)tomlValue, (String)"null cannot be cast to non-null type org.toml.lang.psi.TomlInlineTable");
            return VersionCatalogUtilKt.findAlias((TomlKeyValueOwner)((TomlInlineTable)tomlValue), target2);
        }
        return null;
    }

    private static final PsiElement findAlias(TomlKeyValueOwner valueOwner, String target2) {
        for (TomlKeyValue entry : valueOwner.getEntries()) {
            String entryKeyText = entry.getKey().getText();
            if (!VersionCatalogNamingUtilKt.keysMatch((String)entryKeyText, (String)target2)) continue;
            return (PsiElement)entry;
        }
        return null;
    }

    @Nullable
    public static final TomlFile findVersionCatalog(@NotNull String gradleDeclarationReference, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)gradleDeclarationReference, (String)"gradleDeclarationReference");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String reference = StringsKt.substringBefore$default((String)gradleDeclarationReference, (String)".", null, (int)2, null);
        GradleVersionCatalogView gradleVersionCatalogView = GradleModelProvider.getInstance().getVersionCatalogView(project);
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersionCatalogView, (String)"getVersionCatalogView(...)");
        GradleVersionCatalogView view = gradleVersionCatalogView;
        VirtualFile virtualFile = view.getCatalogToFileMap().get(reference);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile instanceof TomlFile) {
            return (TomlFile)psiFile;
        }
        return null;
    }
}

