/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTrackerSettings;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorNotificationProvider;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.idea.core.script.settings.KotlinScriptingSettings;

public final class AndroidStudioPreferences {
    private static final List<String> PROJECT_PREFERENCES_TO_REMOVE = Arrays.asList("org.intellij.lang.xpath.xslt.associations.impl.FileAssociationsConfigurable", "com.intellij.uiDesigner.GuiDesignerConfigurable", "org.jetbrains.plugins.groovy.gant.GantConfigurable", "org.jetbrains.plugins.groovy.compiler.GroovyCompilerConfigurable", "org.jetbrains.idea.maven.utils.MavenSettings", "com.intellij.compiler.options.CompilerConfigurable", "org.jetbrains.kotlin.idea.compiler.configuration.KotlinCompilerConfigurableTab", "com.intellij.openapi.externalSystem.service.settings.ExternalSystemGroupConfigurable");
    private static final List<String> NOTIFICATION_PROVIDERS_TO_REMOVE = List.of("org.jetbrains.kotlin.idea.gradleJava.scripting.GradleScriptNotificationProvider");

    public static void unregisterUnnecessaryExtensions(@NotNull Project project) {
        AndroidStudioPreferences.disableUnnecessarySettings(project);
        AndroidStudioPreferences.disableUnnecessaryNotificationProviders(project);
    }

    private static void disableUnnecessarySettings(@NotNull Project project) {
        CompilerWorkspaceConfiguration.getInstance((Project)project).MAKE_PROJECT_ON_SAVE = false;
        ExtensionPoint projectConfigurable = Configurable.PROJECT_CONFIGURABLE.getPoint((AreaInstance)project);
        ExternalSystemProjectTrackerSettings.getInstance((Project)project).setAutoReloadType(ExternalSystemProjectTrackerSettings.AutoReloadType.NONE);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ScriptUtilsKt.getAllDefinitions((Project)project).forEach(scriptDefinition -> {
                KotlinScriptingSettings settings = KotlinScriptingSettings.Companion.getInstance(project);
                if (settings.isScriptDefinitionEnabled(scriptDefinition) && settings.autoReloadConfigurations(scriptDefinition)) {
                    settings.setAutoReloadConfigurations(scriptDefinition, false);
                }
            });
        }
        projectConfigurable.unregisterExtensions((s, adapter) -> {
            ConfigurableEP ep = (ConfigurableEP)adapter.createInstance((ComponentManager)project);
            return ep == null || !PROJECT_PREFERENCES_TO_REMOVE.contains(ep.instanceClass);
        }, false);
    }

    private static void disableUnnecessaryNotificationProviders(@NotNull Project project) {
        EditorNotificationProvider.EP_NAME.getPoint((AreaInstance)project).unregisterExtensions((s, adapter) -> !NOTIFICATION_PROVIDERS_TO_REMOVE.contains(s), false);
    }
}

