/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon;

import com.android.annotations.concurrency.Slow;
import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.gradle.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.repositories.search.ArtifactRepositorySearchService;
import com.android.tools.idea.gradle.repositories.search.FoundArtifact;
import com.android.tools.idea.gradle.repositories.search.RepositorySearchFactory;
import com.android.tools.idea.gradle.repositories.search.SearchRequest;
import com.android.tools.idea.gradle.repositories.search.SearchResult;
import com.android.tools.idea.gradle.repositories.search.SearchResultKt;
import com.android.tools.idea.gradle.repositories.search.SingleModuleSearchQuery;
import com.android.tools.idea.gradle.structure.daemon.AvailableLibraryUpdateStorage;
import com.android.tools.idea.gradle.structure.daemon.PsDaemon;
import com.android.tools.idea.gradle.structure.model.PsDeclaredLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsLibraryKey;
import com.android.tools.idea.gradle.structure.model.PsLibraryKeyKt;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsProject;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003+,-B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010 \u001a\u00020!J\u001e\u0010\"\u001a\u00020!2\u000e\b\u0001\u0010#\u001a\b\u0012\u0004\u0012\u00020!0$2\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010%\u001a\u00020!H\u0016J$\u0010&\u001a\u00020!2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001b0(H\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R!\u0010\u0014\u001a\u0015\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u00160\u0015\u00a2\u0006\u0002\b\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon;", "Lcom/android/tools/idea/gradle/structure/daemon/PsDaemon;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/android/tools/idea/gradle/structure/model/PsProject;", "repositorySearchFactory", "Lcom/android/tools/idea/gradle/repositories/search/RepositorySearchFactory;", "<init>", "(Lcom/intellij/openapi/Disposable;Lcom/android/tools/idea/gradle/structure/model/PsProject;Lcom/android/tools/idea/gradle/repositories/search/RepositorySearchFactory;)V", "availableLibraryUpdateStorage", "Lcom/android/tools/idea/gradle/structure/daemon/AvailableLibraryUpdateStorage;", "getAvailableLibraryUpdateStorage", "()Lcom/android/tools/idea/gradle/structure/daemon/AvailableLibraryUpdateStorage;", "mainQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "getMainQueue", "()Lcom/intellij/util/ui/update/MergingUpdateQueue;", "resultsUpdaterQueue", "getResultsUpdaterQueue", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon$AvailableUpdatesListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "beingSearchedKeys", "", "Lcom/android/tools/idea/gradle/structure/model/PsLibraryKey;", "runningSearches", "Ljava/util/concurrent/Future;", "runningLock", "Ljava/util/concurrent/locks/Lock;", "queueUpdateCheck", "", "add", "listener", "Lkotlin/Function0;", "dispose", "search", "repositories", "", "Lcom/android/tools/idea/gradle/repositories/search/ArtifactRepository;", "keys", "RefreshAvailableUpdates", "UpdatesAvailable", "AvailableUpdatesListener", "intellij.android.projectSystem.gradle.psd"})
@SourceDebugExtension(value={"SMAP\nPsLibraryUpdateCheckerDaemon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsLibraryUpdateCheckerDaemon.kt\ncom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n1863#2,2:178\n1202#2,2:180\n1230#2,4:182\n774#2:186\n865#2,2:187\n1557#2:189\n1628#2,3:190\n1557#2:193\n1628#2,3:194\n1557#2:197\n1628#2,3:198\n1368#2:201\n1454#2,5:202\n1863#2,2:207\n1863#2,2:209\n*S KotlinDebug\n*F\n+ 1 PsLibraryUpdateCheckerDaemon.kt\ncom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon\n*L\n75#1:178,2\n93#1:180,2\n93#1:182,4\n97#1:186\n97#1:187,2\n104#1:189\n104#1:190,3\n111#1:193\n111#1:194,3\n116#1:197\n116#1:198,3\n121#1:201\n121#1:202,5\n128#1:207,2\n134#1:209,2\n*E\n"})
public final class PsLibraryUpdateCheckerDaemon
extends PsDaemon {
    @NotNull
    private final PsProject project;
    @NotNull
    private final RepositorySearchFactory repositorySearchFactory;
    @NotNull
    private final AvailableLibraryUpdateStorage availableLibraryUpdateStorage;
    @NotNull
    private final MergingUpdateQueue mainQueue;
    @NotNull
    private final MergingUpdateQueue resultsUpdaterQueue;
    @NotNull
    private final EventDispatcher<AvailableUpdatesListener> eventDispatcher;
    @NotNull
    private final Set<PsLibraryKey> beingSearchedKeys;
    @NotNull
    private final Set<Future<?>> runningSearches;
    @NotNull
    private final Lock runningLock;

    public PsLibraryUpdateCheckerDaemon(@NotNull Disposable parentDisposable, @NotNull PsProject project, @NotNull RepositorySearchFactory repositorySearchFactory) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repositorySearchFactory, (String)"repositorySearchFactory");
        super(parentDisposable);
        this.project = project;
        this.repositorySearchFactory = repositorySearchFactory;
        this.availableLibraryUpdateStorage = AvailableLibraryUpdateStorage.Companion.getInstance(this.project.getIdeProject());
        this.mainQueue = this.createQueue("Project Structure Daemon Update Checker", null);
        this.resultsUpdaterQueue = this.createQueue("Project Structure Available Update Results Updater", MergingUpdateQueue.ANY_COMPONENT);
        EventDispatcher eventDispatcher = EventDispatcher.create(AvailableUpdatesListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.eventDispatcher = eventDispatcher;
        Set set2 = Collections.newSetFromMap(new ConcurrentHashMap());
        Intrinsics.checkNotNullExpressionValue(set2, (String)"newSetFromMap(...)");
        this.beingSearchedKeys = set2;
        this.runningSearches = new LinkedHashSet();
        this.runningLock = new ReentrantLock();
    }

    @NotNull
    public final AvailableLibraryUpdateStorage getAvailableLibraryUpdateStorage() {
        return this.availableLibraryUpdateStorage;
    }

    @Override
    @NotNull
    protected MergingUpdateQueue getMainQueue() {
        return this.mainQueue;
    }

    @Override
    @NotNull
    protected MergingUpdateQueue getResultsUpdaterQueue() {
        return this.resultsUpdaterQueue;
    }

    public final void queueUpdateCheck() {
        this.getMainQueue().queue((Update)new RefreshAvailableUpdates());
    }

    public final void add(@UiThread @NotNull Function0<Unit> listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.eventDispatcher.addListener((EventListener)new AvailableUpdatesListener(listener2){
            final /* synthetic */ Function0<Unit> $listener;
            {
                this.$listener = $listener;
            }

            @UiThread
            public void availableUpdates() {
                this.$listener.invoke();
            }
        }, parentDisposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        super.dispose();
        Lock lock = this.runningLock;
        lock.lock();
        try {
            boolean bl = false;
            Iterable $this$forEach$iv = this.runningSearches;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Future it = (Future)element$iv;
                boolean bl2 = false;
                it.cancel(true);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Slow
    private final void search(Collection<? extends ArtifactRepository> repositories, Collection<PsLibraryKey> keys) {
        Iterator $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Object destination$iv$iv;
        Iterable $this$mapTo$iv$iv;
        List $i$a$-withLock-PsLibraryUpdateCheckerDaemon$search$resultFutures$2;
        Object future2;
        Lock $this$filterTo$iv$iv;
        void $this$filter$iv;
        PsLibraryKey it;
        Object object;
        Object element$iv$iv2;
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        AvailableLibraryUpdateStorage updateStorage = this.availableLibraryUpdateStorage;
        long currentTimeMillis = System.currentTimeMillis();
        Iterable iterable = updateStorage.retainAll((Function1<? super AvailableLibraryUpdateStorage.AvailableLibraryUpdate, Boolean>)((Function1)arg_0 -> PsLibraryUpdateCheckerDaemon.search$lambda$2(currentTimeMillis, keys, arg_0)));
        boolean $i$f$associateBy22 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var10_10 = $this$associateBy$iv;
        Object destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv2 : $this$associateByTo$iv$iv) {
            AvailableLibraryUpdateStorage.AvailableLibraryUpdate availableLibraryUpdate = (AvailableLibraryUpdateStorage.AvailableLibraryUpdate)element$iv$iv2;
            object = destination$iv$iv2;
            boolean bl = false;
            object.put(((AvailableLibraryUpdateStorage.AvailableLibraryUpdate)((Object)it)).toLibraryKey(), element$iv$iv2);
        }
        Map existingUpdateKeys = destination$iv$iv2;
        Iterable $i$f$associateBy22 = keys;
        boolean $i$f$filter = false;
        $this$associateByTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv2 = iterator2.next();
            it = (PsLibraryKey)element$iv$iv2;
            boolean bl = false;
            if (!(!existingUpdateKeys.containsKey(it) && this.beingSearchedKeys.add(it))) continue;
            destination$iv$iv2.add(element$iv$iv2);
        }
        Set requests2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        ArtifactRepositorySearchService searcher = this.repositorySearchFactory.create(repositories);
        $this$filterTo$iv$iv = this.runningLock;
        $this$filterTo$iv$iv.lock();
        try {
            void $this$mapTo$iv$iv2;
            boolean bl = false;
            if (this.isStopped()) {
                return;
            }
            Iterable $this$map$iv = requests2;
            boolean $i$f$map2 = false;
            element$iv$iv2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void key;
                PsLibraryKey psLibraryKey = (PsLibraryKey)item$iv$iv2;
                Collection collection2 = destination$iv$iv3;
                boolean bl2 = false;
                future2 = searcher.search(new SearchRequest(new SingleModuleSearchQuery(key.getGroup(), key.getName()), 1, 0));
                this.runningSearches.add((Future<?>)future2);
                collection2.add(TuplesKt.to((Object)key, future2));
            }
            $i$a$-withLock-PsLibraryUpdateCheckerDaemon$search$resultFutures$2 = (List)destination$iv$iv3;
        }
        finally {
            $this$filterTo$iv$iv.unlock();
        }
        List resultFutures = $i$a$-withLock-PsLibraryUpdateCheckerDaemon$search$resultFutures$2;
        Object $this$map$iv = resultFutures;
        boolean $i$f$map = false;
        Iterable $i$f$map2 = $this$map$iv;
        Set<Future<?>> destination$iv$iv4 = (Set<Future<?>>)((Object)new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10)));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Object item$iv$iv2;
            item$iv$iv2 = (Pair)item$iv$iv;
            object = destination$iv$iv4;
            boolean bl = false;
            object.add(TuplesKt.to((Object)it2.getFirst(), (Object)SearchResultKt.getResultSafely((Future)it2.getSecond())));
        }
        List searchResults = (List)((Object)destination$iv$iv4);
        $this$map$iv = this.runningLock;
        $this$map$iv.lock();
        try {
            void $this$mapTo$iv$iv3;
            void $this$map$iv2;
            boolean bl = false;
            $this$mapTo$iv$iv = resultFutures;
            destination$iv$iv4 = this.runningSearches;
            boolean $i$f$map3 = false;
            Iterator $i$f$mapTo2 = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it3;
                Pair bl2 = (Pair)item$iv$iv;
                future2 = destination$iv$iv;
                boolean bl3 = false;
                future2.add((ListenableFuture)((ListenableFuture)it3.getSecond()));
            }
            bl = destination$iv$iv4.removeAll((List)destination$iv$iv);
        }
        finally {
            $this$map$iv.unlock();
        }
        Iterable bl = searchResults;
        boolean $i$f$flatMap = false;
        destination$iv$iv4 = $this$flatMap$iv;
        Collection destination$iv$iv5 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        destination$iv$iv = $this$flatMapTo$iv$iv.iterator();
        while (destination$iv$iv.hasNext()) {
            Object element$iv$iv3 = destination$iv$iv.next();
            Pair it4 = (Pair)element$iv$iv3;
            boolean bl4 = false;
            Object object2 = (SearchResult)it4.getSecond();
            if (object2 == null || (object2 = ((SearchResult)object2).getArtifacts()) == null || (object2 = UtilKt.nullize((List)object2)) == null) {
                PsLibraryUpdateCheckerDaemon $this$search_u24lambda_u2411_u24lambda_u2410 = this;
                boolean bl5 = false;
                PsLibraryKey key = (PsLibraryKey)it4.getFirst();
                SearchResult result2 = (SearchResult)it4.getSecond();
                Object object3 = result2;
                object2 = (object3 != null && (object3 = ((SearchResult)object3).getErrors()) != null ? object3.isEmpty() : false) ? CollectionsKt.listOf((Object)new FoundArtifact("", key.getGroup(), key.getName(), CollectionsKt.emptyList())) : CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = (Iterable)object2;
            CollectionsKt.addAll((Collection)destination$iv$iv5, (Iterable)list$iv$iv);
        }
        List foundArtifacts = (List)destination$iv$iv5;
        Iterable $this$forEach$iv = searchResults;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it5 = (Pair)element$iv;
            boolean bl6 = false;
            this.beingSearchedKeys.remove(it5.getFirst());
        }
        Lock lock = this.runningLock;
        lock.lock();
        try {
            boolean bl7 = false;
            if (!this.isStopped()) {
                Iterable $this$forEach$iv2 = foundArtifacts;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    FoundArtifact it6 = (FoundArtifact)element$iv;
                    boolean bl8 = false;
                    updateStorage.addOrUpdate(it6, currentTimeMillis);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        this.getResultsUpdaterQueue().queue((Update)new UpdatesAvailable());
    }

    private static final boolean search$lambda$2(long $currentTimeMillis, Collection $keys, AvailableLibraryUpdateStorage.AvailableLibraryUpdate it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        long searchTimeMillis = it.getLastSearchTimeMillis();
        return searchTimeMillis > 0L && TimeUnit.MILLISECONDS.toDays($currentTimeMillis - searchTimeMillis) < 3L && $keys.contains(it.toLibraryKey());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H'\u00a8\u0006\u0004\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon$AvailableUpdatesListener;", "Ljava/util/EventListener;", "availableUpdates", "", "intellij.android.projectSystem.gradle.psd"})
    private static interface AvailableUpdatesListener
    extends EventListener {
        @UiThread
        public void availableUpdates();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon$RefreshAvailableUpdates;", "Lcom/intellij/util/ui/update/Update;", "<init>", "(Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon;)V", "run", "", "intellij.android.projectSystem.gradle.psd"})
    @SourceDebugExtension(value={"SMAP\nPsLibraryUpdateCheckerDaemon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsLibraryUpdateCheckerDaemon.kt\ncom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon$RefreshAvailableUpdates\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n1863#2:178\n1557#2:179\n1628#2,3:180\n1864#2:183\n*S KotlinDebug\n*F\n+ 1 PsLibraryUpdateCheckerDaemon.kt\ncom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon$RefreshAvailableUpdates\n*L\n146#1:178\n152#1:179\n152#1:180,3\n146#1:183\n*E\n"})
    private final class RefreshAvailableUpdates
    extends Update {
        public RefreshAvailableUpdates() {
            super((Object)PsLibraryUpdateCheckerDaemon.this.project, false, 0, 6, null);
        }

        public void run() {
            Set repositories = new LinkedHashSet();
            Set keys = new LinkedHashSet();
            ActionsKt.invokeAndWaitIfNeeded((ModalityState)ModalityState.any(), () -> RefreshAvailableUpdates.run$lambda$2(this, PsLibraryUpdateCheckerDaemon.this, repositories, keys));
            if (!repositories.isEmpty() && !keys.isEmpty()) {
                PsLibraryUpdateCheckerDaemon.this.search(repositories, keys);
            } else {
                PsLibraryUpdateCheckerDaemon.this.getResultsUpdaterQueue().queue((Update)new UpdatesAvailable());
            }
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit run$lambda$2(RefreshAvailableUpdates this$0, PsLibraryUpdateCheckerDaemon this$1, Set $repositories, Set $keys) {
            if (this$0.isDisposed() || this$1.isStopped()) {
                return Unit.INSTANCE;
            }
            Iterable $this$forEach$iv = this$1.project.getModules();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                PsModule module = (PsModule)element$iv;
                boolean bl = false;
                $repositories.addAll(module.getArtifactRepositories());
                Iterable iterable = module.getDependencies().getLibraries();
                Set set2 = $keys;
                boolean $i$f$map = false;
                void var13_13 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    PsDeclaredLibraryDependency psDeclaredLibraryDependency = (PsDeclaredLibraryDependency)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl2 = false;
                    collection2.add(PsLibraryKeyKt.toLibraryKey(it.getSpec()));
                }
                set2.addAll((List)destination$iv$iv);
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon$UpdatesAvailable;", "Lcom/intellij/util/ui/update/Update;", "<init>", "(Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon;)V", "run", "", "intellij.android.projectSystem.gradle.psd"})
    private final class UpdatesAvailable
    extends Update {
        public UpdatesAvailable() {
            super((Object)PsLibraryUpdateCheckerDaemon.this.project, false, 0, 6, null);
        }

        @UiThread
        public void run() {
            ((AvailableUpdatesListener)PsLibraryUpdateCheckerDaemon.this.eventDispatcher.getMulticaster()).availableUpdates();
        }
    }
}

