/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui.dependencies;

import com.android.tools.idea.gradle.structure.configurables.dependencies.details.DependencyDetails;
import com.android.tools.idea.gradle.structure.configurables.issues.IssuesViewer;
import com.android.tools.idea.gradle.structure.configurables.ui.CollapsiblePanel;
import com.android.tools.idea.gradle.structure.configurables.ui.UiUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class DependencyInfoPanel {
    private JPanel myMainPanel;
    private JPanel myDependencyDetailsPanel;
    private JPanel myIssuesPanel;

    public DependencyInfoPanel() {
        this.setupUI();
    }

    void setDependencyDetails(@NotNull DependencyDetails details) {
        ((CollapsiblePanel)this.myDependencyDetailsPanel).setContents(details.getPanel());
        this.revalidateAndRepaintPanel();
    }

    @NotNull
    JPanel getPanel() {
        return this.myMainPanel;
    }

    void setIssuesViewer(@NotNull IssuesViewer viewer) {
        this.myIssuesPanel.add((Component)viewer.getPanel(), "Center");
        this.revalidateAndRepaintPanel();
    }

    private void createUIComponents() {
        this.myDependencyDetailsPanel = new CollapsiblePanel("Details");
        this.myIssuesPanel = new JPanel(new BorderLayout());
    }

    void revalidateAndRepaintPanel() {
        UiUtil.revalidateAndRepaint(this.myMainPanel);
    }

    private void setupUI() {
        this.createUIComponents();
        this.myMainPanel = new JPanel();
        this.myMainPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myMainPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), null, 0, 0, null, null));
        this.myMainPanel.add((Component)this.myDependencyDetailsPanel, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null, 0, false));
        this.myMainPanel.add((Component)this.myIssuesPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 5, null, null, null, 0, false));
    }
}

