/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui.dependencies;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.issues.IssuesBySeverityPathTextComparator;
import com.android.tools.idea.gradle.structure.configurables.ui.AbstractPsModelTableCellRenderer;
import com.android.tools.idea.gradle.structure.configurables.ui.PsUISettings;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsBaseDependency;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueCollection;
import com.android.tools.idea.gradle.structure.model.PsIssueCollectionKt;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsModuleDependency;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.Color;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDeclaredDependenciesTableModel<T extends PsBaseDependency>
extends ListTableModel<T> {
    @NotNull
    private final PsModule myModule;
    @NotNull
    private final PsContext myContext;
    @Nullable
    private PsModuleDependency myHoveredDependency;

    protected AbstractDeclaredDependenciesTableModel(@NotNull PsModule module, @NotNull PsContext context) {
        super(new ColumnInfo[0]);
        this.myModule = module;
        this.myContext = context;
        this.createAndSetColumnInfos();
        this.reset();
    }

    private void createAndSetColumnInfos() {
        ColumnInfo specColumnInfo = new ColumnInfo<T, String>("Dependency"){

            @NotNull
            public String valueOf(T dependency) {
                return dependency.toText();
            }

            @NotNull
            public TableCellRenderer getRenderer(T dependency) {
                return new DependencyCellRenderer((PsBaseDependency)dependency, AbstractDeclaredDependenciesTableModel.this.myContext, dependency == AbstractDeclaredDependenciesTableModel.this.myHoveredDependency);
            }

            @NotNull
            public String getPreferredStringValue() {
                return "com.android.support:appcompat-v7:23.1.0";
            }
        };
        ColumnInfo scopeColumnInfo = new ColumnInfo<T, String>("Configuration"){

            @Nullable
            public String valueOf(T dependency) {
                return dependency.getJoinedConfigurationNames();
            }

            @NotNull
            public String getPreferredStringValue() {
                return "flavor1AndroidTestCompile";
            }
        };
        this.setColumnInfos(new ColumnInfo[]{specColumnInfo, scopeColumnInfo});
    }

    @NotNull
    protected PsModule getModule() {
        return this.myModule;
    }

    public void setHoveredDependency(@Nullable PsModuleDependency hoveredDependency) {
        this.myHoveredDependency = hoveredDependency;
    }

    public void reset() {
    }

    @NotNull
    protected PsContext getContext() {
        return this.myContext;
    }

    @NotNull
    static String displayTextOf(@NotNull PsBaseDependency dependency, @NotNull PsUISettings uiSettings) {
        String text2 = dependency.toText();
        if (dependency instanceof PsLibraryDependency) {
            PsLibraryDependency library = (PsLibraryDependency)dependency;
            PsArtifactDependencySpec spec = library.getSpec();
            text2 = spec.getDisplayText(uiSettings);
        }
        return text2;
    }

    static class DependencyCellRenderer
    extends AbstractPsModelTableCellRenderer<PsBaseDependency> {
        @NotNull
        private final PsBaseDependency myDependency;
        @NotNull
        private final PsContext myContext;
        private final boolean myIsHovered;

        DependencyCellRenderer(@NotNull PsBaseDependency dependency, @NotNull PsContext context, boolean isHovered) {
            super(dependency);
            this.myDependency = dependency;
            this.myContext = context;
            this.myIsHovered = isHovered;
        }

        @Override
        protected void customizeCellRenderer(@NotNull JTable table2, @Nullable Object value2, boolean selected, boolean hasFocus, int row, int column2) {
            SimpleTextAttributes textAttributes;
            this.setIcon(this.myDependency.getIcon());
            this.setIconOpaque(true);
            this.setFocusBorderAroundIcon(true);
            PsIssueCollection issueCollection = this.myContext.getAnalyzerDaemon().getIssues();
            List<PsIssue> issues2 = issueCollection.findIssues(this.myDependency.getPath(), IssuesBySeverityPathTextComparator.INSTANCE);
            this.setToolTipText(PsIssueCollectionKt.getTooltipText(issues2, false));
            if (this.myIsHovered) {
                textAttributes = SimpleTextAttributes.LINK_ATTRIBUTES;
            } else {
                textAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                if (!issues2.isEmpty()) {
                    PsIssue issue2 = issues2.get(0);
                    Color waveColor = issue2.getSeverity().getColor();
                    textAttributes = textAttributes.derive(8, null, null, waveColor);
                }
            }
            this.append(this.getText(), textAttributes);
        }

        @Override
        @NotNull
        protected String getText() {
            return AbstractDeclaredDependenciesTableModel.displayTextOf((PsBaseDependency)this.getModel(), this.myContext.getUiSettings());
        }
    }
}

