/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui;

import com.android.ide.common.gradle.Version;
import com.android.tools.idea.gradle.repositories.search.ArtifactRepositorySearchService;
import com.android.tools.idea.gradle.repositories.search.FoundArtifact;
import com.android.tools.idea.gradle.repositories.search.SearchRequest;
import com.android.tools.idea.gradle.repositories.search.SearchResult;
import com.android.tools.idea.gradle.structure.configurables.ui.ArtifactRepositorySearchForm;
import com.android.tools.idea.gradle.structure.configurables.ui.ArtifactRepositorySearchFormKt;
import com.android.tools.idea.gradle.structure.configurables.ui.ArtifactRepositorySearchFormUi;
import com.android.tools.idea.gradle.structure.configurables.ui.ArtifactSearchQuery;
import com.android.tools.idea.gradle.structure.configurables.ui.AvailableVersionsPanel;
import com.android.tools.idea.gradle.structure.configurables.ui.FutureUtilsKt;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeEventDispatcher;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeListener;
import com.android.tools.idea.gradle.structure.model.PsVariablesScope;
import com.android.tools.idea.gradle.structure.model.meta.ParsedValue;
import com.intellij.openapi.Disposable;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.StatusText;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010%\u001a\u00020&H\u0002J\u0016\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u0011H\u0002J\b\u0010,\u001a\u00020(H\u0002J\b\u0010-\u001a\u00020(H\u0002J\b\u0010.\u001a\u00020(H\u0002J\f\u0010/\u001a\u000200*\u00020&H\u0002J\u0012\u00101\u001a\u0002002\b\u00102\u001a\u0004\u0018\u00010\u0012H\u0002J\"\u00103\u001a\u00020(2\u0012\u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0011052\u0006\u00106\u001a\u000207R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR2\u0010\"\u001a\f\u0012\b\u0012\u00060 j\u0002`!0\u001f2\u0010\u0010\u001e\u001a\f\u0012\b\u0012\u00060 j\u0002`!0\u001f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0010\u0010+\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/android/tools/idea/gradle/structure/configurables/ui/ArtifactRepositorySearchForm;", "Lcom/android/tools/idea/gradle/structure/configurables/ui/ArtifactRepositorySearchFormUi;", "variables", "Lcom/android/tools/idea/gradle/structure/model/PsVariablesScope;", "repositorySearch", "Lcom/android/tools/idea/gradle/repositories/search/ArtifactRepositorySearchService;", "<init>", "(Lcom/android/tools/idea/gradle/structure/model/PsVariablesScope;Lcom/android/tools/idea/gradle/repositories/search/ArtifactRepositorySearchService;)V", "getVariables", "()Lcom/android/tools/idea/gradle/structure/model/PsVariablesScope;", "resultsTable", "Lcom/intellij/ui/table/TableView;", "Lcom/android/tools/idea/gradle/repositories/search/FoundArtifact;", "versionsPanel", "Lcom/android/tools/idea/gradle/structure/configurables/ui/AvailableVersionsPanel;", "eventDispatcher", "Lcom/android/tools/idea/gradle/structure/configurables/ui/SelectionChangeEventDispatcher;", "Lcom/android/tools/idea/gradle/structure/model/meta/ParsedValue;", "", "selectedArtifact", "getSelectedArtifact", "()Lcom/android/tools/idea/gradle/repositories/search/FoundArtifact;", "panel", "Ljavax/swing/JPanel;", "getPanel", "()Ljavax/swing/JPanel;", "preferredFocusedComponent", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "()Ljavax/swing/JComponent;", "value", "", "Ljava/lang/Exception;", "Lkotlin/Exception;", "searchErrors", "getSearchErrors", "()Ljava/util/List;", "getQuery", "Lcom/android/tools/idea/gradle/structure/configurables/ui/ArtifactSearchQuery;", "notifyVersionSelectionChanged", "", "version", "Lcom/android/ide/common/gradle/Version;", "currentSearchQuery", "performSearch", "clearResults", "showSearchStopped", "calculateQueryLength", "", "normalizedLength", "str", "add", "listener", "Lcom/android/tools/idea/gradle/structure/configurables/ui/SelectionChangeListener;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "ResultsTableModel", "intellij.android.projectSystem.gradle.psd"})
@SourceDebugExtension(value={"SMAP\nArtifactRepositorySearchForm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArtifactRepositorySearchForm.kt\ncom/android/tools/idea/gradle/structure/configurables/ui/ArtifactRepositorySearchForm\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,339:1\n1#2:340\n*E\n"})
public final class ArtifactRepositorySearchForm
extends ArtifactRepositorySearchFormUi {
    @NotNull
    private final PsVariablesScope variables;
    @NotNull
    private final ArtifactRepositorySearchService repositorySearch;
    @NotNull
    private final TableView<FoundArtifact> resultsTable;
    @NotNull
    private final AvailableVersionsPanel versionsPanel;
    @NotNull
    private final SelectionChangeEventDispatcher<ParsedValue<String>> eventDispatcher;
    @NotNull
    private List<? extends Exception> searchErrors;
    @Nullable
    private ArtifactSearchQuery currentSearchQuery;

    public ArtifactRepositorySearchForm(@NotNull PsVariablesScope variables, @NotNull ArtifactRepositorySearchService repositorySearch) {
        StatusText statusText;
        Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
        Intrinsics.checkNotNullParameter((Object)repositorySearch, (String)"repositorySearch");
        this.variables = variables;
        this.repositorySearch = repositorySearch;
        this.eventDispatcher = new SelectionChangeEventDispatcher();
        this.searchErrors = CollectionsKt.emptyList();
        DocumentAdapter inputChangedListener2 = new DocumentAdapter(this){
            final /* synthetic */ ArtifactRepositorySearchForm this$0;
            {
                this.this$0 = $receiver;
            }

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ArtifactRepositorySearchForm.access$clearResults(this.this$0);
                ArtifactRepositorySearchForm.access$showSearchStopped(this.this$0);
            }
        };
        this.myArtifactQueryTextField.getDocument().addDocumentListener((DocumentListener)inputChangedListener2);
        ActionListener actionListener2 = arg_0 -> ArtifactRepositorySearchForm._init_$lambda$0(this, arg_0);
        this.mySearchButton.addActionListener(actionListener2);
        this.myArtifactQueryTextField.addActionListener(actionListener2);
        StatusText $this$_init__u24lambda_u241 = statusText = this.myArtifactQueryTextField.getEmptyText();
        boolean bl = false;
        $this$_init__u24lambda_u241.clear();
        $this$_init__u24lambda_u241.appendText("Example: ", SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
        $this$_init__u24lambda_u241.appendText("guava", SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        $this$_init__u24lambda_u241.appendText(" or ", SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
        $this$_init__u24lambda_u241.appendText("com.google.*:*", SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        $this$_init__u24lambda_u241.appendText(" or ", SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
        $this$_init__u24lambda_u241.appendText("guava*", SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        this.resultsTable = new TableView((ListTableModel)new ResultsTableModel());
        this.resultsTable.setSelectionMode(0);
        this.resultsTable.setAutoCreateRowSorter(true);
        this.resultsTable.setShowGrid(false);
        this.resultsTable.getTableHeader().setReorderingAllowed(false);
        this.versionsPanel = new AvailableVersionsPanel(arg_0 -> ArtifactRepositorySearchForm._init_$lambda$2(this, arg_0));
        this.resultsTable.getSelectionModel().addListSelectionListener(arg_0 -> ArtifactRepositorySearchForm._init_$lambda$3(this, arg_0));
        OnePixelSplitter splitter = new OnePixelSplitter(false, 0.7f);
        splitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)((Component)this.resultsTable)));
        splitter.setSecondComponent((JComponent)this.versionsPanel);
        this.myResultsPanel.add((Component)splitter, "Center");
        TableSpeedSearch.installOn((JTable)((JTable)this.resultsTable));
    }

    @NotNull
    public final PsVariablesScope getVariables() {
        return this.variables;
    }

    private final FoundArtifact getSelectedArtifact() {
        Collection collection2 = this.resultsTable.getSelection();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getSelection(...)");
        return (FoundArtifact)CollectionsKt.singleOrNull((Iterable)collection2);
    }

    @NotNull
    public final JPanel getPanel() {
        JPanel jPanel = this.myPanel;
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"myPanel");
        return jPanel;
    }

    @NotNull
    public final JComponent getPreferredFocusedComponent() {
        JBTextField jBTextField = this.myArtifactQueryTextField;
        Intrinsics.checkNotNullExpressionValue((Object)jBTextField, (String)"myArtifactQueryTextField");
        return (JComponent)jBTextField;
    }

    @NotNull
    public final List<Exception> getSearchErrors() {
        return this.searchErrors;
    }

    private final ArtifactSearchQuery getQuery() {
        String string = this.myArtifactQueryTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return ArtifactRepositorySearchFormKt.parseArtifactSearchQuery(string);
    }

    private final void notifyVersionSelectionChanged(ParsedValue<Version> version2) {
        Object object;
        block8: {
            block7: {
                ParsedValue<String> parsedValue;
                object = this.getSelectedArtifact();
                if (object == null) break block7;
                FoundArtifact selectedArtifact = object;
                boolean bl = false;
                ParsedValue<Version> parsedValue2 = version2;
                if (Intrinsics.areEqual(parsedValue2, (Object)ParsedValue.NotSet.INSTANCE)) {
                    parsedValue = ParsedValue.NotSet.INSTANCE;
                } else if (parsedValue2 instanceof ParsedValue.Set.Parsed) {
                    parsedValue = ArtifactRepositorySearchFormKt.versionToLibrary(selectedArtifact, (ParsedValue.Set.Parsed)version2);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                object = parsedValue;
                if (parsedValue != null) break block8;
            }
            object = ParsedValue.NotSet.INSTANCE;
        }
        Object selectedLibrary = object;
        this.eventDispatcher.selectionChanged((ParsedValue<String>)selectedLibrary);
    }

    private final void performSearch() {
        ArtifactSearchQuery artifactSearchQuery;
        this.mySearchButton.setEnabled(false);
        this.versionsPanel.setEmptyText("Searching...");
        this.resultsTable.getEmptyText().setText("Searching...");
        this.resultsTable.setPaintBusy(true);
        this.clearResults();
        ArtifactSearchQuery it = artifactSearchQuery = this.getQuery();
        boolean bl = false;
        this.currentSearchQuery = it;
        ArtifactSearchQuery searchQuery = artifactSearchQuery;
        SearchRequest request = new SearchRequest(ArtifactRepositorySearchFormKt.access$toSearchQuery(searchQuery), 200, 0);
        FutureUtilsKt.continueOnEdt(this.repositorySearch.search(request), arg_0 -> ArtifactRepositorySearchForm.performSearch$lambda$8(this, searchQuery, arg_0));
    }

    private final void clearResults() {
        this.currentSearchQuery = null;
        this.resultsTable.getListTableModel().setItems(CollectionsKt.emptyList());
        this.searchErrors = CollectionsKt.emptyList();
        this.versionsPanel.clear();
    }

    private final void showSearchStopped() {
        this.mySearchButton.setEnabled(this.calculateQueryLength(this.getQuery()) >= 3);
        this.resultsTable.setPaintBusy(false);
        this.resultsTable.getEmptyText().setText("Nothing to show");
        this.versionsPanel.setEmptyText("Nothing to show");
    }

    private final int calculateQueryLength(ArtifactSearchQuery $this$calculateQueryLength) {
        return this.normalizedLength($this$calculateQueryLength.getArtifactName()) + this.normalizedLength($this$calculateQueryLength.getGroupId()) + this.normalizedLength($this$calculateQueryLength.getId());
    }

    private final int normalizedLength(String str) {
        String string = str;
        return string != null && (string = StringsKt.replace$default((String)string, (String)"*", (String)"", (boolean)false, (int)4, null)) != null ? string.length() : 0;
    }

    public final void add(@NotNull SelectionChangeListener<ParsedValue<String>> listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.eventDispatcher.addListener(listener2, parentDisposable);
    }

    private static final void _init_$lambda$0(ArtifactRepositorySearchForm this$0, ActionEvent it) {
        if (this$0.mySearchButton.isEnabled()) {
            this$0.performSearch();
        }
    }

    private static final void _init_$lambda$2(ArtifactRepositorySearchForm this$0, ParsedValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.notifyVersionSelectionChanged(it);
    }

    private static final void _init_$lambda$3(ArtifactRepositorySearchForm this$0, ListSelectionEvent it) {
        FoundArtifact artifact = this$0.getSelectedArtifact();
        ArtifactSearchQuery searchQuery = this$0.currentSearchQuery;
        if (searchQuery != null && artifact != null) {
            this$0.versionsPanel.setVersions(ArtifactRepositorySearchFormKt.prepareArtifactVersionChoices(searchQuery, artifact, this$0.variables));
        } else {
            this$0.notifyVersionSelectionChanged(ParsedValue.NotSet.INSTANCE);
        }
    }

    private static final Unit performSearch$lambda$8(ArtifactRepositorySearchForm this$0, ArtifactSearchQuery $searchQuery, SearchResult results2) {
        Intrinsics.checkNotNullParameter((Object)results2, (String)"results");
        List list = CollectionsKt.sorted((Iterable)results2.getArtifacts());
        Object it = list;
        boolean bl = false;
        List list2 = !it.isEmpty() ? list : null;
        if (list2 == null) {
            it = this$0;
            boolean bl2 = false;
            list2 = $searchQuery.getComponent() != null ? CollectionsKt.listOf((Object)new FoundArtifact("(none)", $searchQuery.getComponent().getGroup(), $searchQuery.getComponent().getName(), $searchQuery.getComponent().getVersion())) : CollectionsKt.emptyList();
        }
        List foundArtifacts = list2;
        this$0.resultsTable.getListTableModel().setItems(foundArtifacts);
        this$0.resultsTable.updateColumnSizes();
        if (!((Collection)foundArtifacts).isEmpty()) {
            this$0.resultsTable.changeSelection(0, 0, false, false);
        }
        this$0.resultsTable.requestFocusInWindow();
        List<Exception> errors = results2.getErrors();
        if (!((Collection)errors).isEmpty()) {
            this$0.searchErrors = errors;
        }
        this$0.showSearchStopped();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$clearResults(ArtifactRepositorySearchForm $this) {
        $this.clearResults();
    }

    public static final /* synthetic */ void access$showSearchStopped(ArtifactRepositorySearchForm $this) {
        $this.showSearchStopped();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/gradle/structure/configurables/ui/ArtifactRepositorySearchForm$ResultsTableModel;", "Lcom/intellij/util/ui/ListTableModel;", "Lcom/android/tools/idea/gradle/repositories/search/FoundArtifact;", "<init>", "()V", "createAndSetColumnInfos", "", "intellij.android.projectSystem.gradle.psd"})
    private static final class ResultsTableModel
    extends ListTableModel<FoundArtifact> {
        public ResultsTableModel() {
            super(new ColumnInfo[0]);
            this.createAndSetColumnInfos();
            this.setSortable(true);
        }

        private final void createAndSetColumnInfos() {
            createAndSetColumnInfos.column.1[] nullArray = new createAndSetColumnInfos.column.1[]{ResultsTableModel.createAndSetColumnInfos$column("Group ID", "abcdefghijklmno", (Function1<? super FoundArtifact, String>)((Function1)ResultsTableModel::createAndSetColumnInfos$lambda$0)), ResultsTableModel.createAndSetColumnInfos$column("Artifact Name", "abcdefg", (Function1<? super FoundArtifact, String>)((Function1)ResultsTableModel::createAndSetColumnInfos$lambda$1)), ResultsTableModel.createAndSetColumnInfos$column$default("Repository", null, ResultsTableModel::createAndSetColumnInfos$lambda$2, 2, null)};
            this.setColumnInfos(nullArray);
        }

        private static final createAndSetColumnInfos.column.1 createAndSetColumnInfos$column(String title2, String preferredWidthTextSample, Function1<? super FoundArtifact, String> valueOf) {
            return new ColumnInfo<FoundArtifact, String>(title2, valueOf, preferredWidthTextSample){
                final /* synthetic */ Function1<FoundArtifact, String> $valueOf;
                final /* synthetic */ String $preferredWidthTextSample;
                {
                    this.$valueOf = $valueOf;
                    this.$preferredWidthTextSample = $preferredWidthTextSample;
                    super($title);
                }

                public String valueOf(FoundArtifact found) {
                    Intrinsics.checkNotNullParameter((Object)found, (String)"found");
                    return (String)this.$valueOf.invoke((Object)found);
                }

                @NonNls
                public String getPreferredStringValue() {
                    return this.$preferredWidthTextSample;
                }
            };
        }

        static /* synthetic */ createAndSetColumnInfos.column.1 createAndSetColumnInfos$column$default(String string, String string2, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            return ResultsTableModel.createAndSetColumnInfos$column(string, string2, (Function1<? super FoundArtifact, String>)function1);
        }

        private static final String createAndSetColumnInfos$lambda$0(FoundArtifact it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getGroupId();
        }

        private static final String createAndSetColumnInfos$lambda$1(FoundArtifact it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getName();
        }

        private static final String createAndSetColumnInfos$lambda$2(FoundArtifact it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return CollectionsKt.joinToString$default((Iterable)it.getRepositoryNames(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        }
    }
}

