/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.suggestions;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.issues.IssuesBySeverityPathTextComparator;
import com.android.tools.idea.gradle.structure.configurables.suggestions.SuggestionsFormUi;
import com.android.tools.idea.gradle.structure.configurables.suggestions.SuggestionsViewIssueRenderer;
import com.android.tools.idea.gradle.structure.configurables.suggestions.SuggestionsViewer;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.navigation.Place;
import java.util.Comparator;
import java.util.List;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0014\u001a\u00020\u0015H\u0007J%\u0010\u0016\u001a\u00020\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\b\u0010\u001d\u001a\u00020\u0015H\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/gradle/structure/configurables/suggestions/SuggestionsForm;", "Lcom/android/tools/idea/gradle/structure/configurables/suggestions/SuggestionsFormUi;", "Lcom/intellij/openapi/Disposable;", "context", "Lcom/android/tools/idea/gradle/structure/configurables/PsContext;", "suggestionsViewIssueRenderer", "Lcom/android/tools/idea/gradle/structure/configurables/suggestions/SuggestionsViewIssueRenderer;", "<init>", "(Lcom/android/tools/idea/gradle/structure/configurables/PsContext;Lcom/android/tools/idea/gradle/structure/configurables/suggestions/SuggestionsViewIssueRenderer;)V", "maxNumberOfIssuesToShow", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "panel", "Ljavax/swing/JPanel;", "getPanel", "()Ljavax/swing/JPanel;", "issuesViewer", "Lcom/android/tools/idea/gradle/structure/configurables/suggestions/SuggestionsViewer;", "updateLoading", "", "renderIssues", "issues", "", "Lcom/android/tools/idea/gradle/structure/model/PsIssue;", "scope", "Lcom/android/tools/idea/gradle/structure/model/PsPath;", "renderIssues$intellij_android_projectSystem_gradle_psd", "dispose", "navigateTo", "Lcom/intellij/openapi/util/ActionCallback;", "place", "Lcom/intellij/ui/navigation/Place;", "requestFocus", "", "queryPlace", "intellij.android.projectSystem.gradle.psd"})
public final class SuggestionsForm
extends SuggestionsFormUi
implements Disposable {
    @NotNull
    private final PsContext context;
    private final int maxNumberOfIssuesToShow;
    @NotNull
    private final Logger logger;
    @NotNull
    private final JPanel panel;
    @NotNull
    private final SuggestionsViewer issuesViewer;

    /*
     * WARNING - void declaration
     */
    public SuggestionsForm(@NotNull PsContext context, @NotNull SuggestionsViewIssueRenderer suggestionsViewIssueRenderer) {
        void it;
        SuggestionsViewer suggestionsViewer;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)suggestionsViewIssueRenderer, (String)"suggestionsViewIssueRenderer");
        this.context = context;
        this.maxNumberOfIssuesToShow = 300;
        Logger logger = Logger.getInstance(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        JPanel jPanel = this.myMainPanel;
        Intrinsics.checkNotNull((Object)jPanel);
        this.panel = jPanel;
        SuggestionsViewer suggestionsViewer2 = suggestionsViewer = new SuggestionsViewer(this.context, suggestionsViewIssueRenderer);
        SuggestionsForm suggestionsForm = this;
        boolean bl = false;
        Disposer.register((Disposable)this, (Disposable)((Disposable)it));
        suggestionsForm.issuesViewer = suggestionsViewer;
        this.setViewComponent(this.issuesViewer.getPanel());
        this.renderIssues$intellij_android_projectSystem_gradle_psd(CollectionsKt.emptyList(), null);
    }

    @NotNull
    public final JPanel getPanel() {
        return this.panel;
    }

    @UiThread
    public final void updateLoading() {
        this.myLoadingLabel.setVisible(this.context.getAnalyzerDaemon().isRunning() || this.context.getLibraryUpdateCheckerDaemon().isRunning());
    }

    public final void renderIssues$intellij_android_projectSystem_gradle_psd(@NotNull List<? extends PsIssue> issues2, @Nullable PsPath scope) {
        Intrinsics.checkNotNullParameter(issues2, (String)"issues");
        if (Disposer.isDisposed((Disposable)this)) {
            return;
        }
        if (issues2.size() > this.maxNumberOfIssuesToShow) {
            this.logger.warn("There are " + issues2.size() + " issues but only " + this.maxNumberOfIssuesToShow + " will be shown in PSD");
        }
        Iterable iterable = issues2;
        IssuesBySeverityPathTextComparator issuesBySeverityPathTextComparator = IssuesBySeverityPathTextComparator.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)issuesBySeverityPathTextComparator, (String)"INSTANCE");
        this.issuesViewer.display(CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)iterable, (Comparator)issuesBySeverityPathTextComparator), (int)this.maxNumberOfIssuesToShow), scope);
        this.updateLoading();
    }

    public void dispose() {
    }

    @NotNull
    public final ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        ActionCallback actionCallback = ActionCallback.DONE;
        Intrinsics.checkNotNullExpressionValue((Object)actionCallback, (String)"DONE");
        return actionCallback;
    }

    public final void queryPlace(@NotNull Place place) {
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
    }
}

