/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.dependencies.details;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.dependencies.details.ConfigurationDependencyDetails;
import com.android.tools.idea.gradle.structure.configurables.dependencies.details.DeclaredLibraryDependencyUiProperties;
import com.android.tools.idea.gradle.structure.configurables.ui.properties.ModelPropertyEditor;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsBaseDependency;
import com.android.tools.idea.gradle.structure.model.PsDeclaredLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import kotlin.Unit;
import org.jdesktop.swingx.JXLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleDeclaredLibraryDependencyDetails
implements ConfigurationDependencyDetails {
    private JPanel myMainPanel;
    private JXLabel myGroupIdLabel;
    private JXLabel myArtifactNameLabel;
    private JPanel myRequestedVersion;
    private JPanel myConfigurationPanel;
    @NotNull
    private final PsContext myContext;
    @Nullable
    private PsDeclaredLibraryDependency myDependency;
    @Nullable
    private ModelPropertyEditor<?> myVersionPropertyEditor;
    @Nullable
    private JComponent myEditorComponent;

    public SingleDeclaredLibraryDependencyDetails(@NotNull PsContext context) {
        this.setupUI();
        this.myContext = context;
    }

    @Override
    @NotNull
    public JPanel getPanel() {
        return this.myMainPanel;
    }

    @Override
    public void display(@NotNull PsBaseDependency dependency) {
        PsDeclaredLibraryDependency d = (PsDeclaredLibraryDependency)dependency;
        this.displayVersion(d);
        this.displayConfiguration(d, PsModule.ImportantFor.LIBRARY);
        if (this.myDependency != dependency) {
            PsArtifactDependencySpec spec = d.getSpec();
            this.myGroupIdLabel.setText(spec.getGroup());
            this.myArtifactNameLabel.setText(spec.getName());
        }
        this.myDependency = d;
    }

    private void displayVersion(@NotNull PsDeclaredLibraryDependency dependency) {
        if (this.myVersionPropertyEditor != null) {
            if (dependency == this.myDependency) {
                this.myVersionPropertyEditor.reloadIfNotChanged();
            } else {
                if (this.myEditorComponent != null) {
                    this.myRequestedVersion.remove(this.myEditorComponent);
                }
                Disposer.dispose(this.myVersionPropertyEditor);
                this.myVersionPropertyEditor = null;
            }
        }
        if (this.myVersionPropertyEditor == null) {
            this.myVersionPropertyEditor = DeclaredLibraryDependencyUiProperties.INSTANCE.makeVersionUiProperty(dependency).createEditor(this.myContext, dependency.getParent().getParent(), dependency.getParent(), Unit.INSTANCE, null, null);
            this.myEditorComponent = this.myVersionPropertyEditor.getComponent();
            this.myEditorComponent.setName("version");
            this.myRequestedVersion.add(this.myEditorComponent);
        }
    }

    @NotNull
    public Class<PsDeclaredLibraryDependency> getSupportedModelType() {
        return PsDeclaredLibraryDependency.class;
    }

    @Override
    @Nullable
    public PsDeclaredLibraryDependency getModel() {
        return this.myDependency;
    }

    @Override
    public PsContext getContext() {
        return this.myContext;
    }

    @Override
    public JPanel getConfigurationUI() {
        return this.myConfigurationPanel;
    }

    private void setupUI() {
        this.myMainPanel = new JPanel();
        this.myMainPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel1.setFontColor(UIUtil.FontColor.NORMAL);
        jBLabel1.setText("Group ID:");
        this.myMainPanel.add((Component)jBLabel1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel2.setFontColor(UIUtil.FontColor.NORMAL);
        jBLabel2.setHorizontalAlignment(10);
        jBLabel2.setText("Artifact Name:");
        this.myMainPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myGroupIdLabel = new JXLabel();
        Font myGroupIdLabelFont = UIManager.getFont("Tree.font");
        if (myGroupIdLabelFont != null) {
            this.myGroupIdLabel.setFont(myGroupIdLabelFont);
        }
        this.myMainPanel.add((Component)this.myGroupIdLabel, new GridConstraints(0, 1, 1, 2, 0, 1, 3, 3, null, null, null, 0, false));
        this.myArtifactNameLabel = new JXLabel();
        Font myArtifactNameLabelFont = UIManager.getFont("Tree.font");
        if (myArtifactNameLabelFont != null) {
            this.myArtifactNameLabel.setFont(myArtifactNameLabelFont);
        }
        this.myMainPanel.add((Component)this.myArtifactNameLabel, new GridConstraints(1, 1, 1, 2, 0, 1, 3, 3, null, null, null, 0, false));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel3.setFontColor(UIUtil.FontColor.NORMAL);
        jBLabel3.setText("Configuration:");
        this.myMainPanel.add((Component)jBLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel4.setFontColor(UIUtil.FontColor.NORMAL);
        jBLabel4.setText("Requested Version:");
        this.myMainPanel.add((Component)jBLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myRequestedVersion = new JPanel();
        this.myRequestedVersion.setLayout(new BorderLayout(0, 0));
        this.myMainPanel.add((Component)this.myRequestedVersion, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myConfigurationPanel = new JPanel();
        this.myConfigurationPanel.setLayout(new BorderLayout(0, 0));
        this.myMainPanel.add((Component)this.myConfigurationPanel, new GridConstraints(3, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
    }
}

