/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.repositories.search;

import com.android.ide.common.gradle.Version;
import com.android.tools.idea.gradle.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.repositories.search.FoundArtifact;
import com.android.tools.idea.gradle.repositories.search.GroupArtifactQuery;
import com.android.tools.idea.gradle.repositories.search.ModuleQuery;
import com.android.tools.idea.gradle.repositories.search.SearchQuery;
import com.android.tools.idea.gradle.repositories.search.SearchRequest;
import com.android.tools.idea.gradle.repositories.search.SearchResult;
import com.android.tools.idea.gradle.repositories.search.SearchResultStats;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.wireless.android.sdk.stats.PSDEvent;
import com.intellij.util.io.HttpRequests;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/gradle/repositories/search/JCenterRepository;", "Lcom/android/tools/idea/gradle/repositories/search/ArtifactRepository;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "isRemote", "", "()Z", "doSearch", "Lcom/android/tools/idea/gradle/repositories/search/SearchResult;", "request", "Lcom/android/tools/idea/gradle/repositories/search/SearchRequest;", "parse", "response", "Ljava/io/Reader;", "createRequestUrl", "intellij.android.projectSystem.gradle.repositorySearch"})
@SourceDebugExtension(value={"SMAP\nJCenterRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JCenterRepository.kt\ncom/android/tools/idea/gradle/repositories/search/JCenterRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n1368#2:200\n1454#2,2:201\n1611#2,9:203\n1863#2:212\n1864#2:214\n1620#2:215\n1611#2,9:216\n1863#2:225\n1864#2:228\n1620#2:229\n1456#2,3:230\n1#3:213\n1#3:226\n1#3:227\n*S KotlinDebug\n*F\n+ 1 JCenterRepository.kt\ncom/android/tools/idea/gradle/repositories/search/JCenterRepository\n*L\n145#1:200\n145#1:201,2\n150#1:203,9\n150#1:212\n150#1:214\n150#1:215\n152#1:216,9\n152#1:225\n152#1:228\n152#1:229\n145#1:230,3\n150#1:213\n152#1:227\n*E\n"})
public final class JCenterRepository
extends ArtifactRepository {
    @NotNull
    public static final JCenterRepository INSTANCE = new JCenterRepository();
    @NotNull
    private static final String name = "JCenter";
    private static final boolean isRemote = true;

    private JCenterRepository() {
        super(PSDEvent.PSDRepositoryUsage.PSDRepository.PROJECT_STRUCTURE_DIALOG_REPOSITORY_JCENTER);
    }

    @Override
    @NotNull
    public String getName() {
        return name;
    }

    @Override
    public boolean isRemote() {
        return isRemote;
    }

    @Override
    @NotNull
    protected SearchResult doSearch(@NotNull SearchRequest request) throws Exception {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Object object = HttpRequests.request((String)this.createRequestUrl(request)).accept("application/json").connect(JCenterRepository::doSearch$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"connect(...)");
        return (SearchResult)object;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final SearchResult parse(@NotNull Reader response2) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        JsonArray array = JsonParser.parseReader((Reader)response2).getAsJsonArray();
        List errors = new ArrayList();
        Intrinsics.checkNotNull((Object)array);
        Iterable $this$flatMap$iv = (Iterable)array;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            JsonElement result2 = (JsonElement)element$iv$iv;
            boolean bl = false;
            JsonObject root = result2.getAsJsonObject();
            try {
                boolean bl2;
                Object element$iv$iv2;
                Object element$iv$iv$iv;
                Iterable $this$mapNotNullTo$iv$iv;
                JsonArray versions2 = root.getAsJsonArray("versions");
                JsonArray systemIds = root.getAsJsonArray("system_ids");
                Intrinsics.checkNotNull((Object)versions2);
                Iterable $this$mapNotNull$iv = (Iterable)versions2;
                boolean $i$f$mapNotNull = false;
                Iterable iterable2 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Version it$iv$iv;
                    element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                    bl2 = false;
                    JsonElement it = (JsonElement)element$iv$iv2;
                    boolean bl3 = false;
                    String string = it.getAsString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
                    if (Version.Companion.parse(string) == null) continue;
                    boolean bl4 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                Set availableVersions = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                Intrinsics.checkNotNull((Object)systemIds);
                $this$mapNotNull$iv = (Iterable)systemIds;
                $i$f$mapNotNull = false;
                $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv2 = new ArrayList();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    FoundArtifact foundArtifact;
                    Object object;
                    element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                    bl2 = false;
                    JsonElement name2 = (JsonElement)element$iv$iv2;
                    boolean bl5 = false;
                    String string = name2.getAsString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
                    Object object2 = new char[]{':'};
                    Object it = object2 = (Object)StringsKt.split$default((CharSequence)string, (char[])object2, (boolean)false, (int)0, (int)6, null);
                    boolean bl6 = false;
                    Object object3 = object = it.size() == 2 ? object2 : null;
                    if (object != null) {
                        it = object;
                        boolean bl7 = false;
                        foundArtifact = new FoundArtifact(INSTANCE.getName(), (String)it.get(0), (String)it.get(1), availableVersions);
                    } else {
                        foundArtifact = null;
                    }
                    if (foundArtifact == null) continue;
                    FoundArtifact it$iv$iv = foundArtifact;
                    boolean bl8 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                list = (List)destination$iv$iv2;
            }
            catch (Exception ex) {
                errors.add(ex);
                list = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List artifacts = (List)destination$iv$iv;
        return new SearchResult(artifacts, errors, SearchResultStats.Companion.getEMPTY());
    }

    @VisibleForTesting
    @NotNull
    public final String createRequestUrl(@NotNull SearchRequest request) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        StringBuilder $this$createRequestUrl_u24lambda_u246 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$createRequestUrl_u24lambda_u246.append("https://api.bintray.com/search/packages/maven?");
        SearchQuery query = request.getQuery();
        if (query instanceof GroupArtifactQuery) {
            String artifactName;
            CharSequence charSequence;
            String groupId = ((GroupArtifactQuery)query).getGroupId();
            CharSequence charSequence2 = groupId;
            if (!(charSequence2 == null || charSequence2.length() == 0)) {
                $this$createRequestUrl_u24lambda_u246.append("g=");
                $this$createRequestUrl_u24lambda_u246.append(groupId);
                $this$createRequestUrl_u24lambda_u246.append("&");
            }
            if (!((charSequence = (CharSequence)(artifactName = ((GroupArtifactQuery)query).getArtifactName())) == null || charSequence.length() == 0)) {
                $this$createRequestUrl_u24lambda_u246.append("a=");
                $this$createRequestUrl_u24lambda_u246.append(artifactName);
                $this$createRequestUrl_u24lambda_u246.append("&");
            }
        } else if (query instanceof ModuleQuery) {
            String artifactName = ((ModuleQuery)query).getModule();
            if (((CharSequence)artifactName).length() > 0) {
                $this$createRequestUrl_u24lambda_u246.append("a=");
                $this$createRequestUrl_u24lambda_u246.append(artifactName);
                $this$createRequestUrl_u24lambda_u246.append("&");
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        $this$createRequestUrl_u24lambda_u246.append("subject=bintray&repo=jcenter");
        return stringBuilder.toString();
    }

    private static final SearchResult doSearch$lambda$0(HttpRequests.Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BufferedReader bufferedReader = it.getReader();
        Intrinsics.checkNotNullExpressionValue((Object)bufferedReader, (String)"getReader(...)");
        return INSTANCE.parse(bufferedReader);
    }
}

