/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues.processor;

import com.android.tools.idea.gradle.dsl.api.ExternalNativeBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001b\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u0012J\u001b\u0010\u0013\u001a\u00020\u00142\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0014H\u0007J\b\u0010\u0017\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/gradle/project/sync/issues/processor/FixNdkVersionProcessor;", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "buildFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "version", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/lang/String;)V", "createUsageViewDescriptor", "Lcom/intellij/usageView/UsageViewDescriptor;", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/usageView/UsageViewDescriptor;", "findUsages", "()[Lcom/intellij/usageView/UsageInfo;", "performRefactoring", "", "([Lcom/intellij/usageView/UsageInfo;)V", "updateProjectBuildModel", "getCommandName", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nFixNdkVersionProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FixNdkVersionProcessor.kt\ncom/android/tools/idea/gradle/project/sync/issues/processor/FixNdkVersionProcessor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,136:1\n37#2:137\n36#2,3:138\n*S KotlinDebug\n*F\n+ 1 FixNdkVersionProcessor.kt\ncom/android/tools/idea/gradle/project/sync/issues/processor/FixNdkVersionProcessor\n*L\n100#1:137\n100#1:138,3\n*E\n"})
public final class FixNdkVersionProcessor
extends BaseRefactoringProcessor {
    @NotNull
    private final Project project;
    @NotNull
    private final List<VirtualFile> buildFiles;
    @NotNull
    private final String version;

    public FixNdkVersionProcessor(@NotNull Project project, @NotNull List<? extends VirtualFile> buildFiles, @NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(buildFiles, (String)"buildFiles");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        super(project);
        this.project = project;
        this.buildFiles = buildFiles;
        this.version = version2;
    }

    @NotNull
    public UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        return new UsageViewDescriptor(){

            public String getCodeReferencesText(int usagesCount, int filesCount) {
                return "Values to update " + UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount);
            }

            public PsiElement[] getElements() {
                Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return PsiElement.EMPTY_ARRAY;
            }

            public String getProcessedElementsHeader() {
                return "Update Android NDK Versions";
            }
        };
    }

    @NotNull
    public UsageInfo[] findUsages() {
        ProjectBuildModel projectBuildModel = ProjectBuildModel.get(this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel, (String)"get(...)");
        ProjectBuildModel projectBuildModel2 = projectBuildModel;
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        for (VirtualFile file : this.buildFiles) {
            boolean bl;
            ResolvedPropertyModel ndkVersion2;
            AndroidModel android;
            if (!file.isValid() || !file.isWritable()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel2.getModuleBuildModel(file).android(), (String)"android(...)");
            ExternalNativeBuildModel externalNativeBuildModel = android.externalNativeBuild();
            Intrinsics.checkNotNull((Object)externalNativeBuildModel, (String)"null cannot be cast to non-null type com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel");
            GradleDslBlockModel externalNativeBuild = (GradleDslBlockModel)((Object)externalNativeBuildModel);
            if (!externalNativeBuild.hasValidPsiElement()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)android.ndkVersion(), (String)"ndkVersion(...)");
            if (Intrinsics.areEqual((Object)this.version, (Object)ndkVersion2.toString())) continue;
            PsiElement element = ndkVersion2.getFullExpressionPsiElement();
            if (element != null) {
                bl = usages.add(new UsageInfo(element));
                continue;
            }
            PsiElement psiElement = ((GradleDslBlockModel)((Object)android)).getPsiElement();
            Intrinsics.checkNotNull((Object)psiElement);
            bl = usages.add(new UsageInfo(psiElement));
        }
        Collection $this$toTypedArray$iv = usages;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new UsageInfo[0]);
    }

    public void performRefactoring(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        this.updateProjectBuildModel();
        ProjectSystemUtil.getSyncManager(this.project).requestSyncProject(ProjectSystemSyncUtil.toReason(GradleSyncStats.Trigger.TRIGGER_QF_NDK_INSTALLED));
    }

    @VisibleForTesting
    public final void updateProjectBuildModel() {
        ProjectBuildModel projectBuildModel = ProjectBuildModel.get(this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel, (String)"get(...)");
        ProjectBuildModel projectBuildModel2 = projectBuildModel;
        for (VirtualFile file : this.buildFiles) {
            ResolvedPropertyModel ndkVersion2;
            AndroidModel android;
            Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel2.getModuleBuildModel(file).android(), (String)"android(...)");
            ExternalNativeBuildModel externalNativeBuildModel = android.externalNativeBuild();
            Intrinsics.checkNotNull((Object)externalNativeBuildModel, (String)"null cannot be cast to non-null type com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel");
            GradleDslBlockModel externalNativeBuild = (GradleDslBlockModel)((Object)externalNativeBuildModel);
            if (!externalNativeBuild.hasValidPsiElement()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)android.ndkVersion(), (String)"ndkVersion(...)");
            ndkVersion2.setValue(this.version);
        }
        projectBuildModel2.applyChanges();
    }

    @NotNull
    public String getCommandName() {
        return "Update Android NDK Version";
    }
}

