/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.gradle.model.IdeSyncIssue;
import com.android.tools.idea.gradle.project.sync.errors.SdkBuildToolsTooLowIssueChecker;
import com.android.tools.idea.gradle.project.sync.errors.SdkBuildToolsTooLowIssueCheckerKt;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixBuildToolsVersionHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.InstallBuildToolsHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.SimpleDeduplicatingSyncIssueReporter;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueNotificationHyperlink;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.sdk.AndroidSdkData;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class BuildToolsTooLowReporter
extends SimpleDeduplicatingSyncIssueReporter {
    BuildToolsTooLowReporter() {
    }

    @Override
    int getSupportedIssueType() {
        return 13;
    }

    @Override
    @NotNull
    protected List<SyncIssueNotificationHyperlink> getCustomLinks(@NotNull Project project, @NotNull List<IdeSyncIssue> syncIssues, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap) {
        assert (!syncIssues.isEmpty() && !affectedModules.isEmpty());
        String minimumVersion = syncIssues.get(0).getData();
        if (minimumVersion == null) {
            return ImmutableList.of();
        }
        return this.getQuickFixHyperlinks(project, minimumVersion, affectedModules, buildFileMap);
    }

    @NotNull
    public List<SyncIssueNotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @NotNull String minimumVersion, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap) {
        ArrayList<SyncIssueNotificationHyperlink> hyperlinks = new ArrayList<SyncIssueNotificationHyperlink>();
        boolean buildToolInstalled = false;
        AndroidSdkHandler sdkHandler = null;
        AndroidSdkData androidSdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        if (androidSdkData != null) {
            sdkHandler = androidSdkData.getSdkHandler();
        }
        if (sdkHandler != null) {
            StudioLoggerProgressIndicator progress2 = new StudioLoggerProgressIndicator(SdkBuildToolsTooLowIssueChecker.class);
            RepositoryPackages packages = sdkHandler.getRepoManagerAndLoadSynchronously((ProgressIndicator)progress2).getPackages();
            LocalPackage buildTool = (LocalPackage)packages.getLocalPackages().get(DetailsTypes.getBuildToolsPath((Revision)Revision.parseRevision((String)minimumVersion)));
            buildToolInstalled = buildTool != null;
        }
        List<VirtualFile> buildFiles = affectedModules.stream().map(buildFileMap::get).filter(Objects::nonNull).collect(Collectors.toList());
        if (!buildToolInstalled) {
            hyperlinks.add(new InstallBuildToolsHyperlink(minimumVersion, buildFiles, SdkBuildToolsTooLowIssueCheckerKt.doesAndroidGradlePluginPackageBuildTools(project)));
        } else if (!buildFiles.isEmpty()) {
            hyperlinks.add(new FixBuildToolsVersionHyperlink(minimumVersion, buildFiles, SdkBuildToolsTooLowIssueCheckerKt.doesAndroidGradlePluginPackageBuildTools(project)));
        }
        return hyperlinks;
    }
}

