/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.idea.issues.DescribedBuildIssueQuickFix;
import com.android.tools.idea.gradle.project.sync.issues.processor.UpdateCompileSdkProcessor;
import com.android.tools.idea.gradle.project.sync.quickFixes.SetJavaLanguageLevelQuickFixKt;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/UpdateCompileSdkQuickFix;", "Lcom/android/tools/idea/gradle/project/sync/idea/issues/DescribedBuildIssueQuickFix;", "modulesWithSuggestedMinCompileSdk", "", "", "", "<init>", "(Ljava/util/Map;)V", "getModulesWithSuggestedMinCompileSdk", "()Ljava/util/Map;", "id", "getId", "()Ljava/lang/String;", "description", "getDescription", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nAarDependencyCompatibilityIssueChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AarDependencyCompatibilityIssueChecker.kt\ncom/android/tools/idea/gradle/project/sync/errors/UpdateCompileSdkQuickFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1863#2,2:105\n*S KotlinDebug\n*F\n+ 1 AarDependencyCompatibilityIssueChecker.kt\ncom/android/tools/idea/gradle/project/sync/errors/UpdateCompileSdkQuickFix\n*L\n82#1:105,2\n*E\n"})
public final class UpdateCompileSdkQuickFix
implements DescribedBuildIssueQuickFix {
    @NotNull
    private final Map<String, Integer> modulesWithSuggestedMinCompileSdk;
    @NotNull
    private final String id;
    @NotNull
    private final String description;

    public UpdateCompileSdkQuickFix(@NotNull Map<String, Integer> modulesWithSuggestedMinCompileSdk) {
        Intrinsics.checkNotNullParameter(modulesWithSuggestedMinCompileSdk, (String)"modulesWithSuggestedMinCompileSdk");
        this.modulesWithSuggestedMinCompileSdk = modulesWithSuggestedMinCompileSdk;
        this.id = "update.modules.minCompileSdk";
        this.description = "Update minCompileSdk in modules with dependencies that require a higher minCompileSdk.";
    }

    @NotNull
    public final Map<String, Integer> getModulesWithSuggestedMinCompileSdk() {
        return this.modulesWithSuggestedMinCompileSdk;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        CompletableFuture future2 = new CompletableFuture();
        try {
            if (!project.isDisposed()) {
                Map map2;
                Map $this$runQuickFix_u24lambda_u241 = map2 = MapsKt.createMapBuilder();
                boolean bl = false;
                for (Map.Entry<String, Integer> entry : this.modulesWithSuggestedMinCompileSdk.entrySet()) {
                    String modulePath = entry.getKey();
                    int minCompileSdk = ((Number)entry.getValue()).intValue();
                    Iterable $this$forEach$iv = SetJavaLanguageLevelQuickFixKt.moduleBuildFiles(project, modulePath);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        VirtualFile it = (VirtualFile)element$iv;
                        boolean bl2 = false;
                        $this$runQuickFix_u24lambda_u241.put(it, minCompileSdk);
                    }
                }
                Map buildFilesWithSuggestedMinCompileSdk = MapsKt.build((Map)map2);
                if (buildFilesWithSuggestedMinCompileSdk.isEmpty()) {
                    Messages.showErrorDialog((Project)project, (String)"Could not determine build files to apply fix", (String)"Update minCompileSdk");
                } else {
                    UpdateCompileSdkProcessor processor = new UpdateCompileSdkProcessor(project, buildFilesWithSuggestedMinCompileSdk);
                    processor.setPreviewUsages(true);
                    processor.run();
                }
            }
            future2.complete(null);
        }
        catch (Exception e) {
            future2.completeExceptionally(e);
        }
        return future2;
    }

    @Override
    @NotNull
    public String getHtml() {
        return DescribedBuildIssueQuickFix.super.getHtml();
    }
}

