/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueComposer;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueUtilKt;
import com.android.tools.idea.gradle.project.sync.idea.issues.DescribedBuildIssueQuickFix;
import com.android.tools.idea.gradle.project.sync.issues.SyncFailureUsageReporter;
import com.android.tools.idea.gradle.project.sync.quickFixes.CreateGradleWrapperQuickFix;
import com.android.tools.idea.gradle.project.sync.quickFixes.OpenFileAtLocationQuickFix;
import com.android.tools.idea.gradle.util.GradleProjectSettingsFinder;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.GradleManager;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\fH\u0002JD\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00190\u0018H\u0016R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/UnsupportedGradleVersionIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "<init>", "()V", "UNSUPPORTED_GRADLE_VERSION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "formatMessage", "", "message", "getSupportedGradleVersion", "consumeBuildOutputFailureMessage", "", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "OpenGradleSettingsQuickFix", "FixGradleVersionInWrapperQuickFix", "intellij.android.projectSystem.gradle"})
public final class UnsupportedGradleVersionIssueChecker
implements GradleIssueChecker {
    private final Pattern UNSUPPORTED_GRADLE_VERSION_PATTERN = Pattern.compile("Minimum supported Gradle version is (.*)\\. Current version is.*", 32);

    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        Throwable error = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
        String string = this.formatMessage(error.getMessage());
        if (string == null) {
            return null;
        }
        String message = string;
        SyncFailureUsageReporter.Companion.getInstance().collectFailure(issueData.getProjectPath(), AndroidStudioEvent.GradleSyncFailure.UNSUPPORTED_GRADLE_VERSION);
        BuildIssueComposer buildIssueComposer = new BuildIssueComposer(message, null, 2, null);
        Project ideaProject = BuildIssueUtilKt.fetchIdeaProjectForGradleProject(issueData.getProjectPath());
        if (ideaProject != null) {
            GradleWrapper gradleWrapper = GradleWrapper.find(ideaProject);
            String gradleVersion2 = this.getSupportedGradleVersion(message);
            if (gradleWrapper != null) {
                buildIssueComposer.addQuickFix(new FixGradleVersionInWrapperQuickFix(gradleWrapper, gradleVersion2));
                File file = gradleWrapper.getPropertiesFilePath();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getPropertiesFilePath(...)");
                File propertiesFile = file;
                if (propertiesFile.exists()) {
                    buildIssueComposer.addQuickFix("Open Gradle wrapper properties", new OpenFileAtLocationQuickFix(new FilePosition(propertiesFile, -1, -1)));
                }
            } else {
                GradleProjectSettings gradleProjectSettings = GradleProjectSettingsFinder.getInstance().findGradleProjectSettings(ideaProject);
                if (gradleProjectSettings != null && gradleProjectSettings.getDistributionType() == DistributionType.LOCAL) {
                    buildIssueComposer.addQuickFix("Migrate to Gradle wrapper and sync project", new CreateGradleWrapperQuickFix());
                }
            }
        }
        buildIssueComposer.addQuickFix("Gradle Settings.", new OpenGradleSettingsQuickFix());
        return buildIssueComposer.composeBuildIssue();
    }

    private final String formatMessage(String message) {
        if (message == null) {
            return null;
        }
        StringBuilder formattedMsg = new StringBuilder();
        if (this.UNSUPPORTED_GRADLE_VERSION_PATTERN.matcher(message).matches()) {
            int index = StringsKt.indexOf$default((CharSequence)message, (String)"If using the gradle wrapper", (int)0, (boolean)false, (int)6, null);
            if (index != -1) {
                String string = message.substring(0, index);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                v1 = formattedMsg.append(((Object)StringsKt.trim((CharSequence)string)).toString());
            } else {
                v1 = formattedMsg.append(message);
            }
            if (((CharSequence)formattedMsg).length() > 0 && !StringsKt.endsWith$default((CharSequence)formattedMsg, (char)'.', (boolean)false, (int)2, null)) {
                formattedMsg.append('.');
            }
            formattedMsg.append("\n\nPlease fix the project's Gradle settings.");
            return formattedMsg.toString();
        }
        return null;
    }

    private final String getSupportedGradleVersion(String message) {
        String version2;
        Matcher matcher = this.UNSUPPORTED_GRADLE_VERSION_PATTERN.matcher(message);
        if (matcher.matches() && StringUtil.isNotEmpty((String)(version2 = matcher.group(1)))) {
            return version2;
        }
        return null;
    }

    public boolean consumeBuildOutputFailureMessage(@NotNull String message, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        return this.UNSUPPORTED_GRADLE_VERSION_PATTERN.matcher(failureCause).matches();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/UnsupportedGradleVersionIssueChecker$FixGradleVersionInWrapperQuickFix;", "Lcom/android/tools/idea/gradle/project/sync/idea/issues/DescribedBuildIssueQuickFix;", "gradleWrapper", "Lcom/android/tools/idea/gradle/util/GradleWrapper;", "gradleVersion", "", "<init>", "(Lcom/android/tools/idea/gradle/util/GradleWrapper;Ljava/lang/String;)V", "description", "getDescription", "()Ljava/lang/String;", "id", "getId", "getGradleVersion", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.android.projectSystem.gradle"})
    public static final class FixGradleVersionInWrapperQuickFix
    implements DescribedBuildIssueQuickFix {
        @Nullable
        private GradleWrapper gradleWrapper;
        @NotNull
        private final String id;
        @NotNull
        private final String gradleVersion;

        public FixGradleVersionInWrapperQuickFix(@Nullable GradleWrapper gradleWrapper, @Nullable String gradleVersion2) {
            this.gradleWrapper = gradleWrapper;
            this.id = "fix.gradle.version.in.wrapper";
            String string = gradleVersion2;
            if (string == null) {
                string = "9.0.0";
            }
            this.gradleVersion = string;
        }

        @Override
        @NotNull
        public String getDescription() {
            return "Change Gradle version in Gradle wrapper to " + this.gradleVersion + " and re-import project";
        }

        @NotNull
        public String getId() {
            return this.id;
        }

        @NotNull
        public final String getGradleVersion() {
            return this.gradleVersion;
        }

        @NotNull
        public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            CompletableFuture future2 = new CompletableFuture();
            ActionsKt.invokeLater$default(null, () -> FixGradleVersionInWrapperQuickFix.runQuickFix$lambda$0(this, project, future2), (int)1, null);
            return future2;
        }

        @Override
        @NotNull
        public String getHtml() {
            return DescribedBuildIssueQuickFix.super.getHtml();
        }

        private static final Unit runQuickFix$lambda$0(FixGradleVersionInWrapperQuickFix this$0, Project $project, CompletableFuture $future) {
            if (this$0.gradleWrapper == null) {
                GradleWrapper gradleWrapper = GradleWrapper.find($project);
                if (gradleWrapper == null) {
                    return Unit.INSTANCE;
                }
                this$0.gradleWrapper = gradleWrapper;
            }
            GradleWrapper gradleWrapper = this$0.gradleWrapper;
            Intrinsics.checkNotNull((Object)gradleWrapper);
            gradleWrapper.updateDistributionUrlAndDisplayFailure(this$0.gradleVersion);
            GradleProjectSettings settings = GradleProjectSettingsFinder.getInstance().findGradleProjectSettings($project);
            if (settings != null) {
                settings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
            }
            ProjectSystemUtil.getSyncManager($project).requestSyncProject(ProjectSystemSyncUtil.toReason(GradleSyncStats.Trigger.TRIGGER_QF_WRAPPER_GRADLE_VERSION_FIXED));
            $future.complete(null);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/UnsupportedGradleVersionIssueChecker$OpenGradleSettingsQuickFix;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.android.projectSystem.gradle"})
    public static final class OpenGradleSettingsQuickFix
    implements BuildIssueQuickFix {
        @NotNull
        private final String id;

        public OpenGradleSettingsQuickFix() {
            this.id = "open.gradle.settings";
        }

        @NotNull
        public String getId() {
            return this.id;
        }

        @NotNull
        public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            CompletableFuture future2 = new CompletableFuture();
            ActionsKt.invokeLater$default(null, () -> OpenGradleSettingsQuickFix.runQuickFix$lambda$0(project, future2), (int)1, null);
            return future2;
        }

        private static final Unit runQuickFix$lambda$0(Project $project, CompletableFuture $future) {
            ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)GradleProjectSystemUtil.GRADLE_SYSTEM_ID);
            boolean bl = manager instanceof GradleManager;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Intrinsics.checkNotNull((Object)manager, (String)"null cannot be cast to non-null type org.jetbrains.plugins.gradle.GradleManager");
            Configurable configurable = ((GradleManager)manager).getConfigurable($project);
            Intrinsics.checkNotNullExpressionValue((Object)configurable, (String)"getConfigurable(...)");
            Configurable configurable2 = configurable;
            ShowSettingsUtil.getInstance().editConfigurable($project, configurable2);
            $future.complete(null);
            return Unit.INSTANCE;
        }
    }
}

