/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.gradle.project.sync.errors.MissingCMakeIssueCheckerKt;
import com.android.tools.idea.gradle.project.sync.errors.RevisionOrHigher;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueComposer;
import com.android.tools.idea.gradle.project.sync.issues.SyncFailureUsageReporter;
import com.android.tools.idea.gradle.project.sync.quickFixes.InstallCmakeQuickFix;
import com.android.tools.idea.gradle.project.sync.quickFixes.SetCmakeDirQuickFix;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.AndroidSdks;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016JD\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00160\u0015H\u0016J \u0010\u0017\u001a\u0004\u0018\u00010\u00052\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u0005H\u0014J\b\u0010 \u001a\u00020!H\u0014J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0010\u0010#\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0010\u0010$\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010\u00052\u0006\u0010&\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/MissingCMakeIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "<init>", "()V", "FAILED_TO_FIND_CMAKE", "", "UNABLE_TO_GET_CMAKE_VERSION", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "consumeBuildOutputFailureMessage", "", "message", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "getAlreadyInstalled", "cmakePackages", "", "Lcom/android/repository/api/LocalPackage;", "cmakeVersion", "Lcom/android/repository/Revision;", "getLocalProperties", "Ljava/io/File;", "projectPath", "getSdkManager", "Lcom/android/repository/api/RepoManager;", "matchesCannotFindCmake", "matchesTriedInstall", "matchesCmakeWithVersion", "extractCmakeVersionFromError", "firstLine", "intellij.android.projectSystem.gradle"})
public class MissingCMakeIssueChecker
implements GradleIssueChecker {
    @NotNull
    private final String FAILED_TO_FIND_CMAKE;
    @NotNull
    private final String UNABLE_TO_GET_CMAKE_VERSION;

    public MissingCMakeIssueChecker() {
        this.FAILED_TO_FIND_CMAKE = "Failed to find CMake.";
        this.UNABLE_TO_GET_CMAKE_VERSION = "Unable to get the CMake version";
    }

    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        BuildIssueComposer buildIssueComposer;
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        String string = ((Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first).getMessage();
        if (string == null) {
            return null;
        }
        String message = string;
        if (this.matchesCannotFindCmake(message) || this.matchesTriedInstall(message) || this.matchesCmakeWithVersion(message)) {
            buildIssueComposer = new BuildIssueComposer(message, null, 2, null);
        } else if (StringsKt.startsWith$default((String)message, (String)this.FAILED_TO_FIND_CMAKE, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)message, (String)this.UNABLE_TO_GET_CMAKE_VERSION, (boolean)false, (int)2, null)) {
            SyncFailureUsageReporter.Companion.getInstance().collectFailure(issueData.getProjectPath(), AndroidStudioEvent.GradleSyncFailure.MISSING_CMAKE);
            buildIssueComposer = new BuildIssueComposer("Failed to find CMake.", null, 2, null);
        } else {
            return null;
        }
        BuildIssueComposer buildIssueComposer2 = buildIssueComposer;
        String firstLine = (String)StringsKt.lines((CharSequence)message).get(0);
        String version2 = this.extractCmakeVersionFromError(firstLine);
        if (version2 == null) {
            buildIssueComposer2.addQuickFix("Install CMake", new InstallCmakeQuickFix(null));
            return buildIssueComposer2.composeBuildIssue();
        }
        RevisionOrHigher revisionOrHigher = MissingCMakeIssueCheckerKt.parseRevisionOrHigher(version2, firstLine);
        if (revisionOrHigher == null) {
            return buildIssueComposer2.composeBuildIssue();
        }
        RevisionOrHigher requestedCmake = revisionOrHigher;
        RepoManager sdkManager = this.getSdkManager();
        Collection remoteCmakePackages = sdkManager.getPackages().getRemotePackagesForPrefix("cmake");
        Intrinsics.checkNotNull((Object)remoteCmakePackages);
        Revision revision = MissingCMakeIssueCheckerKt.findBestMatch(remoteCmakePackages, requestedCmake);
        if (revision == null) {
            return buildIssueComposer2.composeBuildIssue();
        }
        Revision foundCmakeVersion = revision;
        Collection localCmakePackages = sdkManager.getPackages().getLocalPackagesForPrefix("cmake");
        Intrinsics.checkNotNull((Object)localCmakePackages);
        String alreadyInstalledCmake = this.getAlreadyInstalled(localCmakePackages, foundCmakeVersion);
        if (alreadyInstalledCmake != null) {
            try {
                File cmakeDir = this.getLocalProperties(issueData.getProjectPath());
                if (cmakeDir == null) {
                    buildIssueComposer2.addQuickFix("Set cmake.dir in local.properties to '" + alreadyInstalledCmake + "' .", new SetCmakeDirQuickFix(new File(alreadyInstalledCmake)));
                    return buildIssueComposer2.composeBuildIssue();
                }
                if (cmakeDir.getPath() == alreadyInstalledCmake) {
                    return buildIssueComposer2.composeBuildIssue();
                }
                buildIssueComposer2.addQuickFix("Replace cmake.dir in local.properties with '" + alreadyInstalledCmake + "' .", new SetCmakeDirQuickFix(new File(alreadyInstalledCmake)));
                return buildIssueComposer2.composeBuildIssue();
            }
            catch (IOException e) {
                return buildIssueComposer2.composeBuildIssue();
            }
        }
        buildIssueComposer2.addQuickFix("Install Cmake " + foundCmakeVersion, new InstallCmakeQuickFix(foundCmakeVersion));
        return buildIssueComposer2.composeBuildIssue();
    }

    public boolean consumeBuildOutputFailureMessage(@NotNull String message, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        return this.matchesCannotFindCmake(failureCause) || this.matchesTriedInstall(failureCause) || this.matchesCmakeWithVersion(failureCause) || StringsKt.startsWith$default((String)failureCause, (String)this.FAILED_TO_FIND_CMAKE, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)failureCause, (String)this.UNABLE_TO_GET_CMAKE_VERSION, (boolean)false, (int)2, null);
    }

    private final String getAlreadyInstalled(Collection<? extends LocalPackage> cmakePackages, Revision cmakeVersion) {
        for (LocalPackage localPackage : cmakePackages) {
            if (!Intrinsics.areEqual((Object)localPackage.getVersion(), (Object)cmakeVersion)) continue;
            return ((Object)localPackage.getLocation()).toString();
        }
        return null;
    }

    @Nullable
    protected File getLocalProperties(@NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        return new LocalProperties(new File(projectPath)).getAndroidCmakePath();
    }

    @NotNull
    protected RepoManager getSdkManager() {
        AndroidSdkHandler androidSdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler, (String)"tryToChooseSdkHandler(...)");
        AndroidSdkHandler sdkHandler = androidSdkHandler;
        StudioLoggerProgressIndicator progressIndicator = new StudioLoggerProgressIndicator(this.getClass());
        RepoManager repoManager = sdkHandler.getRepoManagerAndLoadSynchronously((ProgressIndicator)progressIndicator);
        Intrinsics.checkNotNullExpressionValue((Object)repoManager, (String)"getRepoManagerAndLoadSynchronously(...)");
        return repoManager;
    }

    private final boolean matchesCannotFindCmake(String message) {
        return StringsKt.startsWith$default((String)message, (String)"CMake", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)message, (CharSequence)"was not found in PATH or by cmake.dir property", (boolean)false, (int)2, null);
    }

    private final boolean matchesTriedInstall(String message) {
        return !(!StringsKt.startsWith$default((String)message, (String)"Failed to install the following Android SDK packages as some licences have not been accepted.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)message, (String)"Failed to install the following SDK components:", (boolean)false, (int)2, null) || !StringsKt.contains$default((CharSequence)message, (CharSequence)"CMake", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)message, (CharSequence)"cmake", (boolean)false, (int)2, null));
    }

    private final boolean matchesCmakeWithVersion(String message) {
        return StringsKt.startsWith$default((String)message, (String)"Unable to find CMake with version:", (boolean)false, (int)2, null);
    }

    private final String extractCmakeVersionFromError(String firstLine) {
        int startIndex = StringsKt.indexOf$default((CharSequence)firstLine, (char)'\'', (int)0, (boolean)false, (int)6, null);
        int endIndex = StringsKt.indexOf$default((CharSequence)firstLine, (char)'\'', (int)(startIndex + 1), (boolean)false, (int)4, null);
        if (startIndex != -1 && endIndex != -1) {
            String string = firstLine.substring(startIndex + 1, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }
        startIndex = StringsKt.indexOf$default((CharSequence)firstLine, (String)"version: ", (int)0, (boolean)false, (int)6, null);
        if (startIndex == -1) {
            return null;
        }
        endIndex = StringsKt.indexOf$default((CharSequence)firstLine, (String)" within", (int)(startIndex + 1), (boolean)false, (int)4, null);
        if (endIndex == -1) {
            return null;
        }
        String string = firstLine.substring(startIndex + 9, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }
}

