/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueComposer;
import com.android.tools.idea.gradle.project.sync.issues.SyncFailureUsageReporter;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.projectsystem.AndroidProjectRootUtil;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016JD\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00180\u0017H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0005H\u0017J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/FailedToParseSdkIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "<init>", "()V", "FAILED_TO_PARSE", "", "EXCEPTION_TRACE_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "consumeBuildOutputFailureMessage", "", "message", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "findPathOfSdkWithoutAddonsFolder", "Ljava/io/File;", "projectPath", "isMissingAddonsFolder", "sdkHomePath", "intellij.android.projectSystem.gradle"})
public class FailedToParseSdkIssueChecker
implements GradleIssueChecker {
    @NotNull
    private final String FAILED_TO_PARSE;
    private final Pattern EXCEPTION_TRACE_PATTERN = Pattern.compile("Caused by: java.lang.RuntimeException(.*)");

    public FailedToParseSdkIssueChecker() {
        this.FAILED_TO_PARSE = "failed to parse SDK";
    }

    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        BuildIssueComposer buildIssueComposer;
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        Throwable rootCause = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
        String string = rootCause.getMessage();
        if (string == null) {
            return null;
        }
        String message = string;
        if (!(rootCause instanceof RuntimeException) || StringsKt.isBlank((CharSequence)message) || !StringsKt.contains$default((CharSequence)message, (CharSequence)this.FAILED_TO_PARSE, (boolean)false, (int)2, null)) {
            return null;
        }
        SyncFailureUsageReporter.Companion.getInstance().collectFailure(issueData.getProjectPath(), AndroidStudioEvent.GradleSyncFailure.FAILED_TO_PARSE_SDK);
        BuildIssueComposer buildIssueComposer2 = new BuildIssueComposer(message, null, 2, null);
        File file = this.findPathOfSdkWithoutAddonsFolder(issueData.getProjectPath());
        if (file == null) {
            BuildIssueComposer buildIssueComposer3;
            BuildIssueComposer $this$check_u24lambda_u240 = buildIssueComposer3 = buildIssueComposer2;
            boolean bl = false;
            $this$check_u24lambda_u240.addDescriptionOnNewLine("The Android SDK may be missing the directory 'add-ons'.");
            return buildIssueComposer3.composeBuildIssue();
        }
        File pathOfBrokenSdk = file;
        BuildIssueComposer $this$check_u24lambda_u241 = buildIssueComposer = buildIssueComposer2;
        boolean bl = false;
        $this$check_u24lambda_u241.addDescriptionOnNewLine("The directory 'add-ons', in the Android SDK at '" + pathOfBrokenSdk.getPath() + "', is either missing or empty");
        $this$check_u24lambda_u241.startNewParagraph();
        if (!pathOfBrokenSdk.canWrite()) {
            buildIssueComposer2.addDescriptionOnNewLine("Current user ('" + SystemProperties.getUserName() + "') does not have write access to the SDK directory.");
        }
        return buildIssueComposer2.composeBuildIssue();
    }

    public boolean consumeBuildOutputFailureMessage(@NotNull String message, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        return stacktrace != null && this.EXCEPTION_TRACE_PATTERN.matcher(stacktrace).find() && StringsKt.contains$default((CharSequence)failureCause, (CharSequence)this.FAILED_TO_PARSE, (boolean)false, (int)2, null);
    }

    @VisibleForTesting
    @Nullable
    public File findPathOfSdkWithoutAddonsFolder(@NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        AndroidSdks androidSdks = AndroidSdks.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)androidSdks, (String)"getInstance(...)");
        AndroidSdks androidSdk = androidSdks;
        if (IdeInfo.getInstance().isAndroidStudio()) {
            File sdkPath = IdeSdks.getInstance().getAndroidSdkPath();
            if (sdkPath != null && this.isMissingAddonsFolder(sdkPath)) {
                return sdkPath;
            }
        } else {
            boolean projectFound = false;
            Object[] modules = null;
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                Intrinsics.checkNotNull((Object)project);
                Project project2 = project;
                modules = ModuleManager.Companion.getInstance(project2).getModules();
                Iterator object = ArrayIteratorKt.iterator((Object[])modules);
                while (object.hasNext()) {
                    Module module = (Module)object.next();
                    if (!Intrinsics.areEqual((Object)AndroidProjectRootUtil.getModuleDirPath(module), (Object)projectPath)) continue;
                    projectFound = true;
                    break;
                }
                if (projectFound) break;
            }
            if (!projectFound || modules == null) {
                return null;
            }
            Iterator iterator2 = ArrayIteratorKt.iterator(modules);
            while (iterator2.hasNext()) {
                String homePath;
                File file;
                Sdk moduleSdk;
                Module module = (Module)iterator2.next();
                if (ModuleRootManager.getInstance((Module)module).getSdk() == null || !androidSdk.isAndroidSdk(moduleSdk) || moduleSdk.getHomePath() == null) continue;
                File file2 = file = FilePaths.stringToFile((String)homePath);
                Intrinsics.checkNotNull((Object)file2);
                if (!this.isMissingAddonsFolder(file2)) continue;
                return file;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isMissingAddonsFolder(File sdkHomePath) {
        File addonsFolder = new File(sdkHomePath, "add-ons");
        if (!addonsFolder.isDirectory()) return true;
        File[] fileArray = FileUtil.notNullize((File[])addonsFolder.listFiles());
        Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"notNullize(...)");
        if (((Object[])fileArray).length != 0) return false;
        return true;
    }
}

