/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.project.sync.errors.AgpVersionNotSupportedIssueCheckerKt;
import com.android.tools.idea.gradle.project.sync.idea.issues.DescribedBuildIssueQuickFix;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/AgpUpgradeQuickFix;", "Lcom/android/tools/idea/gradle/project/sync/idea/issues/DescribedBuildIssueQuickFix;", "currentAgpVersion", "Lcom/android/ide/common/repository/AgpVersion;", "<init>", "(Lcom/android/ide/common/repository/AgpVersion;)V", "getCurrentAgpVersion", "()Lcom/android/ide/common/repository/AgpVersion;", "id", "", "getId", "()Ljava/lang/String;", "description", "getDescription", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.android.projectSystem.gradle.upgrade"})
public final class AgpUpgradeQuickFix
implements DescribedBuildIssueQuickFix {
    @NotNull
    private final AgpVersion currentAgpVersion;
    @NotNull
    private final String id;
    @NotNull
    private final String description;

    public AgpUpgradeQuickFix(@NotNull AgpVersion currentAgpVersion) {
        Intrinsics.checkNotNullParameter((Object)currentAgpVersion, (String)"currentAgpVersion");
        this.currentAgpVersion = currentAgpVersion;
        this.id = "android.gradle.plugin.forced.update";
        this.description = "Upgrade to a supported version";
    }

    @NotNull
    public final AgpVersion getCurrentAgpVersion() {
        return this.currentAgpVersion;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        CompletableFuture future2 = new CompletableFuture();
        AgpVersionNotSupportedIssueCheckerKt.access$updateAndRequestSync(project, this.currentAgpVersion, future2);
        return future2;
    }

    @Override
    @NotNull
    public String getHtml() {
        return DescribedBuildIssueQuickFix.super.getHtml();
    }
}

