/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker;

import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.tooling.CancellationTokenSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class BuildStopper {
    @NotNull
    private final Map<ExternalSystemTaskId, CancellationTokenSource> myMap = new ConcurrentHashMap<ExternalSystemTaskId, CancellationTokenSource>();

    void register(@NotNull ExternalSystemTaskId taskId, CancellationTokenSource tokenSource) {
        this.myMap.put(taskId, tokenSource);
    }

    public void attemptToStopBuild(@NotNull ExternalSystemTaskId id2, @Nullable ProgressIndicator progressIndicator) {
        CancellationTokenSource token;
        if (progressIndicator != null) {
            if (progressIndicator.isCanceled()) {
                return;
            }
            if (progressIndicator.isRunning()) {
                progressIndicator.setText("Stopping Gradle build...");
                progressIndicator.cancel();
            }
        }
        if ((token = this.myMap.get(id2)) != null) {
            token.cancel();
        }
    }

    @Nullable
    public CancellationTokenSource remove(@NotNull ExternalSystemTaskId taskId) {
        return this.myMap.remove(taskId);
    }

    public boolean contains(@NotNull ExternalSystemTaskId taskId) {
        return this.myMap.containsKey(taskId);
    }

    @TestOnly
    @Nullable
    CancellationTokenSource get(@NotNull ExternalSystemTaskId taskId) {
        return this.myMap.get(taskId);
    }
}

