/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.gradle.project.ProjectStructure;
import com.android.tools.idea.gradle.project.SyncDueDialog;
import com.android.tools.idea.gradle.project.SyncDueDialogSelection;
import com.android.tools.idea.gradle.project.sync.AutoSyncBehavior;
import com.android.tools.idea.gradle.project.sync.AutoSyncSettingStore;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.AutoSyncSettingChangeEvent;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.google.wireless.android.sdk.stats.SuppressedSyncEvent;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001/B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u0019J\f\u0010\u001a\u001a\u00020\u0010*\u00020\u0012H\u0002J\f\u0010\u001b\u001a\u00020\u0010*\u00020\u0012H\u0002J\b\u0010\u001c\u001a\u00020\u0010H\u0002J\b\u0010\u001d\u001a\u00020\u0014H\u0002J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u001f\u001a\u00020\u0010J\u000e\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010!\u001a\u00020\u0014H\u0007J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J\f\u0010+\u001a\u00020,*\u00020\tH\u0002J\b\u0010-\u001a\u0004\u0018\u00010,J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00120\u0019H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\n\u0010\u0003\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u00060"}, d2={"Lcom/android/tools/idea/gradle/project/SyncDueMessage;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "timeProvider", "Lkotlin/Function0;", "", "getTimeProvider$annotations", "getTimeProvider", "()Lkotlin/jvm/functions/Function0;", "setTimeProvider", "(Lkotlin/jvm/functions/Function0;)V", "maybeShow", "", "project", "Lcom/intellij/openapi/project/Project;", "requestProjectSync", "", "showAsNotification", "showAsDialog", "dismissNotificationIfPresent", "getProjectsWhereSyncIsDue", "", "hasSyncDueNotificationShown", "hasNoInitialSyncPerformed", "isShownFirstTime", "markAsShownDialog", "isSnoozed", "isTemporarySnoozeActive", "isProjectSpecificSnoozeActive", "snoozeTemporarilyForAllProjects", "snoozeIndefinitelyForProject", "trackAutoSyncEnabled", "changeSource", "Lcom/google/wireless/android/sdk/stats/AutoSyncSettingChangeEvent$ChangeSource;", "trackSuppressedSync", "type", "Lcom/google/wireless/android/sdk/stats/SuppressedSyncEvent$IndicatorType;", "action", "Lcom/google/wireless/android/sdk/stats/SuppressedSyncEvent$UserAction;", "formatDateAtDefaultTimezone", "", "getSnoozedProjectsSummaryNote", "getSnoozedProjects", "SyncDueNotification", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nSyncDueMessage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyncDueMessage.kt\ncom/android/tools/idea/gradle/project/SyncDueMessage\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,353:1\n3829#2:354\n4344#2,2:355\n3829#2:357\n4344#2,2:358\n*S KotlinDebug\n*F\n+ 1 SyncDueMessage.kt\ncom/android/tools/idea/gradle/project/SyncDueMessage\n*L\n213#1:354\n213#1:355,2\n348#1:357\n348#1:358,2\n*E\n"})
public final class SyncDueMessage {
    @NotNull
    public static final SyncDueMessage INSTANCE = new SyncDueMessage();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static Function0<Long> timeProvider;

    private SyncDueMessage() {
    }

    @NotNull
    public final Function0<Long> getTimeProvider() {
        return timeProvider;
    }

    public final void setTimeProvider(@NotNull Function0<Long> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        timeProvider = function0;
    }

    @VisibleForTesting
    public static /* synthetic */ void getTimeProvider$annotations() {
    }

    public final boolean maybeShow(@NotNull Project project) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (this.isSnoozed(project)) {
            LOG.warn("Auto Sync would now be triggered, but it is currently switched off and related notifications snoozed.");
            this.trackSuppressedSync(SuppressedSyncEvent.IndicatorType.HIDDEN_DUE_SNOOZE, SuppressedSyncEvent.UserAction.NONE);
            bl = false;
        } else if (this.isShownFirstTime()) {
            this.showAsDialog(project);
            bl = true;
        } else {
            this.showAsNotification(project);
            bl = true;
        }
        return bl;
    }

    private final void requestProjectSync(Project project) {
        GradleSyncInvoker.Companion.getInstance().requestProjectSync(project, new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_USER_REQUEST, null, false, false, null, 30, null), null);
    }

    private final void showAsNotification(Project project) {
        ActivityTracker.getInstance().inc();
        this.dismissNotificationIfPresent(project);
        Notifications.Bus.notify((Notification)new SyncDueNotification(project), (Project)project);
    }

    private final void showAsDialog(Project project) {
        ApplicationManager.getApplication().invokeAndWait(() -> SyncDueMessage.showAsDialog$lambda$1(project), ModalityState.nonModal());
    }

    public final void dismissNotificationIfPresent(@NotNull Project project) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Notification[] notificationArray = NotificationsManager.getNotificationsManager().getNotificationsOfType(SyncDueNotification.class, project);
        Intrinsics.checkNotNullExpressionValue((Object)notificationArray, (String)"getNotificationsOfType(...)");
        Object[] objectArray2 = objectArray = (Object[])notificationArray;
        int n = objectArray2.length;
        for (int i = 0; i < n; ++i) {
            SyncDueNotification it = (SyncDueNotification)((Object)objectArray2[i]);
            boolean bl = false;
            it.expire();
            it.hideBalloon();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Project> getProjectsWhereSyncIsDue() {
        void $this$filterTo$iv$iv;
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Object[] $this$filter$iv = projectArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            Project it = (Project)element$iv$iv;
            boolean bl = false;
            if (!(INSTANCE.hasSyncDueNotificationShown(it) || INSTANCE.hasNoInitialSyncPerformed(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean hasSyncDueNotificationShown(Project $this$hasSyncDueNotificationShown) {
        Notification[] notificationArray = NotificationsManager.getNotificationsManager().getNotificationsOfType(SyncDueNotification.class, $this$hasSyncDueNotificationShown);
        Intrinsics.checkNotNullExpressionValue((Object)notificationArray, (String)"getNotificationsOfType(...)");
        return !(((Object[])notificationArray).length == 0);
    }

    private final boolean hasNoInitialSyncPerformed(Project $this$hasNoInitialSyncPerformed) {
        return ProjectStructure.getInstance($this$hasNoInitialSyncPerformed).getAndroidPluginVersions().getAllVersions().isEmpty();
    }

    private final boolean isShownFirstTime() {
        CharSequence charSequence = PropertiesComponent.getInstance().getValue("gradle.settings.autoSync.dialog.shown");
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence);
    }

    private final void markAsShownDialog() {
        PropertiesComponent.getInstance().setValue("gradle.settings.autoSync.dialog.shown", true);
    }

    private final boolean isSnoozed(Project project) {
        if (this.isProjectSpecificSnoozeActive(project)) {
            return true;
        }
        return this.isTemporarySnoozeActive();
    }

    public final boolean isTemporarySnoozeActive() {
        String string = PropertiesComponent.getInstance().getValue("gradle.settings.autoSync.notification.snooze.expiration.date");
        if (string == null) {
            return false;
        }
        String snoozeExpirationDate = string;
        String today = this.formatDateAtDefaultTimezone(((Number)timeProvider.invoke()).longValue());
        return snoozeExpirationDate.compareTo(today) > 0;
    }

    public final boolean isProjectSpecificSnoozeActive(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!PropertiesComponent.getInstance((Project)project).isValueSet("gradle.settings.autoSync.notification.snooze.project.set.on.timestamp")) {
            return false;
        }
        Long lastSettingChangeTimestamp = AutoSyncSettingStore.INSTANCE.lastAutoSyncBehaviorChangeTimestamp();
        if (lastSettingChangeTimestamp == null) {
            return true;
        }
        String string = PropertiesComponent.getInstance((Project)project).getValue("gradle.settings.autoSync.notification.snooze.project.set.on.timestamp");
        if (string == null) {
            return false;
        }
        long snoozeSetAtTimestamp = Long.parseLong(string);
        return lastSettingChangeTimestamp < snoozeSetAtTimestamp;
    }

    @VisibleForTesting
    public final void snoozeTemporarilyForAllProjects() {
        String snoozeExpirationDate = this.formatDateAtDefaultTimezone(((Number)timeProvider.invoke()).longValue() + (long)86400000);
        PropertiesComponent.getInstance().setValue("gradle.settings.autoSync.notification.snooze.expiration.date", snoozeExpirationDate);
    }

    @VisibleForTesting
    public final void snoozeIndefinitelyForProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PropertiesComponent.getInstance((Project)project).setValue("gradle.settings.autoSync.notification.snooze.project.set.on.timestamp", String.valueOf(((Number)timeProvider.invoke()).longValue()));
    }

    private final void trackAutoSyncEnabled(AutoSyncSettingChangeEvent.ChangeSource changeSource) {
        AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.AUTO_SYNC_SETTING_CHANGE).setAutoSyncSettingChangeEvent(AutoSyncSettingChangeEvent.newBuilder().setState(true).setChangeSource(changeSource).build());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setAutoSyncSettingChangeEvent(...)");
        UsageTracker.log((AndroidStudioEvent.Builder)builder);
    }

    private final void trackSuppressedSync(SuppressedSyncEvent.IndicatorType type, SuppressedSyncEvent.UserAction action2) {
        AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.SUPPRESSED_SYNC).setSuppressedSyncEvent(SuppressedSyncEvent.newBuilder().setAction(action2).setType(type).build());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setSuppressedSyncEvent(...)");
        UsageTracker.log((AndroidStudioEvent.Builder)builder);
    }

    private final String formatDateAtDefaultTimezone(long $this$formatDateAtDefaultTimezone) {
        ZonedDateTime dateTime = Instant.ofEpochMilli($this$formatDateAtDefaultTimezone).atZone(ZoneId.systemDefault());
        String string = DateTimeFormatter.ISO_LOCAL_DATE.format(dateTime);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @Nullable
    public final String getSnoozedProjectsSummaryNote() {
        if (this.isTemporarySnoozeActive()) {
            return AndroidBundle.message("gradle.settings.autoSync.note", new Object[0]);
        }
        List<Project> snoozedProjects = this.getSnoozedProjects();
        if (snoozedProjects.isEmpty()) {
            return null;
        }
        Object[] objectArray = new Object[]{ProjectManager.getInstance().getOpenProjects().length == 1 ? "this project" : CollectionsKt.joinToString$default((Iterable)snoozedProjects, null, (CharSequence)"projects: ", null, (int)0, null, SyncDueMessage::getSnoozedProjectsSummaryNote$lambda$4, (int)29, null)};
        return AndroidBundle.message("gradle.settings.autoSync.note.specific", objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Project> getSnoozedProjects() {
        void $this$filterTo$iv$iv;
        Long l = AutoSyncSettingStore.INSTANCE.lastAutoSyncBehaviorChangeTimestamp();
        long lastAutoSyncSettingChangeTimestamp = l != null ? l : 0L;
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Object[] $this$filter$iv = projectArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            Project project = (Project)element$iv$iv;
            boolean bl = false;
            String string = PropertiesComponent.getInstance((Project)project).getValue("gradle.settings.autoSync.notification.snooze.project.set.on.timestamp");
            long snoozedAtOrNull = string != null ? Long.parseLong(string) : 0L;
            if (!(snoozedAtOrNull > lastAutoSyncSettingChangeTimestamp)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final long timeProvider$lambda$0() {
        return System.currentTimeMillis();
    }

    private static final void showAsDialog$lambda$1(Project $project) {
        SyncDueDialog dialog2 = new SyncDueDialog();
        dialog2.show();
        switch (WhenMappings.$EnumSwitchMapping$0[SyncDueDialogSelection.Companion.of(dialog2).ordinal()]) {
            case 1: {
                INSTANCE.trackSuppressedSync(SuppressedSyncEvent.IndicatorType.DIALOG, SuppressedSyncEvent.UserAction.SINGLE_SYNC);
                INSTANCE.requestProjectSync($project);
                break;
            }
            case 2: {
                INSTANCE.trackAutoSyncEnabled(AutoSyncSettingChangeEvent.ChangeSource.DIALOG);
                AutoSyncSettingStore.INSTANCE.setAutoSyncBehavior(AutoSyncBehavior.Default);
                INSTANCE.requestProjectSync($project);
                break;
            }
            case 3: {
                INSTANCE.trackSuppressedSync(SuppressedSyncEvent.IndicatorType.DIALOG, SuppressedSyncEvent.UserAction.CLOSED);
                break;
            }
            case 4: {
                INSTANCE.trackSuppressedSync(SuppressedSyncEvent.IndicatorType.DIALOG, SuppressedSyncEvent.UserAction.SNOOZE);
                INSTANCE.snoozeTemporarilyForAllProjects();
                break;
            }
            case 5: {
                INSTANCE.trackSuppressedSync(SuppressedSyncEvent.IndicatorType.DIALOG, SuppressedSyncEvent.UserAction.SNOOZE);
                INSTANCE.snoozeIndefinitelyForProject($project);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        INSTANCE.markAsShownDialog();
    }

    private static final CharSequence getSnoozedProjectsSummaryNote$lambda$4(Project it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\"" + it.getName() + "\"";
    }

    static {
        Logger logger = Logger.getInstance(SyncDueMessage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        timeProvider = SyncDueMessage::timeProvider$lambda$0;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/gradle/project/SyncDueMessage$SyncDueNotification;", "Lcom/intellij/notification/Notification;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "setBalloon", "", "balloon", "Lcom/intellij/openapi/ui/popup/Balloon;", "intellij.android.projectSystem.gradle"})
    private static final class SyncDueNotification
    extends Notification {
        public SyncDueNotification(final @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()};
            super("Syncing project is recommended", AndroidBundle.message("gradle.settings.autoSync.notification.message", object), NotificationType.WARNING);
            NotificationsConfiguration.getNotificationsConfiguration().setDisplayType("Syncing project is recommended", NotificationDisplayType.STICKY_BALLOON);
            object = AndroidBundle.message("gradle.settings.autoSync.notification.action.sync", new Object[0]);
            this.addAction(new AnAction((String)object){

                public void actionPerformed(AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.expire();
                    INSTANCE.trackSuppressedSync(SuppressedSyncEvent.IndicatorType.NOTIFICATION, SuppressedSyncEvent.UserAction.SINGLE_SYNC);
                    INSTANCE.requestProjectSync(project);
                    ActivityTracker.getInstance().inc();
                    this.hideBalloon();
                }
            });
            object = AndroidBundle.message("gradle.settings.autoSync.notification.action.enableAutoSync", new Object[0]);
            this.addAction(new AnAction((String)object){

                public void actionPerformed(AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.expire();
                    INSTANCE.trackSuppressedSync(SuppressedSyncEvent.IndicatorType.NOTIFICATION, SuppressedSyncEvent.UserAction.ENABLE_AUTO_SYNC);
                    INSTANCE.trackAutoSyncEnabled(AutoSyncSettingChangeEvent.ChangeSource.NOTIFICATION);
                    AutoSyncSettingStore.INSTANCE.setAutoSyncBehavior(AutoSyncBehavior.Default);
                    INSTANCE.requestProjectSync(project);
                    ActivityTracker.getInstance().inc();
                    this.hideBalloon();
                }
            });
            object = AndroidBundle.message("gradle.settings.autoSync.notification.action.snooze", new Object[0]);
            this.addAction(new AnAction((String)object){

                public void actionPerformed(AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.expire();
                    INSTANCE.trackSuppressedSync(SuppressedSyncEvent.IndicatorType.NOTIFICATION, SuppressedSyncEvent.UserAction.SNOOZE);
                    INSTANCE.snoozeTemporarilyForAllProjects();
                    this.hideBalloon();
                }
            });
            object = AndroidBundle.message("gradle.settings.autoSync.notification.action.snooze.long", new Object[0]);
            this.addAction(new AnAction((String)object){

                public void actionPerformed(AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.expire();
                    INSTANCE.trackSuppressedSync(SuppressedSyncEvent.IndicatorType.NOTIFICATION, SuppressedSyncEvent.UserAction.SNOOZE);
                    INSTANCE.snoozeIndefinitelyForProject(project);
                    this.hideBalloon();
                }
            });
        }

        public void setBalloon(@NotNull Balloon balloon) {
            Intrinsics.checkNotNullParameter((Object)balloon, (String)"balloon");
            super.setBalloon(balloon);
            balloon.addListener(new JBPopupListener(this){
                final /* synthetic */ SyncDueNotification this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onClosed(LightweightWindowEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    super.onClosed(event);
                    this.this$0.hideBalloon();
                    SyncDueMessage.access$trackSuppressedSync(SyncDueMessage.INSTANCE, SuppressedSyncEvent.IndicatorType.NOTIFICATION, SuppressedSyncEvent.UserAction.CLOSED);
                }
            });
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SyncDueDialogSelection.values().length];
            try {
                nArray[SyncDueDialogSelection.SyncOnce.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SyncDueDialogSelection.SyncAlways.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SyncDueDialogSelection.Close.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SyncDueDialogSelection.CloseAndSnoozeTodayForAllProjects.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SyncDueDialogSelection.CloseAndSnoozeIndefinitelyForProject.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

