/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.adtui.HtmlLabel;
import com.android.tools.idea.gradle.project.PropertyBasedDoNotAskOption;
import com.android.tools.idea.gradle.util.IdeGradleProxySettingsBridge;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PortField;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProxySettingsDialog
extends DialogWrapper {
    private static final String SHOW_DO_NOT_ASK_TO_COPY_PROXY_SETTINGS_PROPERTY_NAME = "show.do.not.copy.http.proxy.settings.to.gradle";
    private final boolean myShouldShowDialog;
    private JPanel myPane;
    private JTextField myHttpProxyLoginTextField;
    private JCheckBox myHttpProxyAuthCheckBox;
    private PortField myHttpProxyPortTextField;
    private JTextField myHttpProxyHostTextField;
    private RawCommandLineEditor myHttpProxyExceptions;
    private JTextField myHttpsProxyLoginTextField;
    private JCheckBox myHttpsProxyAuthCheckBox;
    private PortField myHttpsProxyPortTextField;
    private JTextField myHttpsProxyHostTextField;
    private RawCommandLineEditor myHttpsProxyExceptions;
    private JCheckBox myEnableHttpsProxyCheckBox;
    private JPanel myHttpsProxyPanel;
    private JTextPane myMessageTextLabel;
    private static final Function<String, List<String>> COMMA_LINE_PARSER = text2 -> Arrays.stream(text2.split(",")).map(String::trim).filter(Predicate.not(String::isEmpty)).toList();
    private static final Function<List<String>, String> COMMA_LINE_JOINER = list -> StringUtil.join((Collection)list, (String)", ");
    private static Method cachedGetBundleMethod = null;

    public ProxySettingsDialog(@NotNull Project project, @NotNull IdeGradleProxySettingsBridge httpProxySettings, boolean ideProxyUsed) {
        super(project);
        this.setupUI();
        this.setTitle(AndroidBundle.message("android.proxy.settings.dialog.title", new Object[0]));
        this.setOKButtonText("Yes");
        this.setCancelButtonText("No");
        this.myShouldShowDialog = PropertiesComponent.getInstance((Project)project).getBoolean(SHOW_DO_NOT_ASK_TO_COPY_PROXY_SETTINGS_PROPERTY_NAME, true);
        this.setDoNotAskOption(new PropertyBasedDoNotAskOption(project, SHOW_DO_NOT_ASK_TO_COPY_PROXY_SETTINGS_PROPERTY_NAME));
        this.init();
        this.enableHttpProxyAuth(false);
        this.enableHttpsProxyAuth(false);
        HtmlLabel.setUpAsHtmlLabel((JEditorPane)this.myMessageTextLabel);
        this.myMessageTextLabel.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        this.myMessageTextLabel.setText(ProxySettingsDialog.generateDialogText(ideProxyUsed));
        this.myHttpProxyHostTextField.setText(httpProxySettings.getHost());
        this.myHttpProxyPortTextField.setNumber(httpProxySettings.getPort());
        this.myHttpProxyAuthCheckBox.setSelected(httpProxySettings.getUser() != null);
        this.myHttpProxyExceptions.setText(httpProxySettings.getExceptions());
        if (httpProxySettings.getExceptions() != null) {
            this.myHttpProxyExceptions.setText(IdeGradleProxySettingsBridge.replacePipesWithCommasAndClean(httpProxySettings.getExceptions()));
        }
        if (httpProxySettings.getUser() != null) {
            this.myHttpProxyLoginTextField.setText(httpProxySettings.getUser());
            this.enableHttpProxyAuth(true);
        }
        this.myEnableHttpsProxyCheckBox.setSelected(true);
        this.myHttpsProxyHostTextField.setText(httpProxySettings.getHost());
        this.myHttpsProxyPortTextField.setNumber(httpProxySettings.getPort());
        this.myHttpsProxyAuthCheckBox.setSelected(httpProxySettings.getUser() != null);
        if (httpProxySettings.getExceptions() != null) {
            this.myHttpsProxyExceptions.setText(IdeGradleProxySettingsBridge.replacePipesWithCommasAndClean(httpProxySettings.getExceptions()));
        }
        if (httpProxySettings.getUser() != null) {
            this.myHttpsProxyLoginTextField.setText(httpProxySettings.getUser());
            this.enableHttpsProxyAuth(true);
        }
        this.myEnableHttpsProxyCheckBox.addActionListener(e -> {
            Object source2 = e.getSource();
            if (source2 == this.myEnableHttpsProxyCheckBox) {
                this.enableHttpsProxy(this.myEnableHttpsProxyCheckBox.isSelected());
            }
        });
        this.myHttpProxyAuthCheckBox.addActionListener(e -> {
            Object source2 = e.getSource();
            if (source2 == this.myHttpProxyAuthCheckBox) {
                this.enableHttpProxyAuth(this.myHttpProxyAuthCheckBox.isSelected());
            }
        });
        this.myHttpsProxyAuthCheckBox.addActionListener(e -> {
            Object source2 = e.getSource();
            if (source2 == this.myHttpsProxyAuthCheckBox) {
                this.enableHttpsProxyAuth(this.myHttpsProxyAuthCheckBox.isSelected());
            }
        });
    }

    public void show() {
        if (this.myShouldShowDialog) {
            super.show();
        } else {
            this.doCancelAction();
        }
    }

    public boolean applyProxySettings(@NotNull Properties properties) {
        boolean needsPassword;
        IdeGradleProxySettingsBridge httpProxySettings = ProxySettingsDialog.createProxySettingsFromUI("http", this.myHttpProxyHostTextField, this.myHttpProxyPortTextField, this.myHttpProxyExceptions, this.myHttpProxyAuthCheckBox, this.myHttpProxyLoginTextField);
        boolean hasHttpPassword = properties.containsKey("systemProp.http.proxyPassword");
        boolean hasHttpsPassword = properties.containsKey("systemProp.https.proxyPassword");
        httpProxySettings.setPassword(properties.getProperty("systemProp.http.proxyPassword"));
        httpProxySettings.applyProxySettings(properties);
        boolean bl = needsPassword = StringUtil.isNotEmpty((String)httpProxySettings.getUser()) && !hasHttpPassword;
        if (this.myEnableHttpsProxyCheckBox.isSelected()) {
            IdeGradleProxySettingsBridge httpsProxySettings = ProxySettingsDialog.createProxySettingsFromUI("https", this.myHttpsProxyHostTextField, this.myHttpsProxyPortTextField, this.myHttpsProxyExceptions, this.myHttpsProxyAuthCheckBox, this.myHttpsProxyLoginTextField);
            httpsProxySettings.setPassword(properties.getProperty("systemProp.https.proxyPassword"));
            httpsProxySettings.applyProxySettings(properties);
            needsPassword |= StringUtil.isNotEmpty((String)httpsProxySettings.getUser()) && !hasHttpsPassword;
        }
        return needsPassword;
    }

    private void createUIComponents() {
        this.myHttpProxyExceptions = new RawCommandLineEditor(COMMA_LINE_PARSER, COMMA_LINE_JOINER);
        this.myHttpsProxyExceptions = new RawCommandLineEditor(COMMA_LINE_PARSER, COMMA_LINE_JOINER);
    }

    private void setupUI() {
        this.createUIComponents();
        this.myPane = new JPanel();
        this.myPane.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(10, 10, 10, 10), -1, -1));
        this.myPane.setMaximumSize(new Dimension(-1, -1));
        this.myPane.setMinimumSize(new Dimension(735, 555));
        this.myPane.setOpaque(true);
        this.myPane.setPreferredSize(new Dimension(735, 555));
        this.myPane.setRequestFocusEnabled(false);
        this.myPane.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEmptyBorder(), (String)"", (int)0, (int)0, null, null));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(5, 4, new Insets(0, 0, 6, 6), -1, -1));
        this.myPane.add((Component)panel1, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        panel1.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEmptyBorder(), (String)"HTTP Proxy", (int)0, (int)0, null, null));
        JLabel label1 = new JLabel();
        label1.setHorizontalAlignment(4);
        this.loadLabelText(label1, this.getMessageFromBundle("messages/UIBundle", "proxy.manual.host"));
        panel1.add((Component)label1, new GridConstraints(1, 0, 1, 1, 0, 1, 0, 0, null, null, null, 1, false));
        this.myHttpProxyAuthCheckBox = new JCheckBox();
        this.myHttpProxyAuthCheckBox.setMargin(new Insets(2, 1, 2, 2));
        this.myHttpProxyAuthCheckBox.setSelected(false);
        this.loadButtonText(this.myHttpProxyAuthCheckBox, this.getMessageFromBundle("messages/UIBundle", "proxy.manual.auth"));
        panel1.add((Component)this.myHttpProxyAuthCheckBox, new GridConstraints(3, 0, 1, 4, 8, 0, 3, 0, null, null, null, 1, false));
        JLabel label2 = new JLabel();
        label2.setHorizontalAlignment(4);
        this.loadLabelText(label2, this.getMessageFromBundle("messages/UIBundle", "auth.login.label"));
        panel1.add((Component)label2, new GridConstraints(4, 0, 1, 1, 0, 1, 0, 0, null, null, null, 2, false));
        JLabel label3 = new JLabel();
        label3.setHorizontalAlignment(4);
        this.loadLabelText(label3, this.getMessageFromBundle("messages/UIBundle", "proxy.manual.exclude"));
        panel1.add((Component)label3, new GridConstraints(2, 0, 1, 1, 0, 1, 0, 0, null, null, null, 1, false));
        this.myHttpProxyLoginTextField = new JTextField();
        this.myHttpProxyLoginTextField.setName("httpUser");
        this.myHttpProxyLoginTextField.setText("");
        panel1.add((Component)this.myHttpProxyLoginTextField, new GridConstraints(4, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.myHttpProxyHostTextField = new JTextField();
        this.myHttpProxyHostTextField.setName("httpHost");
        panel1.add((Component)this.myHttpProxyHostTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.myHttpProxyExceptions.setDialogCaption("Proxy exceptions");
        this.myHttpProxyExceptions.setName("httpExceptions");
        panel1.add((Component)this.myHttpProxyExceptions, new GridConstraints(2, 1, 1, 3, 0, 1, 5, 0, null, null, null, 0, false));
        JLabel label4 = new JLabel();
        label4.setHorizontalAlignment(4);
        this.loadLabelText(label4, this.getMessageFromBundle("messages/UIBundle", "proxy.manual.port"));
        panel1.add((Component)label4, new GridConstraints(1, 2, 1, 1, 0, 1, 0, 0, null, null, null, 2, false));
        this.myHttpProxyPortTextField = new PortField();
        this.myHttpProxyPortTextField.setName("httpPort");
        panel1.add((Component)this.myHttpProxyPortTextField, new GridConstraints(1, 3, 1, 1, 0, 1, 3, 3, null, null, null, 0, false));
        JLabel label5 = new JLabel();
        label5.setText("");
        panel1.add((Component)label5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JLabel label6 = new JLabel();
        label6.setHorizontalAlignment(4);
        this.loadLabelText(label6, this.getMessageFromBundle("messages/UIBundle", "auth.password.label"));
        panel1.add((Component)label6, new GridConstraints(4, 2, 1, 1, 0, 1, 0, 0, null, null, null, 4, false));
        JLabel label7 = new JLabel();
        label7.setText("<html><b>N/A</b></html>");
        panel1.add((Component)label7, new GridConstraints(4, 3, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myHttpsProxyPanel = new JPanel();
        this.myHttpsProxyPanel.setLayout((LayoutManager)new GridLayoutManager(5, 4, new Insets(0, 0, 6, 6), -1, -1));
        this.myHttpsProxyPanel.setEnabled(true);
        this.myPane.add((Component)this.myHttpsProxyPanel, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myHttpsProxyPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEmptyBorder(), (String)"HTTPS Proxy", (int)0, (int)0, null, null));
        JLabel label8 = new JLabel();
        label8.setHorizontalAlignment(4);
        this.loadLabelText(label8, this.getMessageFromBundle("messages/UIBundle", "proxy.manual.host"));
        this.myHttpsProxyPanel.add((Component)label8, new GridConstraints(1, 0, 1, 1, 0, 1, 0, 0, null, null, null, 1, false));
        this.myHttpsProxyAuthCheckBox = new JCheckBox();
        this.myHttpsProxyAuthCheckBox.setMargin(new Insets(2, 1, 2, 2));
        this.myHttpsProxyAuthCheckBox.setSelected(false);
        this.loadButtonText(this.myHttpsProxyAuthCheckBox, this.getMessageFromBundle("messages/UIBundle", "proxy.manual.auth"));
        this.myHttpsProxyPanel.add((Component)this.myHttpsProxyAuthCheckBox, new GridConstraints(3, 0, 1, 4, 8, 0, 3, 0, null, null, null, 1, false));
        JLabel label9 = new JLabel();
        label9.setHorizontalAlignment(4);
        this.loadLabelText(label9, this.getMessageFromBundle("messages/UIBundle", "proxy.manual.exclude"));
        this.myHttpsProxyPanel.add((Component)label9, new GridConstraints(2, 0, 1, 1, 0, 1, 0, 0, null, null, null, 1, false));
        this.myHttpsProxyLoginTextField = new JTextField();
        this.myHttpsProxyLoginTextField.setName("httpsUser");
        this.myHttpsProxyLoginTextField.setText("");
        this.myHttpsProxyPanel.add((Component)this.myHttpsProxyLoginTextField, new GridConstraints(4, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.myHttpsProxyHostTextField = new JTextField();
        this.myHttpsProxyHostTextField.setName("httpsHost");
        this.myHttpsProxyPanel.add((Component)this.myHttpsProxyHostTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.myHttpsProxyExceptions.setDialogCaption("Proxy exceptions");
        this.myHttpsProxyExceptions.setName("httpsExceptions");
        this.myHttpsProxyPanel.add((Component)this.myHttpsProxyExceptions, new GridConstraints(2, 1, 1, 3, 0, 1, 5, 0, null, null, null, 0, false));
        JLabel label10 = new JLabel();
        label10.setHorizontalAlignment(4);
        this.loadLabelText(label10, this.getMessageFromBundle("messages/UIBundle", "proxy.manual.port"));
        this.myHttpsProxyPanel.add((Component)label10, new GridConstraints(1, 2, 1, 1, 0, 1, 0, 0, null, null, null, 2, false));
        this.myHttpsProxyPortTextField = new PortField();
        this.myHttpsProxyPortTextField.setName("httpsPort");
        this.myHttpsProxyPanel.add((Component)this.myHttpsProxyPortTextField, new GridConstraints(1, 3, 1, 1, 0, 1, 3, 3, null, null, null, 0, false));
        JLabel label11 = new JLabel();
        label11.setText("");
        this.myHttpsProxyPanel.add((Component)label11, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JLabel label12 = new JLabel();
        label12.setHorizontalAlignment(4);
        this.loadLabelText(label12, this.getMessageFromBundle("messages/UIBundle", "auth.password.label"));
        this.myHttpsProxyPanel.add((Component)label12, new GridConstraints(4, 2, 1, 1, 0, 1, 0, 0, null, null, null, 4, false));
        JLabel label13 = new JLabel();
        label13.setHorizontalAlignment(4);
        this.loadLabelText(label13, this.getMessageFromBundle("messages/UIBundle", "auth.login.label"));
        this.myHttpsProxyPanel.add((Component)label13, new GridConstraints(4, 0, 1, 1, 0, 1, 0, 0, null, null, null, 2, false));
        JLabel label14 = new JLabel();
        label14.setText("<html><b>N/A</b></html>");
        this.myHttpsProxyPanel.add((Component)label14, new GridConstraints(4, 3, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myMessageTextLabel = new JTextPane();
        this.myMessageTextLabel.setText("");
        this.myPane.add((Component)this.myMessageTextLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null, 0, false));
        this.myEnableHttpsProxyCheckBox = new JCheckBox();
        this.myEnableHttpsProxyCheckBox.setText("Enable HTTPS Proxy");
        this.myPane.add((Component)this.myEnableHttpsProxyCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JLabel label15 = new JLabel();
        label15.setText("");
        this.myPane.add((Component)label15, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JLabel label16 = new JLabel();
        label16.setText("");
        this.myPane.add((Component)label16, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myPane.add((Component)spacer1, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        label1.setLabelFor(this.myHttpProxyHostTextField);
        label2.setLabelFor(this.myHttpProxyLoginTextField);
        label8.setLabelFor(this.myHttpsProxyHostTextField);
        label13.setLabelFor(this.myHttpsProxyLoginTextField);
    }

    private String getMessageFromBundle(String path, String key) {
        ResourceBundle bundle;
        try {
            Class<?> thisClass = ((Object)((Object)this)).getClass();
            if (cachedGetBundleMethod == null) {
                Class<?> dynamicBundleClass = thisClass.getClassLoader().loadClass("com.intellij.DynamicBundle");
                cachedGetBundleMethod = dynamicBundleClass.getMethod("getBundle", String.class, Class.class);
            }
            bundle = (ResourceBundle)cachedGetBundleMethod.invoke(null, path, thisClass);
        }
        catch (Exception e) {
            bundle = ResourceBundle.getBundle(path);
        }
        return bundle.getString(key);
    }

    private void loadLabelText(JLabel component, String text2) {
        StringBuffer result2 = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text2.length(); ++i) {
            if (text2.charAt(i) == '&') {
                if (++i == text2.length()) break;
                if (!haveMnemonic && text2.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text2.charAt(i);
                    mnemonicIndex = result2.length();
                }
            }
            result2.append(text2.charAt(i));
        }
        component.setText(result2.toString());
        if (haveMnemonic) {
            component.setDisplayedMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    private void loadButtonText(AbstractButton component, String text2) {
        StringBuffer result2 = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text2.length(); ++i) {
            if (text2.charAt(i) == '&') {
                if (++i == text2.length()) break;
                if (!haveMnemonic && text2.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text2.charAt(i);
                    mnemonicIndex = result2.length();
                }
            }
            result2.append(text2.charAt(i));
        }
        component.setText(result2.toString());
        if (haveMnemonic) {
            component.setMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    @NotNull
    private static IdeGradleProxySettingsBridge createProxySettingsFromUI(@NotNull String proxyType, @NotNull JTextField proxyHostTextField, @NotNull PortField proxyPortTextField, @NotNull RawCommandLineEditor proxyExceptions, @NotNull JCheckBox proxyAuthCheckBox, @NotNull JTextField proxyLoginTextField) {
        IdeGradleProxySettingsBridge proxySettings = new IdeGradleProxySettingsBridge(proxyType);
        proxySettings.setHost(proxyHostTextField.getText());
        proxySettings.setPort(proxyPortTextField.getNumber());
        proxySettings.setExceptions(IdeGradleProxySettingsBridge.replaceCommasWithPipesAndClean(proxyExceptions.getText()));
        if (proxyAuthCheckBox.isSelected()) {
            proxySettings.setUser(proxyLoginTextField.getText());
            proxySettings.setPassword("");
        }
        return proxySettings;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPane;
    }

    private void enableHttpsProxy(boolean enabled) {
        this.myHttpsProxyPanel.setEnabled(enabled);
        this.myHttpsProxyHostTextField.setEnabled(enabled);
        this.myHttpsProxyPortTextField.setEnabled(enabled);
        this.myHttpsProxyExceptions.setEnabled(enabled);
        this.myHttpsProxyAuthCheckBox.setEnabled(enabled);
        this.enableHttpsProxyAuth(enabled && this.myHttpsProxyAuthCheckBox.isSelected());
    }

    private void enableHttpProxyAuth(boolean enabled) {
        this.myHttpProxyLoginTextField.setEnabled(enabled);
    }

    private void enableHttpsProxyAuth(boolean enabled) {
        this.myHttpsProxyLoginTextField.setEnabled(enabled);
    }

    @VisibleForTesting
    void setHttpProxyHost(@NotNull String value2) {
        this.myHttpProxyHostTextField.setText(value2);
    }

    @VisibleForTesting
    void setHttpPortNumber(int value2) {
        this.myHttpProxyPortTextField.setValue((Object)value2);
    }

    @VisibleForTesting
    void setHttpProxyException(@NotNull String value2) {
        this.myHttpProxyExceptions.setText(value2);
    }

    @VisibleForTesting
    void setHttpProxyAuthenticationEnabled(boolean value2) {
        this.myHttpProxyAuthCheckBox.setSelected(value2);
    }

    @VisibleForTesting
    void setHttpProxyLogin(@NotNull String value2) {
        this.myHttpProxyLoginTextField.setText(value2);
    }

    @VisibleForTesting
    void setHttpsProxyEnabled(boolean value2) {
        this.myEnableHttpsProxyCheckBox.setSelected(value2);
    }

    @VisibleForTesting
    void setHttpsProxyHost(@NotNull String value2) {
        this.myHttpsProxyHostTextField.setText(value2);
    }

    @VisibleForTesting
    void setHttpsPortNumber(int value2) {
        this.myHttpsProxyPortTextField.setValue((Object)value2);
    }

    @VisibleForTesting
    void setHttpsProxyException(@NotNull String value2) {
        this.myHttpsProxyExceptions.setText(value2);
    }

    @VisibleForTesting
    void setHttpsProxyAuthenticationEnabled(boolean value2) {
        this.myHttpsProxyAuthCheckBox.setSelected(value2);
    }

    @VisibleForTesting
    void setHttpsProxyLogin(@NotNull String value2) {
        this.myHttpsProxyLoginTextField.setText(value2);
    }

    @VisibleForTesting
    static String generateDialogText(boolean ideProxyUsed) {
        String dialogTemplate = ideProxyUsed ? "android.proxy.settings.dialog.message" : "android.proxy.settings.dialog.no.ide.message";
        return AndroidBundle.message(dialogTemplate, ApplicationNamesInfo.getInstance().getProductName());
    }
}

