/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.project.AndroidModuleImporter;
import com.android.tools.idea.gradle.project.ModuleToImport;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleImporter {
    private static final Logger LOG = Logger.getInstance(ModuleImporter.class);
    private static final Key<ModuleImporter[]> KEY_IMPORTERS = new Key("com.android.tools.importers");
    private static final Key<ModuleImporter> KEY_CURRENT_IMPORTER = new Key("com.android.tools.currentImporter");
    private static final ModuleImporter NONE = new ModuleImporter(){

        @Override
        public boolean isStepVisible(@NotNull ModuleWizardStep step2) {
            return false;
        }

        @Override
        @NotNull
        public List<? extends ModuleWizardStep> createWizardSteps() {
            return Collections.emptyList();
        }

        @Override
        public void importProjects(@Nullable Map<String, VirtualFile> projects) {
            LOG.error("Unsupported import kind");
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public boolean canImport(@NotNull VirtualFile importSource) {
            return false;
        }

        @Override
        @NotNull
        public Set<ModuleToImport> findModules(@NotNull VirtualFile importSource) {
            return Collections.emptySet();
        }
    };

    @NotNull
    public static synchronized ModuleImporter[] getAllImporters(@NotNull WizardContext context) {
        ModuleImporter[] importers = (ModuleImporter[])context.getUserData(KEY_IMPORTERS);
        if (importers == null) {
            importers = ModuleImporter.createImporters(context);
        }
        return importers;
    }

    @NotNull
    private static ModuleImporter[] createImporters(@NotNull WizardContext context) {
        ModuleImporter[] importers = ContainerUtil.map((Collection)AndroidModuleImporter.IMPORTER.getExtensionList(), it -> it.create(context)).toArray(new ModuleImporter[0]);
        context.putUserData(KEY_IMPORTERS, (Object)importers);
        return importers;
    }

    @NotNull
    public static ModuleImporter getImporter(@NotNull WizardContext context) {
        ModuleImporter importer = (ModuleImporter)context.getUserData(KEY_CURRENT_IMPORTER);
        if (importer != null) {
            return importer;
        }
        return NONE;
    }

    @NotNull
    public static ModuleImporter importerForLocation(WizardContext context, VirtualFile importSource) {
        for (ModuleImporter importer : ModuleImporter.getAllImporters(context)) {
            if (!importer.canImport(importSource)) continue;
            return importer;
        }
        return NONE;
    }

    public static void setImporter(@NotNull WizardContext context, @Nullable ModuleImporter importer) {
        context.putUserData(KEY_CURRENT_IMPORTER, (Object)importer);
    }

    public abstract boolean isStepVisible(@NotNull ModuleWizardStep var1);

    @NotNull
    public abstract List<? extends ModuleWizardStep> createWizardSteps();

    public abstract void importProjects(@Nullable Map<String, VirtualFile> var1);

    public abstract boolean isValid();

    public abstract boolean canImport(@NotNull VirtualFile var1);

    @NotNull
    public abstract Set<ModuleToImport> findModules(@NotNull VirtualFile var1) throws IOException;
}

