/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.SdkConstants;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.model.impl.IdeAndroidProjectImpl;
import com.android.tools.idea.gradle.project.AndroidSdkCompatibilityDialog;
import com.android.tools.idea.gradle.project.model.GradleAndroidModelData;
import com.android.tools.idea.serverflags.protos.RecommendedVersions;
import com.android.tools.idea.serverflags.protos.StudioVersionRecommendation;
import com.google.wireless.android.sdk.stats.ProductDetails;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\r2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/gradle/project/AndroidSdkCompatibilityChecker;", "", "<init>", "()V", "checkAndroidSdkVersion", "", "importedModules", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/android/tools/idea/gradle/project/model/GradleAndroidModelData;", "project", "Lcom/intellij/openapi/project/Project;", "serverFlag", "", "", "Lcom/android/tools/idea/serverflags/protos/RecommendedVersions;", "maxRecommendedCompileSdk", "Lcom/android/sdklib/AndroidVersion;", "getChannelFromUpdateSettings", "Lcom/google/wireless/android/sdk/stats/ProductDetails$SoftwareLifeCycleChannel;", "Companion", "StudioUpgradeReminder", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nAndroidSdkCompatibilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidSdkCompatibilityChecker.kt\ncom/android/tools/idea/gradle/project/AndroidSdkCompatibilityChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n1611#2,9:139\n1863#2:148\n1864#2:150\n1620#2:151\n1557#2:152\n1628#2,3:153\n1#3:149\n1#3:156\n*S KotlinDebug\n*F\n+ 1 AndroidSdkCompatibilityChecker.kt\ncom/android/tools/idea/gradle/project/AndroidSdkCompatibilityChecker\n*L\n49#1:139,9\n49#1:148\n49#1:150\n49#1:151\n68#1:152\n68#1:153,3\n49#1:149\n*E\n"})
public final class AndroidSdkCompatibilityChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final AndroidVersion MAX_RECOMMENDED_COMPILE_SDK_VERSION;
    public static final int MAX_NUM_OF_MODULES = 5;

    /*
     * WARNING - void declaration
     */
    public final void checkAndroidSdkVersion(@NotNull Collection<? extends DataNode<GradleAndroidModelData>> importedModules, @NotNull Project project, @Nullable Map<String, RecommendedVersions> serverFlag, @NotNull AndroidVersion maxRecommendedCompileSdk) {
        Pair pair;
        Object object;
        void $this$mapTo$iv$iv;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(importedModules, (String)"importedModules");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)maxRecommendedCompileSdk, (String)"maxRecommendedCompileSdk");
        if (!new StudioUpgradeReminder(project).shouldAsk()) {
            return;
        }
        Iterable $this$mapNotNull$iv = importedModules;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair pair2;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            DataNode it = (DataNode)element$iv$iv;
            boolean bl2 = false;
            IdeAndroidProjectImpl androidProject = ((GradleAndroidModelData)it.getData()).getAndroidProject();
            String moduleName = ((GradleAndroidModelData)it.getData()).getModuleName();
            String compileTargetSdk = androidProject.getCompileTarget();
            AndroidVersion version2 = AndroidTargetHash.getPlatformVersion((String)compileTargetSdk);
            if (version2 != null) {
                AndroidVersion sdkVersion;
                boolean bl3 = false;
                pair2 = AndroidVersion.API_LEVEL_ORDERING.compare(sdkVersion, maxRecommendedCompileSdk) > 0 ? new Pair((Object)moduleName, (Object)sdkVersion) : null;
            } else {
                pair2 = null;
            }
            if (pair2 == null) continue;
            Pair it$iv$iv = pair2;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List modulesViolatingSupportRules = (List)destination$iv$iv;
        if (modulesViolatingSupportRules.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = modulesViolatingSupportRules;
        boolean $i$f$map = false;
        Iterable $i$f$mapNotNullTo22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            element$iv$iv = (Pair)item$iv$iv;
            Collection collection2 = destination$iv$iv2;
            boolean bl = false;
            collection2.add((AndroidVersion)it.getSecond());
        }
        Iterable iterable2 = (List)destination$iv$iv2;
        Comparator comparator = AndroidVersion.API_LEVEL_ORDERING;
        Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"API_LEVEL_ORDERING");
        AndroidVersion androidVersion = (AndroidVersion)CollectionsKt.maxWithOrNull((Iterable)iterable2, (Comparator)comparator);
        if (androidVersion == null) {
            return;
        }
        AndroidVersion highestViolatingSdkVersion = androidVersion;
        if (highestViolatingSdkVersion.isPreview()) {
            String string = highestViolatingSdkVersion.getCodename();
            if (string != null) {
                String previewName = string;
                boolean bl = false;
                RecommendedVersions recommendedVersions = serverFlag;
                object = recommendedVersions != null ? (RecommendedVersions)recommendedVersions.get(previewName) : null;
            } else {
                object = null;
            }
        } else {
            object = serverFlag;
            if (object == null || (object = object.get(highestViolatingSdkVersion.getAndroidApiLevel().toString())) == null) {
                RecommendedVersions recommendedVersions = serverFlag;
                object = recommendedVersions != null ? (RecommendedVersions)recommendedVersions.get(String.valueOf(highestViolatingSdkVersion.getAndroidApiLevel().getMajorVersion())) : null;
            }
        }
        if (object == null) {
            return;
        }
        RecommendedVersions recommendation = object;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getChannelFromUpdateSettings().ordinal()]) {
            case 1: {
                pair = new Pair((Object)recommendation.getCanaryChannel(), null);
                break;
            }
            case 2: {
                void it;
                StudioVersionRecommendation studioVersionRecommendation;
                StudioVersionRecommendation bl = studioVersionRecommendation = recommendation.getCanaryChannel();
                StudioVersionRecommendation studioVersionRecommendation2 = recommendation.getBetaRcChannel();
                boolean bl5 = false;
                boolean bl6 = it.getVersionReleased();
                StudioVersionRecommendation studioVersionRecommendation3 = bl6 ? studioVersionRecommendation : null;
                StudioVersionRecommendation studioVersionRecommendation4 = studioVersionRecommendation2;
                pair = new Pair((Object)studioVersionRecommendation4, (Object)studioVersionRecommendation3);
                break;
            }
            case 3: {
                StudioVersionRecommendation it;
                StudioVersionRecommendation studioVersionRecommendation;
                StudioVersionRecommendation bl5 = studioVersionRecommendation = recommendation.getBetaRcChannel();
                StudioVersionRecommendation studioVersionRecommendation2 = recommendation.getStableChannel();
                boolean bl = false;
                boolean bl6 = it.getVersionReleased();
                StudioVersionRecommendation studioVersionRecommendation5 = studioVersionRecommendation2;
                Object object2 = bl6 ? studioVersionRecommendation : null;
                if (object2 == null) {
                    it = studioVersionRecommendation = recommendation.getCanaryChannel();
                    studioVersionRecommendation2 = studioVersionRecommendation5;
                    boolean bl7 = false;
                    bl6 = it.getVersionReleased();
                    studioVersionRecommendation5 = studioVersionRecommendation2;
                    object2 = bl6 ? studioVersionRecommendation : null;
                }
                StudioVersionRecommendation studioVersionRecommendation6 = object2;
                StudioVersionRecommendation studioVersionRecommendation7 = studioVersionRecommendation5;
                pair = new Pair((Object)studioVersionRecommendation7, (Object)studioVersionRecommendation6);
                break;
            }
            default: {
                return;
            }
        }
        iterable = pair;
        StudioVersionRecommendation recommendedVersion = (StudioVersionRecommendation)iterable.component1();
        StudioVersionRecommendation potentialFallbackVersion = (StudioVersionRecommendation)iterable.component2();
        ApplicationManager.getApplication().invokeLater(() -> AndroidSdkCompatibilityChecker.checkAndroidSdkVersion$lambda$7(project, recommendedVersion, potentialFallbackVersion, modulesViolatingSupportRules));
    }

    public static /* synthetic */ void checkAndroidSdkVersion$default(AndroidSdkCompatibilityChecker androidSdkCompatibilityChecker, Collection collection2, Project project, Map map2, AndroidVersion androidVersion, int n, Object object) {
        if ((n & 8) != 0) {
            androidVersion = MAX_RECOMMENDED_COMPILE_SDK_VERSION;
        }
        androidSdkCompatibilityChecker.checkAndroidSdkVersion(collection2, project, map2, androidVersion);
    }

    private final ProductDetails.SoftwareLifeCycleChannel getChannelFromUpdateSettings() {
        return switch (WhenMappings.$EnumSwitchMapping$1[UpdateSettings.getInstance().getSelectedChannelStatus().ordinal()]) {
            case 1 -> ProductDetails.SoftwareLifeCycleChannel.CANARY;
            case 2 -> ProductDetails.SoftwareLifeCycleChannel.DEV;
            case 3 -> ProductDetails.SoftwareLifeCycleChannel.BETA;
            case 4 -> ProductDetails.SoftwareLifeCycleChannel.STABLE;
            default -> ProductDetails.SoftwareLifeCycleChannel.UNKNOWN_LIFE_CYCLE_CHANNEL;
        };
    }

    private static final void checkAndroidSdkVersion$lambda$7(Project $project, StudioVersionRecommendation $recommendedVersion, StudioVersionRecommendation $potentialFallbackVersion, List $modulesViolatingSupportRules) {
        if (!$project.isDisposed()) {
            Intrinsics.checkNotNull((Object)$recommendedVersion);
            AndroidSdkCompatibilityDialog dialog2 = new AndroidSdkCompatibilityDialog($project, $recommendedVersion, $potentialFallbackVersion, $modulesViolatingSupportRules);
            dialog2.show();
        }
    }

    static {
        AndroidVersion androidVersion = SdkConstants.MAX_SUPPORTED_ANDROID_PLATFORM_VERSION;
        Intrinsics.checkNotNullExpressionValue((Object)androidVersion, (String)"MAX_SUPPORTED_ANDROID_PLATFORM_VERSION");
        MAX_RECOMMENDED_COMPILE_SDK_VERSION = androidVersion;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/gradle/project/AndroidSdkCompatibilityChecker$Companion;", "", "<init>", "()V", "MAX_RECOMMENDED_COMPILE_SDK_VERSION", "Lcom/android/sdklib/AndroidVersion;", "getMAX_RECOMMENDED_COMPILE_SDK_VERSION", "()Lcom/android/sdklib/AndroidVersion;", "MAX_NUM_OF_MODULES", "", "getInstance", "Lcom/android/tools/idea/gradle/project/AndroidSdkCompatibilityChecker;", "intellij.android.projectSystem.gradle"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AndroidVersion getMAX_RECOMMENDED_COMPILE_SDK_VERSION() {
            return MAX_RECOMMENDED_COMPILE_SDK_VERSION;
        }

        @NotNull
        public final AndroidSdkCompatibilityChecker getInstance() {
            Object object = ApplicationManager.getApplication().getService(AndroidSdkCompatibilityChecker.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (AndroidSdkCompatibilityChecker)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0014\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R$\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/gradle/project/AndroidSdkCompatibilityChecker$StudioUpgradeReminder;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "doNotShowAgainPropertyString", "", "value", "", "doNotAskAgainIdeLevel", "getDoNotAskAgainIdeLevel", "()Z", "setDoNotAskAgainIdeLevel", "(Z)V", "doNotAskAgainProjectLevel", "getDoNotAskAgainProjectLevel", "setDoNotAskAgainProjectLevel", "shouldAsk", "intellij.android.projectSystem.gradle"})
    public static final class StudioUpgradeReminder {
        @NotNull
        private final Project project;
        @NotNull
        private final String doNotShowAgainPropertyString;

        public StudioUpgradeReminder(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
            this.doNotShowAgainPropertyString = "studio.upgrade.do.not.show.again";
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public final boolean getDoNotAskAgainIdeLevel() {
            return PropertiesComponent.getInstance().getBoolean(this.doNotShowAgainPropertyString, false);
        }

        public final void setDoNotAskAgainIdeLevel(boolean value2) {
            PropertiesComponent.getInstance().setValue(this.doNotShowAgainPropertyString, value2);
        }

        public final boolean getDoNotAskAgainProjectLevel() {
            return PropertiesComponent.getInstance((Project)this.project).getBoolean(this.doNotShowAgainPropertyString, false);
        }

        public final void setDoNotAskAgainProjectLevel(boolean value2) {
            PropertiesComponent.getInstance((Project)this.project).setValue(this.doNotShowAgainPropertyString, value2);
        }

        public final boolean shouldAsk() {
            return !this.getDoNotAskAgainProjectLevel() || !this.getDoNotAskAgainIdeLevel();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ProductDetails.SoftwareLifeCycleChannel.values().length];
            try {
                nArray[ProductDetails.SoftwareLifeCycleChannel.CANARY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProductDetails.SoftwareLifeCycleChannel.BETA.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProductDetails.SoftwareLifeCycleChannel.STABLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ChannelStatus.values().length];
            try {
                nArray[ChannelStatus.EAP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChannelStatus.MILESTONE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChannelStatus.BETA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChannelStatus.RELEASE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

