/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.android;

import com.android.tools.idea.gradle.dsl.api.android.CompileSdkReleaseModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelBuilder;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslClosure;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompileSdkReleaseModelImpl
implements CompileSdkReleaseModel {
    public static String MINOR_API_LEVEL = "minorApiLevel";
    public static String SDK_EXTENSION = "sdkExtension";
    private final GradleDslMethodCall myMethodCall;
    GradleDslClosure myClosure;

    public CompileSdkReleaseModelImpl(@NotNull GradleDslMethodCall methodCall) {
        this.myMethodCall = methodCall;
        this.myClosure = methodCall.getClosureElement();
        if (this.myClosure == null) {
            this.myClosure = new GradleDslClosure(methodCall, null, GradleNameElement.empty());
        }
    }

    @Override
    @NotNull
    public ResolvedPropertyModel getMinorApiLevel() {
        return GradlePropertyModelBuilder.create((GradlePropertiesDslElement)this.myClosure, MINOR_API_LEVEL).buildResolved();
    }

    @Override
    @NotNull
    public ResolvedPropertyModel getSdkExtension() {
        return GradlePropertyModelBuilder.create((GradlePropertiesDslElement)this.myClosure, SDK_EXTENSION).buildResolved();
    }

    @Override
    @NotNull
    public ResolvedPropertyModel getVersion() {
        return GradlePropertyModelBuilder.create(this.myMethodCall.getArguments().get(0)).buildResolved();
    }

    @Override
    public void delete() {
        this.myMethodCall.delete();
    }

    @Override
    @Nullable
    public String toHash() {
        Integer sdkExtension;
        Integer apiLevel = this.getVersion().toInt();
        String compileSdkString = "android-" + apiLevel;
        Integer minorApiLevel = this.getMinorApiLevel().toInt();
        if (minorApiLevel != null) {
            compileSdkString = compileSdkString + "." + minorApiLevel;
        }
        if ((sdkExtension = this.getSdkExtension().toInt()) != null) {
            compileSdkString = compileSdkString + "-ext" + sdkExtension;
        }
        return compileSdkString;
    }

    @Override
    @Nullable
    public Integer toInt() {
        if (this.getMinorApiLevel().toInt() == null && this.getSdkExtension().toInt() == null) {
            return this.getVersion().toInt();
        }
        return null;
    }
}

