/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.android.tools.idea.gradle.dsl.api.settings.DependencyResolutionManagementModel;
import com.android.tools.idea.gradle.dsl.api.settings.PluginManagementModel;
import com.android.tools.idea.gradle.dsl.api.settings.PluginsBlockModel;
import com.android.tools.idea.gradle.dsl.model.GradleFileModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradleModelFactory;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelBuilder;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelImpl;
import com.android.tools.idea.gradle.dsl.model.settings.DependencyResolutionManagementModelImpl;
import com.android.tools.idea.gradle.dsl.model.settings.PluginManagementModelImpl;
import com.android.tools.idea.gradle.dsl.model.settings.PluginsBlockModelImpl;
import com.android.tools.idea.gradle.dsl.parser.ExternalNameInfo;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.dsl.parser.include.IncludeDslElement;
import com.android.tools.idea.gradle.dsl.parser.plugins.PluginsDslElement;
import com.android.tools.idea.gradle.dsl.parser.settings.DependencyResolutionManagementDslElement;
import com.android.tools.idea.gradle.dsl.parser.settings.PluginManagementDslElement;
import com.android.tools.idea.gradle.dsl.parser.settings.ProjectPropertiesDslElement;
import com.android.tools.idea.gradle.dsl.utils.BuildScriptUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleSettingsModelImpl
extends GradleFileModelImpl
implements GradleSettingsModel {
    @NotNull
    protected GradleSettingsFile myGradleSettingsFile;
    private final ModulePathsCache myModulePathsCache = new ModulePathsCache();

    public GradleSettingsModelImpl(@NotNull GradleSettingsFile parsedModel) {
        super(parsedModel);
        this.myGradleSettingsFile = parsedModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Set<String> modulePaths() {
        long committedCount = this.myGradleDslFile.getLastCommittedModificationCount();
        long modificationCount = this.myGradleDslFile.getModificationCount();
        IncludeDslElement includePaths = this.myGradleDslFile.getPropertyElement(IncludeDslElement.INCLUDE);
        ModulePathsCache modulePathsCache = this.myModulePathsCache;
        synchronized (modulePathsCache) {
            if (this.myModulePathsCache.committedCount == modificationCount) {
                return this.myModulePathsCache.paths;
            }
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        result2.add(":");
        if (includePaths != null) {
            for (GradleDslSimpleExpression includePath : includePaths.getModules()) {
                String value2 = includePath.getValue(String.class);
                if (value2 == null) continue;
                result2.add(GradleSettingsModelImpl.standardiseModulePath(value2));
            }
        }
        ModulePathsCache modulePathsCache2 = this.myModulePathsCache;
        synchronized (modulePathsCache2) {
            this.myModulePathsCache.paths = result2;
            this.myModulePathsCache.committedCount = committedCount;
        }
        return result2;
    }

    @Override
    public void addModulePath(@NotNull String modulePath) {
        modulePath = GradleSettingsModelImpl.standardiseModulePath(modulePath);
        IncludeDslElement includeDslElement = this.myGradleDslFile.ensurePropertyElement(IncludeDslElement.INCLUDE);
        GradleDslLiteral literal = new GradleDslLiteral(includeDslElement, GradleNameElement.create(IncludeDslElement.INCLUDE.name));
        literal.setValue(modulePath);
        includeDslElement.setNewElement(literal);
    }

    @Override
    public void removeModulePath(@NotNull String modulePath) {
        IncludeDslElement includeDslElement = this.myGradleDslFile.getPropertyElement(IncludeDslElement.INCLUDE);
        if (includeDslElement != null) {
            if (!modulePath.startsWith(":")) {
                includeDslElement.removeModule(":" + modulePath);
            }
            includeDslElement.removeModule(modulePath);
        }
    }

    @Override
    public void replaceModulePath(@NotNull String oldModulePath, @NotNull String newModulePath) {
        IncludeDslElement includeDslElement = this.myGradleDslFile.getPropertyElement(IncludeDslElement.INCLUDE);
        if (includeDslElement != null) {
            if (!((String)newModulePath).startsWith(":")) {
                newModulePath = ":" + (String)newModulePath;
            }
            if (!oldModulePath.startsWith(":")) {
                includeDslElement.replaceModulePath(":" + oldModulePath, newModulePath);
            }
            includeDslElement.replaceModulePath(oldModulePath, newModulePath);
        }
    }

    @Override
    @Nullable
    public File moduleDirectory(String modulePath) {
        modulePath = GradleSettingsModelImpl.standardiseModulePath(modulePath);
        if (!this.modulePaths().contains(modulePath)) {
            return null;
        }
        return this.moduleDirectoryNoCheck(modulePath, new HashMap<String, File>());
    }

    @Override
    public void setModuleDirectory(@NotNull String modulePath, @NotNull File moduleDir) {
        String projectKey = "project('" + modulePath + "')";
        String projectDirPropertyName = projectKey + ".projectDir";
        GradleNameElement projectKeyName = GradleNameElement.fake(projectKey);
        ProjectPropertiesDslElement projectProperties = this.myGradleDslFile.ensureNamedPropertyElement(ProjectPropertiesDslElement.PROJECT_PROPERTIES, projectKeyName);
        GradleDslMethodCall currentElement = projectProperties.getPropertyElement("projectDir", GradleDslMethodCall.class);
        if (currentElement != null) {
            projectProperties.removeProperty(currentElement);
        }
        GradleNameElement gradleNameElement = GradleNameElement.fake(projectDirPropertyName);
        GradleDslMethodCall methodCall = new GradleDslMethodCall((GradleDslElement)this.myGradleDslFile, gradleNameElement, "file");
        methodCall.setExternalSyntax(ExternalNameInfo.ExternalNameSyntax.ASSIGNMENT);
        projectProperties.setNewElement(methodCall);
        String dirPath = moduleDir.getAbsolutePath();
        File rootDir = VfsUtilCore.virtualToIoFile((VirtualFile)this.myGradleDslFile.getFile().getParent());
        if (VfsUtilCore.isAncestor((File)rootDir, (File)moduleDir, (boolean)false)) {
            GradleDslLiteral rootDirArg = new GradleDslLiteral(methodCall, GradleNameElement.empty());
            GradlePropertyModelImpl elementModel = GradlePropertyModelBuilder.create(rootDirArg).build();
            rootDirArg.setValue(ReferenceTo.createReferenceFromText("rootDir", elementModel));
            methodCall.addNewArgument(rootDirArg);
            methodCall.setMethodName("File");
            methodCall.setIsConstructor(true);
            dirPath = rootDir.toURI().relativize(moduleDir.toURI()).getPath();
        }
        if (dirPath != null && !dirPath.isEmpty()) {
            GradleDslLiteral extraArg = new GradleDslLiteral(methodCall, GradleNameElement.empty());
            extraArg.setValue(dirPath);
            methodCall.addNewArgument(extraArg);
        }
    }

    @Nullable
    private File moduleDirectoryNoCheck(String modulePath, Map<String, File> processedModulePath) {
        File parentDir;
        File projectDir;
        if (processedModulePath.containsKey(modulePath)) {
            return processedModulePath.get(modulePath);
        }
        File rootDirPath = VfsUtilCore.virtualToIoFile((VirtualFile)this.myGradleDslFile.getFile().getParent());
        if (modulePath.equals(":")) {
            processedModulePath.put(modulePath, rootDirPath);
            return rootDirPath;
        }
        String projectKey = "project('" + modulePath + "')";
        ProjectPropertiesDslElement projectProperties = this.myGradleDslFile.getPropertyElement(projectKey, ProjectPropertiesDslElement.class);
        if (projectProperties != null && (projectDir = projectProperties.projectDir()) != null) {
            processedModulePath.put(modulePath, projectDir);
            return projectDir;
        }
        if (modulePath.lastIndexOf(58) == 0) {
            parentDir = rootDirPath;
        } else {
            String parentModule = GradleSettingsModelImpl.parentModuleNoCheck(modulePath);
            if (parentModule == null) {
                processedModulePath.put(modulePath, null);
                return null;
            }
            parentDir = this.moduleDirectoryNoCheck(parentModule, processedModulePath);
        }
        String moduleName = modulePath.substring(modulePath.lastIndexOf(58) + 1);
        File result2 = new File(parentDir, moduleName);
        processedModulePath.put(modulePath, result2);
        return result2;
    }

    @Override
    @Nullable
    public String moduleWithDirectory(@NotNull File moduleDir) {
        HashMap<String, File> processedModulePath = new HashMap<String, File>();
        for (String modulePath : this.modulePaths()) {
            if (!FileUtil.filesEqual((File)moduleDir, (File)this.moduleDirectoryNoCheck(modulePath, processedModulePath))) continue;
            return modulePath;
        }
        return null;
    }

    @Override
    @Nullable
    public GradleBuildModel moduleModel(@NotNull String modulePath) {
        File buildFilePath = this.buildFile(modulePath);
        if (buildFilePath == null) {
            return null;
        }
        VirtualFile buildFile = VfsUtil.findFileByIoFile((File)buildFilePath, (boolean)false);
        if (buildFile == null) {
            return null;
        }
        GradleBuildFile dslFile = this.myGradleDslFile.getContext().getOrCreateBuildFile(buildFile, modulePath.substring(modulePath.lastIndexOf(58) + 1), false);
        return GradleModelFactory.createGradleBuildModel(dslFile);
    }

    @Override
    @Nullable
    public String parentModule(@NotNull String modulePath) {
        modulePath = GradleSettingsModelImpl.standardiseModulePath(modulePath);
        Set<String> allModulePaths = this.modulePaths();
        if (!allModulePaths.contains(modulePath)) {
            return null;
        }
        String currentPath = modulePath;
        do {
            if (!allModulePaths.contains(currentPath = GradleSettingsModelImpl.parentModuleNoCheck(currentPath))) continue;
            return currentPath;
        } while (currentPath != null && !currentPath.equals(":"));
        return null;
    }

    @Nullable
    private static String parentModuleNoCheck(@NotNull String modulePath) {
        if ((modulePath = GradleSettingsModelImpl.standardiseModulePath(modulePath)).equals(":")) {
            return null;
        }
        int lastPathElementIndex = modulePath.lastIndexOf(58);
        return lastPathElementIndex == 0 ? ":" : modulePath.substring(0, lastPathElementIndex);
    }

    @Override
    @Nullable
    public GradleBuildModel getParentModuleModel(@NotNull String modulePath) {
        String parentModule = this.parentModule(modulePath);
        if (parentModule == null) {
            return null;
        }
        return this.moduleModel(parentModule);
    }

    @Override
    @Nullable
    public File buildFile(@NotNull String modulePath) {
        File moduleDirectory = this.moduleDirectory(modulePath);
        if (moduleDirectory == null) {
            return null;
        }
        String buildFileName = null;
        String projectKey = "project('" + modulePath + "')";
        ProjectPropertiesDslElement projectProperties = this.myGradleDslFile.getPropertyElement(projectKey, ProjectPropertiesDslElement.class);
        if (projectProperties != null) {
            buildFileName = projectProperties.getLiteral("buildFileName", String.class);
        }
        if (buildFileName == null) {
            return BuildScriptUtil.findGradleBuildFile(moduleDirectory);
        }
        return new File(moduleDirectory, buildFileName);
    }

    private static String standardiseModulePath(@NotNull String modulePath) {
        return modulePath.startsWith(":") ? modulePath : ":" + modulePath;
    }

    @Override
    @NotNull
    public DependencyResolutionManagementModel dependencyResolutionManagement() {
        DependencyResolutionManagementDslElement dependencyResolutionManagementElement = this.myGradleDslFile.ensurePropertyElement(DependencyResolutionManagementDslElement.DEPENDENCY_RESOLUTION_MANAGEMENT);
        return new DependencyResolutionManagementModelImpl(dependencyResolutionManagementElement);
    }

    @Override
    @NotNull
    public PluginManagementModel pluginManagement() {
        PluginManagementDslElement pluginManagementDslElement = this.myGradleDslFile.ensurePropertyElementAt(PluginManagementDslElement.PLUGIN_MANAGEMENT_DSL_ELEMENT, 0);
        return new PluginManagementModelImpl(pluginManagementDslElement);
    }

    @Override
    @NotNull
    public PluginsBlockModel plugins() {
        PluginManagementDslElement pluginManagementDslElement = this.myGradleDslFile.getPropertyElement(PluginManagementDslElement.PLUGIN_MANAGEMENT_DSL_ELEMENT);
        Integer at = pluginManagementDslElement == null ? 0 : 1;
        PluginsDslElement pluginsDslElement = this.myGradleDslFile.ensurePropertyElementAt(PluginsDslElement.PLUGINS, at);
        return new PluginsBlockModelImpl(pluginsDslElement);
    }

    private static class ModulePathsCache {
        long committedCount = -1L;
        @NotNull
        LinkedHashSet<String> paths = new LinkedHashSet();

        ModulePathsCache() {
            this.paths.add(":");
        }
    }
}

