/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fonts;

import com.android.ide.common.fonts.FontDetail;
import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.fonts.FontProvider;
import com.android.ide.common.resources.escape.string.StringResourceEscaper;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.fonts.DownloadableFontCacheService;
import com.android.tools.fonts.DownloadableFontCacheServiceImpl;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.fonts.StudioDownloadableFontCacheService;
import com.android.tools.idea.instantapp.InstantApps;
import com.android.tools.idea.model.StudioAndroidModuleInfo;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.projectsystem.ProjectSystemService;
import com.android.tools.module.AndroidModuleInfo;
import com.android.utils.XmlUtils;
import com.intellij.core.CoreBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThrowableRunnable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.intellij.lang.annotations.Language;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontFamilyCreator {
    private static final String PRELOADED_FONTS = "preloaded_fonts";
    private static final String PRELOADED_FONTS_FILE = "preloaded_fonts.xml";
    private static final String FONT_CERTS_FILE = "font_certs.xml";
    private final AndroidFacet myFacet;
    private final Project myProject;
    private final DownloadableFontCacheService myService;

    public FontFamilyCreator(@NotNull AndroidFacet facet) {
        Module module = InstantApps.findBaseFeature(facet);
        this.myFacet = module != null ? AndroidFacet.getInstance((Module)module) : facet;
        this.myProject = facet.getModule().getProject();
        this.myService = StudioDownloadableFontCacheService.getInstance();
    }

    @NotNull
    public String createFontFamily(@NotNull FontDetail font, @NotNull String fontName, boolean downloadable) {
        Project project = this.myFacet.getModule().getProject();
        ThrowableRunnable throwableRunnable = () -> {
            if (downloadable) {
                this.createDownloadableFont(font, fontName);
            } else {
                this.createEmbeddedFont(font, fontName);
            }
        };
        ApplicationManager.getApplication().invokeLater(() -> {
            try {
                WriteCommandAction.writeCommandAction((Project)project).withName("Create new font file").run(throwableRunnable);
            }
            catch (IOException e) {
                ExceptionUtil.rethrowAllAsUnchecked((Throwable)e);
            }
        }, project.getDisposed());
        return "@font/" + fontName;
    }

    private void createDownloadableFont(@NotNull FontDetail font, @NotNull String fontName) throws IOException {
        VirtualFile fontFolder = this.getResourceFolder(ResourceFolderType.FONT);
        String content2 = this.createFontFamilyContent(font);
        this.saveContent(fontFolder, fontName + ".xml", content2.getBytes(StandardCharsets.UTF_8));
        FontProvider provider = font.getFamily().getProvider();
        this.createCertFileIfNeeded(provider);
        this.createOrUpdateFile(PRELOADED_FONTS_FILE, "array", PRELOADED_FONTS, "@font/", fontName, FontFamilyCreator::insertItem);
        this.addPreloadedFontsToManifest();
        FileDocumentManager.getInstance().saveAllDocuments();
    }

    private void createEmbeddedFont(@NotNull FontDetail font, @NotNull String fontName) throws IOException {
        VirtualFile fontFolder = this.getResourceFolder(ResourceFolderType.FONT);
        File cachedFile = this.myService.getCachedFontFile(font);
        if (cachedFile != null && cachedFile.exists()) {
            this.saveContent(fontFolder, fontName + "." + FileUtilRt.getExtension((String)cachedFile.getName()), FileUtil.loadFileBytes((File)cachedFile));
        }
    }

    private void saveContent(@NotNull VirtualFile folder, @NotNull String fileName, byte[] content2) throws IOException {
        folder.createChildData((Object)this, fileName).setBinaryContent(content2);
    }

    @NotNull
    private VirtualFile getResourceFolder(@NotNull ResourceFolderType folderType) throws IOException {
        VirtualFile resourceDirectory = ResourceFolderManager.getInstance(this.myFacet).getPrimaryFolder();
        if (resourceDirectory == null && (resourceDirectory = this.createResourceFolder()) == null) {
            throw new IOException("PrimaryResourceDirectory is null");
        }
        VirtualFile fontFolder = resourceDirectory.findChild(folderType.getName());
        if (fontFolder == null) {
            fontFolder = resourceDirectory.createChildDirectory((Object)this, folderType.getName());
        }
        return fontFolder;
    }

    @Nullable
    private VirtualFile createResourceFolder() {
        NamedModuleTemplate template = ProjectSystemService.getInstance(this.myFacet.getModule().getProject()).getProjectSystem().getModuleSystem(this.myFacet.getModule()).getModuleTemplates(null).stream().findFirst().orElse(null);
        if (template == null) {
            return null;
        }
        File resDir = template.getPaths().getResDirectories().stream().findFirst().orElse(null);
        if (resDir == null) {
            return null;
        }
        try {
            return VfsUtil.createDirectories((String)VfsUtilCore.urlToPath((String)resDir.getAbsolutePath()));
        }
        catch (IOException ex) {
            Logger.getInstance(FontFamilyCreator.class).warn((Throwable)ex);
            return null;
        }
    }

    public static String getFontName(@NotNull FontDetail font) {
        Object name2 = font.getFamily().getName();
        String styleName = StringUtil.trimStart((String)font.getStyleName(), (String)"Regular").trim();
        if (!styleName.isEmpty()) {
            name2 = (String)name2 + " " + styleName;
        }
        return DownloadableFontCacheServiceImpl.convertNameToFilename((String)name2);
    }

    @NotNull
    @Language(value="XML")
    private String createFontFamilyContent(@NotNull FontDetail font) {
        FontFamily family = font.getFamily();
        FontProvider provider = family.getProvider();
        AndroidModuleInfo info = StudioAndroidModuleInfo.getInstance(this.myFacet);
        AndroidVersion minSdkVersion2 = info.getMinSdkVersion();
        if (minSdkVersion2.getApiLevel() >= 28) {
            return String.format("<?xml version=\"1.0\" encoding=\"utf-8\"?>%n<font-family xmlns:android=\"http://schemas.android.com/apk/res/android\"%n        android:fontProviderAuthority=\"" + FontFamilyCreator.escapeXmlValue(provider.getAuthority()) + "\"%n        android:fontProviderPackage=\"" + FontFamilyCreator.escapeXmlValue(provider.getPackageName()) + "\"%n        android:fontProviderQuery=\"" + FontFamilyCreator.escapeXmlValue(font.generateQueryV12()) + "\"%n        android:fontProviderCerts=\"@array/" + FontFamilyCreator.escapeXmlValue(provider.getCertificateResourceName()) + "\">%n</font-family>%n", new Object[0]);
        }
        return String.format("<?xml version=\"1.0\" encoding=\"utf-8\"?>%n<font-family xmlns:app=\"http://schemas.android.com/apk/res-auto\"%n        app:fontProviderAuthority=\"" + FontFamilyCreator.escapeXmlValue(provider.getAuthority()) + "\"%n        app:fontProviderPackage=\"" + FontFamilyCreator.escapeXmlValue(provider.getPackageName()) + "\"%n        app:fontProviderQuery=\"" + FontFamilyCreator.escapeXmlValue(font.generateQueryV12()) + "\"%n        app:fontProviderCerts=\"@array/" + FontFamilyCreator.escapeXmlValue(provider.getCertificateResourceName()) + "\">%n</font-family>%n", new Object[0]);
    }

    @NotNull
    @Language(value="XML")
    private static String createValuesFileContent(@NotNull String tag, @NotNull String name2, @NotNull String prefix, @NotNull String value2) {
        return String.format("<?xml version=\"1.0\" encoding=\"utf-8\"?>%n<resources>%n    <" + tag + " name=\"" + FontFamilyCreator.escapeXmlValue(name2) + "\" translatable=\"false\">%n        <item>" + prefix + StringResourceEscaper.escape((String)value2, (boolean)true) + "</item>%n    </" + tag + ">%n</resources>%n", new Object[0]);
    }

    @NotNull
    @Language(value="XML")
    private static String createCertificateFileContent(@NotNull FontProvider provider) {
        String certName = FontFamilyCreator.escapeXmlValue(provider.getCertificateResourceName());
        return String.format("<?xml version=\"1.0\" encoding=\"utf-8\"?>%n<resources>%n    <array name=\"" + certName + "\">%n        <item>@array/" + certName + "_dev</item>%n        <item>@array/" + certName + "_prod</item>%n    </array>%n    <string-array name=\"" + certName + "_dev\">%n        <item>%n            " + provider.getDevelopmentCertificate() + "%n        </item>%n    </string-array>%n    <string-array name=\"" + certName + "_prod\">%n        <item>%n            " + provider.getCertificate() + "%n        </item>%n    </string-array>%n</resources>%n", new Object[0]);
    }

    private void createOrUpdateFile(@NotNull String fileName, @NotNull String tagName, @NotNull String name2, @NotNull String prefix, @NotNull String value2, @NotNull XmlTagUpdater updater) throws IOException {
        VirtualFile valuesFolder = this.getResourceFolder(ResourceFolderType.VALUES);
        VirtualFile file = valuesFolder.findChild(fileName);
        if (file == null) {
            String content2 = FontFamilyCreator.createValuesFileContent(tagName, name2, prefix, value2);
            this.saveContent(valuesFolder, fileName, content2.getBytes(StandardCharsets.UTF_8));
        } else {
            XmlTag newTag;
            XmlFile xmlFile;
            XmlTag rootTag;
            PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely((Project)this.myProject, (VirtualFile)file);
            if (psiFile instanceof XmlFile && (rootTag = (xmlFile = (XmlFile)psiFile).getRootTag()) != null && (newTag = FontFamilyCreator.updateFile(rootTag, tagName, name2, prefix, value2, tag -> tag.getAttributeValue("name"), updater)) != null) {
                CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)rootTag);
            }
        }
    }

    private void createCertFileIfNeeded(@NotNull FontProvider provider) throws IOException {
        VirtualFile valuesFolder = this.getResourceFolder(ResourceFolderType.VALUES);
        VirtualFile file = valuesFolder.findChild(FONT_CERTS_FILE);
        if (file == null) {
            String content2 = FontFamilyCreator.createCertificateFileContent(provider);
            this.saveContent(valuesFolder, FONT_CERTS_FILE, content2.getBytes(StandardCharsets.UTF_8));
        }
    }

    private void addPreloadedFontsToManifest() {
        Manifest manifest = Manifest.getMainManifest(this.myFacet);
        if (manifest == null) {
            return;
        }
        XmlTag manifestTag = manifest.getXmlTag();
        if (manifestTag == null) {
            return;
        }
        XmlTag applicationTag = manifestTag.findFirstSubTag("application");
        if (applicationTag == null) {
            return;
        }
        XmlTag newTag = null;
        try {
            newTag = FontFamilyCreator.updateFile(applicationTag, "meta-data", PRELOADED_FONTS, "@array/", PRELOADED_FONTS, tag -> tag.getAttributeValue("name", "http://schemas.android.com/apk/res/android"), FontFamilyCreator::setMetaDataAttributes);
        }
        catch (IncorrectOperationException e) {
            String readOnlyErrorMessage = CoreBundle.message((String)"cannot.modify.a.read.only.file", (Object[])new Object[]{""}).split("'")[0];
            if (e.getMessage().startsWith(readOnlyErrorMessage)) {
                throw new UpdateManifestFileException("Could not add preloaded fonts to read-only manifest file. Please reference the font file manually from Android manifest", e);
            }
            throw e;
        }
        if (newTag != null) {
            CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)newTag);
        }
    }

    @Nullable
    private static XmlTag updateFile(@NotNull XmlTag parent, @NotNull String tagName, @NotNull String name2, @NotNull String prefix, @NotNull String value2, @NotNull Function<XmlTag, String> nameAttributeGetter, @NotNull XmlTagUpdater updater) {
        XmlTag before = null;
        XmlTag last = null;
        for (XmlTag tag : parent.getSubTags()) {
            if (!tag.getName().equals(tagName)) continue;
            last = tag;
            String nameAttribute = nameAttributeGetter.apply(tag);
            if (nameAttribute == null || nameAttribute.compareTo(name2) < 0) continue;
            if (nameAttribute.equals(name2)) {
                return updater.update(tag, prefix, value2);
            }
            before = tag;
        }
        XmlTag newTag = parent.createChildTag(tagName, "", null, false);
        if (newTag == null) {
            return null;
        }
        newTag = before != null ? (XmlTag)parent.addBefore((PsiElement)newTag, before) : (last != null ? (XmlTag)parent.addAfter((PsiElement)newTag, (PsiElement)last) : parent.addSubTag(newTag, false));
        updater.update(newTag, prefix, value2);
        return newTag;
    }

    @Nullable
    private static XmlTag insertItem(@NotNull XmlTag parent, @NotNull String prefix, @NotNull String newValue) {
        XmlTag before = null;
        for (XmlTag tag : parent.getSubTags()) {
            if (!tag.getName().equals("item")) continue;
            String value2 = tag.getValue().getText();
            int compare = value2.compareTo(prefix + newValue);
            if (compare == 0) {
                return null;
            }
            if (compare <= 0) continue;
            before = tag;
            break;
        }
        XmlTag newTag = parent.createChildTag("item", "", prefix + StringResourceEscaper.escape((String)newValue, (boolean)true), false);
        if (before != null) {
            parent.addBefore((PsiElement)newTag, before);
        } else {
            parent.addSubTag(newTag, false);
        }
        return newTag;
    }

    private static XmlTag setMetaDataAttributes(@NotNull XmlTag tag, @NotNull String prefix, @NotNull String newValue) {
        tag.setAttribute("name", "http://schemas.android.com/apk/res/android", PRELOADED_FONTS);
        tag.setAttribute("resource", "http://schemas.android.com/apk/res/android", prefix + FontFamilyCreator.escapeXmlValue(newValue));
        return tag;
    }

    @NotNull
    private static String escapeXmlValue(@NotNull String value2) {
        return XmlUtils.toXmlAttributeValue((String)value2);
    }

    private static interface XmlTagUpdater {
        public XmlTag update(@NotNull XmlTag var1, @NotNull String var2, @NotNull String var3);
    }

    public class UpdateManifestFileException
    extends IncorrectOperationException {
        public UpdateManifestFileException(String message, Throwable t) {
            super(message, t);
        }
    }
}

