/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.folding;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.folding.AndroidFoldingSettings;
import com.android.tools.idea.folding.InlinedResource;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceFoldingBuilder
extends FoldingBuilderEx {
    private static final String ANDROID_RESOURCE_INT = "android.annotation.ResourceInt";
    private static final boolean ONLY_FOLD_ANNOTATED_METHODS = false;
    private static final boolean UNIT_TEST_MODE = ApplicationManager.getApplication().isUnitTestMode();

    private static boolean isFoldingEnabled() {
        return AndroidFoldingSettings.getInstance().isCollapseAndroidStrings();
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        return ResourceFoldingBuilder.isFoldingEnabled();
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        String foldLabel;
        InlinedResource string;
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi((ASTNode)node);
        if (element != null && (string = ResourceFoldingBuilder.getResolvedString(element)) != null && (foldLabel = string.getResolvedString()) != null) {
            return foldLabel;
        }
        return element != null ? element.getText() : node.getText();
    }

    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement element, @NotNull Document document, boolean quick) {
        if (!(element instanceof PsiJavaFile) && !(element instanceof XmlFile) || quick && !UNIT_TEST_MODE || !ResourceFoldingBuilder.isFoldingEnabled()) {
            return FoldingDescriptor.EMPTY_ARRAY;
        }
        final ArrayList result2 = new ArrayList();
        if (element instanceof PsiJavaFile) {
            PsiJavaFile file = (PsiJavaFile)element;
            file.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                    InlinedResource inlinedResource = ResourceFoldingBuilder.findJavaExpressionReference(expression);
                    if (inlinedResource != null) {
                        result2.add(inlinedResource.getDescriptor());
                    }
                    super.visitReferenceExpression(expression);
                }
            });
        } else {
            XmlFile file = (XmlFile)element;
            file.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                public void visitXmlAttributeValue(@NotNull XmlAttributeValue value2) {
                    InlinedResource inlinedResource = ResourceFoldingBuilder.findXmlValueReference(value2);
                    if (inlinedResource != null) {
                        FoldingDescriptor descriptor2 = inlinedResource.getDescriptor();
                        result2.add(descriptor2);
                    }
                    super.visitXmlAttributeValue(value2);
                }
            });
        }
        return result2.toArray(FoldingDescriptor.EMPTY_ARRAY);
    }

    @Nullable
    private static InlinedResource getResolvedString(PsiElement element) {
        if (element instanceof PsiReferenceExpression) {
            return ResourceFoldingBuilder.findJavaExpressionReference((PsiReferenceExpression)element);
        }
        if (element instanceof XmlAttributeValue) {
            return ResourceFoldingBuilder.findXmlValueReference((XmlAttributeValue)element);
        }
        if (element instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)element;
            for (PsiExpression expression : call.getArgumentList().getExpressions()) {
                InlinedResource string;
                if (!(expression instanceof PsiReferenceExpression) || (string = ResourceFoldingBuilder.findJavaExpressionReference((PsiReferenceExpression)expression)) == null) continue;
                return string;
            }
        }
        return null;
    }

    @Nullable
    private static InlinedResource findXmlValueReference(XmlAttributeValue element) {
        ResourceReference resourceReference;
        String value2 = element.getValue();
        ResourceUrl resourceUrl = ResourceUrl.parse((String)value2);
        if (resourceUrl == null) {
            return null;
        }
        if ((resourceUrl.type.equals((Object)ResourceType.STRING) || resourceUrl.type.equals((Object)ResourceType.DIMEN) || resourceUrl.type.equals((Object)ResourceType.INTEGER) || resourceUrl.type.equals((Object)ResourceType.BOOL)) && (resourceReference = IdeResourcesUtil.resolve(resourceUrl, (XmlElement)element)) != null) {
            return ResourceFoldingBuilder.createdInlinedResource(resourceReference, (PsiElement)element);
        }
        return null;
    }

    @Nullable
    private static InlinedResource findJavaExpressionReference(PsiReferenceExpression expression) {
        PsiElement call;
        AndroidPsiUtils.ResourceReferenceType referenceType = AndroidPsiUtils.getResourceReferenceType((PsiReferenceExpression)expression);
        if (referenceType != AndroidPsiUtils.ResourceReferenceType.APP) {
            return null;
        }
        ResourceType type = AndroidPsiUtils.getResourceType((PsiElement)expression);
        if (type != ResourceType.STRING && type != ResourceType.DIMEN && type != ResourceType.INTEGER && type != ResourceType.PLURALS) {
            return null;
        }
        PsiElement parameterList = expression.getParent();
        String name2 = AndroidPsiUtils.getResourceName((PsiElement)expression);
        if (parameterList instanceof PsiExpressionList && (call = parameterList.getParent()) instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)call;
            PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (methodName != null && (methodName.equals("getString") || methodName.equals("getText") || methodName.equals("getInteger") || methodName.startsWith("getDimension") || methodName.startsWith("getQuantityString"))) {
                ResourceReference reference = new ResourceReference(ResourceNamespace.RES_AUTO, type, name2);
                return ResourceFoldingBuilder.createdInlinedResource(reference, (PsiElement)callExpression);
            }
            if (!UNIT_TEST_MODE) {
                // empty if block
            }
        }
        ResourceReference reference = new ResourceReference(ResourceNamespace.RES_AUTO, type, name2);
        return ResourceFoldingBuilder.createdInlinedResource(reference, (PsiElement)expression);
    }

    @Nullable
    private static InlinedResource createdInlinedResource(@NotNull ResourceReference resourceReference, @NotNull PsiElement foldElement) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)foldElement);
        if (module == null) {
            return null;
        }
        ASTNode node = foldElement.getNode();
        if (node != null) {
            TextRange textRange = foldElement.getTextRange();
            FoldingDescriptor descriptor2 = new FoldingDescriptor(node, textRange, null);
            StudioResourceRepositoryManager repositoryManager = StudioResourceRepositoryManager.getInstance(module);
            if (repositoryManager == null) {
                return null;
            }
            ResourceRepository resourceRepository = repositoryManager.getResourcesForNamespace(resourceReference.getNamespace());
            if (resourceRepository == null) {
                return null;
            }
            if (resourceRepository.hasResources(resourceReference.getNamespace(), resourceReference.getResourceType(), resourceReference.getName())) {
                return new InlinedResource(resourceReference, resourceRepository, descriptor2, foldElement);
            }
        }
        return null;
    }

    public static boolean allowsResourceType(@NotNull ResourceType type, @Nullable PsiModifierListOwner owner) {
        if (owner == null) {
            return false;
        }
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])new String[]{ANDROID_RESOURCE_INT});
        Boolean allowed = ResourceFoldingBuilder.allowsResourceType(type, annotation);
        return allowed != null && allowed != false;
    }

    @Nullable
    public static Boolean allowsResourceType(@NotNull ResourceType type, @Nullable PsiAnnotation annotation) {
        if (annotation == null) {
            return null;
        }
        assert (ANDROID_RESOURCE_INT.equals(annotation.getQualifiedName()));
        PsiAnnotationParameterList annotationParameters = annotation.getParameterList();
        for (PsiNameValuePair pair : annotationParameters.getAttributes()) {
            PsiAnnotationMemberValue value2 = pair.getValue();
            if (value2 instanceof PsiReferenceExpression) {
                PsiReferenceExpression expression = (PsiReferenceExpression)value2;
                return ResourceFoldingBuilder.allowsResourceType(type, expression);
            }
            if (!(value2 instanceof PsiArrayInitializerMemberValue)) continue;
            PsiArrayInitializerMemberValue mv = (PsiArrayInitializerMemberValue)value2;
            for (PsiAnnotationMemberValue v : mv.getInitializers()) {
                if (!(v instanceof PsiReferenceExpression)) continue;
                return ResourceFoldingBuilder.allowsResourceType(type, (PsiReferenceExpression)v);
            }
        }
        return null;
    }

    private static Boolean allowsResourceType(ResourceType type, PsiReferenceExpression v) {
        String name2 = v.getText();
        if (name2.equals("all")) {
            return true;
        }
        if (name2.equals("none")) {
            return false;
        }
        return type.getName().equalsIgnoreCase(name2);
    }
}

