/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.repository.GoogleMavenArtifactId;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceRepositoryUtil;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourceValueMap;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.configurations.Configuration;
import com.android.tools.configurations.ConfigurationModelModule;
import com.android.tools.configurations.ResourceResolverCache;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.res.AndroidDependenciesCache;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.res.CacheableResourceRepository;
import com.android.tools.res.ResourceNamespacing;
import com.android.tools.res.ResourceRepositoryManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeResolver {
    private static final StyleResourceValue[] NO_BASE_THEMES = new StyleResourceValue[0];
    private final Map<ResourceReference, ConfiguredThemeEditorStyle> myThemesByStyle = new HashMap<ResourceReference, ConfiguredThemeEditorStyle>();
    private final ImmutableList<ConfiguredThemeEditorStyle> myFrameworkThemes;
    private final ImmutableList<ConfiguredThemeEditorStyle> myLocalThemes;
    private final ImmutableList<ConfiguredThemeEditorStyle> myExternalLibraryThemes;
    private final Configuration myConfiguration;
    private final ResourceResolver myResolver;
    private List<ResourceReference> myRecommendedThemes;

    public ThemeResolver(@NotNull Configuration configuration2) {
        this.myConfiguration = configuration2;
        ResourceRepositoryManager repositoryManager = configuration2.getConfigModule().getResourceRepositoryManager();
        if (repositoryManager == null) {
            throw new IllegalArgumentException("\"" + configuration2.getConfigModule().getName() + "\" is not an Android module");
        }
        this.myResolver = configuration2.getResourceResolver();
        if (this.myResolver == null) {
            throw new IllegalArgumentException("Acquired ResourceResolver is null, not an Android module?");
        }
        this.myFrameworkThemes = this.fillThemeResolverFromStyles(this.resolveFrameworkThemes());
        ImmutableList.Builder localThemes = ImmutableList.builder();
        for (Pair<StyleResourceValue, Module> pair : this.resolveLocallyDefinedModuleThemes()) {
            ConfiguredThemeEditorStyle theme = this.constructThemeFromResourceValue((StyleResourceValue)pair.getFirst());
            if (theme == null) continue;
            localThemes.add((Object)theme);
        }
        this.myLocalThemes = localThemes.build();
        this.myExternalLibraryThemes = this.fillThemeResolverFromStyles(this.resolveNonFrameworkThemes());
    }

    @Nullable
    private ConfiguredThemeEditorStyle constructThemeFromResourceValue(@NotNull StyleResourceValue value2) {
        ResourceReference styleReference = value2.asReference();
        if (this.myThemesByStyle.containsKey(styleReference)) {
            return null;
        }
        ConfiguredThemeEditorStyle theme = ResolutionUtils.getThemeEditorStyle(this.myConfiguration, styleReference);
        if (theme != null) {
            this.myThemesByStyle.put(styleReference, theme);
        }
        return theme;
    }

    private ImmutableList<ConfiguredThemeEditorStyle> fillThemeResolverFromStyles(@NotNull List<StyleResourceValue> source2) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (StyleResourceValue value2 : source2) {
            ConfiguredThemeEditorStyle theme = this.constructThemeFromResourceValue(value2);
            if (theme == null) continue;
            builder.add((Object)theme);
        }
        return builder.build();
    }

    @Slow
    @NotNull
    private List<StyleResourceValue> resolveFrameworkThemes() {
        ResourceResolverCache resolverCache = this.myConfiguration.getSettings().getResolverCache();
        IAndroidTarget target2 = this.myConfiguration.getTarget();
        if (target2 == null) {
            return Collections.emptyList();
        }
        Map<ResourceType, ResourceValueMap> resources = resolverCache.getConfiguredFrameworkResources(target2, this.myConfiguration.getFullConfig(), this.myConfiguration.getOverlays());
        ResourceValueMap styles = resources.get(ResourceType.STYLE);
        return ThemeResolver.getFrameworkThemes(styles);
    }

    @NotNull
    private List<StyleResourceValue> resolveNonFrameworkThemes() {
        ResourceRepositoryManager repositoryManager = this.myConfiguration.getConfigModule().getResourceRepositoryManager();
        if (repositoryManager == null) {
            return Collections.emptyList();
        }
        CacheableResourceRepository repository2 = repositoryManager.getAppResources();
        ResourceValueMap configuredResources = ResourceRepositoryUtil.getConfiguredResources((ResourceRepository)repository2, (ResourceNamespace)repositoryManager.getNamespace(), (ResourceType)ResourceType.STYLE, (FolderConfiguration)this.myConfiguration.getFullConfig());
        return this.getNonFrameworkThemes(configuredResources);
    }

    @NotNull
    private List<Pair<StyleResourceValue, Module>> resolveLocallyDefinedModuleThemes() {
        Module module = ConfigurationManager.getFromConfiguration(this.myConfiguration).getModule();
        ConfigurationModelModule configModule = this.myConfiguration.getConfigModule();
        ArrayList<Pair<StyleResourceValue, Module>> result2 = new ArrayList<Pair<StyleResourceValue, Module>>();
        this.fillModuleResources(module, configModule.getResourceRepositoryManager().getModuleResources(), result2);
        List<AndroidFacet> allAndroidDependencies = AndroidDependenciesCache.getAllAndroidDependencies(module, false);
        for (AndroidFacet facet : allAndroidDependencies) {
            this.fillModuleResources(facet.getModule(), StudioResourceRepositoryManager.getModuleResources(facet), result2);
        }
        return result2;
    }

    private void fillModuleResources(@NotNull Module module, @Nullable ResourceRepository repository2, @NotNull List<Pair<StyleResourceValue, Module>> sink) {
        if (repository2 == null) {
            return;
        }
        ResourceNamespace namespace = ((SingleNamespaceResourceRepository)repository2).getNamespace();
        ResourceValueMap configuredResources = ResourceRepositoryUtil.getConfiguredResources((ResourceRepository)repository2, (ResourceNamespace)namespace, (ResourceType)ResourceType.STYLE, (FolderConfiguration)this.myConfiguration.getFullConfig());
        for (StyleResourceValue value2 : this.getNonFrameworkThemes(configuredResources)) {
            sink.add((Pair<StyleResourceValue, Module>)Pair.create((Object)value2, (Object)module));
        }
    }

    @NotNull
    private List<StyleResourceValue> getNonFrameworkThemes(@NotNull ResourceValueMap styles) {
        Collection values = styles.values();
        ArrayList<StyleResourceValue> themes = new ArrayList<StyleResourceValue>(values.size());
        HashMap cache = Maps.newHashMapWithExpectedSize((int)values.size());
        for (ResourceValue value2 : values) {
            StyleResourceValue styleValue;
            if (!(value2 instanceof StyleResourceValue) || !this.myResolver.isTheme((ResourceValue)(styleValue = (StyleResourceValue)value2), (Map)cache)) continue;
            themes.add(styleValue);
        }
        return themes;
    }

    @NotNull
    private static List<StyleResourceValue> getFrameworkThemes(@NotNull ResourceValueMap styles) {
        Collection values = styles.values();
        ArrayList<StyleResourceValue> themes = new ArrayList<StyleResourceValue>(values.size());
        for (ResourceValue value2 : values) {
            String name2 = value2.getName();
            if (!name2.startsWith("Theme.") && !name2.equals("Theme")) continue;
            themes.add((StyleResourceValue)value2);
        }
        return themes;
    }

    @Deprecated
    @Nullable
    public ConfiguredThemeEditorStyle getTheme(@NotNull String themeName) {
        ResourceReference styleReference = ResolutionUtils.getStyleReference(themeName);
        return this.myThemesByStyle.get(styleReference);
    }

    @Nullable
    public ConfiguredThemeEditorStyle getTheme(@NotNull ResourceReference styleReference) {
        assert (styleReference.getResourceType() == ResourceType.STYLE);
        return this.myThemesByStyle.get(styleReference);
    }

    @NotNull
    public ImmutableList<ConfiguredThemeEditorStyle> getLocalThemes() {
        return this.myLocalThemes;
    }

    @NotNull
    public ImmutableList<ConfiguredThemeEditorStyle> getExternalLibraryThemes() {
        return this.myExternalLibraryThemes;
    }

    @NotNull
    public ImmutableList<ConfiguredThemeEditorStyle> getFrameworkThemes() {
        return this.myFrameworkThemes;
    }

    public int getThemesCount() {
        return this.myFrameworkThemes.size() + this.myExternalLibraryThemes.size() + this.myLocalThemes.size();
    }

    @NotNull
    public List<ResourceReference> getRecommendedThemes() {
        if (this.myRecommendedThemes == null) {
            this.myRecommendedThemes = ThemeResolver.computeRecommendedThemes(this.myConfiguration.getConfigModule());
        }
        return this.myRecommendedThemes;
    }

    @NotNull
    public StyleResourceValue[] requiredBaseThemes() {
        ConfigurationModelModule module = this.myConfiguration.getConfigModule();
        if (!module.getDependencies().dependsOn(GoogleMavenArtifactId.SUPPORT_DESIGN) && !module.getDependencies().dependsOn(GoogleMavenArtifactId.MATERIAL)) {
            return NO_BASE_THEMES;
        }
        ResourceNamespace namespace = ThemeResolver.getAppCompatNamespace(module);
        if (namespace == null) {
            return NO_BASE_THEMES;
        }
        StyleResourceValue theme1 = this.findTheme(namespace, "Platform.AppCompat");
        StyleResourceValue theme2 = this.findTheme(namespace, "Platform.AppCompat.Light");
        if (theme1 == null || theme2 == null) {
            return NO_BASE_THEMES;
        }
        return new StyleResourceValue[]{theme1, theme2};
    }

    public boolean themeIsChildOfAny(@NotNull StyleResourceValue childTheme, StyleResourceValue ... parentThemes) {
        return this.myResolver.themeIsChildOfAny(childTheme, parentThemes);
    }

    private StyleResourceValue findTheme(@NotNull ResourceNamespace namespace, @NotNull String themeName) {
        ResourceReference reference = ResourceReference.style((ResourceNamespace)namespace, (String)themeName);
        return this.myResolver.getStyle(reference);
    }

    @Nullable
    private static ResourceNamespace getAppCompatNamespace(@NotNull ConfigurationModelModule module) {
        if (module.getDependencies().dependsOn(GoogleMavenArtifactId.ANDROIDX_APPCOMPAT)) {
            return ThemeResolver.isNamespacingEnabled(module) ? ResourceNamespace.APPCOMPAT : ResourceNamespace.RES_AUTO;
        }
        if (module.getDependencies().dependsOn(GoogleMavenArtifactId.SUPPORT_APPCOMPAT_V7)) {
            return ThemeResolver.isNamespacingEnabled(module) ? ResourceNamespace.APPCOMPAT_LEGACY : ResourceNamespace.RES_AUTO;
        }
        return null;
    }

    @NotNull
    private static List<ResourceReference> computeRecommendedThemes(@NotNull ConfigurationModelModule module) {
        ResourceNamespace appcompatNamespace = ThemeResolver.getAppCompatNamespace(module);
        if (appcompatNamespace == null) {
            return ImmutableList.of((Object)ResourceReference.style((ResourceNamespace)ResourceNamespace.ANDROID, (String)"Theme.Material.Light.NoActionBar"), (Object)ResourceReference.style((ResourceNamespace)ResourceNamespace.ANDROID, (String)"Theme.Material.NoActionBar"));
        }
        return ImmutableList.of((Object)ResourceReference.style((ResourceNamespace)ResourceNamespace.ANDROID, (String)"Theme.Material.Light.NoActionBar"), (Object)ResourceReference.style((ResourceNamespace)ResourceNamespace.ANDROID, (String)"Theme.Material.NoActionBar"), (Object)ResourceReference.style((ResourceNamespace)appcompatNamespace, (String)"Theme.AppCompat.Light.NoActionBar"), (Object)ResourceReference.style((ResourceNamespace)appcompatNamespace, (String)"Theme.AppCompat.NoActionBar"));
    }

    private static boolean isNamespacingEnabled(@NotNull ConfigurationModelModule module) {
        ResourceRepositoryManager repositoryManager = module.getResourceRepositoryManager();
        return repositoryManager != null && repositoryManager.getNamespacing() == ResourceNamespacing.REQUIRED;
    }
}

