/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.manifest;

import com.android.annotations.concurrency.UiThread;
import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.util.PathString;
import com.android.manifmerger.Actions;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlNode;
import com.android.projectmodel.ExternalAndroidLibrary;
import com.android.tools.adtui.workbench.WorkBenchLoadingPanel;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.analytics.UsageTrackerUtils;
import com.android.tools.idea.editors.manifest.AnnotationColors;
import com.android.tools.idea.editors.manifest.InjectedFile;
import com.android.tools.idea.editors.manifest.ManifestFileWithMetadata;
import com.android.tools.idea.editors.manifest.ManifestPanelToken;
import com.android.tools.idea.editors.manifest.ManifestUtils;
import com.android.tools.idea.editors.manifest.ManifestXmlType;
import com.android.tools.idea.editors.manifest.ManifestXmlWithMetadata;
import com.android.tools.idea.editors.manifest.UnknownManifestFile;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.DependencyScopeType;
import com.android.tools.idea.projectsystem.NamedIdeaSourceProvider;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.SourceProviderManager;
import com.android.utils.FileUtils;
import com.android.utils.HtmlBuilder;
import com.android.utils.PositionXmlParser;
import com.android.utils.SdkUtils;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.icons.AllIcons;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.tree.TreeUtil;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import kotlin.jvm.functions.Function1;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@UiThread
public class ManifestPanel
extends JPanel
implements TreeSelectionListener {
    private static final String SUGGESTION_MARKER = "Suggestion: ";
    private static final Pattern ADD_SUGGESTION_FORMAT = Pattern.compile(".*? 'tools:([\\w:]+)=\"([\\w:]+)\"' to \\<(\\w+)\\> element at (.+) to override\\.", 32);
    private static final Pattern FILE_POSITION_FORMAT = Pattern.compile("[^:]+:(\\d+):(\\d+)-[\\d:]+", 32);
    private static final Pattern NAV_FILE_PATTERN = Pattern.compile(".*/res/.*navigation(-[^/]*)?/[^/]*$");
    private final AndroidFacet myFacet;
    @NotNull
    private final Project myProject;
    @NotNull
    private final AndroidProjectSystem myProjectSystem;
    @Nullable
    private final ManifestPanelToken<AndroidProjectSystem> myToken;
    private final Font myDefaultFont;
    private final Tree myTree;
    private final JEditorPane myDetails;
    private final WorkBenchLoadingPanel myLoadingPanel;
    private final JBSplitter mySplitter;
    private JPopupMenu myPopup;
    private JMenuItem myRemoveItem;
    private MergedManifestSnapshot myManifest;
    private boolean myManifestEditable;
    private final List<ManifestFileWithMetadata> myFiles = new ArrayList<ManifestFileWithMetadata>();
    private final List<ManifestFileWithMetadata> myOtherFiles = new ArrayList<ManifestFileWithMetadata>();
    private final HtmlLinkManager myHtmlLinkManager = new HtmlLinkManager();
    private VirtualFile myFile;
    private final JBColor myBackgroundColor;
    private Map<PathString, ExternalAndroidLibrary> myLibrariesByManifestDir;

    public ManifestPanel(@NotNull AndroidFacet facet, @NotNull Disposable parent) {
        this.myFacet = facet;
        this.myProject = this.myFacet.getModule().getProject();
        this.myProjectSystem = ProjectSystemUtil.getProjectSystem(this.myProject);
        this.myToken = ManifestPanelToken.EP_NAME.getExtensionList().stream().filter(it -> it.isApplicable(this.myProjectSystem)).findFirst().orElse(null);
        this.setLayout(new BorderLayout());
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        EditorColorsScheme scheme = colorsManager.getGlobalScheme();
        this.myBackgroundColor = JBColor.lazy(() -> colorsManager.getGlobalScheme().getDefaultBackground());
        this.myDefaultFont = scheme.getFont(EditorFontType.PLAIN);
        this.myTree = new FileColorTree();
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new SyntaxHighlightingCellRenderer()));
        TreeSelectionModel selectionModel = this.myTree.getSelectionModel();
        selectionModel.setSelectionMode(1);
        selectionModel.addTreeSelectionListener(this);
        this.myDetails = this.createDetailsPane(facet);
        this.addSpeedSearch();
        this.createPopupMenu();
        this.registerGotoAction();
        this.mySplitter = new JBSplitter(0.5f);
        this.mySplitter.setFirstComponent((JComponent)new JBScrollPane((Component)this.myTree));
        this.mySplitter.setSecondComponent((JComponent)new JBScrollPane((Component)this.myDetails));
        this.myLoadingPanel = new WorkBenchLoadingPanel((LayoutManager)new BorderLayout(), parent, 0);
        this.myLoadingPanel.add((Component)this.mySplitter);
        this.add((Component)this.myLoadingPanel);
    }

    @NotNull
    public JEditorPane getDetailsPane() {
        return this.myDetails;
    }

    @NotNull
    public Tree getTree() {
        return this.myTree;
    }

    private JEditorPane createDetailsPane(@NotNull AndroidFacet facet) {
        JEditorPane details = new JEditorPane();
        details.setMargin((Insets)JBUI.insets((int)5));
        details.setEditorKit(HTMLEditorKitBuilder.simple());
        details.setEditable(false);
        details.setFont(this.myDefaultFont);
        details.setBackground((Color)this.myBackgroundColor);
        HyperlinkListener hyperLinkListener = e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String url = e.getDescription();
                this.myHtmlLinkManager.handleUrl(url, facet.getModule(), null);
            }
        };
        details.addHyperlinkListener(hyperLinkListener);
        details.addPropertyChangeListener("UI", event -> {
            Object component;
            TreePath path = this.myTree.getSelectionPath();
            ManifestTreeNode node = null;
            if (path != null && (component = path.getLastPathComponent()) instanceof ManifestTreeNode) {
                node = (ManifestTreeNode)component;
            }
            this.updateDetails(node);
        });
        return details;
    }

    private void createPopupMenu() {
        this.myPopup = new JBPopupMenu();
        JBMenuItem gotoItem = new JBMenuItem("Go to Declaration");
        gotoItem.addActionListener(e -> {
            Object patt10999$temp;
            TreePath treePath = this.myTree.getSelectionPath();
            if (treePath != null && (patt10999$temp = treePath.getLastPathComponent()) instanceof ManifestTreeNode) {
                ManifestTreeNode node = (ManifestTreeNode)patt10999$temp;
                this.goToDeclaration(node.getUserObject());
            }
        });
        this.myPopup.add((JMenuItem)gotoItem);
        this.myRemoveItem = new JBMenuItem("Remove");
        this.myRemoveItem.addActionListener(e -> {
            Object patt11351$temp;
            TreePath treePath = this.myTree.getSelectionPath();
            if (treePath != null && (patt11351$temp = treePath.getLastPathComponent()) instanceof ManifestTreeNode) {
                ManifestTreeNode node = (ManifestTreeNode)patt11351$temp;
                WriteCommandAction.writeCommandAction((Project)this.myFacet.getModule().getProject(), (PsiFile[])new PsiFile[]{ManifestUtils.getMainManifest(this.myFacet)}).withName("Removing manifest tag").run(() -> ManifestUtils.toolsRemove(ManifestUtils.getMainManifest(this.myFacet), node.getUserObject()));
            }
        });
        this.myPopup.add(this.myRemoveItem);
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.handlePopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.handlePopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                ManifestTreeNode node;
                Node attribute2;
                TreePath treePath;
                if (e.getClickCount() == 2 && e.getButton() == 1 && (treePath = ManifestPanel.this.myTree.getPathForLocation(e.getX(), e.getY())) != null && (attribute2 = (node = (ManifestTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof Attr) {
                    ManifestPanel.this.goToDeclaration(attribute2);
                }
            }

            private void handlePopup(@NotNull MouseEvent e) {
                TreePath treePath = ManifestPanel.this.myTree.getPathForLocation(e.getX(), e.getY());
                if (treePath == null || e.getSource() == ManifestPanel.this.myDetails) {
                    treePath = ManifestPanel.this.myTree.getSelectionPath();
                }
                if (treePath != null) {
                    ManifestTreeNode node = (ManifestTreeNode)treePath.getLastPathComponent();
                    ManifestPanel.this.myRemoveItem.setEnabled(ManifestPanel.this.canRemove(node.getUserObject()));
                    JBPopupMenu.showByEvent((MouseEvent)e, (JPopupMenu)ManifestPanel.this.myPopup);
                }
            }
        };
        this.myTree.addMouseListener((MouseListener)ml);
        this.myDetails.addMouseListener(ml);
    }

    private void registerGotoAction() {
        AnAction goToDeclarationAction = new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                ManifestTreeNode node = (ManifestTreeNode)ManifestPanel.this.myTree.getLastSelectedPathComponent();
                if (node != null) {
                    ManifestPanel.this.goToDeclaration(node.getUserObject());
                }
            }
        };
        goToDeclarationAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("GotoDeclaration").getShortcutSet(), (JComponent)this.myTree);
    }

    private void addSpeedSearch() {
        TreeSpeedSearch.installOn((JTree)this.myTree);
    }

    public void startLoading() {
        this.mySplitter.setVisible(false);
        this.myLoadingPanel.setLoadingText("Computing merged manifest...");
        this.myLoadingPanel.startLoading();
    }

    public void showLoadingError() {
        this.myLoadingPanel.abortLoading("Unable to compute merged manifest.", AllIcons.General.Warning);
    }

    public void showManifest(MergedManifestSnapshot manifest, @NotNull VirtualFile selectedManifest, boolean isEditable) {
        this.myManifestEditable = isEditable;
        this.setManifestSnapshot(manifest, selectedManifest);
        this.myLoadingPanel.stopLoading();
        this.mySplitter.setVisible(true);
        this.logManifestPanelEvent();
    }

    private void logManifestPanelEvent() {
        UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.MANIFEST_PANEL_EVENT).setCategory(AndroidStudioEvent.EventCategory.STUDIO_UI), this.myProject));
    }

    private void setManifestSnapshot(@NotNull MergedManifestSnapshot manifest, @NotNull VirtualFile selectedManifest) {
        this.myFile = selectedManifest;
        this.myManifest = manifest;
        this.myLibrariesByManifestDir = Arrays.stream(ModuleManager.getInstance((Project)this.myProject).getModules()).flatMap(module -> ProjectSystemUtil.getModuleSystem(module).getAndroidLibraryDependencies(DependencyScopeType.MAIN).stream().filter(it -> it.getManifestFile() != null)).collect(Collectors.toMap(it -> it.getManifestFile().getParent(), it -> it, (a, b) -> a));
        Document document = this.myManifest.getDocument();
        Element root = document != null ? document.getDocumentElement() : null;
        this.myTree.setModel((TreeModel)(root == null ? null : new DefaultTreeModel(new ManifestTreeNode(root))));
        ArrayList<ManifestFileWithMetadata> sortedFiles = new ArrayList<ManifestFileWithMetadata>();
        ArrayList<ManifestFileWithMetadata> sortedOtherFiles = new ArrayList<ManifestFileWithMetadata>();
        List<VirtualFile> manifestFiles = this.myManifest.getManifestFiles();
        sortedFiles.add(this.createMetadataForFile(this.myFacet, new SourceFilePosition(VfsUtilCore.virtualToIoFile((VirtualFile)selectedManifest), SourcePosition.UNKNOWN)));
        HashSet referenced = Sets.newHashSet();
        if (root != null) {
            this.recordLocationReferences(root, referenced);
        }
        for (VirtualFile f : manifestFiles) {
            if (f.equals(selectedManifest)) continue;
            File file = VfsUtilCore.virtualToIoFile((VirtualFile)f);
            if (referenced.contains(file)) {
                sortedFiles.add(this.createMetadataForFile(this.myFacet, new SourceFilePosition(file, SourcePosition.UNKNOWN)));
                continue;
            }
            sortedOtherFiles.add(this.createMetadataForFile(this.myFacet, new SourceFilePosition(file, SourcePosition.UNKNOWN)));
        }
        if (this.myToken != null) {
            this.myToken.handleReferencedFiles(referenced, sortedFiles, sortedOtherFiles, (Function1<SourceFilePosition, ManifestFileWithMetadata>)((Function1)p -> this.createMetadataForFile(this.myFacet, (SourceFilePosition)p)));
        }
        Collections.sort(sortedFiles);
        Collections.sort(sortedOtherFiles);
        this.myFiles.clear();
        this.myFiles.addAll(sortedFiles);
        this.myOtherFiles.clear();
        this.myOtherFiles.addAll(sortedOtherFiles);
        if (root != null) {
            TreeUtil.expandAll((JTree)this.myTree);
        }
        this.updateDetails(null);
    }

    private void recordLocationReferences(@NotNull Node node, @NotNull Set<File> files2) {
        short type = node.getNodeType();
        if (type == 2) {
            File location;
            Actions.Record record;
            XmlNode.NodeKey targetId;
            List<? extends Actions.Record> records = ManifestUtils.getRecords(this.myManifest, node);
            if (!(records.isEmpty() || !(targetId = (record = records.get(0)).getTargetId()).toString().contains("@") || this.myToken != null && this.myToken.recordLocationReference(record, files2) || (location = record.getActionLocation().getFile().getSourceFile()) == null)) {
                files2.add(location);
            }
        } else if (type == 1) {
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1) continue;
                this.recordLocationReferences(child, files2);
            }
            NamedNodeMap attributes = node.getAttributes();
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                this.recordLocationReferences(attributes.item(i), files2);
            }
        }
    }

    @Override
    public void valueChanged(@Nullable TreeSelectionEvent e) {
        if (e != null && e.isAddedPath()) {
            TreePath treePath = e.getPath();
            ManifestTreeNode node = (ManifestTreeNode)treePath.getLastPathComponent();
            this.updateDetails(node);
        } else {
            this.updateDetails(null);
        }
    }

    private void updateDetails(@Nullable ManifestTreeNode node) {
        Node manifestNode = node != null ? node.getUserObject() : null;
        HtmlBuilder sb = this.prepareHtmlReport(manifestNode);
        this.myDetails.setText(sb.getHtml());
        this.myDetails.setCaretPosition(0);
    }

    @NotNull
    private HtmlBuilder prepareHtmlReport(@Nullable Node node) {
        HtmlBuilder sb = new HtmlBuilder();
        this.prepareReportHeader(sb);
        if (node != null) {
            this.prepareSelectedNodeReport(node, sb);
        } else {
            this.prepareMergingErrorsReportForEverything(sb);
        }
        sb.closeHtmlBody();
        return sb;
    }

    private void prepareMergingErrorsReportForEverything(@NotNull HtmlBuilder sb) {
        List<MergingReport.Record> warnings;
        List<MergingReport.Record> errors = this.myManifest.getLoggingRecords().stream().filter(record -> record.getSeverity().equals((Object)MergingReport.Record.Severity.ERROR)).toList();
        if (!errors.isEmpty()) {
            this.appendMergeRecordTitle(sb, "Merge Errors");
            errors.forEach(record -> this.prepareErrorRecord(sb, (MergingReport.Record)record));
        }
        if (!(warnings = this.myManifest.getLoggingRecords().stream().filter(record -> record.getSeverity().equals((Object)MergingReport.Record.Severity.WARNING)).toList()).isEmpty()) {
            this.appendMergeRecordTitle(sb, "Merge Warnings");
            warnings.forEach(record -> this.prepareErrorRecord(sb, (MergingReport.Record)record));
        }
    }

    private void prepareSelectedNodeReport(@NotNull Node manifestNode, @NotNull HtmlBuilder sb) {
        List<? extends Actions.Record> records = ManifestUtils.getRecords(this.myManifest, manifestNode);
        sb.beginUnderline().beginBold();
        sb.add("Merging Log");
        sb.endBold().endUnderline().newline();
        if (records.isEmpty()) {
            sb.add("No records found. (This is a bug in the manifest merger.)");
        }
        SourceFilePosition prev = null;
        boolean prevInjected = false;
        for (Actions.Record record : records) {
            boolean injected;
            SourceFilePosition location = ManifestUtils.getActionLocation(this.myFacet.getModule(), record);
            if (location.equals(prev)) continue;
            prev = location;
            Actions.ActionType actionType = record.getActionType();
            boolean bl = injected = actionType == Actions.ActionType.INJECTED;
            if (injected && prevInjected) continue;
            prevInjected = injected;
            if (injected) {
                sb.add("Value provided by Gradle");
                sb.newline();
                continue;
            }
            sb.add(StringUtil.capitalize((String)StringUtil.toLowerCase((String)String.valueOf(actionType))));
            sb.add(" from the ");
            sb.addHtml(this.getHtml(this.myFacet, location));
            String reason = record.getReason();
            if (reason != null) {
                sb.add("; reason: ");
                sb.add(reason);
            }
            sb.newline();
        }
        this.prepareMergingErrorsForNode(manifestNode, sb, records);
    }

    private void prepareMergingErrorsForNode(@NotNull Node manifestNode, @NotNull HtmlBuilder sb, List<? extends Actions.Record> actionRecords) {
        if (this.doesNodeHaveRecordOfSeverity(manifestNode, MergingReport.Record.Severity.WARNING)) {
            this.appendMergeRecordTitle(sb, "Merge Warnings");
            this.myManifest.getLoggingRecords().stream().filter(record -> actionRecords.stream().anyMatch(actionRecord -> record.getSourceLocation().equals((Object)actionRecord.getActionLocation()))).forEach(record -> this.prepareErrorRecord(sb, (MergingReport.Record)record));
        }
        if (this.doesNodeHaveRecordOfSeverity(manifestNode, MergingReport.Record.Severity.ERROR)) {
            this.appendMergeRecordTitle(sb, "Merge Errors");
            this.myManifest.getLoggingRecords().stream().filter(record -> actionRecords.stream().anyMatch(actionRecord -> record.getSourceLocation().equals((Object)actionRecord.getActionLocation()))).forEach(record -> this.prepareErrorRecord(sb, (MergingReport.Record)record));
        }
    }

    private void appendMergeRecordTitle(@NotNull HtmlBuilder sb, String title2) {
        sb.newline();
        sb.beginUnderline().beginBold();
        sb.add(title2);
        sb.endBold().endUnderline().newline();
    }

    private void prepareErrorRecord(@NotNull HtmlBuilder sb, MergingReport.Record record) {
        sb.addHtml(ManifestPanel.getHtmlForErrorRecord(record.getSeverity()));
        sb.add(" ");
        try {
            File ioFile = this.myFiles.get(0).getFile();
            if (ioFile != null) {
                sb.addHtml(ManifestPanel.getErrorHtml(this.myFacet, record.getMessage(), record.getSourceLocation(), this.myHtmlLinkManager, this.myToken, LocalFileSystem.getInstance().findFileByIoFile(ioFile), this.myManifestEditable));
            } else {
                sb.add(record.getMessage());
            }
        }
        catch (Exception ex) {
            Logger.getInstance(ManifestPanel.class).error("error getting error html", (Throwable)ex);
            sb.add(record.getMessage());
        }
        sb.add(" ");
        sb.addHtml(this.getHtml(this.myFacet, record.getSourceLocation()));
        sb.newline();
    }

    private void prepareReportHeader(@NotNull HtmlBuilder sb) {
        Font font = StartupUiUtil.getLabelFont();
        sb.addHtml("<html><body style=\"font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt;\">");
        sb.beginUnderline().beginBold();
        sb.add("Manifest Sources");
        sb.endBold().endUnderline().newline();
        sb.addHtml("<table border=\"0\">");
        String borderColor = ColorUtil.toHex((Color)JBColor.GRAY);
        for (ManifestFileWithMetadata file : this.myFiles) {
            if (file.getFile() == null) continue;
            Color color = this.getFileColor(file.getFile());
            sb.addHtml("<tr><td width=\"24\" height=\"24\" style=\"background-color:#");
            sb.addHtml(ColorUtil.toHex((Color)color));
            sb.addHtml("; border: 1px solid #");
            sb.addHtml(borderColor);
            sb.addHtml(";\">");
            sb.addHtml("</td><td>");
            this.describePosition(sb, file);
            sb.addHtml("</td></tr>");
        }
        sb.addHtml("</table>");
        sb.newline();
        if (!this.myOtherFiles.isEmpty()) {
            sb.beginUnderline().beginBold();
            sb.add("Other Manifest Files");
            sb.endBold().endUnderline().newline();
            sb.add("(Included in merge, but did not contribute any elements)").newline();
            for (ManifestFileWithMetadata file : this.myOtherFiles) {
                this.describePosition(sb, file);
                sb.newline();
            }
            sb.newline().newline();
        }
    }

    @NotNull
    private Color getNodeColor(@NotNull Node node) {
        List<? extends Actions.Record> records = ManifestUtils.getRecords(this.myManifest, node);
        if (!records.isEmpty()) {
            ManifestFileWithMetadata metadata;
            Actions.Record record = records.get(0);
            File file = null;
            if (this.myToken != null && (metadata = this.myToken.getMetadataForRecord(record, (Function1<SourceFilePosition, ManifestFileWithMetadata>)((Function1)p -> this.createMetadataForFile(this.myFacet, (SourceFilePosition)p)))) != null) {
                file = metadata.getFile();
            }
            if (file == null) {
                file = this.createMetadataForFile(this.myFacet, ManifestUtils.getActionLocation(this.myFacet.getModule(), record)).getFile();
            }
            if (file != null) {
                return this.getFileColor(file);
            }
        }
        return this.myBackgroundColor;
    }

    private boolean doesNodeHaveRecordOfSeverity(@NotNull Node node, MergingReport.Record.Severity severity) {
        List<? extends Actions.Record> actionRecords = ManifestUtils.getRecords(this.myManifest, node);
        return this.myManifest.getLoggingRecords().stream().filter(record -> record.getSeverity().equals((Object)severity)).anyMatch(record -> {
            for (Actions.Record actionRecord : actionRecords) {
                if (!record.getSourceLocation().equals((Object)actionRecord.getActionLocation())) continue;
                return true;
            }
            return false;
        });
    }

    @Nullable
    private Icon getNodeIcon(@NotNull Node node) {
        if (this.doesNodeHaveRecordOfSeverity(node, MergingReport.Record.Severity.ERROR)) {
            return StudioIcons.Common.ERROR;
        }
        if (this.doesNodeHaveRecordOfSeverity(node, MergingReport.Record.Severity.WARNING)) {
            return StudioIcons.Common.WARNING;
        }
        return null;
    }

    @NotNull
    private Color getFileColor(@NotNull File file) {
        int index = this.getFileIndex(file);
        if (index == 0) {
            return this.myBackgroundColor;
        }
        return AnnotationColors.BG_COLORS[(index - 1) * 3 % AnnotationColors.BG_COLORS.length];
    }

    private int getFileIndex(@NotNull File file) {
        BiFunction<ManifestFileWithMetadata, Integer, Integer> f = (m, i) -> {
            File metadataFile = m.getFile();
            if (metadataFile == null) {
                return null;
            }
            if (file.getAbsolutePath().equals(metadataFile.getAbsolutePath())) {
                return i;
            }
            return null;
        };
        Stream metadataFiles = Streams.concat((Stream[])new Stream[]{this.myFiles.stream(), this.myOtherFiles.stream()});
        Stream<Integer> indices = IntStream.range(0, this.myFiles.size() + this.myOtherFiles.size()).boxed();
        return Streams.zip((Stream)metadataFiles, indices, f).filter(Objects::nonNull).findFirst().orElseGet(() -> this.myFiles.size() + this.myOtherFiles.size());
    }

    private boolean canRemove(@NotNull Node node) {
        if (!this.myManifestEditable) {
            return false;
        }
        List<? extends Actions.Record> records = ManifestUtils.getRecords(this.myManifest, node);
        if (records.isEmpty()) {
            return false;
        }
        File mainManifest = VfsUtilCore.virtualToIoFile((VirtualFile)ManifestUtils.getMainManifest(this.myFacet).getVirtualFile());
        for (Actions.Record record : records) {
            if (!FileUtil.filesEqual((File)ManifestUtils.getActionLocation(this.myFacet.getModule(), record).getFile().getSourceFile(), (File)mainManifest)) continue;
            return false;
        }
        return true;
    }

    private void goToDeclaration(Node element) {
        List<? extends Actions.Record> records = ManifestUtils.getRecords(this.myManifest, element);
        for (Actions.Record record : records) {
            File ioFile;
            SourceFilePosition sourceFilePosition = ManifestUtils.getActionLocation(this.myFacet.getModule(), record);
            SourceFile sourceFile = sourceFilePosition.getFile();
            if (SourceFile.UNKNOWN.equals((Object)sourceFile) || (ioFile = sourceFile.getSourceFile()) == null) continue;
            VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile(ioFile);
            assert (file != null);
            int line = -1;
            int column2 = 0;
            SourcePosition sourcePosition = sourceFilePosition.getPosition();
            if (!SourcePosition.UNKNOWN.equals((Object)sourcePosition)) {
                line = sourcePosition.getStartLine();
                column2 = sourcePosition.getStartColumn();
            }
            OpenFileDescriptor descriptor2 = new OpenFileDescriptor(this.myProject, file, line, column2);
            FileEditorManager.getInstance((Project)this.myProject).openEditor(descriptor2, true);
            break;
        }
    }

    @NotNull
    static String getErrorHtml(@NotNull AndroidFacet facet, @NotNull String message, @NotNull SourceFilePosition position, @NotNull HtmlLinkManager htmlLinkManager, @Nullable ManifestPanelToken<AndroidProjectSystem> token, @Nullable VirtualFile currentlyOpenFile, boolean manifestEditable) {
        HtmlBuilder sb = new HtmlBuilder();
        int index = message.indexOf(SUGGESTION_MARKER);
        if (manifestEditable && index >= 0) {
            String action2 = message.substring(index += SUGGESTION_MARKER.length(), message.indexOf(32, index));
            sb.add(message.substring(0, index));
            message = message.substring(index);
            switch (action2) {
                case "add": {
                    sb.addHtml(ManifestPanel.getErrorAddHtml(facet, message, position, htmlLinkManager, currentlyOpenFile));
                    break;
                }
                case "use": {
                    sb.addHtml(ManifestPanel.getErrorUseHtml(facet, message, position, htmlLinkManager, token, currentlyOpenFile));
                    break;
                }
                case "remove": {
                    sb.add(message);
                }
            }
        } else {
            sb.add(message);
        }
        return sb.getHtml();
    }

    @NotNull
    private static String getErrorAddHtml(@NotNull AndroidFacet facet, @NotNull String message, @NotNull SourceFilePosition position, @NotNull HtmlLinkManager htmlLinkManager, @Nullable VirtualFile currentlyOpenFile) {
        HtmlBuilder sb = new HtmlBuilder();
        Matcher matcher = ADD_SUGGESTION_FORMAT.matcher(message);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("unexpected add suggestion format " + message);
        }
        String attributeName = matcher.group(1);
        String attributeValue = matcher.group(2);
        String tagName = matcher.group(3);
        String filePosition = matcher.group(4);
        Matcher filePosMatcher = FILE_POSITION_FORMAT.matcher(filePosition);
        if (position.getPosition().equals((Object)SourcePosition.UNKNOWN) || !filePosMatcher.matches()) {
            Logger.getInstance(ManifestPanel.class).info("Unknown source position for " + tagName + " tag in file " + position.getFile());
            sb.add(message);
            return sb.getHtml();
        }
        int line = Integer.parseInt(filePosMatcher.group(1));
        int col = Integer.parseInt(filePosMatcher.group(2));
        XmlFile mainManifest = ManifestPanel.getMainManifestFile(facet, position.getFile().getSourceFile());
        Element element = ManifestPanel.getElementAt(mainManifest, line, col);
        if (element != null && tagName.equals(element.getTagName())) {
            Element xmlTag = element;
            sb.addLink(message, htmlLinkManager.createRunnableLink(() -> ManifestPanel.addToolsAttribute(mainManifest, xmlTag, attributeName, attributeValue)));
        } else {
            Logger.getInstance(ManifestPanel.class).warn("can not find " + tagName + " tag " + element);
            sb.add(message);
        }
        return sb.getHtml();
    }

    private static XmlFile getMainManifestFile(AndroidFacet facet, File manifestErrorSourceFile) {
        PsiFile psiFile;
        VirtualFile manifestFile;
        if (manifestErrorSourceFile != null && (manifestFile = VfsUtil.findFileByIoFile((File)manifestErrorSourceFile, (boolean)true)) != null && (psiFile = PsiManager.getInstance((Project)facet.getModule().getProject()).findFile(manifestFile)) instanceof XmlFile) {
            return (XmlFile)psiFile;
        }
        return ManifestUtils.getMainManifest(facet);
    }

    @Nullable
    private static Element getElementAt(XmlFile mainManifest, int line, int col) {
        Element element = null;
        try {
            Document document = PositionXmlParser.parse((String)mainManifest.getText());
            for (Node node = PositionXmlParser.findNodeAtLineAndCol((Document)document, (int)line, (int)col); node != null; node = node.getParentNode()) {
                if (!(node instanceof Element)) continue;
                element = (Element)node;
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return element;
    }

    @NotNull
    private static String getErrorUseHtml(@NotNull AndroidFacet facet, @NotNull String message, @NotNull SourceFilePosition position, @NotNull HtmlLinkManager htmlLinkManager, @Nullable ManifestPanelToken<AndroidProjectSystem> token, @Nullable VirtualFile currentlyOpenFile) {
        int minSdkVersion2;
        HtmlBuilder sb = new HtmlBuilder();
        String versionPrefix = "to at least ";
        int start2 = message.indexOf(versionPrefix) + versionPrefix.length();
        if (start2 < 0) {
            throw new IllegalArgumentException("unexpected use suggestion format " + message);
        }
        int end = message.indexOf(44, start2);
        if (end < 0) {
            throw new IllegalArgumentException("unexpected use suggestion format " + message);
        }
        String minSdkVersionString = message.substring(start2, end);
        try {
            minSdkVersion2 = Integer.parseInt(minSdkVersionString);
        }
        catch (NumberFormatException e) {
            sb.add(message);
            return sb.getHtml();
        }
        int finalMinSdk = minSdkVersion2;
        Runnable link2 = null;
        if (token != null) {
            link2 = token.generateMinSdkSettingRunnable(facet.getModule(), finalMinSdk);
        }
        if (link2 == null) {
            sb.add(message);
        } else {
            sb.addLink(message.substring(0, end), htmlLinkManager.createRunnableLink(link2));
            sb.add(message.substring(end));
        }
        return sb.getHtml();
    }

    static void addToolsAttribute(@NotNull XmlFile file, @NotNull Element element, @NotNull String attributeName, @NotNull String attributeValue) {
        Project project = file.getProject();
        WriteCommandAction.writeCommandAction((Project)project).withName("Apply manifest suggestion").run(() -> ManifestUtils.addToolsAttribute(file, element, attributeName, attributeValue));
    }

    @NotNull
    static String getHtmlForErrorRecord(@NotNull MergingReport.Record.Severity severity) {
        String severityString = StringUtil.capitalize((String)StringUtil.toLowerCase((String)severity.toString()));
        if (severity == MergingReport.Record.Severity.ERROR || severity == MergingReport.Record.Severity.WARNING) {
            return new HtmlBuilder().addHtml("<font color=\"#" + ColorUtil.toHex((Color)JBColor.RED) + "\">").addBold(severityString).addHtml("</font>").endBold().addHtml(":").getHtml();
        }
        return severityString;
    }

    @NotNull
    String getHtml(@NotNull AndroidFacet facet, @NotNull SourceFilePosition sourceFilePosition) {
        HtmlBuilder sb = new HtmlBuilder();
        this.describePosition(sb, this.createMetadataForFile(facet, sourceFilePosition));
        return sb.getHtml();
    }

    private ManifestFileWithMetadata createMetadataForFile(@NotNull AndroidFacet facet, @NotNull SourceFilePosition sourceFilePosition) {
        Object source2;
        Module module;
        ManifestFileWithMetadata metadata;
        SourceFile sourceFile = sourceFilePosition.getFile();
        SourcePosition sourcePosition = sourceFilePosition.getPosition();
        File file = sourceFile.getSourceFile();
        if (this.myToken != null && (metadata = this.myToken.createMetadataForFile(file, module = facet.getModule())) != null) {
            return metadata;
        }
        if (file != null && NAV_FILE_PATTERN.matcher(FileUtils.toSystemIndependentPath((String)file.toString())).matches()) {
            VirtualFile vResDir;
            source2 = "";
            boolean isProjectFile = false;
            File resDir = file.getParentFile() == null ? null : file.getParentFile().getParentFile();
            VirtualFile virtualFile = vResDir = resDir == null ? null : LocalFileSystem.getInstance().findFileByIoFile(resDir);
            if (vResDir != null) {
                Module module2 = ModuleUtilCore.findModuleForFile((VirtualFile)vResDir, (Project)this.myProject);
                if (module2 != null) {
                    isProjectFile = true;
                }
                for (NamedIdeaSourceProvider provider : SourceProviderManager.getInstance(facet).getCurrentSourceProviders()) {
                    if (!Iterables.contains(provider.getResDirectories(), (Object)vResDir)) continue;
                    source2 = (String)source2 + provider.getName() + " ";
                    break;
                }
            }
            source2 = (String)source2 + file.getName();
            return new ManifestXmlWithMetadata(ManifestXmlType.NAVIGATION_XML, file, (String)source2, isProjectFile, sourcePosition);
        }
        if (file != null) {
            source2 = null;
            boolean isProjectFile = false;
            Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
            if (vFile != null) {
                NamedIdeaSourceProvider provider;
                String path = file.getPath();
                Module module3 = ModuleUtilCore.findModuleForFile((VirtualFile)vFile, (Project)this.myProject);
                if (module3 != null) {
                    isProjectFile = true;
                    if (modules.length >= 2) {
                        source2 = ProjectSystemUtil.getModuleSystem(module3).getDisplayNameForModuleGroup();
                    }
                    if (path.contains("exploded-aar")) {
                        source2 = this.findSourceForFileInExplodedAar(this.myProject, file);
                    }
                } else if (path.contains("output") && path.matches(".*\\w{40}[\\\\/]output.*")) {
                    source2 = this.findSourceForFileInExplodedAar(this.myProject, file);
                } else if (path.contains("caches")) {
                    source2 = this.findSourceForFileInExplodedAar(this.myProject, file);
                }
                if ((provider = ManifestUtils.findManifestSourceProvider(facet, vFile)) != null) {
                    String providerName = provider.getName();
                    source2 = source2 == null ? providerName : (String)source2 + " " + providerName;
                }
            }
            if (source2 == null) {
                source2 = file.getName();
                if (!SourcePosition.UNKNOWN.equals((Object)sourcePosition)) {
                    source2 = (String)source2 + ":" + sourcePosition;
                }
            }
            return new ManifestXmlWithMetadata(ManifestXmlType.ANDROID_MANIFEST_XML, file, (String)source2, isProjectFile, sourcePosition);
        }
        return UnknownManifestFile.INSTANCE;
    }

    private void describePosition(@NotNull HtmlBuilder sb, ManifestFileWithMetadata manifestFile) {
        if (manifestFile instanceof InjectedFile) {
            InjectedFile injectedFile = (InjectedFile)manifestFile;
            File file = injectedFile.getFile();
            if (file != null) {
                sb.addLink(null, file.getName(), " injection", this.myHtmlLinkManager.createFileLink(file));
            } else {
                sb.add("Injection from Gradle build file (source location unknown)");
            }
            return;
        }
        if (manifestFile instanceof ManifestXmlWithMetadata) {
            String urlString;
            ManifestXmlWithMetadata manifestXml = (ManifestXmlWithMetadata)manifestFile;
            SourcePosition position = manifestXml.getSourcePosition();
            Object textAfter = " unknown manifest XML file";
            switch (manifestXml.getType()) {
                case NAVIGATION_XML: {
                    textAfter = " navigation file";
                    break;
                }
                case ANDROID_MANIFEST_XML: {
                    textAfter = " manifest";
                    if (!FileUtil.filesEqual((File)manifestXml.getFile(), (File)VfsUtilCore.virtualToIoFile((VirtualFile)this.myFile))) break;
                    textAfter = (String)textAfter + " (this file)";
                }
            }
            if (SourcePosition.UNKNOWN.equals((Object)position)) {
                urlString = this.myHtmlLinkManager.createFileLink(manifestXml.getFile());
            } else {
                urlString = this.myHtmlLinkManager.createFileLink(manifestXml.getFile(), position.getStartLine(), position.getStartColumn());
                textAfter = (String)textAfter + ", line " + position.getStartLine();
            }
            sb.addLink(null, manifestXml.getSourceLibrary(), (String)textAfter, urlString);
        }
    }

    @Nullable
    private String findSourceForFileInExplodedAar(@NotNull Project project, @NotNull File file) {
        File parentFile = file.getParentFile();
        if (parentFile == null) {
            return null;
        }
        PathString parentFilePath = new PathString(parentFile);
        ExternalAndroidLibrary androidLibrary = this.myLibrariesByManifestDir.get(parentFilePath);
        if (androidLibrary == null) {
            return null;
        }
        if (this.myToken == null) {
            return null;
        }
        return this.myToken.getExternalAndroidLibraryDisplayName(androidLibrary);
    }

    @VisibleForTesting
    public static class HtmlLinkManager {
        ArrayList<Runnable> runnables = new ArrayList(5);
        private static final String URL_SCHEME_RUNNABLE = "runnable:";

        public void handleUrl(@NotNull String url, @NotNull Module module, @Nullable PsiFile file) {
            if (url.startsWith("http:") || url.startsWith("https:")) {
                BrowserLauncher.getInstance().browse(url, null, module.getProject());
            } else if (url.startsWith("file:")) {
                Project project = module.getProject();
                SdkUtils.FileLineColumnUrlData data2 = SdkUtils.parseDecoratedFileUrlString((String)url);
                int line = data2.line == null ? -1 : data2.line;
                int column2 = data2.column == null ? 0 : data2.column;
                try {
                    File ioFile = SdkUtils.urlToFile((String)data2.urlString);
                    VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(ioFile);
                    if (virtualFile != null) {
                        OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, virtualFile, line, column2);
                        FileEditorManager manager = FileEditorManager.getInstance((Project)project);
                        manager.openTextEditor(descriptor2, true);
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            } else if (url.startsWith(URL_SCHEME_RUNNABLE)) {
                String idString = url.substring(URL_SCHEME_RUNNABLE.length());
                int id2 = Integer.decode(idString);
                this.runnables.get(id2).run();
            }
        }

        public String createRunnableLink(Runnable runnable2) {
            this.runnables.add(runnable2);
            return URL_SCHEME_RUNNABLE + (this.runnables.size() - 1);
        }

        public String createFileLink(@NotNull File file) {
            return this.createFileLink(file, null, null);
        }

        public String createFileLink(@NotNull File file, @Nullable Integer line, @Nullable Integer col) {
            Object fileUrlString = file.toURI().toString();
            if (line != null) {
                fileUrlString = (String)fileUrlString + ":" + line;
                if (col != null) {
                    fileUrlString = (String)fileUrlString + ":" + col;
                }
            }
            return fileUrlString;
        }
    }

    private class FileColorTree
    extends Tree {
        public FileColorTree() {
            this.setFont(ManifestPanel.this.myDefaultFont);
            this.setBackground((Color)ManifestPanel.this.myBackgroundColor);
        }

        public boolean isFileColorsEnabled() {
            if (this.isOpaque()) {
                this.setOpaque(false);
            }
            return true;
        }

        @Nullable
        public Color getFileColorFor(Object object) {
            return object == null ? null : ManifestPanel.this.getNodeColor((Node)object);
        }
    }

    private class SyntaxHighlightingCellRenderer
    extends ColoredTreeCellRenderer {
        private final SimpleTextAttributes myTagNameAttributes;
        private final SimpleTextAttributes myNameAttributes;
        private final SimpleTextAttributes myValueAttributes;
        private final SimpleTextAttributes myPrefixAttributes;

        public SyntaxHighlightingCellRenderer() {
            EditorColorsManager colorsManager = EditorColorsManager.getInstance();
            JBColor tagNameColor = JBColor.lazy(() -> colorsManager.getGlobalScheme().getAttributes(XmlHighlighterColors.XML_TAG_NAME).getForegroundColor());
            JBColor nameColor = JBColor.lazy(() -> colorsManager.getGlobalScheme().getAttributes(XmlHighlighterColors.XML_ATTRIBUTE_NAME).getForegroundColor());
            JBColor valueColor = JBColor.lazy(() -> colorsManager.getGlobalScheme().getAttributes(XmlHighlighterColors.XML_ATTRIBUTE_VALUE).getForegroundColor());
            JBColor prefixColor = JBColor.lazy(() -> colorsManager.getGlobalScheme().getAttributes(XmlHighlighterColors.XML_NS_PREFIX).getForegroundColor());
            this.myTagNameAttributes = new SimpleTextAttributes(1, (Color)tagNameColor);
            this.myNameAttributes = new SimpleTextAttributes(0, (Color)nameColor);
            this.myValueAttributes = new SimpleTextAttributes(0, (Color)valueColor);
            this.myPrefixAttributes = new SimpleTextAttributes(0, (Color)prefixColor);
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value2 instanceof ManifestTreeNode) {
                ManifestTreeNode node = (ManifestTreeNode)value2;
                this.setIcon(ManifestPanel.this.getNodeIcon(node.getUserObject()));
                Node node2 = node.getUserObject();
                if (node2 instanceof Element) {
                    Element element = (Element)node2;
                    this.append("<");
                    this.append(element.getTagName(), this.myTagNameAttributes);
                    if (!expanded) {
                        this.append(" ... " + this.getCloseTag(node));
                    }
                }
                if ((node2 = node.getUserObject()) instanceof Attr) {
                    Attr attr = (Attr)node2;
                    ManifestTreeNode parent = node.getParent();
                    assert (parent != null);
                    if (attr.getPrefix() != null) {
                        this.append(attr.getPrefix(), this.myPrefixAttributes);
                        this.append(":");
                        this.append(attr.getLocalName(), this.myNameAttributes);
                    } else {
                        this.append(attr.getName(), this.myNameAttributes);
                    }
                    this.append("=\"");
                    this.append(attr.getValue(), this.myValueAttributes);
                    this.append("\"");
                    if (parent.lastAttribute() == node) {
                        this.append(" " + this.getCloseTag(node));
                    }
                }
            }
        }

        private String getCloseTag(ManifestTreeNode node) {
            return node.hasElementChildren() ? ">" : "/>";
        }
    }

    static class ManifestTreeNode
    extends DefaultMutableTreeNode {
        public ManifestTreeNode(@NotNull Node obj) {
            super(obj);
        }

        @Override
        @NotNull
        public Node getUserObject() {
            return (Node)super.getUserObject();
        }

        @Override
        public int getChildCount() {
            Node obj = this.getUserObject();
            if (obj instanceof Element) {
                Element element = (Element)obj;
                NamedNodeMap attributes = element.getAttributes();
                int count = attributes.getLength();
                NodeList childNodes = element.getChildNodes();
                int n = childNodes.getLength();
                for (int i = 0; i < n; ++i) {
                    Node child = childNodes.item(i);
                    if (child.getNodeType() != 1) continue;
                    ++count;
                }
                return count;
            }
            return 0;
        }

        @Override
        @NotNull
        public ManifestTreeNode getChildAt(int index) {
            Node obj = this.getUserObject();
            if (this.children == null && obj instanceof Element) {
                Element element = (Element)obj;
                NamedNodeMap attributes = element.getAttributes();
                int n = attributes.getLength();
                for (int i = 0; i < n; ++i) {
                    this.add(new ManifestTreeNode(attributes.item(i)));
                }
                NodeList childNodes = element.getChildNodes();
                int n2 = childNodes.getLength();
                for (int i = 0; i < n2; ++i) {
                    Node child = childNodes.item(i);
                    if (child.getNodeType() != 1) continue;
                    this.add(new ManifestTreeNode(child));
                }
            }
            return (ManifestTreeNode)super.getChildAt(index);
        }

        @Override
        public void add(@NotNull MutableTreeNode newChild) {
            this.insert(newChild, this.children == null ? 0 : this.children.size());
        }

        @Override
        @NotNull
        public String toString() {
            Node obj = this.getUserObject();
            if (obj instanceof Attr) {
                Attr xmlAttribute = (Attr)obj;
                return xmlAttribute.getName() + " = " + xmlAttribute.getValue();
            }
            if (obj instanceof Element) {
                Element xmlTag = (Element)obj;
                return xmlTag.getTagName();
            }
            return obj.toString();
        }

        @Override
        @Nullable
        public ManifestTreeNode getParent() {
            return (ManifestTreeNode)super.getParent();
        }

        @NotNull
        public ManifestTreeNode lastAttribute() {
            Node xmlTag = this.getUserObject();
            return this.getChildAt(xmlTag.getAttributes().getLength() - 1);
        }

        public boolean hasElementChildren() {
            Node node = this.getUserObject();
            if (node instanceof Attr) {
                ManifestTreeNode parent = this.getParent();
                assert (parent != null);
                return parent.hasElementChildren();
            }
            return node.getChildNodes().getLength() > 0;
        }
    }
}

