/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.liveedit;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.adtui.toolwindow.ContentManagerHierarchyAdapter;
import com.android.tools.idea.editors.liveedit.LiveEditApplicationConfiguration;
import com.android.tools.idea.editors.liveedit.LiveEditService;
import com.android.tools.idea.editors.liveedit.LiveEditServiceImpl;
import com.android.tools.idea.editors.liveedit.ui.EmulatorLiveEditAdapter;
import com.android.tools.idea.editors.liveedit.ui.LiveEditDeviceMap;
import com.android.tools.idea.execution.common.AndroidExecutionTarget;
import com.android.tools.idea.execution.common.DeployableToDevice;
import com.android.tools.idea.projectsystem.ApplicationProjectContext;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.AndroidRunConfigurationModule;
import com.android.tools.idea.run.deployment.liveedit.LiveEditAdbEventsListener;
import com.android.tools.idea.run.deployment.liveedit.LiveEditApp;
import com.android.tools.idea.run.deployment.liveedit.LiveEditLogger;
import com.android.tools.idea.run.deployment.liveedit.LiveEditNotifications;
import com.android.tools.idea.run.deployment.liveedit.LiveEditProjectMonitor;
import com.android.tools.idea.run.deployment.liveedit.LiveEditStatus;
import com.android.tools.idea.run.deployment.liveedit.SourceInlineCandidate;
import com.android.tools.idea.run.profiler.AbstractProfilerExecutorGroup;
import com.android.tools.idea.run.profiler.ProfilingMode;
import com.android.tools.idea.run.util.LaunchUtils;
import com.android.tools.idea.streaming.RunningDevicesConstants;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.ui.IdeUiService;
import com.intellij.notification.BrowseNotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.EdtNoGetDataProvider;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 F2\u00020\u00012\u00020\u0002:\u0001FB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\u000bJ\u0018\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001ej\u0002`!H\u0016J\b\u0010\"\u001a\u00020\u0019H\u0017J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020%H\u0016J\u0010\u0010)\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020%H\u0016J0\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0005\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u0010(\u001a\u00020%2\u0006\u00100\u001a\u000201H\u0016J\u0018\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000205H\u0016J\u0018\u00107\u001a\u0002032\u0006\u00104\u001a\u0002082\u0006\u00106\u001a\u000208H\u0016J\b\u00109\u001a\u000203H\u0016J\b\u0010:\u001a\u000203H\u0016J\u0018\u0010;\u001a\u00020\u001f2\u0006\u0010<\u001a\u00020\u001f2\u0006\u0010=\u001a\u00020\u001fH\u0016J\u0010\u0010>\u001a\u0002032\u0006\u0010(\u001a\u00020%H\u0016J\u0018\u0010?\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0005\u001a\u00020-H\u0002J\u0018\u0010@\u001a\u0002032\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010A\u001a\u00020BH\u0002J\u0018\u0010C\u001a\u0002032\u0006\u0010A\u001a\u00020B2\u0006\u0010D\u001a\u00020EH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/android/tools/idea/editors/liveedit/LiveEditServiceImpl;", "Lcom/intellij/openapi/Disposable;", "Lcom/android/tools/idea/editors/liveedit/LiveEditService;", "project", "Lcom/intellij/openapi/project/Project;", "executor", "Ljava/util/concurrent/Executor;", "adbEventsListener", "Lcom/android/tools/idea/run/deployment/liveedit/LiveEditAdbEventsListener;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/concurrent/Executor;Lcom/android/tools/idea/run/deployment/liveedit/LiveEditAdbEventsListener;)V", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getExecutor", "()Ljava/util/concurrent/Executor;", "setExecutor", "(Ljava/util/concurrent/Executor;)V", "getAdbEventsListener", "()Lcom/android/tools/idea/run/deployment/liveedit/LiveEditAdbEventsListener;", "LOGGER", "Lcom/android/tools/idea/run/deployment/liveedit/LiveEditLogger;", "notifications", "Lcom/android/tools/idea/run/deployment/liveedit/LiveEditNotifications;", "deployMonitor", "Lcom/android/tools/idea/run/deployment/liveedit/LiveEditProjectMonitor;", "showMultiDeviceNotification", "", "showMultiDeployNotification", "inlineCandidateCache", "Ljava/util/LinkedHashMap;", "", "Lcom/android/tools/idea/run/deployment/liveedit/SourceInlineCandidate;", "Lcom/android/tools/idea/run/deployment/liveedit/SourceInlineCandidateCache;", "getDeployMonitor", "devices", "", "Lcom/android/ddmlib/IDevice;", "editStatus", "Lcom/android/tools/idea/run/deployment/liveedit/LiveEditStatus;", "device", "notifyAppRefresh", "notifyAppDeploy", "runProfile", "Lcom/intellij/execution/configurations/RunProfile;", "Lcom/intellij/execution/Executor;", "applicationProjectContext", "Lcom/android/tools/idea/projectsystem/ApplicationProjectContext;", "app", "Lcom/android/tools/idea/run/deployment/liveedit/LiveEditApp;", "toggleLiveEdit", "", "oldMode", "Lcom/android/tools/idea/editors/liveedit/LiveEditApplicationConfiguration$LiveEditMode;", "newMode", "toggleLiveEditMode", "Lcom/android/tools/idea/editors/liveedit/LiveEditService$Companion$LiveEditTriggerMode;", "dispose", "triggerLiveEdit", "triggerVibeEdit", "pathString", "prompt", "notifyLiveEditAvailability", "isLiveEditable", "registerWithRunningDevices", "adapter", "Lcom/android/tools/idea/editors/liveedit/ui/EmulatorLiveEditAdapter;", "addListenersToRunningDevices", "runningDevicesWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "Companion", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nLiveEditServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveEditServiceImpl.kt\ncom/android/tools/idea/editors/liveedit/LiveEditServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,352:1\n1863#2:353\n1864#2:355\n1#3:354\n*S KotlinDebug\n*F\n+ 1 LiveEditServiceImpl.kt\ncom/android/tools/idea/editors/liveedit/LiveEditServiceImpl\n*L\n343#1:353\n343#1:355\n*E\n"})
public final class LiveEditServiceImpl
implements Disposable,
LiveEditService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private Executor executor;
    @NotNull
    private final LiveEditAdbEventsListener adbEventsListener;
    @NotNull
    private final LiveEditLogger LOGGER;
    @NotNull
    private final LiveEditNotifications notifications;
    @NotNull
    private final LiveEditProjectMonitor deployMonitor;
    private boolean showMultiDeviceNotification;
    private boolean showMultiDeployNotification;

    public LiveEditServiceImpl(@NotNull Project project, @NotNull Executor executor, @NotNull LiveEditAdbEventsListener adbEventsListener) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)adbEventsListener, (String)"adbEventsListener");
        this.project = project;
        this.executor = executor;
        this.adbEventsListener = adbEventsListener;
        this.LOGGER = new LiveEditLogger("LiveEditService");
        this.notifications = new LiveEditNotifications(this.project);
        this.showMultiDeviceNotification = true;
        this.showMultiDeployNotification = true;
        EmulatorLiveEditAdapter adapter = new EmulatorLiveEditAdapter(this.project);
        LiveEditDeviceMap.INSTANCE.registerProject(this.project, adapter);
        Disposer.register((Disposable)this, () -> LiveEditServiceImpl._init_$lambda$0(this));
        this.registerWithRunningDevices(this.project, adapter);
        this.deployMonitor = new LiveEditProjectMonitor(this, this.project);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        messageBusConnection.subscribe(topic, (Object)new FileEditorManagerListener(){

            public void selectionChanged(FileEditorManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                VirtualFile virtualFile = event.getNewFile();
                if (virtualFile == null) {
                    return;
                }
                VirtualFile file = virtualFile;
                deployMonitor.updatePsiSnapshot(file);
            }
        });
        MessageBusConnection messageBusConnection2 = this.project.getMessageBus().connect((Disposable)this);
        Topic topic2 = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"VFS_CHANGES");
        messageBusConnection2.subscribe(topic2, (Object)new BulkFileListener(){

            /*
             * WARNING - void declaration
             */
            public void before(List<? extends VFileEvent> events) {
                void $this$filterIsInstanceTo$iv$iv;
                Intrinsics.checkNotNullParameter(events, (String)"events");
                Iterable $this$filterIsInstance$iv = events;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof VFileDeleteEvent)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (VFileDeleteEvent event : (List)destination$iv$iv) {
                    deployMonitor.fileChanged(event.getFile());
                }
            }
        });
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(event.getDocument());
                if (virtualFile == null) {
                    return;
                }
                VirtualFile file = virtualFile;
                deployMonitor.fileChanged(file);
            }
        }, (Disposable)this);
        this.project.getMessageBus().connect((Disposable)this).subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processStarting(String executorId, ExecutionEnvironment env) {
                boolean composeEnabled;
                Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
                Intrinsics.checkNotNullParameter((Object)env, (String)"env");
                ExecutionTarget executionTarget = env.getExecutionTarget();
                AndroidExecutionTarget androidExecutionTarget = executionTarget instanceof AndroidExecutionTarget ? (AndroidExecutionTarget)executionTarget : null;
                if (androidExecutionTarget == null) {
                    return;
                }
                AndroidExecutionTarget executionTarget2 = androidExecutionTarget;
                Collection<IDevice> collection2 = executionTarget2.getRunningDevices();
                Intrinsics.checkNotNullExpressionValue(collection2, (String)"getRunningDevices(...)");
                Collection<IDevice> devices2 = collection2;
                boolean multiDeploy = deployMonitor.notifyExecution(devices2);
                boolean bl = composeEnabled = LiveEditService.Companion.usesCompose(this.getProject()) && LiveEditApplicationConfiguration.Companion.getInstance().isLiveEdit();
                if (composeEnabled && devices2.size() > 1 && showMultiDeviceNotification) {
                    NotificationGroupManager.getInstance().getNotificationGroup("Deploy").createNotification("Live Edit works with multi-device deployments but this is not officially supported.", NotificationType.INFORMATION).addAction((AnAction)new BrowseNotificationAction("Learn more", "https://developer.android.com/develop/ui/compose/tooling/iterative-development#limitations")).notify(this.getProject());
                    showMultiDeviceNotification = false;
                }
                if (composeEnabled && multiDeploy && showMultiDeployNotification) {
                    NotificationGroupManager.getInstance().getNotificationGroup("Deploy").createNotification("Live Edit does not work with previous deployments on different devices.", NotificationType.INFORMATION).addAction((AnAction)new BrowseNotificationAction("Learn more", "https://developer.android.com/develop/ui/compose/tooling/iterative-development#limitations")).notify(this.getProject());
                    showMultiDeployNotification = false;
                }
            }
        });
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Executor getExecutor() {
        return this.executor;
    }

    public final void setExecutor(@NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"<set-?>");
        this.executor = executor;
    }

    @Override
    @NotNull
    public LiveEditAdbEventsListener getAdbEventsListener() {
        return this.adbEventsListener;
    }

    public LiveEditServiceImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Document changed listeners executor", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        this(project, executorService, new LiveEditAdbEventsListener());
    }

    @Override
    @NotNull
    public LinkedHashMap<String, SourceInlineCandidate> inlineCandidateCache() {
        return this.deployMonitor.getCompiler().getInlineCandidateCache();
    }

    @Override
    @VisibleForTesting
    @NotNull
    public LiveEditProjectMonitor getDeployMonitor() {
        return this.deployMonitor;
    }

    @Override
    @NotNull
    public Set<IDevice> devices() {
        Set<IDevice> set2 = this.deployMonitor.devices();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"devices(...)");
        return set2;
    }

    @Override
    @NotNull
    public LiveEditStatus editStatus(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        LiveEditStatus liveEditStatus = this.deployMonitor.status(device2);
        Intrinsics.checkNotNullExpressionValue((Object)liveEditStatus, (String)"status(...)");
        return liveEditStatus;
    }

    @Override
    public boolean notifyAppRefresh(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        return this.deployMonitor.notifyAppRefresh(device2);
    }

    @Override
    public boolean notifyAppDeploy(@NotNull RunProfile runProfile, @NotNull com.intellij.execution.Executor executor, @NotNull ApplicationProjectContext applicationProjectContext, @NotNull IDevice device2, @NotNull LiveEditApp app) {
        Intrinsics.checkNotNullParameter((Object)runProfile, (String)"runProfile");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)applicationProjectContext, (String)"applicationProjectContext");
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)this.project).getSelectedFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSelectedFiles(...)");
        List openFiles = ArraysKt.toList((Object[])virtualFileArray);
        return this.deployMonitor.notifyAppDeploy(applicationProjectContext, device2, app, openFiles, () -> LiveEditServiceImpl.notifyAppDeploy$lambda$1(this, runProfile, executor));
    }

    @Override
    public void toggleLiveEdit(@NotNull LiveEditApplicationConfiguration.LiveEditMode oldMode, @NotNull LiveEditApplicationConfiguration.LiveEditMode newMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)oldMode), (String)"oldMode");
        Intrinsics.checkNotNullParameter((Object)((Object)newMode), (String)"newMode");
        if (oldMode == newMode) {
            return;
        }
        if (newMode == LiveEditApplicationConfiguration.LiveEditMode.LIVE_EDIT) {
            if (LiveEditService.Companion.usesCompose(this.project) && LiveEditServiceImpl.Companion.hasLiveEditSupportedDeviceConnected()) {
                this.deployMonitor.requestRerun();
            }
        } else {
            this.deployMonitor.clearDevices();
        }
    }

    @Override
    public void toggleLiveEditMode(@NotNull LiveEditService.Companion.LiveEditTriggerMode oldMode, @NotNull LiveEditService.Companion.LiveEditTriggerMode newMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)oldMode), (String)"oldMode");
        Intrinsics.checkNotNullParameter((Object)((Object)newMode), (String)"newMode");
        if (oldMode == newMode) {
            return;
        }
        if (newMode == LiveEditService.Companion.LiveEditTriggerMode.AUTOMATIC) {
            this.deployMonitor.onManualLETrigger();
        }
    }

    public void dispose() {
    }

    @Override
    public void triggerLiveEdit() {
        this.deployMonitor.onManualLETrigger();
    }

    @Override
    @NotNull
    public String triggerVibeEdit(@NotNull String pathString, @NotNull String prompt) {
        Intrinsics.checkNotNullParameter((Object)pathString, (String)"pathString");
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        String string = this.deployMonitor.onAgentTrigger(pathString, prompt);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"onAgentTrigger(...)");
        return string;
    }

    @Override
    public void notifyLiveEditAvailability(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        this.notifications.notifyLiveEditAvailability$intellij_android_core(device2);
    }

    private final boolean isLiveEditable(RunProfile runProfile, com.intellij.execution.Executor executor) {
        String string = executor.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        AbstractProfilerExecutorGroup.AbstractProfilerSetting profilerSetting = AbstractProfilerExecutorGroup.Companion.getExecutorSetting(string);
        if (!LiveEditService.Companion.usesCompose(this.project)) {
            this.LOGGER.log$intellij_android_core("Not Live Editable: Not Compose");
            return false;
        }
        if (profilerSetting != null && profilerSetting.getProfilingMode() != ProfilingMode.DEBUGGABLE) {
            this.LOGGER.log$intellij_android_core("Not Live Editable: Profiling");
            return false;
        }
        if (runProfile instanceof AndroidRunConfigurationBase) {
            Module module = ((AndroidRunConfigurationModule)((AndroidRunConfigurationBase)runProfile).getConfigurationModule()).getModule();
            if (module == null) {
                return false;
            }
            Module module2 = module;
            AndroidFacet facet = AndroidFacet.getInstance((Module)module2);
            if (facet != null) {
                if (!LaunchUtils.canDebugApp(facet)) {
                    this.LOGGER.log$intellij_android_core("Not Live Editable: Non-debuggable");
                    return false;
                }
                if (((AndroidFacetConfiguration)facet.getConfiguration()).getProjectType() == 4) {
                    this.LOGGER.log$intellij_android_core("Not Live Editable: Instant App");
                    return false;
                }
            }
            return true;
        }
        return DeployableToDevice.deploysToLocalDevice(runProfile);
    }

    private final void registerWithRunningDevices(Project project, EmulatorLiveEditAdapter adapter) {
        ToolWindow toolWindow;
        ToolWindowManager toolWindowManager = (ToolWindowManager)project.getServiceIfCreated(ToolWindowManager.class);
        Object object = toolWindow = toolWindowManager != null ? toolWindowManager.getToolWindow("Running Devices") : null;
        if (toolWindow == null) {
            MessageBusConnection connection2 = project.getMessageBus().connect();
            Topic topic = ToolWindowManagerListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            connection2.subscribe(topic, (Object)new ToolWindowManagerListener(connection2, this, adapter){
                final /* synthetic */ MessageBusConnection $connection;
                final /* synthetic */ LiveEditServiceImpl this$0;
                final /* synthetic */ EmulatorLiveEditAdapter $adapter;
                {
                    this.$connection = $connection;
                    this.this$0 = $receiver;
                    this.$adapter = $adapter;
                }

                public void toolWindowsRegistered(List<String> ids, ToolWindowManager toolWindowManager) {
                    Intrinsics.checkNotNullParameter(ids, (String)"ids");
                    Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                    if (ids.contains("Running Devices")) {
                        ToolWindow toolWindow = toolWindowManager.getToolWindow("Running Devices");
                        if (toolWindow != null) {
                            ToolWindow toolWindow2 = toolWindow;
                            LiveEditServiceImpl liveEditServiceImpl = this.this$0;
                            EmulatorLiveEditAdapter emulatorLiveEditAdapter = this.$adapter;
                            ToolWindow it = toolWindow2;
                            boolean bl = false;
                            LiveEditServiceImpl.access$addListenersToRunningDevices(liveEditServiceImpl, emulatorLiveEditAdapter, it);
                        }
                        this.$connection.disconnect();
                    }
                }
            });
        } else {
            this.addListenersToRunningDevices(adapter, toolWindow);
        }
    }

    private final void addListenersToRunningDevices(EmulatorLiveEditAdapter adapter, ToolWindow runningDevicesWindow) {
        block1: {
            Disposer.register((Disposable)this, (Disposable)((Disposable)new ContentManagerHierarchyAdapter(runningDevicesWindow, adapter){
                final /* synthetic */ EmulatorLiveEditAdapter $adapter;
                {
                    this.$adapter = $adapter;
                    super($runningDevicesWindow);
                }

                public void contentAdded(ContentManagerEvent event) {
                    block0: {
                        String serial;
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        DataContext dataContext = IdeUiService.getInstance().createCustomizedDataContext(DataContext.EMPTY_CONTEXT, (DataProvider)((EdtNoGetDataProvider)arg_0 -> addListenersToRunningDevices.1.contentAdded$lambda$0(event, arg_0)));
                        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"createCustomizedDataContext(...)");
                        DataContext dataContext2 = dataContext;
                        String string = serial = (String)dataContext2.getData(RunningDevicesConstants.SERIAL_NUMBER_KEY);
                        if (string == null) break block0;
                        String string2 = string;
                        EmulatorLiveEditAdapter emulatorLiveEditAdapter = this.$adapter;
                        String it = string2;
                        boolean bl = false;
                        emulatorLiveEditAdapter.register(it);
                    }
                }

                public void contentRemoveQuery(ContentManagerEvent event) {
                    block1: {
                        String serial;
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        Content content2 = event.getContent();
                        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"getContent(...)");
                        Content content3 = content2;
                        if (((Boolean)Content.TEMPORARY_REMOVED_KEY.get((UserDataHolder)content3, (Object)false)).booleanValue()) {
                            return;
                        }
                        DataContext dataContext = IdeUiService.getInstance().createCustomizedDataContext(DataContext.EMPTY_CONTEXT, (DataProvider)((EdtNoGetDataProvider)arg_0 -> addListenersToRunningDevices.1.contentRemoveQuery$lambda$2(event, arg_0)));
                        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"createCustomizedDataContext(...)");
                        DataContext dataContext2 = dataContext;
                        String string = serial = (String)dataContext2.getData(RunningDevicesConstants.SERIAL_NUMBER_KEY);
                        if (string == null) break block1;
                        String string2 = string;
                        EmulatorLiveEditAdapter emulatorLiveEditAdapter = this.$adapter;
                        String it = string2;
                        boolean bl = false;
                        emulatorLiveEditAdapter.unregister(it);
                    }
                }

                private static final void contentAdded$lambda$0(ContentManagerEvent $event, DataSink sink) {
                    Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                    DataSink.Companion.uiDataSnapshot(sink, (Object)$event.getContent().getComponent());
                }

                private static final void contentRemoveQuery$lambda$2(ContentManagerEvent $event, DataSink sink) {
                    Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                    DataSink.Companion.uiDataSnapshot(sink, (Object)$event.getContent().getComponent());
                }
            }));
            Object object = runningDevicesWindow.getContentManagerIfCreated();
            if (object == null || (object = object.getContentsRecursively()) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String s;
                DataContext dataContext;
                Content content2 = (Content)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)IdeUiService.getInstance().createCustomizedDataContext(DataContext.EMPTY_CONTEXT, (DataProvider)((EdtNoGetDataProvider)arg_0 -> LiveEditServiceImpl.addListenersToRunningDevices$lambda$4$lambda$2(content2, arg_0))), (String)"createCustomizedDataContext(...)");
                String serial = (String)dataContext.getData(RunningDevicesConstants.SERIAL_NUMBER_KEY);
                if (serial == null) continue;
                boolean bl2 = false;
                adapter.register(s);
            }
        }
    }

    private static final void _init_$lambda$0(LiveEditServiceImpl this$0) {
        LiveEditDeviceMap.INSTANCE.unregisterProject(this$0.project);
    }

    private static final Boolean notifyAppDeploy$lambda$1(LiveEditServiceImpl this$0, RunProfile $runProfile, com.intellij.execution.Executor $executor) {
        return this$0.isLiveEditable($runProfile, $executor);
    }

    private static final void addListenersToRunningDevices$lambda$4$lambda$2(Content $content, DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataSink.Companion.uiDataSnapshot(sink, (Object)$content.getComponent());
    }

    public static final /* synthetic */ void access$addListenersToRunningDevices(LiveEditServiceImpl $this, EmulatorLiveEditAdapter adapter, ToolWindow runningDevicesWindow) {
        $this.addListenersToRunningDevices(adapter, runningDevicesWindow);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/editors/liveedit/LiveEditServiceImpl$Companion;", "", "<init>", "()V", "hasLiveEditSupportedDeviceConnected", "", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nLiveEditServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveEditServiceImpl.kt\ncom/android/tools/idea/editors/liveedit/LiveEditServiceImpl$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,352:1\n12567#2,2:353\n*S KotlinDebug\n*F\n+ 1 LiveEditServiceImpl.kt\ncom/android/tools/idea/editors/liveedit/LiveEditServiceImpl$Companion\n*L\n178#1:353,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean hasLiveEditSupportedDeviceConnected() {
            boolean bl;
            block1: {
                AndroidDebugBridge androidDebugBridge = AndroidDebugBridge.getBridge();
                Intrinsics.checkNotNull((Object)androidDebugBridge);
                IDevice[] iDeviceArray = androidDebugBridge.getDevices();
                Intrinsics.checkNotNullExpressionValue((Object)iDeviceArray, (String)"getDevices(...)");
                Object[] $this$any$iv = iDeviceArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    IDevice device2 = (IDevice)element$iv;
                    boolean bl2 = false;
                    if (!LiveEditProjectMonitor.supportLiveEdits(device2)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

