/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.util;

import com.android.tools.idea.diagnostics.util.FrameInfo;
import java.lang.management.ThreadInfo;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class ThreadCallTree {
    private long myThreadId;
    private final String myThreadName;
    @NotNull
    private final FrameInfo myRootFrame;

    public String getThreadName() {
        return this.myThreadName;
    }

    @NotNull
    public FrameInfo getRootFrame() {
        return this.myRootFrame;
    }

    public ThreadCallTree(long threadId, String threadName) {
        this.myThreadId = threadId;
        this.myThreadName = threadName;
        this.myRootFrame = new FrameInfo(null);
    }

    public void addThreadInfo(ThreadInfo ti, long timeSpent) {
        this.myRootFrame.addThreadInfo(ti, timeSpent);
    }

    public void addThreadInfoWithLabels(ThreadInfo ti, long timeSpent, @NotNull String leafInfo) {
        this.myRootFrame.addThreadInfo(ti, timeSpent, leafInfo);
    }

    public String getReportString(long frameTimeIgnoreThresholdMs) {
        return this.myThreadName + ", TID: " + this.myThreadId + this.myRootFrame.getReportString(frameTimeIgnoreThresholdMs);
    }

    public int computeMaxDepth() {
        return this.myRootFrame.computeMaxDepth();
    }

    public boolean isAwtThread() {
        return this.myThreadName.startsWith("AWT-EventQueue-");
    }

    public boolean exists(@NotNull Predicate<StackTraceElement> predicate) {
        return this.myRootFrame.exists(predicate);
    }
}

