/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.typing;

import com.android.tools.analytics.crash.GoogleCrashReporter;
import com.android.tools.idea.diagnostics.crash.StudioCrashReporter;
import com.android.tools.idea.diagnostics.freeze.ThreadCallTreeSorter;
import com.android.tools.idea.diagnostics.report.DiagnosticCrashReport;
import com.android.tools.idea.diagnostics.report.DiagnosticReportProperties;
import com.android.tools.idea.diagnostics.util.ThreadCallTree;
import com.android.tools.idea.serverflags.ServerFlagService;
import com.android.tools.idea.serverflags.protos.TypingLatencyReportConfig;
import com.android.tools.idea.stats.EditorStatsUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.Message;
import com.google.wireless.android.sdk.stats.EditorFileType;
import com.intellij.diagnostic.EventWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.LatencyListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.apache.commons.io.FileUtils;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 D2\u00020\u00012\u00020\u0002:\u0007>?@ABCDB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\"\u001a\u00020#H\u0002J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\bJ0\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\bH\u0016J\u0010\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u000200H\u0002J\u0018\u00101\u001a\u00020%2\u0006\u0010/\u001a\u0002002\u0006\u00102\u001a\u00020\fH\u0016J\u0018\u00103\u001a\u00020%2\u0006\u0010/\u001a\u0002002\u0006\u00104\u001a\u00020\fH\u0016J\u0016\u00105\u001a\u00020%2\f\u00106\u001a\b\u0018\u00010\u001aR\u00020\u0000H\u0002J\b\u00107\u001a\u00020%H\u0016J\u0006\u00108\u001a\u00020%J(\u00109\u001a\u00020%2\u0006\u0010:\u001a\u00020#2\u0006\u00102\u001a\u00020\f2\u000e\u0010;\u001a\n\u0012\u0006\b\u0001\u0012\u00020)0<H\u0016J\b\u0010=\u001a\u00020%H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u0010\n\u001a\"\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000bj\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u0001`\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0018\u00010\u001aR\u00020\u00000\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0018\u00010\u001aR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u001c\u001a\u0004\u0018\u00010\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006E"}, d2={"Lcom/android/tools/idea/diagnostics/typing/TypingEventWatcher;", "Lcom/intellij/diagnostic/EventWatcher;", "Lcom/intellij/openapi/Disposable;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "isActive", "", "processKeyEvents", "mergedThreadSnapshots", "Ljava/util/HashMap;", "", "Lcom/android/tools/idea/diagnostics/util/ThreadCallTree;", "Lkotlin/collections/HashMap;", "mergedSnapshotsCount", "", "longestTypingLatencyMs", "slowTypingEventsCount", "missedSlowTypingEventsCount", "myThreadMXBean", "Ljava/lang/management/ThreadMXBean;", "lastTypingLatencySamplingInfo", "Lcom/android/tools/idea/diagnostics/typing/TypingEventWatcher$TypingLatencySamplingInfo;", "taskFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/android/tools/idea/diagnostics/typing/TypingEventWatcher$TypingLatencyCheckerTask;", "currentTypingLatencyCheckerTask", "typingLatencyReportConfig", "Lcom/android/tools/idea/serverflags/protos/TypingLatencyReportConfig;", "getTypingLatencyReportConfig", "()Lcom/android/tools/idea/serverflags/protos/TypingLatencyReportConfig;", "typingLatencyReportConfig$delegate", "Lkotlin/Lazy;", "buildName", "", "collectTypingLatencyDumpsAndSendReport", "", "collectionOnStudioStartup", "runnableTaskFinished", "runnable", "Ljava/lang/Runnable;", "waitedInQueueNs", "queueSize", "executionDurationNs", "wasInSkippedItems", "shouldProcessEvent", "event", "Ljava/awt/AWTEvent;", "edtEventStarted", "startedAtMs", "edtEventFinished", "finishedAtMs", "stopCurrentTaskAndReEmit", "task", "reset", "enableTypingLatencyTracking", "logTimeMillis", "processId", "runnableClass", "Ljava/lang/Class;", "dispose", "TypingLatencyThreadsSample", "TypingLatencySamplingInfo", "TypingLatencySamplingTask", "TypingLatencyCheckerTask", "TypingLatencyCrashReport", "SlowTypingEventListener", "Companion", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nTypingEventWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypingEventWatcher.kt\ncom/android/tools/idea/diagnostics/typing/TypingEventWatcher\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,383:1\n3829#2:384\n4344#2,2:385\n*S KotlinDebug\n*F\n+ 1 TypingEventWatcher.kt\ncom/android/tools/idea/diagnostics/typing/TypingEventWatcher\n*L\n124#1:384\n124#1:385,2\n*E\n"})
public final class TypingEventWatcher
implements EventWatcher,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    private final boolean isActive;
    private boolean processKeyEvents;
    @Nullable
    private HashMap<Long, ThreadCallTree> mergedThreadSnapshots;
    private int mergedSnapshotsCount;
    private long longestTypingLatencyMs;
    private int slowTypingEventsCount;
    private int missedSlowTypingEventsCount;
    @NotNull
    private final ThreadMXBean myThreadMXBean;
    @Nullable
    private TypingLatencySamplingInfo lastTypingLatencySamplingInfo;
    @NotNull
    private final MutableSharedFlow<TypingLatencyCheckerTask> taskFlow;
    @Nullable
    private TypingLatencyCheckerTask currentTypingLatencyCheckerTask;
    @NotNull
    private final Lazy typingLatencyReportConfig$delegate;
    @NotNull
    public static final String TYPING_LATENCY_SERVER_FLAG_NAME = "diagnostics/typing_latency_report";
    @NotNull
    public static final String TYPING_LATENCY_DUMP_PREFIX = "slowTypingLatency";

    public TypingEventWatcher(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.isActive = !ApplicationManager.getApplication().isHeadlessEnvironment();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        Intrinsics.checkNotNullExpressionValue((Object)threadMXBean, (String)"getThreadMXBean(...)");
        this.myThreadMXBean = threadMXBean;
        this.taskFlow = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        this.typingLatencyReportConfig$delegate = LazyKt.lazy(TypingEventWatcher::typingLatencyReportConfig_delegate$lambda$0);
        if (this.isActive) {
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ TypingEventWatcher this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = FlowKt.collectLatest((Flow)((Flow)this.this$0.taskFlow), (Function2)((Function2)new Function2<TypingLatencyCheckerTask, Continuation<? super Unit>, Object>(null){
                                int label;
                                /* synthetic */ Object L$0;

                                /*
                                 * Unable to fully structure code
                                 */
                                public final Object invokeSuspend(Object var1_1) {
                                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)var1_1);
                                            task = (TypingLatencyCheckerTask)this.L$0;
                                            if (task == null) {
                                                return Unit.INSTANCE;
                                            }
                                            this.L$0 = task;
                                            this.label = 1;
                                            v0 = DelayKt.delay((long)task.getDelay(), (Continuation)((Continuation)this));
                                            if (v0 == var3_2) {
                                                return var3_2;
                                            }
                                            ** GOTO lbl18
                                        }
                                        case 1: {
                                            task = (TypingLatencyCheckerTask)this.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl18:
                                            // 2 sources

                                            task.processSlowTypingEvent();
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value2;
                                    return (Continuation)var3_3;
                                }

                                public final Object invoke(TypingLatencyCheckerTask p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ TypingEventWatcher this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
lbl6:
                            // 3 sources

                            while (true) {
                                this.label = 1;
                                v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.HOURS), (Continuation)((Continuation)this));
                                if (v0 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl16
                                break;
                            }
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl16:
                            // 2 sources

                            if (TypingEventWatcher.access$getSlowTypingEventsCount$p(this.this$0) <= 0) ** GOTO lbl6
                            this.this$0.collectTypingLatencyDumpsAndSendReport(false);
                            this.this$0.reset();
                            ** continue;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    private final TypingLatencyReportConfig getTypingLatencyReportConfig() {
        Lazy lazy = this.typingLatencyReportConfig$delegate;
        return (TypingLatencyReportConfig)lazy.getValue();
    }

    private final String buildName() {
        String string = ApplicationInfo.getInstance().getBuild().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void collectTypingLatencyDumpsAndSendReport(boolean collectionOnStudioStartup) {
        void $this$filterTo$iv$iv;
        String typingLatencyFolder = "slowTypingLatency-" + this.buildName();
        Path reportDir = PathManager.getLogDir().resolve(typingLatencyFolder);
        if (!reportDir.toFile().exists()) {
            return;
        }
        File[] fileArray = reportDir.toFile().listFiles();
        if (fileArray == null) return;
        File[] fileArray2 = fileArray;
        boolean $i$f$filter = false;
        File[] fileArray3 = fileArray2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void e = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            String string = e.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.startsWith$default((String)string, (String)TYPING_LATENCY_DUMP_PREFIX, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (arg_0, arg_1) -> TypingEventWatcher.collectTypingLatencyDumpsAndSendReport$lambda$3(TypingEventWatcher::collectTypingLatencyDumpsAndSendReport$lambda$2, arg_0, arg_1));
        if (list == null) return;
        File file = (File)CollectionsKt.lastOrNull((List)list);
        File reportFile = file;
        if (reportFile == null) {
            return;
        }
        Closeable closeable = Files.newBufferedReader(reportFile.toPath());
        Throwable throwable = null;
        try {
            BufferedReader bufferedReader = (BufferedReader)closeable;
            boolean bl = false;
            String string = bufferedReader.readLine();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readLine(...)");
            int reportSlowTypingEventsCount = Integer.parseInt(string);
            String string2 = bufferedReader.readLine();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readLine(...)");
            int reportMissedSlowTypingEventsCount = Integer.parseInt(string2);
            String string3 = bufferedReader.readLine();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"readLine(...)");
            long reportLongestTypingLatencyMs = Long.parseLong(string3);
            StudioCrashReporter studioCrashReporter = StudioCrashReporter.getInstance();
            Intrinsics.checkNotNull((Object)bufferedReader);
            CompletableFuture completableFuture = studioCrashReporter.submit(new TypingLatencyCrashReport(TextStreamsKt.readText((Reader)bufferedReader), reportSlowTypingEventsCount, reportMissedSlowTypingEventsCount, reportLongestTypingLatencyMs, collectionOnStudioStartup));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        FileUtils.deleteDirectory((File)reportDir.toFile());
    }

    public void runnableTaskFinished(@NotNull Runnable runnable2, long waitedInQueueNs, int queueSize, long executionDurationNs, boolean wasInSkippedItems) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
    }

    private final boolean shouldProcessEvent(AWTEvent event) {
        return this.isActive && this.processKeyEvents && this.getTypingLatencyReportConfig() != null && event instanceof KeyEvent && ((KeyEvent)event).getID() == 400 && UIUtil.isReallyTypedEvent((KeyEvent)((KeyEvent)event));
    }

    public void edtEventStarted(@NotNull AWTEvent event, long startedAtMs) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.shouldProcessEvent(event)) {
            this.stopCurrentTaskAndReEmit(new TypingLatencyCheckerTask(((KeyEvent)event).getWhen(), ((KeyEvent)event).getKeyChar()));
        }
    }

    public void edtEventFinished(@NotNull AWTEvent event, long finishedAtMs) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.shouldProcessEvent(event)) {
            this.stopCurrentTaskAndReEmit(null);
        }
    }

    private final void stopCurrentTaskAndReEmit(TypingLatencyCheckerTask task2) {
        this.currentTypingLatencyCheckerTask = task2;
        if (!this.taskFlow.tryEmit((Object)task2)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    public void reset() {
        this.processKeyEvents = true;
        this.mergedSnapshotsCount = 0;
        this.longestTypingLatencyMs = 0L;
        this.mergedThreadSnapshots = Maps.newHashMap();
        this.slowTypingEventsCount = 0;
        this.missedSlowTypingEventsCount = 0;
    }

    public final void enableTypingLatencyTracking() {
        MessageBusConnection messageBusConnection = ApplicationKt.getApplication().getMessageBus().connect((Disposable)this);
        Topic topic = LatencyListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new SlowTypingEventListener());
    }

    public void logTimeMillis(@NotNull String processId, long startedAtMs, @NotNull Class<? extends Runnable> runnableClass) {
        Intrinsics.checkNotNullParameter((Object)processId, (String)"processId");
        Intrinsics.checkNotNullParameter(runnableClass, (String)"runnableClass");
    }

    public void dispose() {
        this.collectTypingLatencyDumpsAndSendReport(false);
    }

    private static final TypingLatencyReportConfig typingLatencyReportConfig_delegate$lambda$0() {
        ServerFlagService serverFlagService = ServerFlagService.Companion.getInstance();
        TypingLatencyReportConfig typingLatencyReportConfig = TypingLatencyReportConfig.getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)typingLatencyReportConfig, (String)"getDefaultInstance(...)");
        return (TypingLatencyReportConfig)serverFlagService.getProtoOrNull(TYPING_LATENCY_SERVER_FLAG_NAME, (Message)typingLatencyReportConfig);
    }

    private static final int collectTypingLatencyDumpsAndSendReport$lambda$2(File o1, File o2) {
        String string = o1.getName();
        String string2 = o2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        return string.compareTo(string2);
    }

    private static final int collectTypingLatencyDumpsAndSendReport$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    public static final /* synthetic */ void access$setProcessKeyEvents$p(TypingEventWatcher $this, boolean bl) {
        $this.processKeyEvents = bl;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/diagnostics/typing/TypingEventWatcher$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "TYPING_LATENCY_SERVER_FLAG_NAME", "", "TYPING_LATENCY_DUMP_PREFIX", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nTypingEventWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypingEventWatcher.kt\ncom/android/tools/idea/diagnostics/typing/TypingEventWatcher$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,383:1\n15#2:384\n*S KotlinDebug\n*F\n+ 1 TypingEventWatcher.kt\ncom/android/tools/idea/diagnostics/typing/TypingEventWatcher$Companion\n*L\n374#1:384\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLOG() {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(TypingEventWatcher.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0017\u001a\u00020\u0011H\u0016J\u001c\u0010\u0018\u001a\u00020\u00152\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J&\u0010\u001c\u001a\u00020\u00152\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001a2\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\u001a\u0010\u001e\u001a\u00020\u00152\b\u0010\u001f\u001a\u0004\u0018\u00010\u001b2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\rH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u000b\u00a8\u0006&"}, d2={"Lcom/android/tools/idea/diagnostics/typing/TypingEventWatcher$SlowTypingEventListener;", "Lcom/intellij/openapi/editor/actionSystem/LatencyListener;", "<init>", "(Lcom/android/tools/idea/diagnostics/typing/TypingEventWatcher;)V", "logDir", "Ljava/nio/file/Path;", "Lorg/jetbrains/annotations/NotNull;", "dateFormat", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "getDateFormat$annotations", "()V", "formatTime", "", "time", "Ljava/time/ZonedDateTime;", "getEditorLastTypedActionTimestamp", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "recordTypingLatency", "", "action", "latencyMs", "saveSlowTypingLatencyReports", "threadSnapshots", "", "Lcom/android/tools/idea/diagnostics/util/ThreadCallTree;", "serializeThreadsReport", "path", "serializeThread", "threadCallTree", "stringBuilder", "Ljava/lang/StringBuilder;", "addThreadSnapshot", "freezeStartThreadInfo", "Ljava/lang/management/ThreadInfo;", "leafInfo", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nTypingEventWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypingEventWatcher.kt\ncom/android/tools/idea/diagnostics/typing/TypingEventWatcher$SlowTypingEventListener\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,383:1\n3829#2:384\n4344#2,2:385\n1863#3,2:387\n381#4,7:389\n*S KotlinDebug\n*F\n+ 1 TypingEventWatcher.kt\ncom/android/tools/idea/diagnostics/typing/TypingEventWatcher$SlowTypingEventListener\n*L\n329#1:384\n329#1:385,2\n329#1:387,2\n363#1:389,7\n*E\n"})
    private final class SlowTypingEventListener
    implements LatencyListener {
        @NotNull
        private final Path logDir;
        private final DateTimeFormatter dateFormat;

        public SlowTypingEventListener() {
            Path path = PathManager.getLogDir();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getLogDir(...)");
            this.logDir = path;
            this.dateFormat = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss");
        }

        private static /* synthetic */ void getDateFormat$annotations() {
        }

        private final String formatTime(ZonedDateTime time2) {
            String string = this.dateFormat.format(time2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return string;
        }

        private final long getEditorLastTypedActionTimestamp(Editor editor) {
            Field field2 = ReflectionUtil.findField(EditorImpl.class, Long.TYPE, (String)"myLastTypedActionTimestamp");
            Intrinsics.checkNotNullExpressionValue((Object)field2, (String)"findField(...)");
            Field field3 = field2;
            Object object = field3.get(editor);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
            return (Long)object;
        }

        public void recordTypingLatency(@NotNull Editor editor, @Nullable String action2, long latencyMs) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            TypingEventWatcher.this.stopCurrentTaskAndReEmit(null);
            TypingLatencyReportConfig typingLatencyReportConfig = TypingEventWatcher.this.getTypingLatencyReportConfig();
            Intrinsics.checkNotNull((Object)typingLatencyReportConfig);
            if (latencyMs > typingLatencyReportConfig.getTypingEventReportThresholdMillis() && TypingEventWatcher.this.lastTypingLatencySamplingInfo == null) {
                int n = TypingEventWatcher.this.missedSlowTypingEventsCount;
                TypingEventWatcher.this.missedSlowTypingEventsCount = n + 1;
            }
            TypingLatencySamplingInfo typingLatencySamplingInfo = TypingEventWatcher.this.lastTypingLatencySamplingInfo;
            if (typingLatencySamplingInfo == null) {
                return;
            }
            TypingLatencySamplingInfo typingLatencySamplingInfo2 = typingLatencySamplingInfo;
            TypingEventWatcher.this.lastTypingLatencySamplingInfo = null;
            long myLastTypedActionTimestamp = this.getEditorLastTypedActionTimestamp(editor);
            if (myLastTypedActionTimestamp != typingLatencySamplingInfo2.getKeyEventStartTimestampMs()) {
                return;
            }
            int n = TypingEventWatcher.this.slowTypingEventsCount;
            TypingEventWatcher.this.slowTypingEventsCount = n + 1;
            TypingEventWatcher.this.longestTypingLatencyMs = Math.max(TypingEventWatcher.this.longestTypingLatencyMs, latencyMs);
            BuildersKt.launch$default((CoroutineScope)TypingEventWatcher.this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(editor, latencyMs, TypingEventWatcher.this, typingLatencySamplingInfo2, this, null){
                Object L$0;
                int label;
                final /* synthetic */ Editor $editor;
                final /* synthetic */ long $latencyMs;
                final /* synthetic */ TypingEventWatcher this$0;
                final /* synthetic */ TypingLatencySamplingInfo $typingLatencySamplingInfo;
                final /* synthetic */ SlowTypingEventListener this$1;
                {
                    this.$editor = $editor;
                    this.$latencyMs = $latencyMs;
                    this.this$0 = $receiver;
                    this.$typingLatencySamplingInfo = $typingLatencySamplingInfo;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var17_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            v0 = FileDocumentManager.getInstance().getFile(this.$editor.getDocument());
                            if (v0 == null) {
                                return Unit.INSTANCE;
                            }
                            file = v0;
                            this.L$0 = file;
                            this.label = 1;
                            v1 = EditorStatsUtil.getEditorFileTypeForAnalytics(file, this.$editor.getProject(), (Continuation<? super EditorFileType>)((Continuation)this));
                            if (v1 == var17_2) {
                                return var17_2;
                            }
                            ** GOTO lbl19
                        }
                        case 1: {
                            file = (VirtualFile)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl19:
                            // 2 sources

                            fileType = (EditorFileType)v1;
                            label = new Ref.ObjectRef();
                            label.element = "latencyMs: " + this.$latencyMs + ", typingId: " + TypingEventWatcher.access$getSlowTypingEventsCount$p(this.this$0) + ", fileType: " + fileType;
                            if (fileType == EditorFileType.UNKNOWN) {
                                label.element = label.element + ", fileExtension: " + file.getExtension();
                            }
                            for (TypingLatencyThreadsSample sample : this.$typingLatencySamplingInfo.getSamples()) {
                                if (sample.isWriteActionPending()) {
                                    for (ThreadInfo threadInfo : sample.getThreadInfo()) {
                                        SlowTypingEventListener.access$addThreadSnapshot(this.this$1, threadInfo, (String)label.element);
                                    }
                                    continue;
                                }
                                $this$filter$iv = sample.getThreadInfo();
                                $i$f$filter = false;
                                var9_13 = $this$filter$iv;
                                destination$iv$iv = new ArrayList<E>();
                                $i$f$filterTo = false;
                                var13_19 = ((void)$this$filterTo$iv$iv).length;
                                for (var12_17 = 0; var12_17 < var13_19; ++var12_17) {
                                    t = element$iv$iv = $this$filterTo$iv$iv[var12_17];
                                    $i$a$-filter-TypingEventWatcher$SlowTypingEventListener$recordTypingLatency$1$1 = false;
                                    if (!(t.getThreadId() == EDT.getEventDispatchThread().getId())) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                $this$forEach$iv = (List)destination$iv$iv;
                                $i$f$filter = this.this$1;
                                $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    e = (ThreadInfo)element$iv;
                                    $i$a$-forEach-TypingEventWatcher$SlowTypingEventListener$recordTypingLatency$1$2 = false;
                                    SlowTypingEventListener.access$addThreadSnapshot($i$f$filter, e, (String)label.element);
                                }
                            }
                            v2 = TypingEventWatcher.access$getMergedThreadSnapshots$p(this.this$0);
                            if (v2 != null) {
                                var6_7 = v2;
                                var7_8 = this.this$1;
                                it = var6_7;
                                $i$a$-let-TypingEventWatcher$SlowTypingEventListener$recordTypingLatency$1$3 = false;
                                SlowTypingEventListener.access$saveSlowTypingLatencyReports((SlowTypingEventListener)var7_8, it);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        /*
         * WARNING - void declaration
         */
        private final void saveSlowTypingLatencyReports(Map<Long, ? extends ThreadCallTree> threadSnapshots) {
            String typingLatencyFolder = "slowTypingLatency-" + TypingEventWatcher.this.buildName();
            Path reportDir = this.logDir.resolve(typingLatencyFolder);
            Files.createDirectories(reportDir, new FileAttribute[0]);
            ZonedDateTime now = ZonedDateTime.now();
            Intrinsics.checkNotNull((Object)now);
            String reportFileName = "slowTypingLatency-" + this.formatTime(now) + "-" + now.toInstant().toEpochMilli() + ".txt";
            Path reportFilePath = reportDir.resolve(reportFileName);
            try {
                int n = TypingEventWatcher.this.mergedSnapshotsCount;
                TypingEventWatcher.this.mergedSnapshotsCount = n + 1;
                Intrinsics.checkNotNull((Object)reportFilePath);
                this.serializeThreadsReport(threadSnapshots, reportFilePath);
                File[] fileArray = reportDir.toFile().listFiles();
                if (fileArray != null) {
                    void $this$filterTo$iv$iv;
                    File[] $this$filter$iv = fileArray;
                    boolean $i$f$filter = false;
                    File[] fileArray2 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    int n2 = ((void)$this$filterTo$iv$iv).length;
                    for (int i = 0; i < n2; ++i) {
                        void element$iv$iv;
                        void f = element$iv$iv = $this$filterTo$iv$iv[i];
                        boolean bl = false;
                        if (!(!f.getName().equals(PathsKt.getName((Path)reportFilePath)))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$forEach$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        File f = (File)element$iv;
                        boolean bl = false;
                        Files.delete(f.toPath());
                    }
                }
            }
            catch (IOException e) {
                Companion.getLOG().warn("Failed to write the thread dump file", (Throwable)e);
            }
        }

        private final void serializeThreadsReport(Map<Long, ? extends ThreadCallTree> threadSnapshots, Path path) {
            if (threadSnapshots == null) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(TypingEventWatcher.this.mergedSnapshotsCount).append("\n");
            sb.append(TypingEventWatcher.this.missedSlowTypingEventsCount).append("\n");
            sb.append(TypingEventWatcher.this.longestTypingLatencyMs).append("\n");
            this.serializeThread(threadSnapshots.get(EDT.getEventDispatchThread().getId()), sb);
            List<ThreadCallTree> sortedCallTrees = new ThreadCallTreeSorter(CollectionsKt.toMutableList(threadSnapshots.values())).sort();
            for (ThreadCallTree callTree : sortedCallTrees) {
                if (callTree.isAwtThread()) continue;
                this.serializeThread(callTree, sb);
            }
            Files.writeString(path, (CharSequence)sb, new OpenOption[0]);
        }

        private final void serializeThread(ThreadCallTree threadCallTree, StringBuilder stringBuilder) {
            if (threadCallTree == null) {
                return;
            }
            stringBuilder.append(threadCallTree.getReportString(0L));
        }

        /*
         * WARNING - void declaration
         */
        private final void addThreadSnapshot(ThreadInfo freezeStartThreadInfo, String leafInfo) {
            block2: {
                Object object;
                void $this$getOrPut$iv;
                HashMap hashMap = TypingEventWatcher.this.mergedThreadSnapshots;
                if (hashMap == null) break block2;
                Map map2 = hashMap;
                Long key$iv = freezeStartThreadInfo.getThreadId();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    ThreadCallTree answer$iv = new ThreadCallTree(freezeStartThreadInfo.getThreadId(), freezeStartThreadInfo.getThreadName());
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ThreadCallTree threadCallTree = (ThreadCallTree)object;
                TypingLatencyReportConfig typingLatencyReportConfig = TypingEventWatcher.this.getTypingLatencyReportConfig();
                Intrinsics.checkNotNull((Object)typingLatencyReportConfig);
                threadCallTree.addThreadInfoWithLabels(freezeStartThreadInfo, typingLatencyReportConfig.getTypingEventReportThresholdMillis(), leafInfo);
            }
        }

        public static final /* synthetic */ void access$addThreadSnapshot(SlowTypingEventListener $this, ThreadInfo freezeStartThreadInfo, String leafInfo) {
            $this.addThreadSnapshot(freezeStartThreadInfo, leafInfo);
        }

        public static final /* synthetic */ void access$saveSlowTypingLatencyReports(SlowTypingEventListener $this, Map threadSnapshots) {
            $this.saveSlowTypingLatencyReports(threadSnapshots);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\f\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\b\u0092\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/diagnostics/typing/TypingEventWatcher$TypingLatencyCheckerTask;", "", "keyEventStartTimestampMs", "", "keyChar", "", "<init>", "(Lcom/android/tools/idea/diagnostics/typing/TypingEventWatcher;JC)V", "getKeyEventStartTimestampMs", "()J", "getKeyChar", "()C", "delay", "getDelay", "processSlowTypingEvent", "", "intellij.android.core"})
    private class TypingLatencyCheckerTask {
        private final long keyEventStartTimestampMs;
        private final char keyChar;
        private final long delay;

        public TypingLatencyCheckerTask(long keyEventStartTimestampMs, char keyChar) {
            this.keyEventStartTimestampMs = keyEventStartTimestampMs;
            this.keyChar = keyChar;
            TypingLatencyReportConfig typingLatencyReportConfig = TypingEventWatcher.this.getTypingLatencyReportConfig();
            Intrinsics.checkNotNull((Object)typingLatencyReportConfig);
            this.delay = typingLatencyReportConfig.getTypingEventReportThresholdMillis();
        }

        public final long getKeyEventStartTimestampMs() {
            return this.keyEventStartTimestampMs;
        }

        public final char getKeyChar() {
            return this.keyChar;
        }

        public long getDelay() {
            return this.delay;
        }

        public void processSlowTypingEvent() {
            ThreadInfo[] allThreads = TypingEventWatcher.this.myThreadMXBean.dumpAllThreads(false, false);
            Intrinsics.checkNotNull((Object)allThreads);
            TypingEventWatcher.this.stopCurrentTaskAndReEmit(new TypingLatencySamplingTask(new TypingLatencyThreadsSample(allThreads, ApplicationManagerEx.getApplicationEx().isWriteActionPending()), this.keyEventStartTimestampMs, this.keyChar));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/diagnostics/typing/TypingEventWatcher$TypingLatencyCrashReport;", "Lcom/android/tools/idea/diagnostics/report/DiagnosticCrashReport;", "uiThreadSnapshot", "", "slowTypingEventsCount", "", "missedSlowTypingEventsCount", "longestTypingLatencyMs", "", "collectionOnStudioStartup", "", "<init>", "(Ljava/lang/String;IIJZ)V", "serialize", "", "builder", "Lorg/apache/http/entity/mime/MultipartEntityBuilder;", "intellij.android.core"})
    public static final class TypingLatencyCrashReport
    extends DiagnosticCrashReport {
        @NotNull
        private final String uiThreadSnapshot;
        private final int slowTypingEventsCount;
        private final int missedSlowTypingEventsCount;
        private long longestTypingLatencyMs;
        private final boolean collectionOnStudioStartup;

        public TypingLatencyCrashReport(@NotNull String uiThreadSnapshot, int slowTypingEventsCount, int missedSlowTypingEventsCount, long longestTypingLatencyMs, boolean collectionOnStudioStartup) {
            Intrinsics.checkNotNullParameter((Object)uiThreadSnapshot, (String)"uiThreadSnapshot");
            super("TypingLatency", new DiagnosticReportProperties(0L, 0L, null, null, null, 31, null));
            this.uiThreadSnapshot = uiThreadSnapshot;
            this.slowTypingEventsCount = slowTypingEventsCount;
            this.missedSlowTypingEventsCount = missedSlowTypingEventsCount;
            this.longestTypingLatencyMs = longestTypingLatencyMs;
            this.collectionOnStudioStartup = collectionOnStudioStartup;
        }

        public void serialize(@NotNull MultipartEntityBuilder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            super.serialize(builder);
            GoogleCrashReporter.addBodyToBuilder((MultipartEntityBuilder)builder, (String)"numberOfSlowTypingEvents", (String)String.valueOf(this.slowTypingEventsCount));
            GoogleCrashReporter.addBodyToBuilder((MultipartEntityBuilder)builder, (String)"missedSlowTypingEventsCount", (String)String.valueOf(this.missedSlowTypingEventsCount));
            GoogleCrashReporter.addBodyToBuilder((MultipartEntityBuilder)builder, (String)"longestTypingLatencyMs", (String)String.valueOf(this.longestTypingLatencyMs));
            GoogleCrashReporter.addBodyToBuilder((MultipartEntityBuilder)builder, (String)"mergedUIThreadStackTraces", (String)this.uiThreadSnapshot);
            GoogleCrashReporter.addBodyToBuilder((MultipartEntityBuilder)builder, (String)"collectionOnStudioStartup", (String)String.valueOf(this.collectionOnStudioStartup));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/diagnostics/typing/TypingEventWatcher$TypingLatencySamplingInfo;", "", "samples", "", "Lcom/android/tools/idea/diagnostics/typing/TypingEventWatcher$TypingLatencyThreadsSample;", "keyEventStartTimestampMs", "", "<init>", "(Ljava/util/List;J)V", "getSamples", "()Ljava/util/List;", "getKeyEventStartTimestampMs", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.android.core"})
    private static final class TypingLatencySamplingInfo {
        @NotNull
        private final List<TypingLatencyThreadsSample> samples;
        private final long keyEventStartTimestampMs;

        public TypingLatencySamplingInfo(@NotNull List<TypingLatencyThreadsSample> samples, long keyEventStartTimestampMs) {
            Intrinsics.checkNotNullParameter(samples, (String)"samples");
            this.samples = samples;
            this.keyEventStartTimestampMs = keyEventStartTimestampMs;
        }

        @NotNull
        public final List<TypingLatencyThreadsSample> getSamples() {
            return this.samples;
        }

        public final long getKeyEventStartTimestampMs() {
            return this.keyEventStartTimestampMs;
        }

        @NotNull
        public final List<TypingLatencyThreadsSample> component1() {
            return this.samples;
        }

        public final long component2() {
            return this.keyEventStartTimestampMs;
        }

        @NotNull
        public final TypingLatencySamplingInfo copy(@NotNull List<TypingLatencyThreadsSample> samples, long keyEventStartTimestampMs) {
            Intrinsics.checkNotNullParameter(samples, (String)"samples");
            return new TypingLatencySamplingInfo(samples, keyEventStartTimestampMs);
        }

        public static /* synthetic */ TypingLatencySamplingInfo copy$default(TypingLatencySamplingInfo typingLatencySamplingInfo, List list, long l, int n, Object object) {
            if ((n & 1) != 0) {
                list = typingLatencySamplingInfo.samples;
            }
            if ((n & 2) != 0) {
                l = typingLatencySamplingInfo.keyEventStartTimestampMs;
            }
            return typingLatencySamplingInfo.copy(list, l);
        }

        @NotNull
        public String toString() {
            return "TypingLatencySamplingInfo(samples=" + this.samples + ", keyEventStartTimestampMs=" + this.keyEventStartTimestampMs + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.samples).hashCode();
            result2 = result2 * 31 + Long.hashCode(this.keyEventStartTimestampMs);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TypingLatencySamplingInfo)) {
                return false;
            }
            TypingLatencySamplingInfo typingLatencySamplingInfo = (TypingLatencySamplingInfo)other;
            if (!Intrinsics.areEqual(this.samples, typingLatencySamplingInfo.samples)) {
                return false;
            }
            return this.keyEventStartTimestampMs == typingLatencySamplingInfo.keyEventStartTimestampMs;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\f\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/diagnostics/typing/TypingEventWatcher$TypingLatencySamplingTask;", "Lcom/android/tools/idea/diagnostics/typing/TypingEventWatcher$TypingLatencyCheckerTask;", "Lcom/android/tools/idea/diagnostics/typing/TypingEventWatcher;", "freezeStartThreadsSample", "Lcom/android/tools/idea/diagnostics/typing/TypingEventWatcher$TypingLatencyThreadsSample;", "keyEventStartTimestampMs", "", "keyChar", "", "<init>", "(Lcom/android/tools/idea/diagnostics/typing/TypingEventWatcher;Lcom/android/tools/idea/diagnostics/typing/TypingEventWatcher$TypingLatencyThreadsSample;JC)V", "getFreezeStartThreadsSample", "()Lcom/android/tools/idea/diagnostics/typing/TypingEventWatcher$TypingLatencyThreadsSample;", "delay", "getDelay", "()J", "processSlowTypingEvent", "", "intellij.android.core"})
    private final class TypingLatencySamplingTask
    extends TypingLatencyCheckerTask {
        @NotNull
        private final TypingLatencyThreadsSample freezeStartThreadsSample;
        private final long delay;

        public TypingLatencySamplingTask(TypingLatencyThreadsSample freezeStartThreadsSample, long keyEventStartTimestampMs, char keyChar) {
            Intrinsics.checkNotNullParameter((Object)freezeStartThreadsSample, (String)"freezeStartThreadsSample");
            super(keyEventStartTimestampMs, keyChar);
            this.freezeStartThreadsSample = freezeStartThreadsSample;
            TypingLatencyReportConfig typingLatencyReportConfig = TypingEventWatcher.this.getTypingLatencyReportConfig();
            Intrinsics.checkNotNull((Object)typingLatencyReportConfig);
            this.delay = typingLatencyReportConfig.getSamplingIntervalMillis();
        }

        @NotNull
        public final TypingLatencyThreadsSample getFreezeStartThreadsSample() {
            return this.freezeStartThreadsSample;
        }

        @Override
        public long getDelay() {
            return this.delay;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void processSlowTypingEvent() {
            v0 = TypingEventWatcher.access$getMergedSnapshotsCount$p(TypingEventWatcher.this);
            v1 = TypingEventWatcher.access$getTypingLatencyReportConfig(TypingEventWatcher.this);
            Intrinsics.checkNotNull((Object)v1);
            if (v0 >= v1.getMaxNumberOfSnapshotsPerReport()) {
                TypingEventWatcher.access$setProcessKeyEvents$p(TypingEventWatcher.this, false);
                return;
            }
            allThreads = TypingEventWatcher.access$getMyThreadMXBean$p(TypingEventWatcher.this).dumpAllThreads(false, false);
            Intrinsics.checkNotNull((Object)allThreads);
            typingLatencyThreadsSample = new TypingLatencyThreadsSample(allThreads, ApplicationManagerEx.getApplicationEx().isWriteActionPending());
            if (TypingEventWatcher.access$getLastTypingLatencySamplingInfo$p(TypingEventWatcher.this) == null) ** GOTO lbl-1000
            v2 = TypingEventWatcher.access$getLastTypingLatencySamplingInfo$p(TypingEventWatcher.this);
            v3 = v2 != null ? v2.getKeyEventStartTimestampMs() == this.getKeyEventStartTimestampMs() : false;
            if (v3) {
                v4 = TypingEventWatcher.access$getLastTypingLatencySamplingInfo$p(TypingEventWatcher.this);
                if (v4 != null && (v4 = v4.getSamples()) != null) {
                    v4.add(typingLatencyThreadsSample);
                }
                if ((v5 = TypingEventWatcher.access$getLastTypingLatencySamplingInfo$p(TypingEventWatcher.this)) != null && (v5 = v5.getSamples()) != null) {
                    it = v5.size();
                    $i$a$-let-TypingEventWatcher$TypingLatencySamplingTask$processSlowTypingEvent$1 = false;
                    if (it > 100) {
                        return;
                    }
                }
            } else lbl-1000:
            // 2 sources

            {
                var3_5 = new TypingLatencyThreadsSample[]{this.freezeStartThreadsSample, typingLatencyThreadsSample};
                v6 = Lists.newArrayList((Object[])var3_5);
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"newArrayList(...)");
                TypingEventWatcher.access$setLastTypingLatencySamplingInfo$p(TypingEventWatcher.this, new TypingLatencySamplingInfo(v6, this.getKeyEventStartTimestampMs()));
            }
            TypingEventWatcher.access$stopCurrentTaskAndReEmit(TypingEventWatcher.this, new TypingLatencySamplingTask(new TypingLatencyThreadsSample(allThreads, ApplicationManagerEx.getApplicationEx().isWriteActionPending()), this.getKeyEventStartTimestampMs(), this.getKeyChar()));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J(\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/diagnostics/typing/TypingEventWatcher$TypingLatencyThreadsSample;", "", "threadInfo", "", "Ljava/lang/management/ThreadInfo;", "isWriteActionPending", "", "<init>", "([Ljava/lang/management/ThreadInfo;Z)V", "getThreadInfo", "()[Ljava/lang/management/ThreadInfo;", "[Ljava/lang/management/ThreadInfo;", "()Z", "component1", "component2", "copy", "([Ljava/lang/management/ThreadInfo;Z)Lcom/android/tools/idea/diagnostics/typing/TypingEventWatcher$TypingLatencyThreadsSample;", "equals", "other", "hashCode", "", "toString", "", "intellij.android.core"})
    private static final class TypingLatencyThreadsSample {
        @NotNull
        private final ThreadInfo[] threadInfo;
        private final boolean isWriteActionPending;

        public TypingLatencyThreadsSample(@NotNull ThreadInfo[] threadInfo, boolean isWriteActionPending) {
            Intrinsics.checkNotNullParameter((Object)threadInfo, (String)"threadInfo");
            this.threadInfo = threadInfo;
            this.isWriteActionPending = isWriteActionPending;
        }

        @NotNull
        public final ThreadInfo[] getThreadInfo() {
            return this.threadInfo;
        }

        public final boolean isWriteActionPending() {
            return this.isWriteActionPending;
        }

        @NotNull
        public final ThreadInfo[] component1() {
            return this.threadInfo;
        }

        public final boolean component2() {
            return this.isWriteActionPending;
        }

        @NotNull
        public final TypingLatencyThreadsSample copy(@NotNull ThreadInfo[] threadInfo, boolean isWriteActionPending) {
            Intrinsics.checkNotNullParameter((Object)threadInfo, (String)"threadInfo");
            return new TypingLatencyThreadsSample(threadInfo, isWriteActionPending);
        }

        public static /* synthetic */ TypingLatencyThreadsSample copy$default(TypingLatencyThreadsSample typingLatencyThreadsSample, ThreadInfo[] threadInfoArray, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                threadInfoArray = typingLatencyThreadsSample.threadInfo;
            }
            if ((n & 2) != 0) {
                bl = typingLatencyThreadsSample.isWriteActionPending;
            }
            return typingLatencyThreadsSample.copy(threadInfoArray, bl);
        }

        @NotNull
        public String toString() {
            return "TypingLatencyThreadsSample(threadInfo=" + Arrays.toString(this.threadInfo) + ", isWriteActionPending=" + this.isWriteActionPending + ")";
        }

        public int hashCode() {
            int result2 = Arrays.hashCode(this.threadInfo);
            result2 = result2 * 31 + Boolean.hashCode(this.isWriteActionPending);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TypingLatencyThreadsSample)) {
                return false;
            }
            TypingLatencyThreadsSample typingLatencyThreadsSample = (TypingLatencyThreadsSample)other;
            if (!Intrinsics.areEqual((Object)this.threadInfo, (Object)typingLatencyThreadsSample.threadInfo)) {
                return false;
            }
            return this.isWriteActionPending == typingLatencyThreadsSample.isWriteActionPending;
        }
    }
}

