/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.jfr.analysis;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/diagnostics/jfr/analysis/IdleStacks;", "", "<init>", "()V", "Companion", "intellij.android.core"})
public final class IdleStacks {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<Pair<String, List<String>>> idlePatterns;

    static {
        Object[] objectArray = new Pair[7];
        Object[] objectArray2 = new String[]{"sun.nio.ch.WindowsSelectorImpl$SubSelector.poll0", "sun.nio.ch.KQueue.poll", "sun.nio.ch.EPoll.wait"};
        objectArray[0] = TuplesKt.to((Object)"", (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray[1] = TuplesKt.to((Object)"fsnotifier.exe", (Object)CollectionsKt.listOf((Object)"java.lang.ProcessImpl.waitForInterruptibly"));
        objectArray[2] = TuplesKt.to((Object)"AWT-Windows", (Object)CollectionsKt.listOf((Object)"sun.awt.windows.WToolkit.eventLoop"));
        objectArray[3] = TuplesKt.to((Object)"BaseDataReader", (Object)CollectionsKt.listOf((Object)"java.io.FileInputStream.readBytes"));
        objectArray[4] = TuplesKt.to((Object)"Monitor", (Object)CollectionsKt.listOf((Object)"sun.nio.ch.FileDispatcherImpl.read0"));
        objectArray[5] = TuplesKt.to((Object)"process reaper", (Object)CollectionsKt.listOf((Object)"java.lang.ProcessHandleImpl.waitForProcessExit0"));
        objectArray[6] = TuplesKt.to((Object)"AWT-XAWT", (Object)CollectionsKt.listOf((Object)"sun.awt.X11.XToolkit.waitForEvents"));
        idlePatterns = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tJ\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R&\u0010\u000b\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\t0\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/diagnostics/jfr/analysis/IdleStacks$Companion;", "", "<init>", "()V", "isIdle", "", "threadName", "", "stacktrace", "", "isIgnoredThread", "idlePatterns", "Lkotlin/Pair;", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nIdleStacks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdleStacks.kt\ncom/android/tools/idea/diagnostics/jfr/analysis/IdleStacks$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,40:1\n1863#2,2:41\n*S KotlinDebug\n*F\n+ 1 IdleStacks.kt\ncom/android/tools/idea/diagnostics/jfr/analysis/IdleStacks$Companion\n*L\n21#1:41,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isIdle(@NotNull String threadName, @NotNull List<String> stacktrace) {
            Intrinsics.checkNotNullParameter((Object)threadName, (String)"threadName");
            Intrinsics.checkNotNullParameter(stacktrace, (String)"stacktrace");
            Iterable $this$forEach$iv = idlePatterns;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                String prefix = (String)pair.component1();
                List topFrameCandidates = (List)pair.component2();
                String topFrame = StringsKt.substringBefore$default((String)stacktrace.get(0), (String)"(", null, (int)2, null);
                if (!StringsKt.startsWith$default((String)threadName, (String)prefix, (boolean)false, (int)2, null) || !topFrameCandidates.contains(topFrame)) continue;
                return true;
            }
            return false;
        }

        public final boolean isIgnoredThread(@NotNull String threadName) {
            Intrinsics.checkNotNullParameter((Object)threadName, (String)"threadName");
            return CollectionsKt.listOf((Object)"JFR Periodic Tasks").contains(threadName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

