/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.navigator;

import com.android.tools.idea.diagnostics.hprof.classstore.ClassDefinition;
import com.android.tools.idea.diagnostics.hprof.classstore.ClassStore;
import com.android.tools.idea.diagnostics.hprof.classstore.InstanceField;
import com.android.tools.idea.diagnostics.hprof.classstore.StaticField;
import com.android.tools.idea.diagnostics.hprof.navigator.ObjectNavigator;
import com.android.tools.idea.diagnostics.hprof.navigator.RootReason;
import com.android.tools.idea.diagnostics.hprof.parser.Type;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001>B=\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0016J\b\u0010#\u001a\u00020\u0019H\u0016J\b\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\rH\u0016J\b\u0010+\u001a\u00020'H\u0002J\u0018\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020\r2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010.\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010/\u001a\u00020'2\u0006\u00100\u001a\u00020\u00112\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u00103\u001a\u00020%2\u0006\u00100\u001a\u00020\u0011H\u0002J\b\u00104\u001a\u00020'H\u0002J\b\u00105\u001a\u00020\u000bH\u0016J\b\u00106\u001a\u00020\u000bH\u0016J\b\u00107\u001a\u00020\rH\u0016J\b\u00108\u001a\u00020\rH\u0016J\u0010\u00109\u001a\u00020'2\u0006\u0010:\u001a\u00020\u0019H\u0016J\u0012\u0010;\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\f\u0010<\u001a\u00020\r*\u00020\u0006H\u0002J\f\u0010=\u001a\u00020\r*\u00020\u0006H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0010\u00101\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/navigator/ObjectNavigatorOnAuxFiles;", "Lcom/android/tools/idea/diagnostics/hprof/navigator/ObjectNavigator;", "roots", "Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "Lcom/android/tools/idea/diagnostics/hprof/navigator/RootReason;", "auxOffsets", "Ljava/nio/ByteBuffer;", "aux", "classStore", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassStore;", "instanceCount", "", "idSize", "", "<init>", "(Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;Ljava/nio/ByteBuffer;Ljava/nio/ByteBuffer;Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassStore;JI)V", "getClass", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "getClassForObjectId", "id", "softWeakReferenceIndex", "currentObjectId", "arraySize", "currentClass", "references", "Lit/unimi/dsi/fastutil/longs/LongArrayList;", "softWeakReferenceId", "referenceType", "Lcom/android/tools/idea/diagnostics/hprof/navigator/ObjectNavigatorOnAuxFiles$ReferenceType;", "extraData", "getId", "()J", "createRootsIterator", "", "Lcom/android/tools/idea/diagnostics/hprof/navigator/ObjectNavigator$RootObject;", "getReferencesCopy", "isNull", "", "goTo", "", "referenceResolution", "Lcom/android/tools/idea/diagnostics/hprof/navigator/ObjectNavigator$ReferenceResolution;", "getExtraData", "preloadPrimitiveArray", "preloadClass", "classId", "preloadObjectArray", "preloadInstance", "classDefinition", "directByteBufferClass", "editorImplClass", "isExtraDataPresent", "preloadExtraData", "getSoftReferenceId", "getWeakReferenceId", "getSoftWeakReferenceIndex", "getObjectSize", "copyReferencesTo", "outReferences", "getRootReasonForObjectId", "readId", "readNonNegativeLEB128Int", "ReferenceType", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nObjectNavigatorOnAuxFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectNavigatorOnAuxFiles.kt\ncom/android/tools/idea/diagnostics/hprof/navigator/ObjectNavigatorOnAuxFiles\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,294:1\n13430#2,2:295\n13402#2,2:297\n13402#2,2:299\n1310#2,2:301\n1730#2,6:303\n*S KotlinDebug\n*F\n+ 1 ObjectNavigatorOnAuxFiles.kt\ncom/android/tools/idea/diagnostics/hprof/navigator/ObjectNavigatorOnAuxFiles\n*L\n137#1:295,2\n138#1:297,2\n172#1:299,2\n260#1:301,2\n265#1:303,6\n*E\n"})
public final class ObjectNavigatorOnAuxFiles
extends ObjectNavigator {
    @NotNull
    private final Long2ObjectOpenHashMap<RootReason> roots;
    @NotNull
    private final ByteBuffer auxOffsets;
    @NotNull
    private final ByteBuffer aux;
    private final int idSize;
    private int softWeakReferenceIndex;
    private long currentObjectId;
    private int arraySize;
    @Nullable
    private ClassDefinition currentClass;
    @NotNull
    private final LongArrayList references;
    private long softWeakReferenceId;
    @NotNull
    private ReferenceType referenceType;
    private int extraData;
    @Nullable
    private final ClassDefinition directByteBufferClass;
    @Nullable
    private final ClassDefinition editorImplClass;

    public ObjectNavigatorOnAuxFiles(@NotNull Long2ObjectOpenHashMap<RootReason> roots, @NotNull ByteBuffer auxOffsets, @NotNull ByteBuffer aux, @NotNull ClassStore classStore, long instanceCount, int idSize) {
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)auxOffsets, (String)"auxOffsets");
        Intrinsics.checkNotNullParameter((Object)aux, (String)"aux");
        Intrinsics.checkNotNullParameter((Object)classStore, (String)"classStore");
        super(classStore, instanceCount);
        this.roots = roots;
        this.auxOffsets = auxOffsets;
        this.aux = aux;
        this.idSize = idSize;
        this.softWeakReferenceIndex = -1;
        this.references = new LongArrayList();
        this.referenceType = ReferenceType.Strong;
        this.directByteBufferClass = classStore.getClassIfExists("java.nio.DirectByteBuffer");
        this.editorImplClass = classStore.getClassIfExists("com.intellij.openapi.editor.impl.EditorImpl");
    }

    @Override
    @NotNull
    public ClassDefinition getClass() {
        ClassDefinition classDefinition = this.currentClass;
        Intrinsics.checkNotNull((Object)classDefinition);
        return classDefinition;
    }

    @Override
    @NotNull
    public ClassDefinition getClassForObjectId(long id2) {
        this.auxOffsets.position((int)(id2 * (long)4));
        this.aux.position(this.auxOffsets.getInt());
        int classId = this.readId(this.aux);
        return classId == 0 ? this.getClassStore().getClassClass() : this.getClassStore().get(classId);
    }

    @Override
    public long getId() {
        return this.currentObjectId;
    }

    @Override
    @NotNull
    public Iterator<ObjectNavigator.RootObject> createRootsIterator() {
        return new Iterator<ObjectNavigator.RootObject>(this){
            private final Iterator<Map.Entry<Long, RootReason>> internalIterator;
            {
                this.internalIterator = ((Map)ObjectNavigatorOnAuxFiles.access$getRoots$p($receiver)).entrySet().iterator();
            }

            public final Iterator<Map.Entry<Long, RootReason>> getInternalIterator() {
                return this.internalIterator;
            }

            public boolean hasNext() {
                return this.internalIterator.hasNext();
            }

            public ObjectNavigator.RootObject next() {
                Map.Entry<Long, RootReason> entry = this.internalIterator.next();
                Long id2 = entry.getKey();
                RootReason reason = entry.getValue();
                Intrinsics.checkNotNull((Object)id2);
                long l = id2;
                Intrinsics.checkNotNull((Object)reason);
                return new ObjectNavigator.RootObject(l, reason);
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @Override
    @NotNull
    public LongArrayList getReferencesCopy() {
        LongArrayList result2 = new LongArrayList();
        int n = ((Collection)this.references).size();
        for (int i = 0; i < n; ++i) {
            result2.add(this.references.getLong(i));
        }
        return result2;
    }

    @Override
    public boolean isNull() {
        return this.getId() == 0L;
    }

    @Override
    public void goTo(long id2, @NotNull ObjectNavigator.ReferenceResolution referenceResolution) {
        Intrinsics.checkNotNullParameter((Object)((Object)referenceResolution), (String)"referenceResolution");
        this.auxOffsets.position((int)(id2 * (long)4));
        this.aux.position(this.auxOffsets.getInt());
        this.currentObjectId = id2;
        this.references.clear();
        this.softWeakReferenceId = 0L;
        this.softWeakReferenceIndex = -1;
        this.referenceType = ReferenceType.Strong;
        this.extraData = 0;
        if (id2 == 0L) {
            this.currentClass = null;
            return;
        }
        int classId = this.readId(this.aux);
        ClassDefinition classDefinition = null;
        classDefinition = classId == 0 ? this.getClassStore().getClassClass() : this.getClassStore().get(classId);
        this.currentClass = classDefinition;
        if (classId == 0) {
            this.preloadClass((int)id2, referenceResolution);
            return;
        }
        if (classDefinition.isPrimitiveArray()) {
            this.preloadPrimitiveArray();
            return;
        }
        if (classDefinition.isArray()) {
            this.preloadObjectArray(referenceResolution);
            return;
        }
        this.preloadInstance(classDefinition, referenceResolution);
    }

    @Override
    public int getExtraData() {
        return this.extraData;
    }

    private final void preloadPrimitiveArray() {
        this.arraySize = this.readNonNegativeLEB128Int(this.aux);
    }

    /*
     * WARNING - void declaration
     */
    private final void preloadClass(int classId, ObjectNavigator.ReferenceResolution referenceResolution) {
        this.arraySize = 0;
        if (referenceResolution != ObjectNavigator.ReferenceResolution.NO_REFERENCES) {
            int n;
            StaticField[] $this$forEach$iv;
            ClassDefinition classDefinition = this.getClassStore().get(classId);
            long[] lArray = classDefinition.getConstantFields();
            LongArrayList longArrayList = this.references;
            boolean $i$f$forEach = false;
            int n2 = $this$forEach$iv.length;
            for (n = 0; n < n2; ++n) {
                void element$iv;
                void p0 = element$iv = $this$forEach$iv[n];
                boolean bl = false;
                longArrayList.add((long)p0);
            }
            $this$forEach$iv = classDefinition.getStaticFields();
            boolean $i$f$forEach2 = false;
            n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                StaticField element$iv;
                StaticField it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                this.references.add(it.getObjectId());
            }
        }
    }

    private final void preloadObjectArray(ObjectNavigator.ReferenceResolution referenceResolution) {
        int nullElementsCount = this.readNonNegativeLEB128Int(this.aux);
        int nonNullElementsCount = this.readNonNegativeLEB128Int(this.aux);
        this.arraySize = nullElementsCount + nonNullElementsCount;
        if (referenceResolution != ObjectNavigator.ReferenceResolution.NO_REFERENCES) {
            for (int i = 0; i < nonNullElementsCount; ++i) {
                this.references.add((long)this.readId(this.aux));
            }
        }
    }

    private final void preloadInstance(ClassDefinition classDefinition, ObjectNavigator.ReferenceResolution referenceResolution) {
        this.arraySize = 0;
        if (referenceResolution == ObjectNavigator.ReferenceResolution.NO_REFERENCES) {
            return;
        }
        ClassDefinition c = classDefinition;
        boolean isSoftReference = false;
        boolean isWeakReference = false;
        boolean includeSoftWeakReferences = referenceResolution == ObjectNavigator.ReferenceResolution.ALL_REFERENCES;
        boolean includeInnerClassRefs = referenceResolution != ObjectNavigator.ReferenceResolution.STRONG_EXCLUDING_INNER_CLASS;
        while (true) {
            InstanceField[] fields2;
            isSoftReference = isSoftReference || Intrinsics.areEqual((Object)this.getClassStore().getSoftReferenceClass(), (Object)c);
            isWeakReference = isWeakReference || Intrinsics.areEqual((Object)this.getClassStore().getWeakReferenceClass(), (Object)c);
            InstanceField[] $this$forEach$iv = fields2 = c.getRefInstanceFields();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                boolean bl;
                InstanceField element$iv;
                InstanceField it = element$iv = $this$forEach$iv[i];
                boolean bl2 = false;
                int reference = this.readId(this.aux);
                if (!isSoftReference && !isWeakReference || !Intrinsics.areEqual((Object)it.getName(), (Object)"referent")) {
                    if (Intrinsics.areEqual((Object)it.getName(), (Object)"this$0") && !includeInnerClassRefs) {
                        bl = this.references.add(0L);
                        continue;
                    }
                    bl = this.references.add((long)reference);
                    continue;
                }
                this.softWeakReferenceId = reference;
                this.softWeakReferenceIndex = ((Collection)this.references).size();
                this.referenceType = isSoftReference ? ReferenceType.Soft : ReferenceType.Weak;
                bl = includeSoftWeakReferences ? this.references.add((long)reference) : this.references.add(0L);
            }
            long superClassId = c.getSuperClassId();
            if (superClassId == 0L) break;
            c = this.getClassStore().get(superClassId);
        }
        if (this.isExtraDataPresent(classDefinition)) {
            this.preloadExtraData();
        }
    }

    private final boolean isExtraDataPresent(ClassDefinition classDefinition) {
        return Intrinsics.areEqual((Object)classDefinition, (Object)this.directByteBufferClass) || Intrinsics.areEqual((Object)classDefinition, (Object)this.editorImplClass);
    }

    private final void preloadExtraData() {
        this.extraData = this.readNonNegativeLEB128Int(this.aux);
    }

    @Override
    public long getSoftReferenceId() {
        return this.referenceType == ReferenceType.Soft ? this.softWeakReferenceId : 0L;
    }

    @Override
    public long getWeakReferenceId() {
        return this.referenceType == ReferenceType.Weak ? this.softWeakReferenceId : 0L;
    }

    @Override
    public int getSoftWeakReferenceIndex() {
        return this.softWeakReferenceIndex;
    }

    @Override
    public int getObjectSize() {
        ClassDefinition classDefinition = this.currentClass;
        if (classDefinition == null) {
            return this.idSize;
        }
        ClassDefinition localClass = classDefinition;
        return localClass.isPrimitiveArray() ? localClass.getInstanceSize() + Type.Companion.getType(localClass.getName()).getSize() * this.arraySize + ClassDefinition.Companion.getARRAY_PREAMBLE_SIZE() : (localClass.isArray() ? localClass.getInstanceSize() + this.idSize * this.arraySize + ClassDefinition.Companion.getARRAY_PREAMBLE_SIZE() : localClass.getInstanceSize() + ClassDefinition.Companion.getOBJECT_PREAMBLE_SIZE());
    }

    @Override
    public void copyReferencesTo(@NotNull LongArrayList outReferences) {
        Intrinsics.checkNotNullParameter((Object)outReferences, (String)"outReferences");
        outReferences.clear();
        outReferences.ensureCapacity(((Collection)this.references).size());
        int n = ((Collection)this.references).size();
        for (int i = 0; i < n; ++i) {
            outReferences.add(this.references.getLong(i));
        }
    }

    @Override
    @Nullable
    public RootReason getRootReasonForObjectId(long id2) {
        Ref.ObjectRef rootReason = new Ref.ObjectRef();
        rootReason.element = this.roots.get(id2);
        if (rootReason.element != null && !((RootReason)rootReason.element).getJavaFrame()) {
            return (RootReason)rootReason.element;
        }
        this.getClassStore().forEachClass((Function1<? super ClassDefinition, Unit>)((Function1)arg_0 -> ObjectNavigatorOnAuxFiles.getRootReasonForObjectId$lambda$5(id2, rootReason, arg_0)));
        return (RootReason)rootReason.element;
    }

    private final int readId(ByteBuffer $this$readId) {
        return this.readNonNegativeLEB128Int($this$readId);
    }

    private final int readNonNegativeLEB128Int(ByteBuffer $this$readNonNegativeLEB128Int) {
        int v = 0;
        int shift = 0;
        while (true) {
            byte b = $this$readNonNegativeLEB128Int.get();
            v |= (byte)(b & 0x7F) << shift;
            if (b >= 0) break;
            shift += 7;
        }
        return v;
    }

    private static final Unit getRootReasonForObjectId$lambda$5(long $id, Ref.ObjectRef $rootReason, ClassDefinition classDefinition) {
        int index;
        block6: {
            int n;
            StaticField staticField;
            int n2;
            block5: {
                StaticField staticField2;
                Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
                if (classDefinition.getId() == $id) {
                    $rootReason.element = RootReason.Companion.createClassDefinitionReason(classDefinition);
                }
                StaticField[] $this$firstOrNull$iv = classDefinition.getStaticFields();
                boolean $i$f$firstOrNull = false;
                n2 = $this$firstOrNull$iv.length;
                for (int i = 0; i < n2; ++i) {
                    StaticField element$iv;
                    StaticField it = element$iv = $this$firstOrNull$iv[i];
                    boolean bl = false;
                    if (!(it.getObjectId() == $id)) continue;
                    staticField2 = element$iv;
                    break block5;
                }
                staticField2 = staticField = null;
            }
            if (staticField != null) {
                StaticField it = staticField;
                boolean bl = false;
                $rootReason.element = RootReason.Companion.createStaticFieldReferenceReason(classDefinition, it.getName());
            }
            long[] $this$indexOfFirst$iv = classDefinition.getConstantFields();
            boolean $i$f$indexOfFirst = false;
            n2 = $this$indexOfFirst$iv.length;
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                long it = $this$indexOfFirst$iv[index$iv];
                boolean bl = false;
                if (!(it == $id)) continue;
                n = index$iv;
                break block6;
            }
            n = index = -1;
        }
        if (index != -1) {
            $rootReason.element = RootReason.Companion.createConstantReferenceReason(classDefinition, index);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Long2ObjectOpenHashMap access$getRoots$p(ObjectNavigatorOnAuxFiles $this) {
        return $this.roots;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/navigator/ObjectNavigatorOnAuxFiles$ReferenceType;", "", "<init>", "(Ljava/lang/String;I)V", "Strong", "Weak", "Soft", "intellij.android.core"})
    private static final class ReferenceType
    extends Enum<ReferenceType> {
        public static final /* enum */ ReferenceType Strong = new ReferenceType();
        public static final /* enum */ ReferenceType Weak = new ReferenceType();
        public static final /* enum */ ReferenceType Soft = new ReferenceType();
        private static final /* synthetic */ ReferenceType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ReferenceType[] values() {
            return (ReferenceType[])$VALUES.clone();
        }

        public static ReferenceType valueOf(String value2) {
            return Enum.valueOf(ReferenceType.class, value2);
        }

        @NotNull
        public static EnumEntries<ReferenceType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = referenceTypeArray = new ReferenceType[]{ReferenceType.Strong, ReferenceType.Weak, ReferenceType.Soft};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

