/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.classstore;

import com.android.tools.idea.diagnostics.hprof.classstore.ClassDefinition;
import com.android.tools.idea.diagnostics.hprof.parser.Type;
import com.android.tools.idea.diagnostics.hprof.util.IDMapper;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0086\u0002J\u0011\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u001aH\u0086\u0002J\u0011\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\tH\u0086\u0002J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001b\u001a\u00020\tJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\tJ\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00042\u0006\u0010 \u001a\u00020\u0016J\u0006\u0010!\u001a\u00020\u0019J\u000e\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u0004J\u001a\u0010$\u001a\u00020%2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020%0'J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u0004R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0004`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u00040\fj\b\u0012\u0004\u0012\u00020\u0004`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R*\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00040\bj\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0004`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassStore;", "", "classes", "Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "<init>", "(Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;)V", "stringToClassDefinition", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "classDefinitionToShortPrettyName", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "softReferenceClass", "getSoftReferenceClass", "()Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "weakReferenceClass", "getWeakReferenceClass", "classClass", "getClassClass", "primitiveArrayToClassDefinition", "Lcom/android/tools/idea/diagnostics/hprof/parser/Type;", "get", "id", "", "", "name", "getClassIfExists", "containsClass", "", "getClassForPrimitiveArray", "t", "size", "isSoftOrWeakReferenceClass", "classDefinition", "forEachClass", "", "func", "Lkotlin/Function1;", "createStoreWithRemappedIDs", "idMapper", "Lcom/android/tools/idea/diagnostics/hprof/util/IDMapper;", "getShortPrettyNameForClass", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nClassStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassStore.kt\ncom/android/tools/idea/diagnostics/hprof/classstore/ClassStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,172:1\n1863#2,2:173\n1863#2,2:175\n1863#2,2:179\n1863#2,2:183\n1863#2,2:185\n13402#3,2:177\n216#4,2:181\n*S KotlinDebug\n*F\n+ 1 ClassStore.kt\ncom/android/tools/idea/diagnostics/hprof/classstore/ClassStore\n*L\n43#1:173,2\n77#1:175,2\n94#1:179,2\n143#1:183,2\n151#1:185,2\n84#1:177,2\n108#1:181,2\n*E\n"})
public final class ClassStore {
    @NotNull
    private final Long2ObjectOpenHashMap<ClassDefinition> classes;
    @NotNull
    private final HashMap<String, ClassDefinition> stringToClassDefinition;
    @NotNull
    private final HashSet<ClassDefinition> classDefinitionToShortPrettyName;
    @NotNull
    private final ClassDefinition softReferenceClass;
    @NotNull
    private final ClassDefinition weakReferenceClass;
    @NotNull
    private final ClassDefinition classClass;
    @NotNull
    private final HashMap<Type, ClassDefinition> primitiveArrayToClassDefinition;

    public ClassStore(@NotNull Long2ObjectOpenHashMap<ClassDefinition> classes) {
        boolean bl;
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        this.classes = classes;
        this.stringToClassDefinition = new HashMap();
        this.classDefinitionToShortPrettyName = new HashSet();
        this.primitiveArrayToClassDefinition = new HashMap();
        Set clashedClassNames = new LinkedHashSet();
        Collection collection2 = this.classes.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"<get-values>(...)");
        Type[] $this$forEach$iv = (Type[])collection2;
        boolean $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            ClassDefinition classDefinition = (ClassDefinition)t;
            bl = false;
            String className = classDefinition.getName();
            boolean clashed = false;
            if (clashedClassNames.contains(className)) {
                clashed = true;
            } else {
                ClassDefinition clashedClass = this.stringToClassDefinition.remove(className);
                if (clashedClass != null) {
                    clashed = true;
                    ClassDefinition newDefinition = clashedClass.copyWithName(ClassStore._init_$getClashedNameWithIndex(clashedClass, 1));
                    ((Map)this.stringToClassDefinition).put(newDefinition.getName(), newDefinition);
                    this.classes.put(clashedClass.getId(), (Object)newDefinition);
                    clashedClassNames.add(className);
                }
            }
            if (clashed) {
                int i = 2;
                String newName = null;
                do {
                    Intrinsics.checkNotNull((Object)classDefinition);
                    newName = ClassStore._init_$getClashedNameWithIndex(classDefinition, i);
                    ++i;
                } while (this.stringToClassDefinition.containsKey(newName));
                ClassDefinition newClassDefinition = classDefinition.copyWithName(newName);
                ((Map)this.stringToClassDefinition).put(newName, newClassDefinition);
                this.classes.put(classDefinition.getId(), (Object)newClassDefinition);
                continue;
            }
            ((Map)this.stringToClassDefinition).put(classDefinition.getName(), classDefinition);
        }
        $this$forEach$iv = clashedClassNames;
        $i$f$forEach = false;
        for (Object iterator2 : $this$forEach$iv) {
            boolean className;
            String string = (String)iterator2;
            bl = false;
            boolean bl2 = className = !((Map)this.stringToClassDefinition).containsKey(string);
            if (!_Assertions.ENABLED || className) continue;
            String clashed = "Assertion failed";
            throw new AssertionError((Object)clashed);
        }
        ClassDefinition classDefinition = this.stringToClassDefinition.get("java.lang.ref.SoftReference");
        Intrinsics.checkNotNull((Object)classDefinition);
        this.softReferenceClass = classDefinition;
        ClassDefinition classDefinition2 = this.stringToClassDefinition.get("java.lang.ref.WeakReference");
        Intrinsics.checkNotNull((Object)classDefinition2);
        this.weakReferenceClass = classDefinition2;
        ClassDefinition classDefinition3 = this.stringToClassDefinition.get("java.lang.Class");
        Intrinsics.checkNotNull((Object)classDefinition3);
        this.classClass = classDefinition3;
        $this$forEach$iv = Type.values();
        $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            ClassDefinition classDefinition4;
            Type type;
            Type type2 = type = $this$forEach$iv[i];
            boolean bl3 = false;
            if (type2 == Type.OBJECT) continue;
            if (this.stringToClassDefinition.get(type2.getClassNameOfPrimitiveArray()) == null) continue;
            boolean bl32 = false;
            this.primitiveArrayToClassDefinition.put(type2, classDefinition4);
        }
        HashMap shortNameToClassDefinition = new HashMap();
        Collection collection3 = this.classes.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"<get-values>(...)");
        Iterable $this$forEach$iv2 = collection3;
        boolean $i$f$forEach2 = false;
        for (Object t : $this$forEach$iv2) {
            ClassDefinition it = (ClassDefinition)t;
            boolean bl4 = false;
            if (StringsKt.contains$default((CharSequence)it.getName(), (char)'$', (boolean)false, (int)2, null)) continue;
            String prettyName = it.getPrettyName();
            String shortPrettyName = StringsKt.substringAfterLast$default((String)prettyName, (char)'.', null, (int)2, null);
            if (shortNameToClassDefinition.containsKey(shortPrettyName)) {
                ClassDefinition prevClassDefinition = (ClassDefinition)shortNameToClassDefinition.get(shortPrettyName);
                if (prevClassDefinition == null) continue;
                ((Map)shortNameToClassDefinition).put(shortPrettyName, null);
                continue;
            }
            ((Map)shortNameToClassDefinition).put(shortPrettyName, it);
        }
        Map $this$forEach$iv3 = shortNameToClassDefinition;
        boolean $i$f$forEach3 = false;
        Iterator iterator2 = $this$forEach$iv3.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator2.next();
            boolean bl5 = false;
            ClassDefinition classDef = (ClassDefinition)entry2.getValue();
            if (classDef == null) continue;
            this.classDefinitionToShortPrettyName.add(classDef);
        }
    }

    @NotNull
    public final ClassDefinition getSoftReferenceClass() {
        return this.softReferenceClass;
    }

    @NotNull
    public final ClassDefinition getWeakReferenceClass() {
        return this.weakReferenceClass;
    }

    @NotNull
    public final ClassDefinition getClassClass() {
        return this.classClass;
    }

    @NotNull
    public final ClassDefinition get(int id2) {
        Object object = this.classes.get((long)id2);
        Intrinsics.checkNotNull((Object)object);
        return (ClassDefinition)object;
    }

    @NotNull
    public final ClassDefinition get(long id2) {
        Object object = this.classes.get(id2);
        Intrinsics.checkNotNull((Object)object);
        return (ClassDefinition)object;
    }

    @NotNull
    public final ClassDefinition get(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        ClassDefinition classDefinition = this.stringToClassDefinition.get(name2);
        Intrinsics.checkNotNull((Object)classDefinition);
        return classDefinition;
    }

    @Nullable
    public final ClassDefinition getClassIfExists(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.stringToClassDefinition.get(name2);
    }

    public final boolean containsClass(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.stringToClassDefinition.containsKey(name2);
    }

    @Nullable
    public final ClassDefinition getClassForPrimitiveArray(@NotNull Type t) {
        Intrinsics.checkNotNullParameter((Object)((Object)t), (String)"t");
        return this.primitiveArrayToClassDefinition.get((Object)t);
    }

    public final int size() {
        return ((Map)this.classes).size();
    }

    public final boolean isSoftOrWeakReferenceClass(@NotNull ClassDefinition classDefinition) {
        Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
        return Intrinsics.areEqual((Object)classDefinition, (Object)this.softReferenceClass) || Intrinsics.areEqual((Object)classDefinition, (Object)this.weakReferenceClass);
    }

    public final void forEachClass(@NotNull Function1<? super ClassDefinition, Unit> func) {
        Intrinsics.checkNotNullParameter(func, (String)"func");
        Collection collection2 = this.classes.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClassDefinition it = (ClassDefinition)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            func.invoke((Object)it);
        }
    }

    @NotNull
    public final ClassStore createStoreWithRemappedIDs(@NotNull IDMapper idMapper) {
        Intrinsics.checkNotNullParameter((Object)idMapper, (String)"idMapper");
        Long2ObjectOpenHashMap newClasses = new Long2ObjectOpenHashMap();
        Collection collection2 = this.classes.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClassDefinition it = (ClassDefinition)element$iv;
            boolean bl = false;
            newClasses.put(ClassStore.createStoreWithRemappedIDs$map(idMapper, it.getId()), (Object)it.copyWithRemappedIDs(idMapper));
        }
        return new ClassStore((Long2ObjectOpenHashMap<ClassDefinition>)newClasses);
    }

    @NotNull
    public final String getShortPrettyNameForClass(@NotNull ClassDefinition classDefinition) {
        ClassDefinition outerClass;
        Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
        if (StringsKt.contains$default((CharSequence)classDefinition.getName(), (char)'$', (boolean)false, (int)2, null) ? (outerClass = this.stringToClassDefinition.get(StringsKt.substringBefore$default((String)classDefinition.getName(), (char)'$', null, (int)2, null))) != null && this.classDefinitionToShortPrettyName.contains(outerClass) : this.classDefinitionToShortPrettyName.contains(classDefinition)) {
            return StringsKt.substringAfterLast$default((String)classDefinition.getPrettyName(), (char)'.', null, (int)2, null);
        }
        return classDefinition.getPrettyName();
    }

    private static final String _init_$getClashedNameWithIndex(ClassDefinition classDefinition, int index) {
        if (StringsKt.endsWith$default((CharSequence)classDefinition.getName(), (char)';', (boolean)false, (int)2, null)) {
            return StringsKt.removeSuffix((String)classDefinition.getName(), (CharSequence)";") + "!" + index + ";";
        }
        return classDefinition.getName() + "!" + index;
    }

    private static final long createStoreWithRemappedIDs$map(IDMapper $idMapper, long id2) {
        return $idMapper.getID(id2);
    }
}

