/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.heap;

import com.android.tools.idea.diagnostics.heap.ExceededClusterStatistics;
import com.android.tools.idea.diagnostics.heap.ExtendedReportStatistics;
import com.android.tools.idea.diagnostics.heap.HeapSnapshotStatistics;
import com.android.tools.idea.diagnostics.heap.HeapTraverseUtil;
import com.android.tools.idea.diagnostics.heap.MemoryReportCollector;
import com.android.tools.idea.diagnostics.heap.ObjectsStatistics;
import com.android.tools.idea.diagnostics.heap.RootPathTree;
import com.android.tools.idea.diagnostics.heap.RootPathTreeNode;
import com.android.tools.idea.diagnostics.hprof.util.HeapReportUtils;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.intellij.openapi.util.Pair;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public abstract class RootPathTreePrinter {
    private static final int NODE_SUBTREE_SIZE_PERCENTAGE_REQUIREMENT = 2;
    private static final int NODE_SUBTREE_OBJECTS_SIZE_REQUIREMENT_BYTES = 750000;
    protected final int nominatedNodeTypeId;
    protected final int exceededClusterId;
    @NotNull
    protected final ExtendedReportStatistics extendedReportStatistics;

    protected RootPathTreePrinter(@NotNull ExtendedReportStatistics extendedReportStatistics, int nominatedNodeTypeId, int exceededClusterId) {
        this.extendedReportStatistics = extendedReportStatistics;
        this.nominatedNodeTypeId = nominatedNodeTypeId;
        this.exceededClusterId = exceededClusterId;
    }

    abstract boolean shouldPrintNodeSubtree(@NotNull RootPathTreeNode var1, int var2, short var3);

    abstract void print(@NotNull Consumer<String> var1);

    @NotNull
    abstract Comparator<RootPathTreeNode> getChildrenOrderingComparator();

    protected void printPathTreeForComponentAndNominatedType(@NotNull Consumer<String> writer2) {
        AtomicInteger rootIndex = new AtomicInteger(1);
        this.extendedReportStatistics.rootPathTree.roots.values().stream().filter(r -> this.shouldPrintNodeSubtree((RootPathTreeNode)r, 0, (short)0)).sorted(this.getChildrenOrderingComparator()).forEach(r -> {
            writer2.accept(String.format(Locale.US, "Root %d:", rootIndex.getAndIncrement()));
            this.printRootPathIteration(writer2, (RootPathTreeNode)r, " ", true, false, 0, (short)0);
        });
    }

    protected void printRootPathIteration(@NotNull Consumer<String> writer2, @NotNull RootPathTreeNode node, @NotNull String prefix, boolean isOnlyChild, boolean isLastChild, int depth, short visitedEssentialNominatedNodeTypesMask) {
        writer2.accept(this.constructRootPathLine(node, prefix, isOnlyChild, isLastChild, visitedEssentialNominatedNodeTypesMask));
        if (node.isDisposedButReferenced) {
            visitedEssentialNominatedNodeTypesMask = (short)(visitedEssentialNominatedNodeTypesMask | 0x200);
        }
        if (node.isLoadedWithNominatedLoader) {
            visitedEssentialNominatedNodeTypesMask = (short)(visitedEssentialNominatedNodeTypesMask | 0x400);
        }
        short finalVisitedEssentialNominatedNodeTypesMask = visitedEssentialNominatedNodeTypesMask;
        List<RootPathTreeNode> children2 = node.children.values().stream().filter(c -> c.instancesStatistics[this.exceededClusterId][this.nominatedNodeTypeId] != null && c.instancesStatistics[this.exceededClusterId][this.nominatedNodeTypeId].getObjectsCount() > 0 && this.shouldPrintNodeSubtree((RootPathTreeNode)c, depth + 1, finalVisitedEssentialNominatedNodeTypesMask)).sorted(this.getChildrenOrderingComparator()).toList();
        if (children2.size() > 1) {
            int i = 0;
            for (RootPathTreeNode childNode : children2) {
                Object childPrefix = prefix;
                childPrefix = i == children2.size() - 1 ? (String)childPrefix + "  " : (String)childPrefix + " |";
                this.printRootPathIteration(writer2, childNode, (String)childPrefix, false, i == children2.size() - 1, depth + 1, visitedEssentialNominatedNodeTypesMask);
                ++i;
            }
            return;
        }
        for (RootPathTreeNode childNode : children2) {
            this.printRootPathIteration(writer2, childNode, prefix, true, false, depth + 1, visitedEssentialNominatedNodeTypesMask);
        }
    }

    private String transformPrefix(@NotNull String prefix, boolean isOnlyChild, boolean isLastChild) {
        if (isOnlyChild) {
            return prefix + " ";
        }
        if (isLastChild) {
            return prefix.substring(0, prefix.length() - 1) + "\\-";
        }
        return prefix.substring(0, prefix.length() - 1) + "+-";
    }

    @NotNull
    protected String constructRootPathLine(@NotNull RootPathTreeNode node, @NotNull String prefix, boolean isOnlyChild, boolean isLastChild, short visitedEssentialNominatedNodeTypesMask) {
        return Strings.padStart((String)HeapTraverseUtil.getObjectsSizePresentation(node.instancesStatistics[this.exceededClusterId][this.nominatedNodeTypeId].getTotalSizeInBytes(), MemoryReportCollector.HeapSnapshotPresentationConfig.PresentationStyle.OPTIMAL_UNITS), (int)6, (char)' ') + Strings.padStart((String)HeapTraverseUtil.getObjectsCountPresentation(node.instancesStatistics[this.exceededClusterId][this.nominatedNodeTypeId].getObjectsCount(), MemoryReportCollector.HeapSnapshotPresentationConfig.PresentationStyle.OPTIMAL_UNITS), (int)11, (char)' ') + " " + (node.selfSizes[this.exceededClusterId][this.nominatedNodeTypeId] != null ? (char)'*' : ' ') + " " + (node.isRepeated ? "(rep)" : "     ") + this.transformPrefix(prefix, isOnlyChild, isLastChild) + node.getPresentation(this.exceededClusterId, this.nominatedNodeTypeId, visitedEssentialNominatedNodeTypesMask);
    }

    static class RootPathTreeSummaryPrinter
    extends RootPathTreePrinter {
        private final Comparator<RootPathTreeNode> childrenOrderingComparator;
        private static final long SUMMARY_SUBTREE_MAX_DEPTH = 50L;
        private final long summaryRequiredSubtreeSize;

        RootPathTreeSummaryPrinter(@NotNull ExtendedReportStatistics extendedReportStatistics, @NotNull ExceededClusterStatistics exceededClusterStatistics, long summaryRequiredSubtreeSize) {
            super(extendedReportStatistics, 11, exceededClusterStatistics.exceededClusterIndex);
            this.summaryRequiredSubtreeSize = summaryRequiredSubtreeSize;
            this.childrenOrderingComparator = Comparator.comparingLong(c -> c.instancesStatistics[this.exceededClusterId][11].getTotalSizeInBytes()).reversed();
        }

        @Override
        boolean shouldPrintNodeSubtree(@NotNull RootPathTreeNode node, int depth, short visitedEssentialNominatedNodeTypesMask) {
            return node.instancesStatistics[this.exceededClusterId][this.nominatedNodeTypeId] != null && node.instancesStatistics[this.exceededClusterId][this.nominatedNodeTypeId].getObjectsCount() > 0 && node.instancesStatistics[this.exceededClusterId][this.nominatedNodeTypeId].getTotalSizeInBytes() > this.summaryRequiredSubtreeSize && (long)depth < 50L;
        }

        @Override
        void print(@NotNull Consumer<String> writer2) {
            this.printPathTreeForComponentAndNominatedType(writer2);
        }

        @Override
        @NotNull
        Comparator<RootPathTreeNode> getChildrenOrderingComparator() {
            return this.childrenOrderingComparator;
        }
    }

    static class RootPathTreeNominatedLoadersPrinter
    extends RootPathTreeNominatedTypePrinter {
        RootPathTreeNominatedLoadersPrinter(@NotNull ObjectsStatistics totalNominatedTypeStatistics, @NotNull ExtendedReportStatistics extendedReportStatistics, @NotNull ExceededClusterStatistics exceededClusterStatistics) {
            super(totalNominatedTypeStatistics, extendedReportStatistics, exceededClusterStatistics, 10);
        }

        @Override
        public void print(@NotNull Consumer<String> writer2) {
            if (this.totalNominatedTypeStatistics.getObjectsCount() == 0) {
                return;
            }
            writer2.accept("================= OBJECTS RETAINING NOMINATED LOADERS ================");
            writer2.accept("Nominated ClassLoaders:");
            HashMap classLoaderNameToCount = Maps.newHashMap();
            this.extendedReportStatistics.globalNominatedClassLoaders.forEach(cl -> {
                String loaderName = cl.getClass().getName();
                classLoaderNameToCount.putIfAbsent(loaderName, 0);
                classLoaderNameToCount.put(loaderName, (Integer)classLoaderNameToCount.get(loaderName) + 1);
            });
            for (String string : classLoaderNameToCount.keySet()) {
                writer2.accept(" --> " + string + ": " + classLoaderNameToCount.get(string));
            }
            writer2.accept("Duplicated classes:");
            for (Pair pair : this.extendedReportStatistics.duplicatedClassNamesAndNumberOfInstances) {
                writer2.accept(" --> " + (String)pair.first + ": " + pair.second);
            }
            this.printPathTreeForComponentAndNominatedType(writer2);
        }
    }

    static class RootPathTreeDisposedObjectsPrinter
    extends RootPathTreeNominatedTypePrinter {
        @NotNull
        private final HeapSnapshotStatistics.DisposedObjectsInfo disposedObjectsInfo;

        RootPathTreeDisposedObjectsPrinter(@NotNull ObjectsStatistics totalNominatedTypeStatistics, @NotNull ExtendedReportStatistics extendedReportStatistics, @NotNull ExceededClusterStatistics exceededClusterStatistics, @NotNull HeapSnapshotStatistics.DisposedObjectsInfo disposedObjectsInfo) {
            super(totalNominatedTypeStatistics, extendedReportStatistics, exceededClusterStatistics, 9);
            this.disposedObjectsInfo = disposedObjectsInfo;
        }

        @Override
        public void print(@NotNull Consumer<String> writer2) {
            if (this.totalNominatedTypeStatistics.getObjectsCount() == 0) {
                return;
            }
            writer2.accept("================= DISPOSED OBJECTS ================");
            this.printPathTreeForComponentAndNominatedType(writer2);
        }

        @Override
        @NotNull
        protected String constructRootPathLine(@NotNull RootPathTreeNode node, @NotNull String prefix, boolean isOnlyChild, boolean isLastChild, short visitedEssentialNominatedNodeTypesMask) {
            if (node.isDisposedButReferenced) {
                ObjectsStatistics nominatedObjectsInTheSubtree = node.instancesStatistics[this.exceededClusterId][this.nominatedNodeTypeId];
                if (nominatedObjectsInTheSubtree.getTotalSizeInBytes() >= 1000000L) {
                    ++this.disposedObjectsInfo.numberOfDisposedObjectsWithAtLeast1mb;
                }
                if (nominatedObjectsInTheSubtree.getTotalSizeInBytes() >= 10000000L) {
                    ++this.disposedObjectsInfo.numberOfDisposedObjectsWithAtLeast10mb;
                }
                if (nominatedObjectsInTheSubtree.getTotalSizeInBytes() >= 100000000L) {
                    ++this.disposedObjectsInfo.numberOfDisposedObjectsWithAtLeast100mb;
                }
            }
            return super.constructRootPathLine(node, prefix, isOnlyChild, isLastChild, visitedEssentialNominatedNodeTypesMask);
        }
    }

    static class RootPathTreeNominatedTypePrinter
    extends RootPathTreePrinter {
        @NotNull
        protected final ObjectsStatistics totalNominatedTypeStatistics;
        @NotNull
        protected final Map<RootPathTreeNode, ObjectsStatistics> nominatedObjectsStatsInTheNodeSubtree = new HashMap<RootPathTreeNode, ObjectsStatistics>();
        @NotNull
        private final Comparator<RootPathTreeNode> childrenOrderingComparator;

        RootPathTreeNominatedTypePrinter(@NotNull ObjectsStatistics totalNominatedTypeStatistics, @NotNull ExtendedReportStatistics extendedReportStatistics, @NotNull ExceededClusterStatistics exceededClusterStatistics, int nominatedNodeTypeId) {
            super(extendedReportStatistics, nominatedNodeTypeId, exceededClusterStatistics.exceededClusterIndex);
            this.totalNominatedTypeStatistics = totalNominatedTypeStatistics;
            for (RootPathTreeNode root : extendedReportStatistics.rootPathTree.roots.values()) {
                this.calculateNominatedObjectsStatisticsInTheSubtree(root, exceededClusterStatistics.exceededClusterIndex, nominatedNodeTypeId, this.nominatedObjectsStatsInTheNodeSubtree);
            }
            this.childrenOrderingComparator = Comparator.comparingLong(c -> this.nominatedObjectsStatsInTheNodeSubtree.get(c).getTotalSizeInBytes()).reversed();
        }

        @Override
        @NotNull
        Comparator<RootPathTreeNode> getChildrenOrderingComparator() {
            return this.childrenOrderingComparator;
        }

        @Override
        void print(@NotNull Consumer<String> writer2) {
            this.printPathTreeForComponentAndNominatedType(writer2);
        }

        private ObjectsStatistics calculateNominatedObjectsStatisticsInTheSubtree(@NotNull RootPathTreeNode node, int exceededClusterId, int nominatedNodeTypeId, @NotNull Map<RootPathTreeNode, ObjectsStatistics> nominatedObjectsStatsInTheNodeSubtree) {
            ObjectsStatistics statistics = new ObjectsStatistics();
            if (node.instancesStatistics[exceededClusterId][nominatedNodeTypeId] == null || node.instancesStatistics[exceededClusterId][nominatedNodeTypeId].getObjectsCount() == 0) {
                return statistics;
            }
            if (node.selfSizes[exceededClusterId][nominatedNodeTypeId] != null) {
                statistics.addStats(node.instancesStatistics[exceededClusterId][nominatedNodeTypeId].getObjectsCount(), node.selfSizes[exceededClusterId][nominatedNodeTypeId]);
            }
            for (RootPathTreeNode childNode : node.children.values()) {
                if (childNode.instancesStatistics[exceededClusterId][nominatedNodeTypeId] == null || childNode.instancesStatistics[exceededClusterId][nominatedNodeTypeId].getObjectsCount() == 0) continue;
                statistics.addStats(this.calculateNominatedObjectsStatisticsInTheSubtree(childNode, exceededClusterId, nominatedNodeTypeId, nominatedObjectsStatsInTheNodeSubtree));
            }
            if (statistics.getObjectsCount() > 0) {
                nominatedObjectsStatsInTheNodeSubtree.put(node, statistics);
            }
            return statistics;
        }

        @Override
        boolean shouldPrintNodeSubtree(@NotNull RootPathTreeNode node, int depth, short visitedEssentialNominatedNodeTypesMask) {
            ObjectsStatistics rootSubtreeStatistics = this.nominatedObjectsStatsInTheNodeSubtree.get(node);
            return rootSubtreeStatistics != null && (100L * rootSubtreeStatistics.getTotalSizeInBytes() >= this.totalNominatedTypeStatistics.getTotalSizeInBytes() * 2L || 100 * rootSubtreeStatistics.getObjectsCount() >= this.totalNominatedTypeStatistics.getObjectsCount() * 2 || rootSubtreeStatistics.getTotalSizeInBytes() >= 750000L || RootPathTree.ESSENTIAL_NOMINATED_NODE_TYPES.contains(this.nominatedNodeTypeId));
        }

        @Override
        @NotNull
        protected String constructRootPathLine(@NotNull RootPathTreeNode node, @NotNull String prefix, boolean isOnlyChild, boolean isLastChild, short visitedEssentialNominatedNodeTypesMask) {
            ObjectsStatistics nominatedObjectsInTheSubtree = this.nominatedObjectsStatsInTheNodeSubtree.get(node);
            String percentString = Strings.padStart((String)((int)(100.0 * (double)nominatedObjectsInTheSubtree.getTotalSizeInBytes() / (double)this.totalNominatedTypeStatistics.getTotalSizeInBytes()) + "%"), (int)4, (char)' ');
            return "[" + Strings.padStart((String)HeapReportUtils.INSTANCE.toShortStringAsCount(nominatedObjectsInTheSubtree.getObjectsCount()), (int)5, (char)' ') + "/" + percentString + "/" + Strings.padStart((String)HeapReportUtils.INSTANCE.toShortStringAsSize(nominatedObjectsInTheSubtree.getTotalSizeInBytes()), (int)6, (char)' ') + "]" + super.constructRootPathLine(node, prefix, isOnlyChild, isLastChild, visitedEssentialNominatedNodeTypesMask);
        }
    }
}

