/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.heap;

import com.android.tools.idea.diagnostics.heap.ExtendedReportStatistics;
import com.android.tools.idea.diagnostics.heap.ExtendedStackNode;
import com.android.tools.idea.diagnostics.heap.ObjectsStatistics;
import com.google.common.collect.Maps;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class RootPathTreeNode {
    @NotNull
    final String className;
    @NotNull
    final String label;
    boolean isDisposedButReferenced;
    boolean isLoadedWithNominatedLoader;
    @NotNull
    final Map<ExtendedStackNode, RootPathTreeNode> children = Maps.newHashMap();
    boolean isRepeated = false;
    final ObjectsStatistics[][] instancesStatistics;
    final Long[][] selfSizes;

    RootPathTreeNode(@NotNull String label2, @NotNull String className, boolean isDisposedButReferenced, boolean isLoadedWithNominatedLoader, @NotNull ExtendedReportStatistics extendedReportStatistics) {
        this.className = className;
        this.label = label2;
        this.isDisposedButReferenced = isDisposedButReferenced;
        this.isLoadedWithNominatedLoader = isLoadedWithNominatedLoader;
        this.instancesStatistics = new ObjectsStatistics[extendedReportStatistics.componentToExceededClustersStatistics.size()][12];
        this.selfSizes = new Long[extendedReportStatistics.componentToExceededClustersStatistics.size()][12];
    }

    void incrementNumberOfInstances(int exceededClusterId, int nominatedNodeTypeId, long subtreeSize) {
        if (this.instancesStatistics[exceededClusterId][nominatedNodeTypeId] == null) {
            this.instancesStatistics[exceededClusterId][nominatedNodeTypeId] = new ObjectsStatistics();
        }
        this.instancesStatistics[exceededClusterId][nominatedNodeTypeId].addObject(subtreeSize);
    }

    void markNodeAsNominated(int exceededClusterId, int nominatedNodeTypeId, long size) {
        if (this.selfSizes[exceededClusterId][nominatedNodeTypeId] == null) {
            this.selfSizes[exceededClusterId][nominatedNodeTypeId] = 0L;
        }
        Long[] longArray = this.selfSizes[exceededClusterId];
        int n = nominatedNodeTypeId;
        Long.valueOf(longArray[n] + size);
    }

    @NotNull
    public String getPresentation(int exceededClusterId, int nominatedNodeTypeId, short visitedEssentialNominatedNodeTypesMask) {
        return this.label + ": " + this.className + (this.isDisposedButReferenced ? ((visitedEssentialNominatedNodeTypesMask & 0x200) == 0 ? " (disposedRoot)" : " (disposedChild)") : "") + (this.isLoadedWithNominatedLoader ? " (nominatedLoader)" : "");
    }

    static class RootPathArrayTreeNode
    extends RootPathTreeNode {
        @NotNull
        private static final int[] SCALE_VALUES = new int[]{250000, 1000000, 5000000, 10000000, 50000000};
        @NotNull
        private static final String[] SCALE_LABELS = new String[]{"0-250KB", "250KB-1MB", "1MB-5MB", "5MB-10MB", "10MB-50MB", "50MB+"};
        int[] sizeDistributionMap = null;

        public RootPathArrayTreeNode(@NotNull String label2, @NotNull String className, boolean isDisposedButReferenced, boolean isLoadedWithNominatedLoader, @NotNull ExtendedReportStatistics extendedReportStatistics) {
            super(label2, className, isDisposedButReferenced, isLoadedWithNominatedLoader, extendedReportStatistics);
        }

        @Override
        void markNodeAsNominated(int exceededClusterId, int nominatedNodeTypeId, long size) {
            super.markNodeAsNominated(exceededClusterId, nominatedNodeTypeId, size);
            if (nominatedNodeTypeId >= 9) {
                return;
            }
            if (this.sizeDistributionMap == null) {
                this.sizeDistributionMap = new int[SCALE_LABELS.length];
            }
            int i = 0;
            for (int scaleValue : SCALE_VALUES) {
                if (size < (long)scaleValue) {
                    int n = i;
                    this.sizeDistributionMap[n] = this.sizeDistributionMap[n] + 1;
                    return;
                }
                ++i;
            }
            int n = i;
            this.sizeDistributionMap[n] = this.sizeDistributionMap[n] + 1;
        }

        @Override
        @NotNull
        public String getPresentation(int exceededClusterId, int nominatedNodeTypeId, short visitedEssentialNominatedNodeTypesMask) {
            if (this.sizeDistributionMap == null || this.selfSizes[exceededClusterId][nominatedNodeTypeId] == null) {
                return super.getPresentation(exceededClusterId, nominatedNodeTypeId, visitedEssentialNominatedNodeTypesMask);
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < SCALE_LABELS.length; ++i) {
                if (this.sizeDistributionMap[i] <= 0) continue;
                builder.append(SCALE_LABELS[i]).append("->").append(this.sizeDistributionMap[i]).append(';');
            }
            return super.getPresentation(exceededClusterId, nominatedNodeTypeId, visitedEssentialNominatedNodeTypesMask) + " {" + builder + "}";
        }
    }
}

