/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.heap;

import com.android.tools.idea.diagnostics.heap.ComponentsSet;
import com.android.tools.idea.diagnostics.heap.DepthFirstSearchTraverse;
import com.android.tools.idea.diagnostics.heap.ExceededClusterStatistics;
import com.android.tools.idea.diagnostics.heap.FieldCache;
import com.android.tools.idea.diagnostics.heap.HeapSnapshotStatistics;
import com.android.tools.idea.diagnostics.heap.HeapSnapshotTraverseException;
import com.android.tools.idea.diagnostics.heap.HeapTraverseConfig;
import com.android.tools.idea.diagnostics.heap.HeapTraverseUtil;
import com.android.tools.idea.diagnostics.heap.MemoryReportCollector;
import com.android.tools.idea.diagnostics.heap.ObjectsStatistics;
import com.android.tools.idea.diagnostics.heap.RootPathTree;
import com.android.tools.idea.diagnostics.heap.RootPathTreePrinter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakList;
import it.unimi.dsi.fastutil.ints.Int2ByteMap;
import it.unimi.dsi.fastutil.ints.Int2ByteOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.ToLongFunction;
import org.jetbrains.annotations.NotNull;

public class ExtendedReportStatistics {
    static final int NOMINATED_CLASSES_NUMBER_IN_SECTION = 3;
    static final int NUMBER_OF_LOADERS_FOR_CLASS_NAME_THRESHOLD = 10;
    private static final String CLASS_FQN = "java.lang.Class";
    @NotNull
    final List<ClusterHistogram> componentHistograms;
    @NotNull
    final List<CategoryHistogram> categoryHistograms;
    @NotNull
    final Long2ObjectMap<ClusterHistogram> sharedClustersHistograms;
    @NotNull
    final Int2IntMap objectIdToMinDepth = new Int2IntOpenHashMap();
    @NotNull
    final Int2ByteMap objectIdToMinDepthKind = new Int2ByteOpenHashMap();
    @NotNull
    final Map<ComponentsSet.Component, ExceededClusterStatistics> componentToExceededClustersStatistics = Maps.newHashMap();
    @NotNull
    final Int2ObjectMap<ExceededClusterStatistics> exceededClustersEnumeration = new Int2ObjectOpenHashMap();
    @NotNull
    final Set<ClassLoader> globalNominatedClassLoaders = ContainerUtil.createWeakSet();
    @NotNull
    final List<Pair<String, Integer>> duplicatedClassNamesAndNumberOfInstances = Lists.newArrayList();
    private int totalNumberOfDisposedButReferencedObjects = 0;
    private int totalDisposerTreeSize = 0;
    @NotNull
    private final Map<String, ObjectsStatistics> disposedButReferencedObjectsClasses = Maps.newHashMap();
    @NotNull
    final RootPathTree rootPathTree = new RootPathTree(this);
    @NotNull
    final HeapTraverseConfig myConfig;

    /*
     * WARNING - void declaration
     */
    public ExtendedReportStatistics(@NotNull HeapTraverseConfig config) {
        this.myConfig = config;
        this.componentHistograms = Lists.newArrayList();
        this.categoryHistograms = Lists.newArrayList();
        this.sharedClustersHistograms = new Long2ObjectOpenHashMap();
        int componentIndex = 0;
        for (ComponentsSet.Component component : config.getComponentsSet().getComponents()) {
            this.componentHistograms.add(new ClusterHistogram(ClusterHistogram.ClusterType.COMPONENT));
            assert (component.getId() == componentIndex);
            ++componentIndex;
        }
        int componentCategoryIndex = 0;
        for (ComponentsSet.ComponentCategory componentCategory : config.getComponentsSet().getComponentsCategories()) {
            this.categoryHistograms.add(new CategoryHistogram());
            assert (componentCategory.getId() == componentCategoryIndex);
            ++componentCategoryIndex;
        }
        boolean bl = false;
        for (ComponentsSet.Component component : config.exceededComponents) {
            void var4_8;
            ExceededClusterStatistics exceededClusterStatistics = new ExceededClusterStatistics((int)(++var4_8));
            this.exceededClustersEnumeration.put(exceededClusterStatistics.exceededClusterIndex, (Object)exceededClusterStatistics);
            this.componentToExceededClustersStatistics.put(component, exceededClusterStatistics);
        }
    }

    void addClassNameToComponentOwnedHistogram(@NotNull ComponentsSet.Component component, @NotNull String className, long size, boolean isRoot2, boolean isDisposedButReferenced) {
        this.componentHistograms.get(component.getId()).addObjectClassName(className, size, isRoot2, isDisposedButReferenced);
    }

    void addClassNameToCategoryOwnedHistogram(@NotNull ComponentsSet.ComponentCategory componentCategory, @NotNull String className, long size, boolean isRoot2, boolean isDisposedButReferenced) {
        this.categoryHistograms.get(componentCategory.getId()).addObjectClassName(className, size, isRoot2, isDisposedButReferenced);
    }

    public void addClassNameToSharedClusterHistogram(@NotNull HeapSnapshotStatistics.SharedClusterStatistics sharedClusterStatistics, @NotNull String className, long size, boolean isMergePoint, boolean isDisposedButReferenced) {
        this.sharedClustersHistograms.putIfAbsent(sharedClusterStatistics.componentsMask, (Object)new ClusterHistogram(ClusterHistogram.ClusterType.SHARED_CLUSTER));
        ((ClusterHistogram)this.sharedClustersHistograms.get(sharedClusterStatistics.componentsMask)).addObjectClassName(className, size, isMergePoint, isDisposedButReferenced);
    }

    public void logClusterHistogram(@NotNull Consumer<String> writer2, @NotNull ComponentsSet.Cluster cluster, @NotNull ClusterHistogram.ClusterType clusterType) {
        switch (clusterType) {
            case COMPONENT: {
                this.logComponentHistogram(writer2, (ComponentsSet.Component)cluster);
                break;
            }
            case CATEGORY: {
                this.logCategoryHistogram(writer2, (ComponentsSet.ComponentCategory)cluster);
            }
        }
    }

    public void logCategoryHistogram(@NotNull Consumer<String> writer2, @NotNull ComponentsSet.ComponentCategory componentCategory) {
        this.categoryHistograms.get(componentCategory.getId()).print(writer2);
    }

    public void logComponentHistogram(@NotNull Consumer<String> writer2, @NotNull ComponentsSet.Component component) {
        this.componentHistograms.get(component.getId()).print(writer2);
    }

    public void logSharedClusterHistogram(@NotNull Consumer<String> writer2, @NotNull HeapSnapshotStatistics.SharedClusterStatistics sharedClusterStatistics) {
        ((ClusterHistogram)this.sharedClustersHistograms.get(sharedClusterStatistics.componentsMask)).print(writer2);
    }

    public void addDisposedButReferencedObject(long size, String className) {
        ++this.totalNumberOfDisposedButReferencedObjects;
        this.disposedButReferencedObjectsClasses.putIfAbsent(className, new ObjectsStatistics());
        this.disposedButReferencedObjectsClasses.get(className).addObject(size);
    }

    public void setDisposerTreeSize(int size) {
        this.totalDisposerTreeSize = size;
    }

    public void logDisposerTreeReport(@NotNull Consumer<String> writer2) {
        writer2.accept("Disposer tree size: " + this.totalDisposerTreeSize);
        writer2.accept("Total number of disposed but strong referenced objects: " + this.totalNumberOfDisposedButReferencedObjects);
        for (String className : this.disposedButReferencedObjectsClasses.keySet()) {
            writer2.accept(HeapTraverseUtil.getObjectsStatsPresentation(this.disposedButReferencedObjectsClasses.get(className), MemoryReportCollector.HeapSnapshotPresentationConfig.PresentationStyle.OPTIMAL_UNITS) + " " + className);
        }
    }

    public void calculateExtendedReportData(@NotNull HeapTraverseConfig config, @NotNull FieldCache fieldCache, @NotNull MemoryReportCollector collector, @NotNull WeakList<Object> startRoots, @NotNull Map<String, ClassObjectsStatistics> nameToClassObjectsStatistics) throws HeapSnapshotTraverseException {
        Iterator<Object> objToNodeMap;
        if (config.collectDisposerTreeInfo && (objToNodeMap = HeapTraverseUtil.getFieldValue(Disposer.getTree(), "myObject2ParentNode")) instanceof Map) {
            this.setDisposerTreeSize(((Map)((Object)objToNodeMap)).size());
        }
        for (Map.Entry<String, ClassObjectsStatistics> entry : nameToClassObjectsStatistics.entrySet()) {
            if (entry.getValue().classLoaders.size() <= 10) continue;
            this.globalNominatedClassLoaders.addAll(entry.getValue().classLoaders);
            this.duplicatedClassNamesAndNumberOfInstances.add((Pair<String, Integer>)Pair.create((Object)entry.getKey(), (Object)entry.getValue().classObjects.size()));
        }
        for (ComponentsSet.Component component : config.exceededComponents) {
            ClusterHistogram histogram = this.componentHistograms.get(component.getId());
            ExceededClusterStatistics exceededClusterStatistics = this.componentToExceededClustersStatistics.get(component);
            this.addNominatedClassesFromHistogram(exceededClusterStatistics, histogram.histogram, e -> ((ObjectsStatistics)e.getValue()).getObjectsCount());
            this.addNominatedClassesFromHistogram(exceededClusterStatistics, histogram.histogram, e -> ((ObjectsStatistics)e.getValue()).getTotalSizeInBytes());
            this.addNominatedClassesFromHistogram(exceededClusterStatistics, histogram.rootHistogram, e -> ((ObjectsStatistics)e.getValue()).getObjectsCount());
        }
        DepthFirstSearchTraverse.ExtendedReportCollectionTraverse traverse = new DepthFirstSearchTraverse.ExtendedReportCollectionTraverse(fieldCache, collector, this);
        WeakList firstTraverseRoots = new WeakList();
        WeakList nominatedLoadersRoots = new WeakList();
        for (Object root : startRoots) {
            ClassLoader cl;
            if (root == null) continue;
            if (root instanceof Class) {
                cl = ((Class)root).getClassLoader();
            } else if (root instanceof ClassLoader) {
                cl = (ClassLoader)root;
            } else {
                firstTraverseRoots.add(root);
                continue;
            }
            if (cl != null && (this.globalNominatedClassLoaders.contains(cl) || this.componentToExceededClustersStatistics.values().stream().anyMatch(a -> a.isClassLoaderNominated(cl)))) {
                nominatedLoadersRoots.add(root);
                continue;
            }
            firstTraverseRoots.add(root);
        }
        traverse.start((WeakList<Object>)firstTraverseRoots);
        traverse.disableClassLoaderTracking();
        traverse.start((WeakList<Object>)nominatedLoadersRoots);
    }

    private void addNominatedClassesFromHistogram(@NotNull ExceededClusterStatistics exceededClusterStatistics, @NotNull Map<String, ObjectsStatistics> histogram, @NotNull ToLongFunction<Map.Entry<String, ObjectsStatistics>> extractorForComparator) {
        histogram.entrySet().stream().filter(e -> !CLASS_FQN.equals(e.getKey())).sorted(Comparator.comparingLong(extractorForComparator).reversed()).limit(3L).forEach(e -> exceededClusterStatistics.addNominatedClass((String)e.getKey(), (ObjectsStatistics)e.getValue()));
    }

    public void printExceededClusterStatisticsIfNeeded(@NotNull Consumer<String> writer2, @NotNull ComponentsSet.Component component, @NotNull HeapSnapshotStatistics.DisposedObjectsInfo disposedObjectsInfo) {
        ExceededClusterStatistics statistics = this.componentToExceededClustersStatistics.get(component);
        List<Pair> nominatedClassesInOrder = statistics.nominatedClassesTotalStatistics.entrySet().stream().sorted(Comparator.comparingInt(e -> ((ObjectsStatistics)e.getValue()).getObjectsCount()).reversed()).map(e -> new Pair((Object)((String)e.getKey()), (Object)((ObjectsStatistics)e.getValue()))).toList();
        new RootPathTreePrinter.RootPathTreeDisposedObjectsPrinter(this.rootPathTree.totalRetainedDisposedObjectsStatistics, this, statistics, disposedObjectsInfo).print(writer2);
        writer2.accept("======== INSTANCES OF EACH NOMINATED CLASS ========");
        writer2.accept("Nominated classes:");
        for (Pair pair : nominatedClassesInOrder) {
            writer2.accept(String.format(Locale.US, " --> [%s] %s", HeapTraverseUtil.getObjectsStatsPresentation((ObjectsStatistics)pair.second, MemoryReportCollector.HeapSnapshotPresentationConfig.PresentationStyle.OPTIMAL_UNITS), pair.first));
        }
        writer2.accept("");
        for (Pair pair : nominatedClassesInOrder) {
            writer2.accept(String.format(Locale.US, "CLASS: %s (%d objects)", pair.first, ((ObjectsStatistics)pair.second).getObjectsCount()));
            new RootPathTreePrinter.RootPathTreeNominatedTypePrinter((ObjectsStatistics)pair.second, this, statistics, statistics.nominatedClassesEnumeration.getInt(pair.first)).print(writer2);
        }
        new RootPathTreePrinter.RootPathTreeNominatedLoadersPrinter(this.rootPathTree.totalNominatedLoadersReferringObjectsStatistics, this, statistics).print(writer2);
    }

    class ClusterHistogram {
        @NotNull
        final Map<String, ObjectsStatistics> disposedButReferencedObjects = Maps.newHashMap();
        @NotNull
        final Map<String, ObjectsStatistics> histogram = Maps.newHashMap();
        @NotNull
        final Map<String, ObjectsStatistics> rootHistogram = Maps.newHashMap();
        @NotNull
        private final ClusterType clusterType;

        public ClusterHistogram(ClusterType clusterType) {
            this.clusterType = clusterType;
        }

        public void addObjectClassName(@NotNull String className, long size, boolean isRoot2, boolean isDisposedButReferenced) {
            this.histogram.putIfAbsent(className, new ObjectsStatistics());
            this.histogram.get(className).addObject(size);
            if (isRoot2) {
                this.rootHistogram.putIfAbsent(className, new ObjectsStatistics());
                this.rootHistogram.get(className).addObject(size);
            }
            if (isDisposedButReferenced) {
                this.disposedButReferencedObjects.putIfAbsent(className, new ObjectsStatistics());
                this.disposedButReferencedObjects.get(className).addObject(size);
            }
        }

        private boolean classNameIsStudioSource(@NotNull String className) {
            return className.startsWith("com.android.") || MemoryReportCollector.isPlatformObject(className);
        }

        public void print(Consumer<String> writer2) {
            writer2.accept("      Histogram:");
            this.histogram.entrySet().stream().sorted(Comparator.comparingLong(a -> ((ObjectsStatistics)a.getValue()).getTotalSizeInBytes()).reversed()).limit(ExtendedReportStatistics.this.myConfig.histogramPrintLimit).forEach(e -> writer2.accept(String.format(Locale.US, "        %s: %s", HeapTraverseUtil.getObjectsStatsPresentation((ObjectsStatistics)e.getValue(), MemoryReportCollector.HeapSnapshotPresentationConfig.PresentationStyle.OPTIMAL_UNITS), e.getKey())));
            writer2.accept("      Studio objects histogram:");
            this.histogram.entrySet().stream().filter(e -> this.classNameIsStudioSource((String)e.getKey())).sorted(Comparator.comparingLong(a -> ((ObjectsStatistics)a.getValue()).getTotalSizeInBytes()).reversed()).limit(ExtendedReportStatistics.this.myConfig.histogramPrintLimit).forEach(e -> writer2.accept(String.format(Locale.US, "        %s: %s", HeapTraverseUtil.getObjectsStatsPresentation((ObjectsStatistics)e.getValue(), MemoryReportCollector.HeapSnapshotPresentationConfig.PresentationStyle.OPTIMAL_UNITS), e.getKey())));
            switch (this.clusterType) {
                case CATEGORY: {
                    writer2.accept("      Category roots histogram:");
                    break;
                }
                case COMPONENT: {
                    writer2.accept("      Component roots histogram:");
                    break;
                }
                case SHARED_CLUSTER: {
                    writer2.accept("      Shared cluster merge-points histogram:");
                }
            }
            this.rootHistogram.entrySet().stream().sorted(Comparator.comparingInt(a -> ((ObjectsStatistics)a.getValue()).getObjectsCount()).reversed()).limit(ExtendedReportStatistics.this.myConfig.histogramPrintLimit).forEach(e -> writer2.accept(String.format(Locale.US, "        %s: %s", HeapTraverseUtil.getObjectsStatsPresentation((ObjectsStatistics)e.getValue(), MemoryReportCollector.HeapSnapshotPresentationConfig.PresentationStyle.OPTIMAL_UNITS), e.getKey())));
            if (!this.disposedButReferencedObjects.isEmpty()) {
                writer2.accept("      Disposed but strong referenced objects:");
                this.disposedButReferencedObjects.entrySet().stream().sorted(Comparator.comparingInt(a -> ((ObjectsStatistics)a.getValue()).getObjectsCount()).reversed()).forEach(e -> writer2.accept(String.format(Locale.US, "        %s: %s", HeapTraverseUtil.getObjectsStatsPresentation((ObjectsStatistics)e.getValue(), MemoryReportCollector.HeapSnapshotPresentationConfig.PresentationStyle.OPTIMAL_UNITS), e.getKey())));
            }
        }

        static enum ClusterType {
            COMPONENT,
            CATEGORY,
            SHARED_CLUSTER;

        }
    }

    class CategoryHistogram
    extends ClusterHistogram {
        public CategoryHistogram() {
            super(ClusterHistogram.ClusterType.CATEGORY);
        }
    }

    static class ClassObjectsStatistics {
        Set<ClassLoader> classLoaders = ContainerUtil.createWeakSet();
        Set<Class<?>> classObjects = ContainerUtil.createWeakSet();

        ClassObjectsStatistics() {
        }
    }
}

