/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.heap;

import com.android.tools.idea.diagnostics.heap.ObjectsStatistics;
import com.google.common.collect.Maps;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ExceededClusterStatistics {
    @NotNull
    final Map<String, ObjectsStatistics> nominatedClassesTotalStatistics = Maps.newHashMap();
    @NotNull
    final Object2IntMap<String> nominatedClassesEnumeration = new Object2IntOpenHashMap();
    @NotNull
    final Set<ClassLoader> nominatedClassLoaders = ContainerUtil.createWeakSet();
    final int exceededClusterIndex;

    public ExceededClusterStatistics(int exceededClusterIndex) {
        this.exceededClusterIndex = exceededClusterIndex;
    }

    public void addNominatedClass(@NotNull String className, @NotNull ObjectsStatistics objectsStatistics) {
        this.nominatedClassesEnumeration.putIfAbsent((Object)className, this.nominatedClassesEnumeration.size());
        this.nominatedClassesTotalStatistics.putIfAbsent(className, objectsStatistics);
    }

    public void addNominatedClassLoader(@NotNull ClassLoader classLoader) {
        this.nominatedClassLoaders.add(classLoader);
    }

    public boolean isClassLoaderNominated(@NotNull ClassLoader loader2) {
        return this.nominatedClassLoaders.contains(loader2);
    }

    public boolean isClassNominated(@NotNull String className) {
        return this.nominatedClassesTotalStatistics.containsKey(className);
    }
}

