/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.heap;

import com.android.tools.idea.diagnostics.heap.ExceededClusterStatistics;
import com.android.tools.idea.diagnostics.heap.ExtendedReportStatistics;
import com.android.tools.idea.diagnostics.heap.ExtendedStackNode;
import com.android.tools.idea.diagnostics.heap.FieldCache;
import com.android.tools.idea.diagnostics.heap.HeapSnapshotTraverseException;
import com.android.tools.idea.diagnostics.heap.HeapTraverseChildProcessor;
import com.android.tools.idea.diagnostics.heap.HeapTraverseNode;
import com.android.tools.idea.diagnostics.heap.HeapTraverseUtil;
import com.android.tools.idea.diagnostics.heap.MemoryReportCollector;
import com.android.tools.idea.diagnostics.heap.MemoryReportJniHelper;
import com.android.tools.idea.diagnostics.heap.ObjectTagUtil;
import com.android.tools.idea.diagnostics.heap.RootPathTree;
import com.android.tools.idea.diagnostics.heap.StackNode;
import com.google.wireless.android.sdk.stats.MemoryUsageReportEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.TriConsumer;
import com.intellij.util.containers.WeakList;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class DepthFirstSearchTraverse {
    private static final int MAX_DEPTH = 100000;
    @NotNull
    private final FieldCache fieldCache;
    @NotNull
    private final HeapTraverseChildProcessor heapTraverseChildProcessor;
    @NotNull
    protected final MemoryReportCollector collector;
    protected final short iterationId;

    public DepthFirstSearchTraverse(@NotNull FieldCache fieldCache, @NotNull MemoryReportCollector collector) {
        this.fieldCache = fieldCache;
        this.heapTraverseChildProcessor = collector.heapTraverseChildProcessor;
        this.collector = collector;
        this.iterationId = collector.getIterationId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(@NotNull WeakList<Object> roots) throws HeapSnapshotTraverseException {
        try {
            for (Object root : roots) {
                if (root == null) continue;
                this.depthFirstTraverseHeapObjects(root);
            }
        }
        finally {
            this.cleanup();
        }
    }

    protected void cleanup() {
        StackNode.clearDepthFirstSearchStack();
    }

    private void depthFirstTraverseHeapObjects(@NotNull Object root) throws HeapSnapshotTraverseException {
        long rootTag = MemoryReportJniHelper.getObjectTag(root);
        if (ObjectTagUtil.wasVisited(rootTag, this.iterationId)) {
            return;
        }
        rootTag = ObjectTagUtil.markVisited(root, rootTag, this.iterationId);
        this.pushElementToDepthFirstSearchStack(root, 0, rootTag, "(root)");
        while (true) {
            this.collector.abortTraversalIfRequested();
            int stackSize = StackNode.getDepthFirstSearchStackSize();
            if (stackSize == 0) break;
            if (stackSize > 1000000) {
                throw new HeapSnapshotTraverseException(MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode.OBJECTS_MAP_IS_TOO_BIG);
            }
            StackNode stackNode = StackNode.peekAndMarkProcessedDepthFirstSearchStack(StackNode.class);
            if (stackNode == null) continue;
            if (stackNode.referencesProcessed) {
                this.handleProcessedNode(stackNode, root);
                StackNode.popElementFromDepthFirstSearchStack();
                continue;
            }
            this.handleNode(stackNode);
            this.addStronglyReferencedChildrenToStack(stackNode, this.fieldCache);
        }
    }

    protected abstract void handleProcessedNode(@NotNull StackNode var1, @NotNull Object var2);

    private void addStronglyReferencedChildrenToStack(@NotNull StackNode stackNode, @NotNull FieldCache fieldCache) throws HeapSnapshotTraverseException {
        if (stackNode.getObject() == null) {
            return;
        }
        if (stackNode.depth >= 100000) {
            return;
        }
        this.heapTraverseChildProcessor.processChildObjects(stackNode.getObject(), (TriConsumer<Object, HeapTraverseNode.RefWeight, String>)((TriConsumer)(value2, weight, label2) -> this.addToStack(stackNode, value2, (String)label2)), fieldCache);
    }

    private void addToStack(@NotNull StackNode parentStackNode, @Nullable Object value2, @NotNull String label2) {
        if (value2 == null) {
            return;
        }
        if (parentStackNode.depth + 1 > 100000) {
            return;
        }
        if (HeapTraverseUtil.isPrimitive(value2.getClass()) || value2 instanceof Thread || value2 instanceof Class || value2 instanceof ClassLoader) {
            return;
        }
        long tag = MemoryReportJniHelper.getObjectTag(value2);
        if (ObjectTagUtil.wasVisited(tag, this.iterationId)) {
            return;
        }
        if (!this.shouldAddObjectToStack(parentStackNode, tag, value2, label2)) {
            return;
        }
        this.pushElementToDepthFirstSearchStack(value2, parentStackNode.depth + 1, ObjectTagUtil.markVisited(value2, tag, this.iterationId), label2);
    }

    protected void pushElementToDepthFirstSearchStack(@NotNull Object obj, int depth, long tag, @NotNull String label2) {
        StackNode.pushElementToDepthFirstSearchStack(obj, depth, tag);
    }

    protected void handleNode(@NotNull StackNode stackNode) {
    }

    protected boolean shouldAddObjectToStack(@NotNull StackNode stackNode, long childTag, @NotNull Object childObject, @NotNull String label2) {
        return true;
    }

    static class ExtendedReportCollectionTraverse
    extends DepthFirstSearchTraverse {
        @NotNull
        private final ExtendedReportStatistics extendedReportStatistics;
        @NotNull
        private final Stack<ExtendedStackNode> extendedNodesStack = new Stack();
        @NotNull
        private final Stack<RootPathTree.RootPathElement> pathToRoot = new Stack();
        private boolean trackNominatedClassLoaders = true;
        boolean disposedObjectInPathToRoot = false;
        int disposedObjectInPathToRootPosition;
        boolean objectLoadedWithNominatedLoaderInPathToRoot = false;
        int objectLoadedWithNominatedLoaderInPathToRootPosition;
        boolean currentObjectIsLoadedWithNominatedLoader;

        public ExtendedReportCollectionTraverse(@NotNull FieldCache fieldCache, @NotNull MemoryReportCollector collector, @NotNull ExtendedReportStatistics extendedReportStatistics) {
            super(fieldCache, collector);
            this.extendedReportStatistics = extendedReportStatistics;
        }

        private RootPathTree.RootPathElement pathToRootPop() {
            if (this.disposedObjectInPathToRoot && this.disposedObjectInPathToRootPosition == this.pathToRoot.size() - 1) {
                this.disposedObjectInPathToRoot = false;
            }
            if (this.objectLoadedWithNominatedLoaderInPathToRoot && this.objectLoadedWithNominatedLoaderInPathToRootPosition == this.pathToRoot.size() - 1) {
                this.objectLoadedWithNominatedLoaderInPathToRoot = false;
            }
            return this.pathToRoot.pop();
        }

        @Override
        protected void handleProcessedNode(@NotNull StackNode stackNode, @NotNull Object root) {
            if (stackNode.getObject() == null) {
                this.pathToRootPop();
                return;
            }
            if (ObjectTagUtil.isOwnedByExceededComponent(stackNode.tag)) {
                String currentObjectClassName;
                ExceededClusterStatistics exceededClusterStatistics = (ExceededClusterStatistics)this.extendedReportStatistics.exceededClustersEnumeration.get((int)ObjectTagUtil.getOwningExceededClusterIndex(stackNode.tag));
                if (exceededClusterStatistics.isClassNominated(currentObjectClassName = stackNode.getObject().getClass().getName())) {
                    this.extendedReportStatistics.rootPathTree.addObjectWithPathToRoot(this.pathToRoot, exceededClusterStatistics, exceededClusterStatistics.nominatedClassesEnumeration.getInt((Object)currentObjectClassName));
                }
                if (this.pathToRoot.peek().isDisposedButReferenced() && this.disposedObjectInPathToRootPosition == this.pathToRoot.size() - 1) {
                    this.extendedReportStatistics.rootPathTree.addDisposedReferencedObjectWithPathToRoot(this.pathToRoot, exceededClusterStatistics);
                }
            }
            RootPathTree.RootPathElement element = this.pathToRootPop();
            if (!this.pathToRoot.empty() && !element.extendedStackNode.equals(this.pathToRoot.peek().extendedStackNode)) {
                element.update();
                this.pathToRoot.peek().addSubtreeSize(element.getSubtreeSize());
            }
            if (this.pathToRoot.empty()) {
                element.update();
            }
            MemoryReportJniHelper.setObjectTag(stackNode.getObject(), 0L);
        }

        @Override
        protected void pushElementToDepthFirstSearchStack(@NotNull Object obj, int depth, long tag, @NotNull String label2) {
            super.pushElementToDepthFirstSearchStack(obj, depth, tag, label2);
            this.extendedNodesStack.push(new ExtendedStackNode(this.getObjectClassNameLabel(obj), label2, ExtendedReportCollectionTraverse.isDisposedButReferenced(obj), this.currentObjectIsLoadedWithNominatedLoader));
        }

        public void disableClassLoaderTracking() {
            this.trackNominatedClassLoaders = false;
        }

        private static boolean isDisposedButReferenced(@NotNull Object obj) {
            return obj instanceof Disposable && Disposer.isDisposed((Disposable)((Disposable)obj));
        }

        @NotNull
        private String getObjectClassNameLabel(@NotNull Object obj) {
            if (obj instanceof Class) {
                return String.format("%s(%s)", obj.getClass().getName(), ((Class)obj).getName());
            }
            return obj.getClass().getName();
        }

        private void pathToRootAdd(@NotNull ExtendedStackNode extendedStackNode, long size, boolean isArray) {
            if (!this.disposedObjectInPathToRoot && extendedStackNode.isDisposedButReferenced()) {
                this.disposedObjectInPathToRoot = true;
                this.disposedObjectInPathToRootPosition = this.pathToRoot.size();
            }
            if (!this.objectLoadedWithNominatedLoaderInPathToRoot && extendedStackNode.isLoadedWithNominatedLoader()) {
                this.objectLoadedWithNominatedLoaderInPathToRoot = true;
                this.objectLoadedWithNominatedLoaderInPathToRootPosition = this.pathToRoot.size();
            }
            this.pathToRoot.add(new RootPathTree.RootPathElement(extendedStackNode, size, this.extendedReportStatistics, isArray));
        }

        @Override
        protected void handleNode(@NotNull StackNode stackNode) {
            super.handleNode(stackNode);
            ExtendedStackNode extendedStackNode = this.extendedNodesStack.pop();
            this.pathToRootAdd(extendedStackNode, stackNode.getObject() == null ? 0L : MemoryReportJniHelper.getObjectSize(stackNode.getObject()), stackNode.getObject() != null && stackNode.getObject().getClass().isArray());
        }

        private boolean checkReferenceIsHoldingNominatedClassLoader(@NotNull Object childObject, @NotNull String label2) {
            if (childObject.getClass() == null || !this.trackNominatedClassLoaders || this.disposedObjectInPathToRoot || this.objectLoadedWithNominatedLoaderInPathToRoot) {
                return false;
            }
            ClassLoader childObjectClassLoader = childObject.getClass().getClassLoader();
            if (childObjectClassLoader == null) {
                return false;
            }
            List<ExceededClusterStatistics> statistics = this.extendedReportStatistics.componentToExceededClustersStatistics.values().stream().filter(c -> c.isClassLoaderNominated(childObjectClassLoader) || this.extendedReportStatistics.globalNominatedClassLoaders.contains(childObjectClassLoader)).toList();
            if (statistics.isEmpty()) {
                return false;
            }
            this.pathToRoot.add(new RootPathTree.RootPathElement(new ExtendedStackNode(this.getObjectClassNameLabel(childObject), label2, ExtendedReportCollectionTraverse.isDisposedButReferenced(childObject), true), MemoryReportJniHelper.getObjectSize(childObject), this.extendedReportStatistics, childObject.getClass().isArray()));
            statistics.forEach(c -> this.extendedReportStatistics.rootPathTree.addClassLoaderPath(this.pathToRoot, (ExceededClusterStatistics)c));
            this.pathToRootPop();
            return true;
        }

        @Override
        protected boolean shouldAddObjectToStack(@NotNull StackNode stackNode, long childTag, @NotNull Object childObject, @NotNull String label2) {
            this.currentObjectIsLoadedWithNominatedLoader = this.checkReferenceIsHoldingNominatedClassLoader(childObject, label2);
            int childObjectDepth = ObjectTagUtil.getDepth(childTag, this.iterationId);
            HeapTraverseNode.MinDepthKind childMinDepthKind = ObjectTagUtil.getDepthKind(childTag, this.iterationId);
            HeapTraverseNode.MinDepthKind parentMinDepthKind = ObjectTagUtil.getDepthKind(stackNode.tag, this.iterationId);
            if (childObjectDepth == -1 || childMinDepthKind == null) {
                return false;
            }
            if (this.pathToRoot.peek().isDisposedButReferenced()) {
                parentMinDepthKind = HeapTraverseNode.MinDepthKind.USING_DISPOSED_OBJECTS;
            }
            return stackNode.depth + 1 == childObjectDepth && parentMinDepthKind == childMinDepthKind;
        }

        @Override
        protected void cleanup() {
            super.cleanup();
            this.extendedNodesStack.clear();
            this.pathToRoot.clear();
        }
    }

    static class ObjectsEnumerationTraverse
    extends DepthFirstSearchTraverse {
        private int lastObjectId = 0;

        ObjectsEnumerationTraverse(@NotNull FieldCache fieldCache, @NotNull MemoryReportCollector collector) {
            super(fieldCache, collector);
        }

        @Override
        protected void handleProcessedNode(@NotNull StackNode stackNode, @NotNull Object root) {
            if (stackNode.getObject() == null) {
                return;
            }
            long tag = stackNode.tag;
            ObjectTagUtil.setObjectId(stackNode.getObject(), tag, ++this.lastObjectId, this.iterationId);
            if (stackNode.getObject() == root) {
                this.collector.putOrUpdateObjectIdToTraverseNodeMap(this.lastObjectId, root, this.collector.createRootNode(root));
            }
        }

        public int getLastObjectId() {
            return this.lastObjectId;
        }
    }
}

