/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.heap;

import com.android.tools.idea.serverflags.ServerFlagService;
import com.android.tools.idea.serverflags.protos.MemoryUsageComponent;
import com.android.tools.idea.serverflags.protos.MemoryUsageComponentCategory;
import com.android.tools.idea.serverflags.protos.MemoryUsageReportConfiguration;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.Strings;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class ComponentsSet {
    private static final Logger LOG = Logger.getInstance(ComponentsSet.class);
    public static final String MEMORY_USAGE_REPORTING_SERVER_FLAG_NAME = "diagnostics/memory_usage_reporting";
    private static final String INTEGRATION_TEST_CONFIG_RESOURCE_NAME = "/diagnostics/integration_test_memory_usage_config.textproto";
    static final String UNCATEGORIZED_CATEGORY_LABEL = "android:uncategorized";
    static final String UNCATEGORIZED_COMPONENT_LABEL = "uncategorized_main";
    @NotNull
    private final Component uncategorizedComponent;
    @NotNull
    private final List<Component> components;
    @NotNull
    private final List<ComponentCategory> componentCategories;
    @NotNull
    private final Map<String, Component> classNameToComponent;
    @NotNull
    private final Map<String, Component> packageNameToComponentCache;
    @NotNull
    private final Multimap<String, ComponentCategory> categoriesTrackingClassName = HashMultimap.create();
    @NotNull
    private final Multimap<String, Component> componentsTrackingClassName = HashMultimap.create();
    private final long sharedClusterExtendedReportThreshold;
    private static final long TEST_COMPONENTS_EXTENDED_REPORT_THRESHOLD = 100000000L;

    @TestOnly
    ComponentsSet() {
        this(100000000L, 100000000L);
    }

    ComponentsSet(long sharedClusterExtendedReportThreshold, long uncategorizedComponentThreshold) {
        this.packageNameToComponentCache = Maps.newHashMap();
        this.classNameToComponent = Maps.newHashMap();
        this.components = new ArrayList<Component>();
        this.componentCategories = new ArrayList<ComponentCategory>();
        this.sharedClusterExtendedReportThreshold = sharedClusterExtendedReportThreshold;
        this.uncategorizedComponent = this.registerComponent(UNCATEGORIZED_COMPONENT_LABEL, uncategorizedComponentThreshold, this.registerCategory(UNCATEGORIZED_CATEGORY_LABEL, uncategorizedComponentThreshold, Collections.emptyList()), Collections.emptyList(), Collections.emptyList());
    }

    public long getSharedClusterExtendedReportThreshold() {
        return this.sharedClusterExtendedReportThreshold;
    }

    @NotNull
    public static MemoryUsageReportConfiguration getServerFlagConfiguration() {
        return ServerFlagService.Companion.getInstance().getProto(MEMORY_USAGE_REPORTING_SERVER_FLAG_NAME, MemoryUsageReportConfiguration.getDefaultInstance());
    }

    @NotNull
    public static MemoryUsageReportConfiguration getIntegrationTestConfiguration() {
        MemoryUsageReportConfiguration.Builder builder = MemoryUsageReportConfiguration.newBuilder();
        try {
            TextFormat.merge((CharSequence)Resources.toString((URL)Resources.getResource(ComponentsSet.class, (String)INTEGRATION_TEST_CONFIG_RESOURCE_NAME), (Charset)StandardCharsets.UTF_8), (Message.Builder)builder);
        }
        catch (IOException e) {
            LOG.error("Failed to read memory usage components configuration", (Throwable)e);
        }
        return builder.build();
    }

    @NotNull
    public List<ComponentCategory> getComponentsCategories() {
        return this.componentCategories;
    }

    @NotNull
    public Component getUncategorizedComponent() {
        return this.uncategorizedComponent;
    }

    @NotNull
    public List<Component> getComponents() {
        return this.components;
    }

    @NotNull
    public Multimap<String, ComponentCategory> getCategoriesTrackingClassName() {
        return this.categoriesTrackingClassName;
    }

    @NotNull
    public Multimap<String, Component> getComponentsTrackingClassName() {
        return this.componentsTrackingClassName;
    }

    @NotNull
    Component registerComponent(@NotNull String componentLabel, long extendedReportCollectionThresholdBytes, @NotNull ComponentCategory category, @NotNull List<String> trackedFQNs, @NotNull List<String> customClassLoaders) {
        Component component = new Component(componentLabel, extendedReportCollectionThresholdBytes, customClassLoaders, this.components.size(), category);
        for (String fqn : trackedFQNs) {
            this.componentsTrackingClassName.put((Object)fqn, (Object)component);
        }
        this.components.add(component);
        return component;
    }

    @TestOnly
    ComponentCategory registerCategory(@NotNull String componentCategoryLabel) {
        return this.registerCategory(componentCategoryLabel, 100000000L, Collections.emptyList());
    }

    @TestOnly
    void addComponentWithPackagesAndClassNames(@NotNull String componentLabel, @NotNull ComponentCategory componentCategory, @NotNull List<String> packageNames, @NotNull List<String> classNames) {
        this.addComponentWithPackagesAndClassNames(componentLabel, 100000000L, componentCategory, packageNames, classNames, Collections.emptyList(), Collections.emptyList());
    }

    ComponentCategory registerCategory(@NotNull String componentCategoryLabel, long extendedReportCollectionThresholdBytes, @NotNull List<String> trackedFQNs) {
        ComponentCategory category = new ComponentCategory(this.componentCategories.size(), componentCategoryLabel, extendedReportCollectionThresholdBytes);
        for (String fqn : trackedFQNs) {
            this.categoriesTrackingClassName.put((Object)fqn, (Object)category);
        }
        this.componentCategories.add(category);
        return category;
    }

    ComponentCategory registerCategory(@NotNull MemoryUsageComponentCategory protoCategory) {
        return this.registerCategory(protoCategory.getLabel(), protoCategory.hasExtendedReportThresholdBytes() ? protoCategory.getExtendedReportThresholdBytes() : Long.MAX_VALUE, (List<String>)protoCategory.getTrackedFqnsList());
    }

    void addComponentWithPackagesAndClassNames(@NotNull ComponentCategory componentCategory, @NotNull MemoryUsageComponent component) {
        this.addComponentWithPackagesAndClassNames(component.getLabel(), component.hasExtendedReportThresholdBytes() ? component.getExtendedReportThresholdBytes() : Long.MAX_VALUE, componentCategory, (List<String>)component.getPackageNamesList(), (List<String>)component.getClassNamesList(), (List<String>)component.getTrackedFqnsList(), (List<String>)component.getCustomClassLoadersList());
    }

    void addComponentWithPackagesAndClassNames(@NotNull String componentLabel, long extendedReportCollectionThresholdBytes, @NotNull ComponentCategory componentCategory, @NotNull List<String> packageNames, @NotNull List<String> classNames, @NotNull List<String> trackedFQNs, @NotNull List<String> customClassLoaders) {
        Component newComponent = this.registerComponent(componentLabel, extendedReportCollectionThresholdBytes, componentCategory, trackedFQNs, customClassLoaders);
        for (String name2 : classNames) {
            this.classNameToComponent.put(name2, newComponent);
        }
        for (String name2 : packageNames) {
            this.packageNameToComponentCache.put(name2, newComponent);
        }
    }

    @Nullable
    public Component getComponentOfObject(@NotNull Object obj) {
        return obj instanceof Class ? this.getClassComponent((Class)obj) : this.getObjectComponent(obj);
    }

    @Nullable
    private Component getObjectComponent(@NotNull Object obj) {
        return this.getClassComponent(obj.getClass());
    }

    @Nullable
    private Component getClassComponent(@NotNull Class<?> aClass) {
        String outerClassName;
        String objClassName = aClass.getName();
        if (Strings.containsChar((String)objClassName, (char)'$') && this.classNameToComponent.containsKey(outerClassName = objClassName.substring(0, Strings.indexOf((CharSequence)objClassName, (char)'$')))) {
            return this.classNameToComponent.get(outerClassName);
        }
        if (this.classNameToComponent.containsKey(objClassName)) {
            return this.classNameToComponent.get(objClassName);
        }
        String packageName = aClass.getPackageName();
        int lastDot = packageName.length();
        String packageNamePrefix = packageName;
        do {
            if (!this.packageNameToComponentCache.containsKey(packageNamePrefix = packageNamePrefix.substring(0, lastDot))) continue;
            Component ans = this.packageNameToComponentCache.get(packageNamePrefix);
            this.packageNameToComponentCache.put(packageName, ans);
            return ans;
        } while ((lastDot = packageNamePrefix.lastIndexOf(46)) > 0);
        this.packageNameToComponentCache.put(packageName, null);
        return null;
    }

    private static ComponentsSet buildComponentSetFromConfiguration(MemoryUsageReportConfiguration configuration2) {
        int i;
        ComponentsSet components = new ComponentsSet(configuration2.getSharedClusterExtendedReportThresholdBytes(), configuration2.getUncategorizedComponentExtendedReportThresholdBytes());
        for (MemoryUsageComponentCategory protoCategory : configuration2.getCategoriesList()) {
            ComponentCategory category = components.registerCategory(protoCategory);
            for (MemoryUsageComponent component : protoCategory.getComponentsList()) {
                components.addComponentWithPackagesAndClassNames(category, component);
            }
        }
        for (i = 0; i < components.getComponents().size(); ++i) {
            assert (components.getComponents().get(i).getId() == i);
        }
        for (i = 0; i < components.getComponentsCategories().size(); ++i) {
            assert (components.getComponentsCategories().get(i).getId() == i);
        }
        return components;
    }

    @NotNull
    public static ComponentsSet buildComponentSet() {
        return ComponentsSet.buildComponentSetFromConfiguration(ComponentsSet.getServerFlagConfiguration());
    }

    @NotNull
    public static ComponentsSet buildComponentSetForIntegrationTesting() {
        return ComponentsSet.buildComponentSetFromConfiguration(ComponentsSet.getIntegrationTestConfiguration());
    }

    public static final class ComponentCategory
    extends Cluster {
        public ComponentCategory(int id2, @NotNull String label2, long extendedReportCollectionThresholdBytes) {
            super(id2, label2, extendedReportCollectionThresholdBytes);
        }
    }

    public static final class Component
    extends Cluster {
        @NotNull
        private final ComponentCategory componentCategory;
        @NotNull
        final Set<String> customClassLoaders;

        private Component(@NotNull String componentLabel, long extendedReportCollectionThresholdBytes, @NotNull List<String> customClassLoaders, int id2, @NotNull ComponentCategory category) {
            super(id2, componentLabel, extendedReportCollectionThresholdBytes);
            this.customClassLoaders = Sets.newHashSet(customClassLoaders);
            this.componentCategory = category;
        }

        @NotNull
        public ComponentCategory getComponentCategory() {
            return this.componentCategory;
        }
    }

    public static abstract class Cluster {
        private final int id;
        @NotNull
        private final String label;
        private final long extendedReportCollectionThresholdBytes;

        public Cluster(int id2, @NotNull String label2, long extendedReportCollectionThresholdBytes) {
            this.id = id2;
            this.label = label2;
            this.extendedReportCollectionThresholdBytes = extendedReportCollectionThresholdBytes;
        }

        @NotNull
        public String getLabel() {
            return this.label;
        }

        public int getId() {
            return this.id;
        }

        public long getExtendedReportCollectionThresholdBytes() {
            return this.extendedReportCollectionThresholdBytes;
        }
    }
}

