/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.error;

import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.diagnostics.AndroidStudioSystemHealthMonitor;
import com.android.tools.idea.diagnostics.StudioCrashDetails;
import com.android.tools.idea.diagnostics.crash.StudioCrashReport;
import com.android.tools.idea.diagnostics.crash.StudioCrashReporter;
import com.android.tools.idea.diagnostics.crash.StudioExceptionReport;
import com.android.tools.idea.diagnostics.error.ErrorReportCustomizer;
import com.android.tools.idea.diagnostics.error.SubmitCrashReportTask;
import com.google.common.collect.ImmutableMap;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.SystemHealthEvent;
import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.KotlinCompilerCrash;
import com.intellij.diagnostic.LogMessage;
import com.intellij.diagnostic.ReportMessages;
import com.intellij.ide.DataManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginUtil;
import com.intellij.idea.IdeaLogger;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.android.diagnostics.error.ErrorBean;
import org.jetbrains.android.diagnostics.error.IdeaITNProxy;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidStudioErrorReportSubmitter
extends ErrorReportSubmitter {
    private static final Logger LOG = Logger.getInstance(AndroidStudioErrorReportSubmitter.class);
    private static final String FEEDBACK_TASK_TITLE = "Submitting error report";
    private static final long REPORT_ID_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(10L);

    @NotNull
    public String getReportActionText() {
        return AndroidBundle.message("error.report.to.google.action", new Object[0]);
    }

    public boolean submit(@NotNull IdeaLoggingEvent[] events, @Nullable String description2, @Nullable Component parentComponent, @NotNull Consumer<? super SubmittedReportInfo> callback2) {
        IdeaPluginDescriptor plugin;
        IdeaLoggingEvent event = events[0];
        ErrorBean bean = new ErrorBean(event.getThrowable(), IdeaLogger.ourLastActionId);
        bean.setDescription(description2);
        bean.setMessage(event.getMessage());
        Throwable eventThrowable = event.getThrowable();
        if (eventThrowable != null && (plugin = PluginManagerCore.getPlugin((PluginId)PluginUtil.getInstance().findPluginId(eventThrowable))) != null && (!plugin.isBundled() || plugin.allowBundledUpdate())) {
            bean.setPluginName(plugin.getName());
            bean.setPluginVersion(plugin.getVersion());
        }
        if (AndroidStudioErrorReportSubmitter.handleAnalyticsReports(event, bean)) {
            return true;
        }
        Object data2 = event.getData();
        if (data2 instanceof AbstractMessage) {
            bean.setAttachments(((AbstractMessage)data2).getIncludedAttachments());
        }
        java.util.function.Consumer<DataContext> submitter = dataContext -> {
            Task.Backgroundable feedbackTask;
            if (dataContext == null) {
                return;
            }
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            Consumer successCallback = token -> {
                SubmittedReportInfo reportInfo = new SubmittedReportInfo(null, "Issue " + token, SubmittedReportInfo.SubmissionStatus.NEW_ISSUE);
                callback2.consume((Object)reportInfo);
                ReportMessages.GROUP.createNotification("Report Submitted", NotificationType.INFORMATION).setImportant(false).notify(project);
            };
            Consumer errorCallback = e -> {
                String message = AndroidBundle.message("error.report.at.b.android", e.getMessage());
                ReportMessages.GROUP.createNotification(message, NotificationType.ERROR).setListener(NotificationListener.URL_OPENING_LISTENER).setImportant(false).notify(project);
            };
            if (data2 instanceof ErrorReportCustomizer) {
                feedbackTask = ((ErrorReportCustomizer)data2).makeReportingTask(project, FEEDBACK_TASK_TITLE, true, bean, (Consumer<String>)successCallback, (Consumer<Exception>)errorCallback);
            } else {
                Map<String, String> errorDataMap = AndroidStudioErrorReportSubmitter.getPlatformErrorData(event, bean);
                feedbackTask = new SubmitCrashReportTask(project, FEEDBACK_TASK_TITLE, true, event.getThrowable(), errorDataMap, (Consumer<String>)successCallback, (Consumer<Exception>)errorCallback);
            }
            if (project == null) {
                feedbackTask.run((ProgressIndicator)new EmptyProgressIndicator());
            } else {
                ProgressManager.getInstance().run((Task)feedbackTask);
            }
        };
        if (parentComponent != null) {
            submitter.accept(DataManager.getInstance().getDataContext(parentComponent));
        } else {
            DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(submitter);
        }
        return true;
    }

    private static boolean handleAnalyticsReports(@NotNull IdeaLoggingEvent loggingEvent, ErrorBean bean) {
        String type;
        Object data2 = loggingEvent.getData();
        if (!(data2 instanceof Map)) {
            return false;
        }
        Map map2 = (Map)data2;
        switch (type = (String)map2.get("Type")) {
            case "Exception": {
                AndroidStudioErrorReportSubmitter.handleExceptionEvent(loggingEvent, map2, bean);
                return true;
            }
            case "Crashes": {
                AndroidStudioErrorReportSubmitter.handleCrashesEvent(map2);
                return true;
            }
        }
        return false;
    }

    private static void handleCrashesEvent(Map map2) {
        Optional<StudioCrashDetails> jvmCrashOptional;
        List crashDetails = (List)map2.get("crashDetails");
        List descriptions = ContainerUtil.map((Collection)crashDetails, StudioCrashDetails::getDescription);
        boolean isJvmCrash = crashDetails.stream().anyMatch(StudioCrashDetails::isJvmCrash);
        long uptimeInMs = crashDetails.stream().mapToLong(StudioCrashDetails::getUptimeInMs).min().orElse(-1L);
        StudioCrashReport.Builder reportBuilder = new StudioCrashReport.Builder().setDescriptions(descriptions).setIsJvmCrash(isJvmCrash).setUptimeInMs(uptimeInMs);
        if (isJvmCrash && (jvmCrashOptional = crashDetails.stream().filter(StudioCrashDetails::isJvmCrash).findAny()).isPresent()) {
            StudioCrashDetails jvmCrash = jvmCrashOptional.get();
            reportBuilder.setErrorSignal(jvmCrash.getErrorSignal());
            reportBuilder.setErrorFrame(jvmCrash.getErrorFrame());
            reportBuilder.setErrorThread(jvmCrash.getErrorThread());
            reportBuilder.setNativeStack(jvmCrash.getNativeStack());
        }
        StudioCrashReport report = reportBuilder.build();
        StudioCrashReporter.getInstance().submit(report, true);
    }

    private static void handleExceptionEvent(@NotNull IdeaLoggingEvent loggingEvent, Map<Object, Object> map2, ErrorBean bean) {
        Throwable t = loggingEvent.getThrowable();
        if (t == null) {
            return;
        }
        AndroidStudioSystemHealthMonitor.AndroidStudioExceptionEvent exceptionEvent = loggingEvent instanceof AndroidStudioSystemHealthMonitor.AndroidStudioExceptionEvent ? (AndroidStudioSystemHealthMonitor.AndroidStudioExceptionEvent)loggingEvent : null;
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry<Object, Object> entry : map2.entrySet()) {
            mapBuilder.put((Object)entry.getKey().toString(), (Object)entry.getValue().toString());
        }
        Map<String, String> platformMap = AndroidStudioErrorReportSubmitter.getPlatformErrorData(loggingEvent, bean);
        for (Map.Entry<String, String> entry : platformMap.entrySet()) {
            mapBuilder.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        mapBuilder.put((Object)"sessionId", (Object)UsageTracker.getSessionId());
        ImmutableMap immutableMap = mapBuilder.buildKeepingLast();
        StudioExceptionReport studioExceptionReport = ((StudioExceptionReport.Builder)new StudioExceptionReport.Builder().setThrowable(t, false, true).addProductData((Map)immutableMap)).build();
        CompletableFuture reportIdFuture = StudioCrashReporter.getInstance().submit(studioExceptionReport, true);
        long timeMs = AnalyticsSettings.getDateProvider().now().getTime();
        reportIdFuture.completeOnTimeout("[timeout:%dms]".formatted(REPORT_ID_TIMEOUT_MS), REPORT_ID_TIMEOUT_MS, TimeUnit.MILLISECONDS).whenComplete((reportId, throwable) -> {
            if (throwable != null) {
                reportId = "[exception:%s]".formatted(throwable.getClass().getName());
            }
            SystemHealthEvent.Exception.Builder exceptionBuilder = SystemHealthEvent.Exception.newBuilder().setCrashReportId(reportId);
            String signature = "[missing signature]";
            if (exceptionEvent != null) {
                signature = exceptionEvent.getSignature();
                exceptionBuilder.setExceptionIndex((long)exceptionEvent.getExceptionIndex()).setSignatureIndex((long)exceptionEvent.getSignatureIndex()).setSignatureReportsSkipped((long)exceptionEvent.getDeniedSinceLastAllow()).setStableSignature(signature);
            }
            AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.SYSTEM_HEALTH_EVENT).setSystemHealthEvent(SystemHealthEvent.newBuilder().setEventType(SystemHealthEvent.SystemHealthEventType.EXCEPTION).setException(exceptionBuilder));
            UsageTracker.log((long)timeMs, (AndroidStudioEvent.Builder)event);
            LOG.info("Exception signature: %s, report ID: %s".formatted(signature, reportId));
        });
    }

    @NotNull
    private static Map<String, String> getPlatformErrorData(@NotNull IdeaLoggingEvent loggingEvent, @NotNull ErrorBean bean) {
        List<Pair<String, String>> keyValuePairs = IdeaITNProxy.getKeyValuePairs(null, null, bean, ApplicationManager.getApplication(), (ApplicationInfoEx)ApplicationInfo.getInstance(), ApplicationNamesInfo.getInstance(), UpdateSettings.getInstance());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Pair<String, String> p : keyValuePairs) {
            if (p.first == null || p.second == null || AndroidStudioErrorReportSubmitter.ignoredErrorDataEntry((String)p.first)) continue;
            builder.put((Object)((String)p.first), (Object)((String)p.second));
        }
        KotlinCompilerCrash kotlinCompilerCrash = AndroidStudioErrorReportSubmitter.getKotlinCompilerCrashOrNull(loggingEvent);
        if (kotlinCompilerCrash != null) {
            builder.put((Object)"kotlinGradlePluginVersion", (Object)kotlinCompilerCrash.getVersion());
        }
        return builder.build();
    }

    private static boolean ignoredErrorDataEntry(@NotNull String key) {
        for (String s : Arrays.asList("os.", "user.", "java.", "error.")) {
            if (!key.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static KotlinCompilerCrash getKotlinCompilerCrashOrNull(@NotNull IdeaLoggingEvent loggingEvent) {
        if (loggingEvent.getThrowable() instanceof KotlinCompilerCrash) {
            return (KotlinCompilerCrash)loggingEvent.getThrowable();
        }
        if (loggingEvent.getThrowable() != null && loggingEvent.getThrowable().getCause() instanceof KotlinCompilerCrash) {
            return (KotlinCompilerCrash)loggingEvent.getThrowable().getCause();
        }
        if (loggingEvent.getData() instanceof LogMessage && ((LogMessage)loggingEvent.getData()).getThrowable() instanceof KotlinCompilerCrash) {
            return (KotlinCompilerCrash)((LogMessage)loggingEvent.getData()).getThrowable();
        }
        return null;
    }
}

