/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.crash;

import com.android.tools.analytics.crash.CrashReport;
import com.android.tools.analytics.crash.GoogleCrashReporter;
import com.android.tools.idea.diagnostics.crash.BaseStudioReport;
import com.android.tools.idea.diagnostics.crash.exception.JvmCrashException;
import com.android.tools.idea.diagnostics.crash.exception.NonGracefulExitException;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StudioCrashReport
extends BaseStudioReport {
    private final List<String> descriptions;
    private final boolean isJvmCrash;
    private final long uptimeInMs;
    private final String errorSignal;
    private final String errorFrame;
    private final String errorThread;
    private final String nativeStack;

    private StudioCrashReport(@Nullable String version2, @NotNull List<String> descriptions, @Nullable Map<String, String> productData, boolean isJvmCrash, long uptimeInMs, @NotNull String errorSignal, @NotNull String errorFrame, @NotNull String errorThread, @NotNull String nativeStack) {
        super(version2, productData, "Crash");
        this.descriptions = descriptions;
        this.isJvmCrash = isJvmCrash;
        this.uptimeInMs = uptimeInMs;
        this.errorSignal = errorSignal;
        this.errorFrame = errorFrame;
        this.errorThread = errorThread;
        this.nativeStack = nativeStack;
    }

    @Override
    protected void serializeTo(@NotNull MultipartEntityBuilder builder) {
        super.serializeTo(builder);
        builder.addTextBody("numCrashes", Integer.toString(this.descriptions.size()));
        builder.addTextBody("crashDesc", Joiner.on((String)"\n\n").join(this.descriptions));
        Exception exception = this.isJvmCrash ? new JvmCrashException() : new NonGracefulExitException();
        String[] exceptionInfoAllLines = Throwables.getStackTraceAsString((Throwable)exception).split("[\\r\\n]+");
        String exceptionInfo = Arrays.stream(exceptionInfoAllLines).limit(2L).collect(Collectors.joining("\n"));
        GoogleCrashReporter.addBodyToBuilder((MultipartEntityBuilder)builder, (String)"exception_info", (String)exceptionInfo);
        if (this.isJvmCrash) {
            GoogleCrashReporter.addBodyToBuilder((MultipartEntityBuilder)builder, (String)"errorSignal", (String)this.errorSignal);
            GoogleCrashReporter.addBodyToBuilder((MultipartEntityBuilder)builder, (String)"errorFrame", (String)this.errorFrame);
            GoogleCrashReporter.addBodyToBuilder((MultipartEntityBuilder)builder, (String)"errorThread", (String)this.errorThread);
            GoogleCrashReporter.addBodyToBuilder((MultipartEntityBuilder)builder, (String)"nativeStack", (String)this.nativeStack);
        }
    }

    protected void overrideDefaultParameters(Map<String, String> parameters2) {
        if (this.uptimeInMs >= 0L) {
            parameters2.put("ptime", Long.toString(this.uptimeInMs));
        }
    }

    public static class Builder
    extends CrashReport.BaseBuilder<StudioCrashReport, Builder> {
        private List<String> descriptions;
        private boolean isJvmCrash = false;
        private long uptimeInMs = -1L;
        private String errorSignal = "";
        private String errorFrame = "";
        private String errorThread = "";
        private String nativeStack = "";

        protected Builder getThis() {
            return this;
        }

        @NotNull
        public Builder setDescriptions(@NotNull List<String> descriptions) {
            this.descriptions = descriptions;
            return this;
        }

        @NotNull
        public Builder setIsJvmCrash(boolean isJvmCrash) {
            this.isJvmCrash = isJvmCrash;
            return this;
        }

        @NotNull
        public Builder setUptimeInMs(long uptimeInMs) {
            this.uptimeInMs = uptimeInMs;
            return this;
        }

        @NotNull
        public Builder setErrorSignal(String errorSignal) {
            this.errorSignal = errorSignal;
            return this;
        }

        @NotNull
        public Builder setErrorFrame(String errorFrame) {
            this.errorFrame = errorFrame;
            return this;
        }

        @NotNull
        public Builder setErrorThread(String errorThread) {
            this.errorThread = errorThread;
            return this;
        }

        @NotNull
        public Builder setNativeStack(String nativeStack) {
            this.nativeStack = nativeStack;
            return this;
        }

        public StudioCrashReport build() {
            return new StudioCrashReport(this.getVersion(), this.descriptions, this.getProductData(), this.isJvmCrash, this.uptimeInMs, this.errorSignal, this.errorFrame, this.errorThread, this.nativeStack);
        }
    }
}

