/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics;

import com.android.tools.idea.diagnostics.DiagnosticsReportCleanerKt;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\u0005H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/diagnostics/DiagnosticsReportCleaner;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cleanDefaultDirectories", "Companion", "intellij.android.core"})
public final class DiagnosticsReportCleaner
implements ProjectActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DiagnosticsReportCleaner this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        DiagnosticsReportCleaner.access$cleanDefaultDirectories(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void cleanDefaultDirectories() {
        Path path = Paths.get(PathManager.getLogPath(), new String[0]);
        for (String directory : DiagnosticsReportCleanerKt.access$getDIRECTORIES$p()) {
            Path path2 = path.resolve(directory);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            Companion.cleanupFiles(path2);
        }
        Intrinsics.checkNotNull((Object)path);
        Companion.cleanupDirectories(path, DiagnosticsReportCleanerKt.access$getDIRECTORY_REGEXES$p());
    }

    public static final /* synthetic */ void access$cleanDefaultDirectories(DiagnosticsReportCleaner $this) {
        $this.cleanDefaultDirectories();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J!\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J#\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/diagnostics/DiagnosticsReportCleaner$Companion;", "", "<init>", "()V", "cleanupFiles", "", "path", "Ljava/nio/file/Path;", "cleanupDirectories", "regexes", "", "Lkotlin/text/Regex;", "(Ljava/nio/file/Path;[Lkotlin/text/Regex;)V", "shouldDeleteFile", "", "shouldDeleteDirectory", "(Ljava/nio/file/Path;[Lkotlin/text/Regex;)Z", "isOld", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nDiagnosticsReportCleaner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiagnosticsReportCleaner.kt\ncom/android/tools/idea/diagnostics/DiagnosticsReportCleaner$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,89:1\n12567#2,2:90\n*S KotlinDebug\n*F\n+ 1 DiagnosticsReportCleaner.kt\ncom/android/tools/idea/diagnostics/DiagnosticsReportCleaner$Companion\n*L\n82#1:90,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void cleanupFiles(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (!Files.isDirectory(path, new LinkOption[0])) {
                return;
            }
            Iterator iterator2 = Files.list(path).filter(arg_0 -> Companion.cleanupFiles$lambda$1(Companion::cleanupFiles$lambda$0, arg_0)).iterator();
            while (iterator2.hasNext()) {
                Path child = (Path)iterator2.next();
                Files.delete(child);
            }
        }

        public final void cleanupDirectories(@NotNull Path path, @NotNull Regex[] regexes) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)regexes, (String)"regexes");
            if (!Files.isDirectory(path, new LinkOption[0])) {
                return;
            }
            Iterator iterator2 = Files.list(path).filter(arg_0 -> Companion.cleanupDirectories$lambda$3(arg_0 -> Companion.cleanupDirectories$lambda$2(regexes, arg_0), arg_0)).iterator();
            while (iterator2.hasNext()) {
                Path directory = (Path)iterator2.next();
                File file = directory.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                FilesKt.deleteRecursively((File)file);
            }
        }

        private final boolean shouldDeleteFile(Path path) {
            return Files.isRegularFile(path, new LinkOption[0]) && this.isOld(path);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean shouldDeleteDirectory(Path path, Regex[] regexes) {
            block2: {
                if (!Files.isDirectory(path, new LinkOption[0])) return false;
                Regex[] $this$any$iv = regexes;
                boolean $i$f$any = false;
                int n = 0;
                int n2 = $this$any$iv.length;
                while (n < n2) {
                    Regex element$iv;
                    Regex it = element$iv = $this$any$iv[n];
                    boolean bl = false;
                    if (!it.matches((CharSequence)PathsKt.getName((Path)path))) {
                        ++n;
                        continue;
                    }
                    break block2;
                }
                return false;
            }
            boolean bl = true;
            if (!bl) return false;
            if (!this.isOld(path)) return false;
            return true;
        }

        private final boolean isOld(Path path) {
            return Duration.ofMillis(System.currentTimeMillis() - Files.getLastModifiedTime(path, new LinkOption[0]).toMillis()).compareTo(DiagnosticsReportCleanerKt.access$getMAX_AGE$p()) > 0;
        }

        private static final boolean cleanupFiles$lambda$0(Path it) {
            Intrinsics.checkNotNull((Object)it);
            return Companion.shouldDeleteFile(it);
        }

        private static final boolean cleanupFiles$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean cleanupDirectories$lambda$2(Regex[] $regexes, Path it) {
            Intrinsics.checkNotNull((Object)it);
            return Companion.shouldDeleteDirectory(it, $regexes);
        }

        private static final boolean cleanupDirectories$lambda$3(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

